/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.util;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;

public final class ImageUtils {
    private ImageUtils() {
    }

    public static BufferedImage fixSubBufferedImage(BufferedImage image) {
        boolean needFix;
        boolean bl2 = needFix = image.getSampleModel().getWidth() != image.getWidth() || image.getSampleModel().getHeight() != image.getHeight();
        if (needFix) {
            if (image.getType() == 10) {
                BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                byte[] pixelBytes = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int p2 = 0;
                for (int y2 = 0; y2 < image.getHeight(); ++y2) {
                    for (int x2 = 0; x2 < image.getWidth(); ++x2) {
                        pixelBytes[p2++] = (byte)(image.getRGB(x2, y2) & 0xFF);
                    }
                }
                return result;
            }
            BufferedImage result = image.getColorModel().hasAlpha() ? new BufferedImage(image.getWidth(), image.getHeight(), 2) : new BufferedImage(image.getWidth(), image.getHeight(), 1);
            int[] pixelInts = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
            int p3 = 0;
            for (int y3 = 0; y3 < image.getHeight(); ++y3) {
                for (int x3 = 0; x3 < image.getWidth(); ++x3) {
                    pixelInts[p3++] = image.getRGB(x3, y3);
                }
            }
            return result;
        }
        return image;
    }
}

