/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.util;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;

class CustomColorConvertOp
implements BufferedImageOp {
    private final RenderingHints hints;

    public CustomColorConvertOp(RenderingHints hints) {
        this.hints = hints;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        if (dest == null) {
            dest = this.createCompatibleDestImage(src, null);
        }
        if (src.getType() == dest.getType()) {
            dest.getRaster().setRect(src.getRaster());
        } else if (dest.getType() == 12) {
            for (int i2 = 0; i2 < src.getHeight(); ++i2) {
                for (int j2 = 0; j2 < src.getWidth(); ++j2) {
                    int b2;
                    int g2;
                    int px = src.getRGB(j2, i2);
                    int r2 = px >> 16 & 0xFF;
                    int m2 = r2 + (g2 = px >> 8 & 0xFF) + (b2 = px & 0xFF);
                    if (m2 >= 383) {
                        dest.setRGB(j2, i2, Color.WHITE.getRGB());
                        continue;
                    }
                    dest.setRGB(j2, i2, 0);
                }
            }
        } else if (src.getType() == 10) {
            int srcWidth = src.getWidth();
            byte[] srcPixels = ((DataBufferByte)src.getRaster().getDataBuffer()).getData();
            for (int i3 = 0; i3 < srcPixels.length; ++i3) {
                int px = srcPixels[i3] & 0xFF;
                dest.setRGB(i3 % srcWidth, i3 / srcWidth, 0xFF000000 | px << 16 | px << 8 | px);
            }
        } else {
            try {
                ColorConvertOp xformOp = new ColorConvertOp(this.hints);
                xformOp.filter(src, dest);
            }
            catch (Exception e2) {
                throw new RuntimeException("Exception " + e2 + " creating argb image");
            }
        }
        return dest;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle2D.Float(0.0f, 0.0f, src.getWidth(), src.getHeight());
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        return new BufferedImage(destCM, src.getRaster().createCompatibleWritableRaster(), src.isAlphaPremultiplied(), null);
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return srcPt;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.hints;
    }
}

