/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.util;

import com.idrsolutions.image.util.CustomColorConvertOp;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public final class ColorSpaceConversion {
    private static final RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);

    private ColorSpaceConversion() {
    }

    public static BufferedImage convertBufferedImageToColorSpace(BufferedImage img, int colorspace) {
        if (img.getType() != colorspace) {
            if (colorspace == 13) {
                BufferedImage raw_image = img;
                img = new BufferedImage(img.getWidth(), img.getHeight(), 13);
                img.getGraphics().drawImage(raw_image, 0, 0, null);
            } else {
                BufferedImage raw_image2 = img;
                img = new BufferedImage(raw_image2.getWidth(), raw_image2.getHeight(), colorspace);
                CustomColorConvertOp xformOp2 = new CustomColorConvertOp(null);
                xformOp2.filter(raw_image2, img);
            }
        }
        return img;
    }

    public static BufferedImage getBufferedImageAsRGB(BufferedImage image, RenderingHints hints) {
        switch (image.getType()) {
            case 1: {
                return image;
            }
            case 2: {
                return ColorSpaceConversion.convertARGBToRGB(image);
            }
        }
        BufferedImage raw_image = image;
        image = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        new CustomColorConvertOp(hints).filter(raw_image, image);
        return image;
    }

    private static BufferedImage convertARGBToRGB(BufferedImage image) {
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        int[] pixelsOut = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        System.arraycopy(pixels, 0, pixelsOut, 0, pixels.length);
        return result;
    }

    public static BufferedImage getBufferedImageAsARGB(BufferedImage image) {
        if (image.getType() != 2) {
            BufferedImage raw_image = image;
            image = new BufferedImage(raw_image.getWidth(), raw_image.getHeight(), 2);
            CustomColorConvertOp xformOp = new CustomColorConvertOp(null);
            xformOp.filter(raw_image, image);
        }
        return image;
    }

    static {
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }
}

