/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.filter.FlateFilterOptions;
import com.idrsolutions.image.filter.LZWFilterOptions;
import com.idrsolutions.image.jpeg.JpegEncoder;
import com.idrsolutions.image.metadata.ifd.IFDKeys;
import com.idrsolutions.image.tiff.IFDColorSpace;
import com.idrsolutions.image.tiff.IFDCompression;
import com.idrsolutions.image.tiff.options.TiffCompressionFormat;
import com.idrsolutions.image.tiff.options.TiffEncoderOptions;
import com.idrsolutions.image.tiff.options.TiffResolutionUnit;
import com.idrsolutions.image.util.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.jpedal.io.filter.Flate;
import org.jpedal.io.filter.LZW;

public class TiffEncoder
extends JDeliImage
implements Encoder {
    private TiffEncoderOptions tiffEncoderOptions = new TiffEncoderOptions();

    public TiffEncoder(TiffEncoderOptions tiffOptions) {
        if (tiffOptions != null) {
            this.tiffEncoderOptions = tiffOptions;
        }
    }

    public TiffEncoder() {
    }

    @Override
    public void write(BufferedImage image, OutputStream outputStream) throws IOException {
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        BufferedImage imageToCompress = ImageUtils.fixSubBufferedImage(image);
        TiffEncoder.optimiseImage(image);
        int offsetIFD = 8;
        TiffEncoder.writeIdentifier(outputStream);
        this.writeContents(true, imageToCompress, outputStream, imageW, imageH, 8);
    }

    public void append(BufferedImage image, String fileName) throws IOException {
        BufferedImage img = ImageUtils.fixSubBufferedImage(TiffEncoder.optimiseImage(image));
        File file = new File(fileName);
        if (file.exists() && file.length() > 0L) {
            int endFile = (int)file.length();
            int padding = endFile % 8;
            try (RandomAccessFile rFile = new RandomAccessFile(fileName, "rw");){
                byte[] ends = new byte[2];
                rFile.read(ends);
                boolean isBig = ends[0] == 77 && ends[1] == 77;
                rFile.seek(endFile);
                for (int i2 = 0; i2 < padding; ++i2) {
                    rFile.write(0);
                }
                TiffEncoder.alterLastIFDOffset(isBig, rFile, endFile += padding);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                this.writeContents(isBig, img, bos, img.getWidth(), img.getHeight(), endFile);
                bos.close();
                byte[] data = bos.toByteArray();
                rFile.seek(endFile);
                rFile.write(data);
            }
        }
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Paths.get(fileName, new String[0]), new OpenOption[0]));){
            this.createImage(img, out);
        }
    }

    @Deprecated
    public boolean isCompressed() {
        return this.tiffEncoderOptions.getCompressionFormat() != TiffCompressionFormat.NONE;
    }

    public TiffEncoderOptions getEncoderOptions() {
        return this.tiffEncoderOptions;
    }

    public void setEncoderOptions(TiffEncoderOptions tiffEncoderOptions) {
        this.tiffEncoderOptions = tiffEncoderOptions;
    }

    @Deprecated
    public void setCompressed(boolean compress) {
        if (compress) {
            this.tiffEncoderOptions.setCompressionFormat(TiffCompressionFormat.DEFLATE);
        } else {
            this.tiffEncoderOptions.setCompressionFormat(TiffCompressionFormat.NONE);
        }
    }

    private static void alterLastIFDOffset(boolean isBig, RandomAccessFile rFile, int fileLen) throws IOException {
        rFile.seek(0L);
        rFile.skipBytes(4);
        int offsetIFD = TiffEncoder.get32(rFile, isBig);
        do {
            rFile.seek(offsetIFD);
            int dirs = TiffEncoder.get16(rFile, isBig);
            rFile.skipBytes(dirs * 12);
        } while ((offsetIFD = TiffEncoder.get32(rFile, isBig)) != 0);
        int pointer = (int)rFile.getFilePointer();
        rFile.seek(pointer - 4);
        TiffEncoder.put32(rFile, isBig, fileLen);
    }

    private void createImage(BufferedImage image, OutputStream out) throws IOException {
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        int offsetIFD = 8;
        TiffEncoder.writeIdentifier(out);
        this.writeContents(true, image, out, imageW, imageH, 8);
    }

    private static byte[] handleDefault(BufferedImage image) {
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        byte[] raw = new byte[imageH * imageW * 3];
        int p2 = 0;
        BufferedImage bImage = new BufferedImage(imageW, imageH, 1);
        bImage.createGraphics().drawImage((Image)image, 0, 0, null);
        int[] pixInts = ((DataBufferInt)bImage.getRaster().getDataBuffer()).getData();
        int ii = imageH * imageW;
        for (int i2 = 0; i2 < ii; ++i2) {
            int xx = pixInts[i2];
            raw[p2++] = (byte)(xx >> 16 & 0xFF);
            raw[p2++] = (byte)(xx >> 8 & 0xFF);
            raw[p2++] = (byte)(xx & 0xFF);
        }
        return raw;
    }

    private static byte[] handle4ByteABGR(BufferedImage image) {
        byte[] pByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        byte[] raw = new byte[imageH * imageW * 4];
        int index = 0;
        int pb4 = 0;
        for (int i2 = 0; i2 < imageH; ++i2) {
            for (int j2 = 0; j2 < imageW; ++j2) {
                raw[index++] = pByte[pb4 + 3];
                raw[index++] = pByte[pb4 + 2];
                raw[index++] = pByte[pb4 + 1];
                raw[index++] = pByte[pb4];
                pb4 += 4;
            }
        }
        return raw;
    }

    private static byte[] handleUShortGray(BufferedImage image) {
        short[] pix = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
        byte[] raw = new byte[image.getWidth() * image.getHeight() * 2];
        int p2 = 0;
        int ii = raw.length / 2;
        for (int i2 = 0; i2 < ii; ++i2) {
            int xx = pix[i2] & 0xFFFF;
            raw[p2++] = (byte)(xx >> 8);
            raw[p2++] = (byte)(xx & 0xFF);
        }
        return raw;
    }

    private static byte[] handleByteBGR(BufferedImage image) {
        byte[] pByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        byte[] raw = new byte[imageH * imageW * 3];
        int index = 0;
        int pb = 0;
        int ii = imageW * imageH;
        for (int i2 = 0; i2 < ii; ++i2) {
            raw[index++] = pByte[pb + 2];
            raw[index++] = pByte[pb + 1];
            raw[index++] = pByte[pb];
            pb += 3;
        }
        return raw;
    }

    private static byte[] handleIntBGR(BufferedImage image) {
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        byte[] raw = new byte[imageH * imageW * 3];
        int index = 0;
        int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int ii = imageH * imageW;
        for (int i2 = 0; i2 < ii; ++i2) {
            int xx = pixInts[i2];
            raw[index++] = (byte)(xx & 0xFF);
            raw[index++] = (byte)(xx >> 8 & 0xFF);
            raw[index++] = (byte)(xx >> 16 & 0xFF);
        }
        return raw;
    }

    private static byte[] handleIntARGB(BufferedImage image) {
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        byte[] raw = new byte[imageH * imageW * 4];
        int index = 0;
        int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int ii = imageH * imageW;
        for (int i2 = 0; i2 < ii; ++i2) {
            int xx = pixInts[i2];
            raw[index++] = (byte)(xx >> 16 & 0xFF);
            raw[index++] = (byte)(xx >> 8 & 0xFF);
            raw[index++] = (byte)(xx & 0xFF);
            raw[index++] = (byte)(xx >> 24 & 0xFF);
        }
        return raw;
    }

    private static byte[] handleIntRGB(BufferedImage image) {
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        byte[] raw = new byte[imageH * imageW * 3];
        int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int index = 0;
        int ii = imageH * imageW;
        for (int i2 = 0; i2 < ii; ++i2) {
            int xx = pixInts[i2];
            raw[index++] = (byte)(xx >> 16 & 0xFF);
            raw[index++] = (byte)(xx >> 8 & 0xFF);
            raw[index++] = (byte)(xx & 0xFF);
        }
        return raw;
    }

    private static void writeIdentifier(OutputStream out) throws IOException {
        out.write(new byte[]{77, 77});
        out.write(new byte[]{0, 42});
        out.write(TiffEncoder.intToBytes());
    }

    private static void writePadding(OutputStream out, int rawLen) throws IOException {
        int balance = rawLen % 8;
        for (int i2 = 0; i2 < balance; ++i2) {
            out.write(0);
        }
    }

    private static int getNComp(BufferedImage image) {
        switch (image.getType()) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return 1;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return 4;
            }
        }
        return 3;
    }

    private static int getBPS(BufferedImage image) {
        switch (image.getType()) {
            case 12: {
                return image.getColorModel().getPixelSize();
            }
            case 11: {
                return 16;
            }
        }
        return 8;
    }

    private static byte[] grabData(BufferedImage image, TiffCompressionFormat compressionType) throws IOException {
        byte[] raw;
        switch (image.getType()) {
            case 10: 
            case 12: 
            case 13: {
                raw = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                break;
            }
            case 11: {
                raw = TiffEncoder.handleUShortGray(image);
                break;
            }
            case 1: {
                raw = TiffEncoder.handleIntRGB(image);
                break;
            }
            case 2: 
            case 3: {
                raw = TiffEncoder.handleIntARGB(image);
                break;
            }
            case 4: {
                raw = TiffEncoder.handleIntBGR(image);
                break;
            }
            case 5: {
                raw = TiffEncoder.handleByteBGR(image);
                break;
            }
            case 6: 
            case 7: {
                raw = TiffEncoder.handle4ByteABGR(image);
                break;
            }
            default: {
                raw = TiffEncoder.handleDefault(image);
            }
        }
        Flate flate = new Flate(new FlateFilterOptions());
        switch (compressionType) {
            case JPEG: {
                ByteArrayOutputStream jpegBuff = new ByteArrayOutputStream();
                JpegEncoder enc = new JpegEncoder();
                enc.write(image, jpegBuff);
                return jpegBuff.toByteArray();
            }
            case DEFLATE: {
                return flate.encode(raw, -1);
            }
            case DEFLATE_BETTER_COMPRESSION: {
                return flate.encode(raw, 9);
            }
            case DEFLATE_BETTER_SPEED: {
                return flate.encode(raw, 1);
            }
            case LZW: {
                LZW lzw = new LZW(new LZWFilterOptions(), image.getWidth(), image.getHeight());
                return lzw.encode(raw);
            }
        }
        return raw;
    }

    private static int getMapSize(BufferedImage image) {
        switch (image.getType()) {
            case 12: 
            case 13: {
                IndexColorModel model = (IndexColorModel)image.getColorModel();
                return (int)Math.pow(2.0, model.getPixelSize());
            }
        }
        return 0;
    }

    private static byte[] grabCmapData(BufferedImage image) {
        int p2 = 0;
        switch (image.getType()) {
            case 12: 
            case 13: {
                int i2;
                IndexColorModel model = (IndexColorModel)image.getColorModel();
                int mapSize = TiffEncoder.getMapSize(image);
                byte[] cmap = new byte[mapSize * 3 * 2];
                byte[] rr = new byte[mapSize];
                model.getReds(rr);
                byte[] gg = new byte[mapSize];
                model.getGreens(gg);
                byte[] bb2 = new byte[mapSize];
                model.getBlues(bb2);
                for (i2 = 0; i2 < mapSize; ++i2) {
                    cmap[p2] = rr[i2];
                    p2 += 2;
                }
                for (i2 = 0; i2 < mapSize; ++i2) {
                    cmap[p2] = gg[i2];
                    p2 += 2;
                }
                for (i2 = 0; i2 < mapSize; ++i2) {
                    cmap[p2] = bb2[i2];
                    p2 += 2;
                }
                return cmap;
            }
        }
        return null;
    }

    private void writeContents(boolean isBig, BufferedImage image, OutputStream out, int imageWidth, int imageHeight, int offsetIFD) throws IOException {
        int i2;
        int totalEntries;
        String xmpMeta = this.tiffEncoderOptions.getXmpMetaData();
        byte[] xmpDataBytes = xmpMeta != null ? xmpMeta.getBytes() : null;
        int nComp = TiffEncoder.getNComp(image);
        int bps = TiffEncoder.getBPS(image);
        byte[] cmapData = TiffEncoder.grabCmapData(image);
        boolean isGray = image.getType() == 10 || image.getType() == 11;
        int compressValue = 1;
        int photoMetric = isGray ? 1 : (cmapData != null ? IFDColorSpace.RGB_Palette.value : IFDColorSpace.RGB.value);
        switch (this.tiffEncoderOptions.getCompressionFormat()) {
            case JPEG: {
                compressValue = IFDCompression.JPEG_TechNote.value;
                photoMetric = isGray ? 1 : IFDColorSpace.YCbCr.value;
                switch (image.getType()) {
                    case 10: 
                    case 11: {
                        nComp = 1;
                        break;
                    }
                    default: {
                        nComp = 3;
                    }
                }
                cmapData = null;
                bps = 8;
                break;
            }
            case DEFLATE: 
            case DEFLATE_BETTER_COMPRESSION: 
            case DEFLATE_BETTER_SPEED: {
                compressValue = IFDCompression.ADOBEDEFLATE.value;
                break;
            }
            case LZW: {
                compressValue = IFDCompression.LZW.value;
            }
        }
        int n2 = totalEntries = cmapData != null ? 13 : 12;
        if (xmpDataBytes != null) {
            ++totalEntries;
        }
        byte[] data = TiffEncoder.grabData(image, this.tiffEncoderOptions.getCompressionFormat());
        int sampleOffset = offsetIFD + 2 + totalEntries * 12 + 4;
        int offsetXR = nComp > 1 ? sampleOffset + 2 * nComp : sampleOffset;
        int offsetYR = offsetXR + 8;
        int offsetXMP = offsetYR + 8;
        int offsetStrip = offsetYR + 8;
        if (xmpDataBytes != null) {
            offsetStrip = offsetXMP + xmpDataBytes.length;
        }
        int cmapOffset = offsetStrip;
        if (cmapData != null) {
            offsetStrip += cmapData.length;
        }
        TiffEncoder.putU16(out, isBig, totalEntries);
        TiffEncoder.writeDimension(out, isBig, IFDKeys.ImageWidth.value, imageWidth);
        TiffEncoder.writeDimension(out, isBig, IFDKeys.ImageHeight.value, imageHeight);
        TiffEncoder.putU16(out, isBig, IFDKeys.BitsPerSample.value);
        TiffEncoder.putU16(out, isBig, 3);
        if (nComp == 1) {
            TiffEncoder.putU32(out, isBig, 1);
            TiffEncoder.putU16(out, isBig, bps);
            TiffEncoder.putU16(out, isBig, 0);
        } else {
            TiffEncoder.putU32(out, isBig, nComp);
            TiffEncoder.putU32(out, isBig, sampleOffset);
        }
        TiffEncoder.write5Values(out, isBig, IFDKeys.Compression.value, compressValue);
        TiffEncoder.write5Values(out, isBig, IFDKeys.PhotometricInterpolation.value, photoMetric);
        TiffEncoder.write4Values(out, isBig, IFDKeys.StripOffsets.value, offsetStrip);
        TiffEncoder.write5Values(out, isBig, IFDKeys.SamplesPerPixel.value, nComp);
        TiffEncoder.write4Values(out, isBig, IFDKeys.RowsPerStrip.value, imageHeight);
        TiffEncoder.write4Values(out, isBig, IFDKeys.StripByteCounts.value, data.length);
        TiffEncoder.writeResolution(out, isBig, IFDKeys.Xresolution.value, offsetXR);
        TiffEncoder.writeResolution(out, isBig, IFDKeys.Yresolution.value, offsetYR);
        TiffResolutionUnit resolutionUnit = this.tiffEncoderOptions.getResolutionUnit();
        TiffEncoder.write5Values(out, isBig, IFDKeys.ResolutionUnit.value, resolutionUnit.value);
        if (xmpDataBytes != null) {
            TiffEncoder.putU16(out, isBig, IFDKeys.XMP.value);
            TiffEncoder.putU16(out, isBig, 1);
            TiffEncoder.putU32(out, isBig, xmpDataBytes.length);
            TiffEncoder.putU32(out, isBig, offsetXMP);
        }
        if (cmapData != null) {
            TiffEncoder.putU16(out, isBig, IFDKeys.ColorMap.value);
            TiffEncoder.putU16(out, isBig, 3);
            TiffEncoder.putU32(out, isBig, TiffEncoder.getMapSize(image) * 3);
            TiffEncoder.putU32(out, isBig, cmapOffset);
        }
        TiffEncoder.putU32(out, isBig, 0);
        if (nComp > 1) {
            for (i2 = 0; i2 < nComp; ++i2) {
                TiffEncoder.putU16(out, isBig, bps);
            }
        }
        if (resolutionUnit != TiffResolutionUnit.NONE) {
            TiffEncoder.putU32(out, isBig, this.tiffEncoderOptions.getXResolution());
            TiffEncoder.putU32(out, isBig, 1);
            TiffEncoder.putU32(out, isBig, this.tiffEncoderOptions.getYResolution());
            TiffEncoder.putU32(out, isBig, 1);
        } else {
            for (i2 = 0; i2 < 4; ++i2) {
                TiffEncoder.putU32(out, isBig, 1);
            }
        }
        if (xmpDataBytes != null) {
            out.write(xmpDataBytes);
        }
        if (cmapData != null) {
            out.write(cmapData);
        }
        out.write(data);
        TiffEncoder.writePadding(out, data.length);
    }

    private static void write4Values(OutputStream out, boolean isBig, int tag, int value) throws IOException {
        TiffEncoder.putU16(out, isBig, tag);
        TiffEncoder.putU16(out, isBig, 4);
        TiffEncoder.putU32(out, isBig, 1);
        TiffEncoder.putU32(out, isBig, value);
    }

    private static void write5Values(OutputStream out, boolean isBig, int tag, int value) throws IOException {
        TiffEncoder.putU16(out, isBig, tag);
        TiffEncoder.putU16(out, isBig, 3);
        TiffEncoder.putU32(out, isBig, 1);
        TiffEncoder.putU16(out, isBig, value);
        TiffEncoder.putU16(out, isBig, 0);
    }

    private static void writeDimension(OutputStream out, boolean isBig, int tag, int dim) throws IOException {
        TiffEncoder.putU16(out, isBig, tag);
        TiffEncoder.putU16(out, isBig, 3);
        TiffEncoder.putU32(out, isBig, 1);
        TiffEncoder.putU16(out, isBig, dim);
        TiffEncoder.putU16(out, isBig, 0);
    }

    private static void writeResolution(OutputStream out, boolean isBig, int tag, int offset) throws IOException {
        TiffEncoder.putU16(out, isBig, tag);
        TiffEncoder.putU16(out, isBig, 5);
        TiffEncoder.putU32(out, isBig, 1);
        TiffEncoder.putU32(out, isBig, offset);
    }

    private static int get32(RandomAccessFile os, boolean isBig) throws IOException {
        byte[] bb2 = new byte[4];
        os.read(bb2);
        if (isBig) {
            return (bb2[0] & 0xFF) << 24 | (bb2[1] & 0xFF) << 16 | (bb2[2] & 0xFF) << 8 | bb2[3] & 0xFF;
        }
        return (bb2[3] & 0xFF) << 24 | (bb2[2] & 0xFF) << 16 | (bb2[1] & 0xFF) << 8 | bb2[0] & 0xFF;
    }

    private static int get16(RandomAccessFile os, boolean isBig) throws IOException {
        byte[] bb2 = new byte[2];
        os.read(bb2);
        if (isBig) {
            return (bb2[0] & 0xFF) << 8 | bb2[1] & 0xFF;
        }
        return (bb2[1] & 0xFF) << 8 | bb2[0] & 0xFF;
    }

    private static void putU16(OutputStream os, boolean isBig, int v2) throws IOException {
        if (isBig) {
            os.write(v2 >> 8);
            os.write(v2 & 0xFF);
        } else {
            os.write(v2 & 0xFF);
            os.write(v2 >> 8);
        }
    }

    private static void putU32(OutputStream os, boolean isBig, int v2) throws IOException {
        if (isBig) {
            os.write(v2 >>> 24);
            os.write(v2 >> 16);
            os.write(v2 >> 8);
            os.write(v2 & 0xFF);
        } else {
            os.write(v2 & 0xFF);
            os.write(v2 >> 8);
            os.write(v2 >> 16);
            os.write(v2 >> 24);
        }
    }

    private static void put32(RandomAccessFile os, boolean isBig, int v2) throws IOException {
        if (isBig) {
            os.write(v2 >> 24);
            os.write(v2 >> 16);
            os.write(v2 >> 8);
            os.write(v2 & 0xFF);
        } else {
            os.write(v2 & 0xFF);
            os.write(v2 >> 8);
            os.write(v2 >> 16);
            os.write(v2 >> 24);
        }
    }

    @Deprecated
    public void setXMPMetaData(String xmpMetaData) {
        this.tiffEncoderOptions.setXmpMetaData(xmpMetaData);
    }

    private static byte[] intToBytes() {
        return new byte[]{0, 0, 0, 8};
    }
}

