/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

final class PackBits {
    private PackBits() {
    }

    public static byte[] decompress(byte[] input, int expected) throws IOException {
        int total = 0;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length * 2);){
            int i2 = 0;
            while (total < expected) {
                byte n2;
                if (i2 >= input.length) {
                    throw new IOException("Error in packbit decompression ");
                }
                if ((n2 = input[i2++]) >= 0) {
                    int cc = n2 + 1;
                    total += cc;
                    for (int j2 = 0; j2 < cc; ++j2) {
                        bos.write(input[i2++]);
                    }
                    continue;
                }
                if (n2 >= -127) {
                    byte b2 = input[i2++];
                    int count = -n2 + 1;
                    total += count;
                    for (int j3 = 0; j3 < count; ++j3) {
                        bos.write(b2);
                    }
                    continue;
                }
                throw new IOException("Error in packbit decompression ");
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

