/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.scale;

import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.scale.data.ChannelImage;
import com.idrsolutions.image.scale.data.Holder;
import com.idrsolutions.image.scale.data.ImagePlane;
import com.idrsolutions.image.scale.data.Tables;
import com.idrsolutions.image.utility.BitReader;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jpedal.utils.LogWriter;

public final class SuperResolution
extends JDeliImage {
    private static float[][][] MATRIXWIDTHS;
    private static final List<float[]> W;
    private static final boolean debug = true;
    private static final int BLOCK_SIZE = 128;
    private static final int OVERLAP = 14;

    private SuperResolution() {
    }

    private static ImagePlane normalize(ChannelImage image) {
        int width = image.width;
        int height = image.height;
        ImagePlane imagePlane = new ImagePlane(width, height);
        for (int i2 = 0; i2 < image.buffer.length; ++i2) {
            imagePlane.setValueIndexed(i2, image.buffer[i2] / 255.0f);
        }
        return imagePlane;
    }

    private static ChannelImage denormalize(ImagePlane imagePlane) {
        ChannelImage image = new ChannelImage(imagePlane.width, imagePlane.height);
        for (int i2 = 0; i2 < imagePlane.buffer.length; ++i2) {
            image.buffer[i2] = imagePlane.buffer[i2] * 255.0f;
        }
        return image;
    }

    private static ChannelImage[] channelDecompose(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        ChannelImage imageR = new ChannelImage(width, height);
        ChannelImage imageG = new ChannelImage(width, height);
        ChannelImage imageB = new ChannelImage(width, height);
        ChannelImage imageA = null;
        switch (image.getType()) {
            case 12: {
                SuperResolution.decomposeBinary(image, imageR, imageG, imageB);
                break;
            }
            case 10: {
                SuperResolution.decomposeGRAY(image, imageR, imageG, imageB);
                break;
            }
            case 13: {
                SuperResolution.decomposeBYTE_INDEXED(image, imageR, imageG, imageB);
                break;
            }
            case 5: {
                SuperResolution.decomposeBYTE_BGR(image, imageR, imageG, imageB);
                break;
            }
            case 6: 
            case 7: {
                imageA = new ChannelImage(width, height);
                SuperResolution.decomposeBYTE_ABGR(image, imageR, imageG, imageB, imageA);
                break;
            }
            case 4: {
                SuperResolution.decomposeINT_BGR(image, imageR, imageG, imageB);
                break;
            }
            case 1: {
                SuperResolution.decomposeINT_RGB(image, imageR, imageG, imageB);
                break;
            }
            case 2: 
            case 3: {
                imageA = new ChannelImage(width, height);
                SuperResolution.decomposeINT_ARGB(image, imageR, imageG, imageB, imageA);
                break;
            }
            default: {
                BufferedImage image2 = new BufferedImage(image.getWidth(), image.getHeight(), 5);
                Graphics g2 = image2.getGraphics();
                g2.drawImage(image, 0, 0, null);
                g2.dispose();
                SuperResolution.decomposeBYTE_BGR(image2, imageR, imageG, imageB);
            }
        }
        return new ChannelImage[]{imageR, imageG, imageB, imageA};
    }

    private static void decomposeBinary(BufferedImage image, ChannelImage imageR, ChannelImage imageG, ChannelImage imageB) {
        int width = imageR.width;
        int height = imageR.height;
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int p2 = 0;
        int bps = image.getColorModel().getPixelSize();
        int iw8 = width * bps % 8;
        BitReader br2 = new BitReader(data);
        IndexColorModel model = (IndexColorModel)image.getColorModel();
        byte[] rr = new byte[1 << bps];
        byte[] gg = new byte[1 << bps];
        byte[] bb2 = new byte[1 << bps];
        model.getReds(rr);
        model.getGreens(gg);
        model.getBlues(bb2);
        for (int h2 = 0; h2 < height; ++h2) {
            for (int w2 = 0; w2 < width; ++w2) {
                int v2 = br2.readBits(bps);
                imageR.buffer[p2] = rr[v2] & 0xFF;
                imageG.buffer[p2] = gg[v2] & 0xFF;
                imageB.buffer[p2] = bb2[v2] & 0xFF;
                ++p2;
            }
            if (iw8 == 0) continue;
            br2.readBits(8 - iw8);
        }
    }

    private static void decomposeGRAY(BufferedImage image, ChannelImage imageR, ChannelImage imageG, ChannelImage imageB) {
        int dim = imageR.width * imageR.height;
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int d2 = 0; d2 < dim; ++d2) {
            float f2;
            imageR.buffer[d2] = f2 = (float)(data[d2] & 0xFF);
            imageG.buffer[d2] = f2;
            imageB.buffer[d2] = f2;
        }
    }

    private static void decomposeBYTE_INDEXED(BufferedImage image, ChannelImage imageR, ChannelImage imageG, ChannelImage imageB) {
        int dim = imageR.width * imageR.height;
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        IndexColorModel model = (IndexColorModel)image.getColorModel();
        byte[] rr = new byte[256];
        byte[] gg = new byte[256];
        byte[] bb2 = new byte[256];
        model.getReds(rr);
        model.getGreens(gg);
        model.getBlues(bb2);
        for (int d2 = 0; d2 < dim; ++d2) {
            int v2 = data[d2] & 0xFF;
            imageR.buffer[d2] = rr[v2] & 0xFF;
            imageG.buffer[d2] = gg[v2] & 0xFF;
            imageB.buffer[d2] = bb2[v2] & 0xFF;
        }
    }

    private static void decomposeBYTE_BGR(BufferedImage image, ChannelImage imageR, ChannelImage imageG, ChannelImage imageB) {
        int p2 = 0;
        int c2 = 0;
        int dim = imageR.width * imageR.height;
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int d2 = 0; d2 < dim; ++d2) {
            imageB.buffer[c2] = data[p2++] & 0xFF;
            imageG.buffer[c2] = data[p2++] & 0xFF;
            imageR.buffer[c2] = data[p2++] & 0xFF;
            ++c2;
        }
    }

    private static void decomposeBYTE_ABGR(BufferedImage image, ChannelImage imageR, ChannelImage imageG, ChannelImage imageB, ChannelImage imageA) {
        int p2 = 0;
        int dim = imageR.width * imageR.height;
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int d2 = 0; d2 < dim; ++d2) {
            imageA.buffer[d2] = data[p2++] & 0xFF;
            imageB.buffer[d2] = data[p2++] & 0xFF;
            imageG.buffer[d2] = data[p2++] & 0xFF;
            imageR.buffer[d2] = data[p2++] & 0xFF;
        }
    }

    private static void decomposeINT_BGR(BufferedImage image, ChannelImage imageR, ChannelImage imageG, ChannelImage imageB) {
        int dim = imageR.width * imageR.height;
        int[] data = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int d2 = 0; d2 < dim; ++d2) {
            int v2 = data[d2];
            imageR.buffer[d2] = v2 & 0xFF;
            imageG.buffer[d2] = v2 >> 8 & 0xFF;
            imageB.buffer[d2] = v2 >> 16 & 0xFF;
        }
    }

    private static void decomposeINT_RGB(BufferedImage image, ChannelImage imageR, ChannelImage imageG, ChannelImage imageB) {
        int dim = imageR.width * imageR.height;
        int[] data = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int d2 = 0; d2 < dim; ++d2) {
            int v2 = data[d2];
            imageR.buffer[d2] = v2 >> 16 & 0xFF;
            imageG.buffer[d2] = v2 >> 8 & 0xFF;
            imageB.buffer[d2] = v2 & 0xFF;
        }
    }

    private static void decomposeINT_ARGB(BufferedImage image, ChannelImage imageR, ChannelImage imageG, ChannelImage imageB, ChannelImage imageA) {
        int dim = imageR.width * imageR.height;
        int[] data = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int d2 = 0; d2 < dim; ++d2) {
            int v2 = data[d2];
            imageA.buffer[d2] = v2 >> 24 & 0xFF;
            imageR.buffer[d2] = v2 >> 16 & 0xFF;
            imageG.buffer[d2] = v2 >> 8 & 0xFF;
            imageB.buffer[d2] = v2 & 0xFF;
        }
    }

    private static BufferedImage channelCompose(ChannelImage[] channels, int imageType) {
        BufferedImage image;
        ChannelImage imageR = channels[0];
        int p2 = 0;
        int c2 = 0;
        int dim = imageR.width * imageR.height;
        if (imageType == 10) {
            image = new BufferedImage(imageR.width, imageR.height, 10);
            byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            for (int d2 = 0; d2 < dim; ++d2) {
                float r2 = imageR.buffer[d2];
                data[d2] = (byte)(r2 < 0.0f ? 0.0f : (r2 > 255.0f ? 255.0f : r2));
            }
        } else {
            ChannelImage imageG = channels[1];
            ChannelImage imageB = channels[2];
            if (channels[3] != null) {
                ChannelImage imageA = channels[3];
                image = new BufferedImage(imageR.width, imageR.height, 6);
                byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int hh = imageR.height;
                for (int h2 = 0; h2 < hh; ++h2) {
                    int ww = imageR.width;
                    for (int w2 = 0; w2 < ww; ++w2) {
                        float a10 = imageA.buffer[c2];
                        float b2 = imageB.buffer[c2];
                        float g2 = imageG.buffer[c2];
                        float r3 = imageR.buffer[c2];
                        data[p2++] = (byte)(a10 < 0.0f ? 0 : (byte)(a10 > 255.0f ? -1 : (byte)a10));
                        data[p2++] = (byte)(b2 < 0.0f ? 0 : (byte)(b2 > 255.0f ? -1 : (byte)b2));
                        data[p2++] = (byte)(g2 < 0.0f ? 0 : (byte)(g2 > 255.0f ? -1 : (byte)g2));
                        data[p2++] = (byte)(r3 < 0.0f ? 0 : (byte)(r3 > 255.0f ? -1 : (byte)r3));
                        ++c2;
                    }
                }
            } else {
                image = new BufferedImage(imageR.width, imageR.height, 5);
                byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int hh = imageR.height;
                for (int h3 = 0; h3 < hh; ++h3) {
                    int ww = imageR.width;
                    for (int w3 = 0; w3 < ww; ++w3) {
                        float b3 = imageB.buffer[c2];
                        float g3 = imageG.buffer[c2];
                        float r4 = imageR.buffer[c2];
                        data[p2++] = (byte)(b3 < 0.0f ? 0 : (byte)(b3 > 255.0f ? -1 : (byte)b3));
                        data[p2++] = (byte)(g3 < 0.0f ? 0 : (byte)(g3 > 255.0f ? -1 : (byte)g3));
                        data[p2++] = (byte)(r4 < 0.0f ? 0 : (byte)(r4 > 255.0f ? -1 : (byte)r4));
                        ++c2;
                    }
                }
            }
        }
        return image;
    }

    private static ChannelImage extrapolation(ChannelImage ci) {
        int px = 7;
        int height = ci.height;
        int width = ci.width;
        ChannelImage result = new ChannelImage(width + 14, height + 14);
        int hh = height + 14;
        for (int h2 = 0; h2 < hh; ++h2) {
            int ww = width + 14;
            for (int w2 = 0; w2 < ww; ++w2) {
                int index = w2 + h2 * ww;
                if (w2 < 7) {
                    if (h2 < 7) {
                        result.buffer[index] = ci.buffer[0];
                        continue;
                    }
                    if (7 + height <= h2) {
                        result.buffer[index] = ci.buffer[(height - 1) * width];
                        continue;
                    }
                    result.buffer[index] = ci.buffer[(h2 - 7) * width];
                    continue;
                }
                if (7 + width <= w2) {
                    if (h2 < 7) {
                        result.buffer[index] = ci.buffer[width - 1];
                        continue;
                    }
                    if (7 + height <= h2) {
                        result.buffer[index] = ci.buffer[width - 1 + (height - 1) * width];
                        continue;
                    }
                    result.buffer[index] = ci.buffer[width - 1 + (h2 - 7) * width];
                    continue;
                }
                result.buffer[index] = h2 < 7 ? ci.buffer[w2 - 7] : (7 + height <= h2 ? ci.buffer[w2 - 7 + (height - 1) * width] : ci.buffer[w2 - 7 + (h2 - 7) * width]);
            }
        }
        return result;
    }

    private static ChannelImage resize2x(ChannelImage ci) {
        int dw = ci.width * 2;
        int dh = ci.height * 2;
        ChannelImage scaled_image = new ChannelImage(dw, dh);
        for (int h2 = 0; h2 < dh; ++h2) {
            for (int w2 = 0; w2 < dw; ++w2) {
                int scaled_index = w2 + h2 * dw;
                int w_orig = Math.round((float)(w2 + 1) / 2.0f) - 1;
                int h_orig = Math.round((float)(h2 + 1) / 2.0f) - 1;
                int index_orig = w_orig + h_orig * ci.width;
                scaled_image.buffer[scaled_index] = ci.buffer[index_orig];
            }
        }
        return scaled_image;
    }

    private static Holder blocking(ImagePlane[] initialPlanes) {
        int widthInput = initialPlanes[0].width;
        int heightInput = initialPlanes[0].height;
        int blocksW = (int)Math.ceil((1.0 * (double)widthInput - 14.0) / 114.0);
        int blocksH = (int)Math.ceil((1.0 * (double)heightInput - 14.0) / 114.0);
        int blocks = blocksW * blocksH;
        ImagePlane[][] inputBlocks = new ImagePlane[blocks][];
        for (int b2 = 0; b2 < blocks; ++b2) {
            int n2;
            int blockIndexW = b2 % blocksW;
            int blockIndexH = b2 / blocksW;
            int blockWidth = blockIndexW == blocksW - 1 ? widthInput - 114 * blockIndexW : 128;
            int blockHeight = blockIndexH == blocksH - 1 ? heightInput - 114 * blockIndexH : 128;
            ImagePlane[] channels = new ImagePlane[initialPlanes.length];
            for (n2 = 0; n2 < initialPlanes.length; ++n2) {
                channels[n2] = new ImagePlane(blockWidth, blockHeight);
            }
            for (int w2 = 0; w2 < blockWidth; ++w2) {
                for (int h2 = 0; h2 < blockHeight; ++h2) {
                    for (n2 = 0; n2 < initialPlanes.length; ++n2) {
                        int targetIndexW = blockIndexW * 114 + w2;
                        int targetIndexH = blockIndexH * 114 + h2;
                        ImagePlane channel = initialPlanes[n2];
                        float v2 = channel.getValue(targetIndexW, targetIndexH);
                        channels[n2].setValue(w2, h2, v2);
                    }
                }
            }
            inputBlocks[b2] = channels;
        }
        Holder hold = new Holder();
        hold.inputBlocks = inputBlocks;
        hold.blockW = blocksW;
        hold.blockH = blocksH;
        return hold;
    }

    private static ImagePlane[] deblocking(ImagePlane[][] outputBlocks, int blocksW, int blocksH) {
        int block_size = outputBlocks[0][0].width;
        int width = SuperResolution.getWidth(outputBlocks, blocksW);
        int height = SuperResolution.getHeight(outputBlocks, blocksW, blocksH);
        ImagePlane[] outputPlanes = new ImagePlane[3];
        for (int b2 = 0; b2 < outputBlocks.length; ++b2) {
            ImagePlane[] block = outputBlocks[b2];
            int blockIndexW = b2 % blocksW;
            int blockIndexH = b2 / blocksW;
            for (int n2 = 0; n2 < block.length; ++n2) {
                if (outputPlanes[n2] == null) {
                    outputPlanes[n2] = new ImagePlane(width, height);
                }
                ImagePlane channelBlock = block[n2];
                int p2 = 0;
                for (int h2 = 0; h2 < channelBlock.height; ++h2) {
                    for (int w2 = 0; w2 < channelBlock.width; ++w2) {
                        int targetIndexW = blockIndexW * block_size + w2;
                        int targetIndexH = blockIndexH * block_size + h2;
                        int targetIndex = targetIndexH * width + targetIndexW;
                        outputPlanes[n2].setValueIndexed(targetIndex, channelBlock.buffer[p2++]);
                    }
                }
            }
        }
        return outputPlanes;
    }

    private static int getHeight(ImagePlane[][] outputBlocks, int blocksW, int blocksH) {
        int height = 0;
        for (int b2 = 0; b2 < blocksW * blocksH; b2 += blocksW) {
            height += outputBlocks[b2][0].height;
        }
        return height;
    }

    private static int getWidth(ImagePlane[][] outputBlocks, int blocksW) {
        int width = 0;
        for (int b2 = 0; b2 < blocksW; ++b2) {
            width += outputBlocks[b2][0].width;
        }
        return width;
    }

    private static ImagePlane[] convolution(ImagePlane[] inputPlanes, int wi, int nOutputPlane, float[] bias, float[] sums) {
        int width = inputPlanes[0].width;
        int height = inputPlanes[0].height;
        ImagePlane[] outputPlanes = new ImagePlane[nOutputPlane];
        for (int o2 = 0; o2 < nOutputPlane; ++o2) {
            outputPlanes[o2] = new ImagePlane(width - 2, height - 2);
        }
        int niPlane = inputPlanes.length;
        float[][] widths = MATRIXWIDTHS[wi];
        int hh = height - 2;
        int ww = width - 2;
        for (int h2 = 0; h2 < hh; ++h2) {
            int hw = h2 * width;
            int h1w = (h2 + 1) * width;
            int h2w = (h2 + 2) * width;
            for (int w2 = 0; w2 < ww; ++w2) {
                float v2;
                int n2;
                System.arraycopy(bias, 0, sums, 0, nOutputPlane);
                int a12 = w2 + hw;
                int a42 = w2 + h1w;
                int a72 = w2 + h2w;
                for (int i2 = 0; i2 < niPlane; ++i2) {
                    float[] iPlane = inputPlanes[i2].buffer;
                    float i00 = iPlane[a12];
                    float i10 = iPlane[a12 + 1];
                    float i20 = iPlane[a12 + 2];
                    float i01 = iPlane[a42];
                    float i11 = iPlane[a42 + 1];
                    float i21 = iPlane[a42 + 2];
                    float i02 = iPlane[a72];
                    float i12 = iPlane[a72 + 1];
                    float i22 = iPlane[a72 + 2];
                    float[] xx = widths[i2];
                    int pp = 0;
                    n2 = 0;
                    while (n2 < nOutputPlane) {
                        v2 = i00 * xx[pp++] + i10 * xx[pp++] + i20 * xx[pp++] + i01 * xx[pp++] + i11 * xx[pp++] + i21 * xx[pp++] + i02 * xx[pp++] + i12 * xx[pp++] + i22 * xx[pp++];
                        int n3 = n2++;
                        sums[n3] = sums[n3] + v2;
                    }
                }
                for (n2 = 0; n2 < nOutputPlane; ++n2) {
                    v2 = sums[n2];
                    if (v2 < 0.0f) {
                        v2 *= 0.1f;
                    }
                    outputPlanes[n2].setValue(w2, h2, v2);
                }
            }
        }
        return outputPlanes;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String readWidths(String path) {
        try (InputStream is = SuperResolution.class.getResourceAsStream("/com/idrsolutions/image/res/w" + path + ".txt");){
            String string;
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                int nRead;
                byte[] data = new byte[4096];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                buffer.close();
                string = buffer.toString();
            }
            return string;
        }
        catch (IOException e2) {
            LogWriter.writeLog(e2);
            return null;
        }
    }

    public static BufferedImage scale2x(BufferedImage image) {
        SuperResolution.optimiseImage(image);
        if (MATRIXWIDTHS == null) {
            SuperResolution.initMatrixWidths();
        }
        int iw = image.getWidth();
        int ih = image.getHeight();
        int nComp = 3;
        ChannelImage[] rgba = SuperResolution.channelDecompose(image);
        ImagePlane[] inputPlanes = new ImagePlane[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            rgba[i2] = SuperResolution.resize2x(rgba[i2]);
            rgba[i2] = SuperResolution.extrapolation(rgba[i2]);
            inputPlanes[i2] = SuperResolution.normalize(rgba[i2]);
        }
        rgba[3] = SuperResolution.resizeAlpha(rgba[3], iw, ih);
        Holder holder = SuperResolution.blocking(inputPlanes);
        ImagePlane[][] outputBlocks = new ImagePlane[holder.inputBlocks.length][];
        float[] sum1 = new float[3];
        float[] sum2 = new float[32];
        float[] sum3 = new float[64];
        float[] sum4 = new float[128];
        int bb2 = holder.inputBlocks.length;
        for (int b2 = 0; b2 < bb2; ++b2) {
            ImagePlane[] inputBlock = holder.inputBlocks[b2];
            ImagePlane[] outputBlock = null;
            for (int l2 = 0; l2 < 7; ++l2) {
                float[] bias;
                float[] sums;
                switch (l2 + 1) {
                    case 1: {
                        sums = sum2;
                        bias = Tables.BIAS1;
                        break;
                    }
                    case 2: {
                        sums = sum2;
                        bias = Tables.BIAS2;
                        break;
                    }
                    case 3: {
                        sums = sum3;
                        bias = Tables.BIAS3;
                        break;
                    }
                    case 4: {
                        sums = sum3;
                        bias = Tables.BIAS4;
                        break;
                    }
                    case 5: {
                        sums = sum4;
                        bias = Tables.BIAS5;
                        break;
                    }
                    case 6: {
                        sums = sum4;
                        bias = Tables.BIAS6;
                        break;
                    }
                    default: {
                        sums = sum1;
                        bias = Tables.BIAS7;
                    }
                }
                outputBlock = SuperResolution.convolution(inputBlock, l2, Tables.NO[l2], bias, sums);
                inputBlock = outputBlock;
                holder.inputBlocks[b2] = null;
            }
            outputBlocks[b2] = outputBlock;
            LogWriter.writeLog("Processed " + (int)(100.0 * (double)(b2 + 1) / (double)bb2) + '%');
        }
        ImagePlane[] outputPlanes = SuperResolution.deblocking(outputBlocks, holder.blockW, holder.blockH);
        for (int i3 = 0; i3 < 3; ++i3) {
            rgba[i3] = SuperResolution.denormalize(outputPlanes[i3]);
        }
        return SuperResolution.channelCompose(rgba, image.getType());
    }

    private static void initMatrixWidths() {
        for (int i2 = 0; i2 < 7; ++i2) {
            float[] result;
            switch (i2 + 1) {
                case 1: {
                    result = Tables.WEIGHT1;
                    break;
                }
                case 7: {
                    result = Tables.WEIGHT7;
                    break;
                }
                default: {
                    String str = SuperResolution.readWidths(String.valueOf(i2 + 1));
                    String[] values = str != null ? str.split(",") : new String[]{};
                    result = new float[values.length];
                    for (int j2 = 0; j2 < values.length; ++j2) {
                        double res = Double.parseDouble(values[j2]);
                        result[j2] = (float)res;
                    }
                }
            }
            W.add(result);
        }
        int[] inp = new int[]{3, 32, 32, 64, 64, 128, 128};
        int[] out = new int[]{32, 32, 64, 64, 128, 128, 3};
        MATRIXWIDTHS = new float[7][][];
        for (int i3 = 0; i3 < 7; ++i3) {
            SuperResolution.MATRIXWIDTHS[i3] = new float[inp[i3]][];
            SuperResolution.readWidthsFromW(W.get(i3), MATRIXWIDTHS[i3], inp[i3], out[i3]);
        }
    }

    private static void readWidthsFromW(float[] W2, float[][] widths, int niPlane, int nOutputPlane) {
        for (int j2 = 0; j2 < niPlane; ++j2) {
            float[] iPlane = new float[nOutputPlane * 9];
            int aa2 = 0;
            for (int k2 = 0; k2 < nOutputPlane; ++k2) {
                int pp = (k2 * niPlane + j2) * 9;
                for (int l2 = 0; l2 < 9; ++l2) {
                    iPlane[aa2++] = W2[pp++];
                }
            }
            widths[j2] = iPlane;
        }
    }

    private static ChannelImage resizeAlpha(ChannelImage ch, int iw, int ih) {
        if (ch == null) {
            return null;
        }
        BufferedImage img = new BufferedImage(iw, ih, 10);
        byte[] pix = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        int ii = pix.length;
        for (int i2 = 0; i2 < ii; ++i2) {
            pix[i2] = (byte)ch.buffer[i2];
        }
        img = SuperResolution.scale2x(img);
        pix = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        ChannelImage res = new ChannelImage(iw * 2, ih * 2);
        int ii2 = pix.length;
        for (int i3 = 0; i3 < ii2; ++i3) {
            res.buffer[i3] = pix[i3] & 0xFF;
        }
        return res;
    }

    static {
        W = new ArrayList<float[]>();
    }
}

