/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png.data;

import java.util.Arrays;

public class Quant32 {
    private static final int IndexBits = 6;
    private static final int IndexBitsPlus = 7;
    private static final int DoubleIndexBits = 12;
    private static final int IndexAlphaBits = 3;
    private static final int SumBits = 9;
    private static final int IndexCount = 65;
    private static final int IndexAlphaCount = 9;
    private static final int TableLength = 2471625;
    private final int[] vwt = new int[2471625];
    private final int[] vmr = new int[2471625];
    private final int[] vmg = new int[2471625];
    private final int[] vmb = new int[2471625];
    private final int[] vma = new int[2471625];
    private final double[] m2 = new double[2471625];

    private static int indexify(int r2, int g2, int b2, int a10) {
        return (r2 << 15) + (r2 << 10) + (g2 << 9) + (r2 << 12) + (r2 << 7) + (g2 << 6) + (r2 + g2 + b2 << 3) + r2 + g2 + b2 + a10;
    }

    private static double volume(Cube cube, int[] moment) {
        return moment[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A1)] - moment[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A0)] - moment[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A1)] + moment[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A0)] - moment[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A1)] + moment[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A0)] + moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A1)] - moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A1)] + moment[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A1)] - moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A1)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
    }

    private static int base(Cube cube, int direction, int[] moment) {
        switch (direction) {
            case 3: {
                return -moment[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A1)] + moment[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A1)] - moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A1)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
            }
            case 2: {
                return -moment[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A1)] + moment[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A0)] + moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A1)] - moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A1)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
            }
            case 1: {
                return -moment[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A1)] + moment[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A0)] + moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A1)] - moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A1)] - moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
            }
            case 0: {
                return -moment[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A0)] + moment[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A0)] + moment[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A0)] - moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
            }
        }
        return 0;
    }

    private static int findTop(Cube cube, int direction, int position, int[] moment) {
        switch (direction) {
            case 3: {
                return moment[Quant32.indexify(position, cube.G1, cube.B1, cube.A1)] - moment[Quant32.indexify(position, cube.G1, cube.B1, cube.A0)] - moment[Quant32.indexify(position, cube.G1, cube.B0, cube.A1)] + moment[Quant32.indexify(position, cube.G1, cube.B0, cube.A0)] - moment[Quant32.indexify(position, cube.G0, cube.B1, cube.A1)] + moment[Quant32.indexify(position, cube.G0, cube.B1, cube.A0)] + moment[Quant32.indexify(position, cube.G0, cube.B0, cube.A1)] - moment[Quant32.indexify(position, cube.G0, cube.B0, cube.A0)];
            }
            case 2: {
                return moment[Quant32.indexify(cube.R1, position, cube.B1, cube.A1)] - moment[Quant32.indexify(cube.R1, position, cube.B1, cube.A0)] - moment[Quant32.indexify(cube.R1, position, cube.B0, cube.A1)] + moment[Quant32.indexify(cube.R1, position, cube.B0, cube.A0)] - moment[Quant32.indexify(cube.R0, position, cube.B1, cube.A1)] + moment[Quant32.indexify(cube.R0, position, cube.B1, cube.A0)] + moment[Quant32.indexify(cube.R0, position, cube.B0, cube.A1)] - moment[Quant32.indexify(cube.R0, position, cube.B0, cube.A0)];
            }
            case 1: {
                return moment[Quant32.indexify(cube.R1, cube.G1, position, cube.A1)] - moment[Quant32.indexify(cube.R1, cube.G1, position, cube.A0)] - moment[Quant32.indexify(cube.R1, cube.G0, position, cube.A1)] + moment[Quant32.indexify(cube.R1, cube.G0, position, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G1, position, cube.A1)] + moment[Quant32.indexify(cube.R0, cube.G1, position, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G0, position, cube.A1)] - moment[Quant32.indexify(cube.R0, cube.G0, position, cube.A0)];
            }
            case 0: {
                return moment[Quant32.indexify(cube.R1, cube.G1, cube.B1, position)] - moment[Quant32.indexify(cube.R1, cube.G1, cube.B0, position)] - moment[Quant32.indexify(cube.R1, cube.G0, cube.B1, position)] + moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, position)] - moment[Quant32.indexify(cube.R0, cube.G1, cube.B1, position)] + moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, position)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, position)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, position)];
            }
        }
        return 0;
    }

    private void histogram(int[] image, int bw, int bh2) {
        int mm = 2;
        int nn = 5;
        int pp = 0;
        for (int y2 = 0; y2 < bh2; ++y2) {
            for (int x2 = 0; x2 < bw; ++x2) {
                int ind;
                int val = image[pp++];
                int a10 = val >> 24 & 0xFF;
                int r2 = val >> 16 & 0xFF;
                int g2 = val >> 8 & 0xFF;
                int b2 = val & 0xFF;
                int inr = r2 >> 2;
                int ing = g2 >> 2;
                int inb = b2 >> 2;
                int ina = a10 >> 5;
                int n2 = ind = Quant32.indexify(inr + 1, ing + 1, inb + 1, ina + 1);
                this.vwt[n2] = this.vwt[n2] + 1;
                int n3 = ind;
                this.vmr[n3] = this.vmr[n3] + r2;
                int n4 = ind;
                this.vmg[n4] = this.vmg[n4] + g2;
                int n5 = ind;
                this.vmb[n5] = this.vmb[n5] + b2;
                int n6 = ind;
                this.vma[n6] = this.vma[n6] + a10;
                int n7 = ind;
                this.m2[n7] = this.m2[n7] + (double)(r2 * r2 + g2 * g2 + b2 * b2 + a10 * a10);
            }
        }
    }

    private void M3d() {
        int indexOffset = Quant32.indexify(1, 0, 0, 0);
        int multiCount = 585;
        int[] volume = new int[585];
        int[] volR = new int[585];
        int[] volG = new int[585];
        int[] volB = new int[585];
        int[] volA = new int[585];
        double[] volTemp = new double[585];
        int[] area = new int[9];
        int[] areaR = new int[9];
        int[] areaG = new int[9];
        int[] areaB = new int[9];
        int[] areaA = new int[9];
        double[] areaTemp = new double[9];
        for (int r2 = 1; r2 < 65; ++r2) {
            Arrays.fill(volume, 0);
            Arrays.fill(volR, 0);
            Arrays.fill(volG, 0);
            Arrays.fill(volB, 0);
            Arrays.fill(volA, 0);
            Arrays.fill(volTemp, 0.0);
            int indR = r2 + (r2 << 15) + (r2 << 10) + (r2 << 12) + (r2 << 7) + (r2 << 3);
            for (int g2 = 1; g2 < 65; ++g2) {
                Arrays.fill(area, 0);
                Arrays.fill(areaR, 0);
                Arrays.fill(areaG, 0);
                Arrays.fill(areaB, 0);
                Arrays.fill(areaA, 0);
                Arrays.fill(areaTemp, 0.0);
                int indG = g2 + (g2 << 9) + (g2 << 6) + (g2 << 3);
                for (int b2 = 1; b2 < 65; ++b2) {
                    int line = 0;
                    int line_r = 0;
                    int line_g = 0;
                    int line_b = 0;
                    int line_a = 0;
                    double line2 = 0.0;
                    int indB = b2 + (b2 << 3);
                    for (int a10 = 1; a10 < 9; ++a10) {
                        int inv;
                        int ind1 = indR + indG + indB + a10;
                        line += this.vwt[ind1];
                        line_r += this.vmr[ind1];
                        line_g += this.vmg[ind1];
                        line_b += this.vmb[ind1];
                        line_a += this.vma[ind1];
                        line2 += this.m2[ind1];
                        int n2 = a10;
                        area[n2] = area[n2] + line;
                        int n3 = a10;
                        areaR[n3] = areaR[n3] + line_r;
                        int n4 = a10;
                        areaG[n4] = areaG[n4] + line_g;
                        int n5 = a10;
                        areaB[n5] = areaB[n5] + line_b;
                        int n6 = a10;
                        areaA[n6] = areaA[n6] + line_a;
                        int n7 = a10;
                        areaTemp[n7] = areaTemp[n7] + line2;
                        int n8 = inv = b2 * 9 + a10;
                        volume[n8] = volume[n8] + area[a10];
                        int n9 = inv;
                        volR[n9] = volR[n9] + areaR[a10];
                        int n10 = inv;
                        volG[n10] = volG[n10] + areaG[a10];
                        int n11 = inv;
                        volB[n11] = volB[n11] + areaB[a10];
                        int n12 = inv;
                        volA[n12] = volA[n12] + areaA[a10];
                        int n13 = inv;
                        volTemp[n13] = volTemp[n13] + areaTemp[a10];
                        int ind2 = ind1 - indexOffset;
                        this.vwt[ind1] = this.vwt[ind2] + volume[inv];
                        this.vmr[ind1] = this.vmr[ind2] + volR[inv];
                        this.vmg[ind1] = this.vmg[ind2] + volG[inv];
                        this.vmb[ind1] = this.vmb[ind2] + volB[inv];
                        this.vma[ind1] = this.vma[ind2] + volA[inv];
                        this.m2[ind1] = this.m2[ind2] + volTemp[inv];
                    }
                }
            }
        }
    }

    private double variance(Cube cube) {
        double dr = Quant32.volume(cube, this.vmr);
        double dg = Quant32.volume(cube, this.vmg);
        double db = Quant32.volume(cube, this.vmb);
        double da = Quant32.volume(cube, this.vma);
        double cc = this.m2[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A1)] - this.m2[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A0)] - this.m2[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A1)] + this.m2[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A0)] - this.m2[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A1)] + this.m2[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A0)] + this.m2[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A1)] - this.m2[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] - this.m2[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A1)] + this.m2[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A0)] + this.m2[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A1)] - this.m2[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] + this.m2[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A1)] - this.m2[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] - this.m2[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + this.m2[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
        return cc - (dr * dr + dg * dg + db * db + da * da) / Quant32.volume(cube, this.vwt);
    }

    private Object[] maximize(Cube cube, int direction, int first, int last, double whole_r, double whole_g, double whole_b, double whole_a, double whole_w) {
        int base_r = Quant32.base(cube, direction, this.vmr);
        int base_g = Quant32.base(cube, direction, this.vmg);
        int base_b = Quant32.base(cube, direction, this.vmb);
        int base_a = Quant32.base(cube, direction, this.vma);
        int base_w = Quant32.base(cube, direction, this.vwt);
        double max = 0.0;
        int cut = -1;
        for (int i2 = first; i2 < last; ++i2) {
            double half_r = base_r + Quant32.findTop(cube, direction, i2, this.vmr);
            double half_g = base_g + Quant32.findTop(cube, direction, i2, this.vmg);
            double half_b = base_b + Quant32.findTop(cube, direction, i2, this.vmb);
            double half_a = base_a + Quant32.findTop(cube, direction, i2, this.vma);
            double half_w = base_w + Quant32.findTop(cube, direction, i2, this.vwt);
            if (half_w == 0.0) continue;
            double temp = (half_r * half_r + half_g * half_g + half_b * half_b + half_a * half_a) / half_w;
            half_r = whole_r - half_r;
            half_g = whole_g - half_g;
            half_b = whole_b - half_b;
            half_a = whole_a - half_a;
            if ((half_w = whole_w - half_w) == 0.0 || !((temp += (half_r * half_r + half_g * half_g + half_b * half_b + half_a * half_a) / half_w) > max)) continue;
            max = temp;
            cut = i2;
        }
        return new Object[]{cut, max};
    }

    private boolean cut(Cube set1, Cube set2) {
        int dir;
        double whole_r = Quant32.volume(set1, this.vmr);
        double whole_g = Quant32.volume(set1, this.vmg);
        double whole_b = Quant32.volume(set1, this.vmb);
        double whole_a = Quant32.volume(set1, this.vma);
        double whole_w = Quant32.volume(set1, this.vwt);
        Object[] temp = this.maximize(set1, 3, set1.R0 + 1, set1.R1, whole_r, whole_g, whole_b, whole_a, whole_w);
        int cutr = (Integer)temp[0];
        double maxr = (Double)temp[1];
        temp = this.maximize(set1, 2, set1.G0 + 1, set1.G1, whole_r, whole_g, whole_b, whole_a, whole_w);
        int cutg = (Integer)temp[0];
        double maxg = (Double)temp[1];
        temp = this.maximize(set1, 1, set1.B0 + 1, set1.B1, whole_r, whole_g, whole_b, whole_a, whole_w);
        int cutb = (Integer)temp[0];
        double maxb = (Double)temp[1];
        temp = this.maximize(set1, 0, set1.A0 + 1, set1.A1, whole_r, whole_g, whole_b, whole_a, whole_w);
        int cuta = (Integer)temp[0];
        double maxa = (Double)temp[1];
        if (maxr >= maxg && maxr >= maxb && maxr >= maxa) {
            dir = 3;
            if (cutr < 0) {
                return false;
            }
        } else {
            dir = maxg >= maxr && maxg >= maxb && maxg >= maxa ? 2 : (maxb >= maxr && maxb >= maxg && maxb >= maxa ? 1 : 0);
        }
        set2.R1 = set1.R1;
        set2.G1 = set1.G1;
        set2.B1 = set1.B1;
        set2.A1 = set1.A1;
        switch (dir) {
            case 3: {
                set2.R0 = set1.R1 = cutr;
                set2.G0 = set1.G0;
                set2.B0 = set1.B0;
                set2.A0 = set1.A0;
                break;
            }
            case 2: {
                set2.G0 = set1.G1 = cutg;
                set2.R0 = set1.R0;
                set2.B0 = set1.B0;
                set2.A0 = set1.A0;
                break;
            }
            case 1: {
                set2.B0 = set1.B1 = cutb;
                set2.R0 = set1.R0;
                set2.G0 = set1.G0;
                set2.A0 = set1.A0;
                break;
            }
            case 0: {
                set2.A0 = set1.A1 = cuta;
                set2.R0 = set1.R0;
                set2.G0 = set1.G0;
                set2.B0 = set1.B0;
            }
        }
        set1.Volume = (set1.R1 - set1.R0) * (set1.G1 - set1.G0) * (set1.B1 - set1.B0) * (set1.A1 - set1.A0);
        set2.Volume = (set2.R1 - set2.R0) * (set2.G1 - set2.G0) * (set2.B1 - set2.B0) * (set2.A1 - set2.A0);
        return true;
    }

    private void buildCube(Cube[] cube) {
        double[] vv = new double[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            cube[i2] = new Cube();
        }
        cube[0].A0 = 0;
        cube[0].B0 = 0;
        cube[0].G0 = 0;
        cube[0].R0 = 0;
        cube[0].B1 = 64;
        cube[0].G1 = 64;
        cube[0].R1 = 64;
        cube[0].A1 = 8;
        int next = 0;
        for (int i3 = 1; i3 < 256; ++i3) {
            if (this.cut(cube[next], cube[i3])) {
                vv[next] = cube[next].Volume > 1 ? this.variance(cube[next]) : 0.0;
                vv[i3] = cube[i3].Volume > 1 ? this.variance(cube[i3]) : 0.0;
            } else {
                vv[next] = 0.0;
                --i3;
            }
            next = 0;
            double temp = vv[0];
            for (int k2 = 1; k2 <= i3; ++k2) {
                if (!(vv[k2] > temp)) continue;
                temp = vv[k2];
                next = k2;
            }
            if (temp <= 0.0) break;
        }
    }

    public Object[] getPalette(int[] image, int bw, int bh2) {
        int colorCount = 256;
        this.histogram(image, bw, bh2);
        this.M3d();
        Cube[] cube = new Cube[256];
        this.buildCube(cube);
        byte[] palette = new byte[768];
        byte[] trns = new byte[256];
        int z2 = 0;
        for (int k2 = 0; k2 < 256; ++k2) {
            double weight = Quant32.volume(cube[k2], this.vwt);
            if (weight != 0.0) {
                trns[k2] = (byte)(Quant32.volume(cube[k2], this.vma) / weight);
                palette[z2++] = (byte)(Quant32.volume(cube[k2], this.vmr) / weight);
                palette[z2++] = (byte)(Quant32.volume(cube[k2], this.vmg) / weight);
                palette[z2++] = (byte)(Quant32.volume(cube[k2], this.vmb) / weight);
                continue;
            }
            z2 += 4;
        }
        return new Object[]{palette, trns};
    }

    static class Cube {
        int A0;
        int A1;
        int R0;
        int R1;
        int G0;
        int G1;
        int B0;
        int B1;
        int Volume;

        Cube() {
        }
    }
}

