/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png.data;

import java.util.Arrays;

public class Quant24 {
    private static final int IndexBits = 7;
    private static final int IndexBitsPlus = 8;
    private static final int DoubleIndexBits = 14;
    private static final int IndexCount = 129;
    private static final int TableLength = 2146689;
    private final int[] vwt = new int[2146689];
    private final int[] vmr = new int[2146689];
    private final int[] vmg = new int[2146689];
    private final int[] vmb = new int[2146689];
    private final double[] m2 = new double[2146689];

    public byte[] getPalette(int[] image, int bw, int bh2) {
        this.histogram(image, bw, bh2);
        this.M3d();
        Cube[] cube = new Cube[256];
        this.buildCube(cube);
        byte[] palette = new byte[768];
        int z2 = 0;
        for (int k2 = 0; k2 < 256; ++k2) {
            double weight = Quant24.volume(cube[k2], this.vwt);
            if (weight != 0.0) {
                palette[z2++] = (byte)(Quant24.volume(cube[k2], this.vmr) / weight);
                palette[z2++] = (byte)(Quant24.volume(cube[k2], this.vmg) / weight);
                palette[z2++] = (byte)(Quant24.volume(cube[k2], this.vmb) / weight);
                continue;
            }
            z2 += 3;
        }
        return palette;
    }

    private static int indexify(int r2, int g2, int b2) {
        return (r2 << 14) + (r2 << 8) + (g2 << 7) + r2 + g2 + b2;
    }

    private static double volume(Cube cube, int[] moment) {
        return moment[Quant24.indexify(cube.R1, cube.G1, cube.B1)] - moment[Quant24.indexify(cube.R1, cube.G1, cube.B0)] - moment[Quant24.indexify(cube.R1, cube.G0, cube.B1)] + moment[Quant24.indexify(cube.R1, cube.G0, cube.B0)] - moment[Quant24.indexify(cube.R0, cube.G1, cube.B1)] + moment[Quant24.indexify(cube.R0, cube.G1, cube.B0)] + moment[Quant24.indexify(cube.R0, cube.G0, cube.B1)] - moment[Quant24.indexify(cube.R0, cube.G0, cube.B0)];
    }

    private static int base(Cube cube, int direction, int[] moment) {
        switch (direction) {
            case 2: {
                return -moment[Quant24.indexify(cube.R0, cube.G1, cube.B1)] + moment[Quant24.indexify(cube.R0, cube.G1, cube.B0)] + moment[Quant24.indexify(cube.R0, cube.G0, cube.B1)] - moment[Quant24.indexify(cube.R0, cube.G0, cube.B0)];
            }
            case 1: {
                return -moment[Quant24.indexify(cube.R1, cube.G0, cube.B1)] + moment[Quant24.indexify(cube.R1, cube.G0, cube.B0)] + moment[Quant24.indexify(cube.R0, cube.G0, cube.B1)] - moment[Quant24.indexify(cube.R0, cube.G0, cube.B0)];
            }
            case 0: {
                return -moment[Quant24.indexify(cube.R1, cube.G1, cube.B0)] + moment[Quant24.indexify(cube.R1, cube.G0, cube.B0)] + moment[Quant24.indexify(cube.R0, cube.G1, cube.B0)] - moment[Quant24.indexify(cube.R0, cube.G0, cube.B0)];
            }
        }
        return 0;
    }

    private static int findTop(Cube cube, int direction, int position, int[] moment) {
        switch (direction) {
            case 2: {
                return moment[Quant24.indexify(position, cube.G1, cube.B1)] - moment[Quant24.indexify(position, cube.G1, cube.B0)] - moment[Quant24.indexify(position, cube.G0, cube.B1)] + moment[Quant24.indexify(position, cube.G0, cube.B0)];
            }
            case 1: {
                return moment[Quant24.indexify(cube.R1, position, cube.B1)] - moment[Quant24.indexify(cube.R1, position, cube.B0)] - moment[Quant24.indexify(cube.R0, position, cube.B1)] + moment[Quant24.indexify(cube.R0, position, cube.B0)];
            }
            case 0: {
                return moment[Quant24.indexify(cube.R1, cube.G1, position)] - moment[Quant24.indexify(cube.R1, cube.G0, position)] - moment[Quant24.indexify(cube.R0, cube.G1, position)] + moment[Quant24.indexify(cube.R0, cube.G0, position)];
            }
        }
        return 0;
    }

    private void histogram(int[] image, int bw, int bh2) {
        boolean mm = true;
        int pp = 0;
        for (int y2 = 0; y2 < bh2; ++y2) {
            for (int x2 = 0; x2 < bw; ++x2) {
                int ind;
                int val = image[pp++];
                int r2 = val >> 16 & 0xFF;
                int g2 = val >> 8 & 0xFF;
                int b2 = val & 0xFF;
                int inr = r2 >> 1;
                int ing = g2 >> 1;
                int inb = b2 >> 1;
                int n2 = ind = Quant24.indexify(inr + 1, ing + 1, inb + 1);
                this.vwt[n2] = this.vwt[n2] + 1;
                int n3 = ind;
                this.vmr[n3] = this.vmr[n3] + r2;
                int n4 = ind;
                this.vmg[n4] = this.vmg[n4] + g2;
                int n5 = ind;
                this.vmb[n5] = this.vmb[n5] + b2;
                int n6 = ind;
                this.m2[n6] = this.m2[n6] + (double)(r2 * r2 + g2 * g2 + b2 * b2);
            }
        }
    }

    private void M3d() {
        int[] area = new int[129];
        int[] areaR = new int[129];
        int[] areaG = new int[129];
        int[] areaB = new int[129];
        double[] areaTemp = new double[129];
        for (int r2 = 1; r2 < 129; ++r2) {
            Arrays.fill(area, 0);
            Arrays.fill(areaR, 0);
            Arrays.fill(areaG, 0);
            Arrays.fill(areaB, 0);
            Arrays.fill(areaTemp, 0.0);
            for (int g2 = 1; g2 < 129; ++g2) {
                int ln = 0;
                int lr = 0;
                int lg = 0;
                int lb = 0;
                double line2 = 0.0;
                for (int b2 = 1; b2 < 129; ++b2) {
                    int ind1 = Quant24.indexify(r2, g2, b2);
                    ln += this.vwt[ind1];
                    lr += this.vmr[ind1];
                    lg += this.vmg[ind1];
                    lb += this.vmb[ind1];
                    line2 += this.m2[ind1];
                    int n2 = b2;
                    area[n2] = area[n2] + ln;
                    int n3 = b2;
                    areaR[n3] = areaR[n3] + lr;
                    int n4 = b2;
                    areaG[n4] = areaG[n4] + lg;
                    int n5 = b2;
                    areaB[n5] = areaB[n5] + lb;
                    int n6 = b2;
                    areaTemp[n6] = areaTemp[n6] + line2;
                    int ind2 = ind1 - Quant24.indexify(1, 0, 0);
                    this.vwt[ind1] = this.vwt[ind2] + area[b2];
                    this.vmr[ind1] = this.vmr[ind2] + areaR[b2];
                    this.vmg[ind1] = this.vmg[ind2] + areaG[b2];
                    this.vmb[ind1] = this.vmb[ind2] + areaB[b2];
                    this.m2[ind1] = this.m2[ind2] + areaTemp[b2];
                }
            }
        }
    }

    private double variance(Cube cube) {
        double dr = Quant24.volume(cube, this.vmr);
        double dg = Quant24.volume(cube, this.vmg);
        double db = Quant24.volume(cube, this.vmb);
        double xx = this.m2[Quant24.indexify(cube.R1, cube.G1, cube.B1)] - this.m2[Quant24.indexify(cube.R1, cube.G1, cube.B0)] - this.m2[Quant24.indexify(cube.R1, cube.G0, cube.B1)] + this.m2[Quant24.indexify(cube.R1, cube.G0, cube.B0)] - this.m2[Quant24.indexify(cube.R0, cube.G1, cube.B1)] + this.m2[Quant24.indexify(cube.R0, cube.G1, cube.B0)] + this.m2[Quant24.indexify(cube.R0, cube.G0, cube.B1)] - this.m2[Quant24.indexify(cube.R0, cube.G0, cube.B0)];
        return xx - (dr * dr + dg * dg + db * db) / Quant24.volume(cube, this.vwt);
    }

    private Object[] maximize(Cube cube, int direction, int first, int last, double whole_r, double whole_g, double whole_b, double whole_w) {
        int base_r = Quant24.base(cube, direction, this.vmr);
        int base_g = Quant24.base(cube, direction, this.vmg);
        int base_b = Quant24.base(cube, direction, this.vmb);
        int base_w = Quant24.base(cube, direction, this.vwt);
        double max = 0.0;
        int cut = -1;
        for (int i2 = first; i2 < last; ++i2) {
            double half_r = base_r + Quant24.findTop(cube, direction, i2, this.vmr);
            double half_g = base_g + Quant24.findTop(cube, direction, i2, this.vmg);
            double half_b = base_b + Quant24.findTop(cube, direction, i2, this.vmb);
            double half_w = base_w + Quant24.findTop(cube, direction, i2, this.vwt);
            if (half_w == 0.0) continue;
            double temp = (half_r * half_r + half_g * half_g + half_b * half_b) / half_w;
            half_r = whole_r - half_r;
            half_g = whole_g - half_g;
            half_b = whole_b - half_b;
            if ((half_w = whole_w - half_w) == 0.0 || !((temp += (half_r * half_r + half_g * half_g + half_b * half_b) / half_w) > max)) continue;
            max = temp;
            cut = i2;
        }
        return new Object[]{cut, max};
    }

    private boolean cut(Cube set1, Cube set2) {
        int dir;
        double whole_r = Quant24.volume(set1, this.vmr);
        double whole_g = Quant24.volume(set1, this.vmg);
        double whole_b = Quant24.volume(set1, this.vmb);
        double whole_w = Quant24.volume(set1, this.vwt);
        Object[] temp = this.maximize(set1, 2, set1.R0 + 1, set1.R1, whole_r, whole_g, whole_b, whole_w);
        int cutr = (Integer)temp[0];
        double maxr = (Double)temp[1];
        temp = this.maximize(set1, 1, set1.G0 + 1, set1.G1, whole_r, whole_g, whole_b, whole_w);
        int cutg = (Integer)temp[0];
        double maxg = (Double)temp[1];
        temp = this.maximize(set1, 0, set1.B0 + 1, set1.B1, whole_r, whole_g, whole_b, whole_w);
        int cutb = (Integer)temp[0];
        double maxb = (Double)temp[1];
        if (maxr >= maxg && maxr >= maxb) {
            dir = 2;
            if (cutr < 0) {
                return false;
            }
        } else {
            dir = maxg >= maxr && maxg >= maxb ? 1 : 0;
        }
        set2.R1 = set1.R1;
        set2.G1 = set1.G1;
        set2.B1 = set1.B1;
        switch (dir) {
            case 2: {
                set2.R0 = set1.R1 = cutr;
                set2.G0 = set1.G0;
                set2.B0 = set1.B0;
                break;
            }
            case 1: {
                set2.G0 = set1.G1 = cutg;
                set2.R0 = set1.R0;
                set2.B0 = set1.B0;
                break;
            }
            case 0: {
                set2.B0 = set1.B1 = cutb;
                set2.R0 = set1.R0;
                set2.G0 = set1.G0;
            }
        }
        set1.Volume = (set1.R1 - set1.R0) * (set1.G1 - set1.G0) * (set1.B1 - set1.B0);
        set2.Volume = (set2.R1 - set2.R0) * (set2.G1 - set2.G0) * (set2.B1 - set2.B0);
        return true;
    }

    private void buildCube(Cube[] cube) {
        double[] vv = new double[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            cube[i2] = new Cube();
        }
        cube[0].B0 = 0;
        cube[0].G0 = 0;
        cube[0].R0 = 0;
        cube[0].B1 = 128;
        cube[0].G1 = 128;
        cube[0].R1 = 128;
        int next = 0;
        for (int i3 = 1; i3 < 256; ++i3) {
            if (this.cut(cube[next], cube[i3])) {
                vv[next] = cube[next].Volume > 1 ? this.variance(cube[next]) : 0.0;
                vv[i3] = cube[i3].Volume > 1 ? this.variance(cube[i3]) : 0.0;
            } else {
                vv[next] = 0.0;
                --i3;
            }
            next = 0;
            double temp = vv[0];
            for (int k2 = 1; k2 <= i3; ++k2) {
                if (!(vv[k2] > temp)) continue;
                temp = vv[k2];
                next = k2;
            }
            if (temp <= 0.0) break;
        }
    }

    static class Cube {
        int R0;
        int R1;
        int G0;
        int G1;
        int B0;
        int B1;
        int Volume;

        Cube() {
        }
    }
}

