/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png.data;

import java.util.BitSet;

public class PngBitReader {
    private int p;
    private BitSet bitset;
    private byte[] data;
    private final boolean hasSmallBits;

    public PngBitReader(byte[] data, boolean hasSmallBits) {
        this.hasSmallBits = hasSmallBits;
        int totalBitLen = data.length * 8;
        if (this.hasSmallBits) {
            this.bitset = new BitSet(totalBitLen);
            int c2 = 0;
            for (byte b2 : data) {
                for (int j2 = 7; j2 >= 0; --j2) {
                    boolean isOn = (b2 >> j2 & 1) == 1;
                    this.bitset.set(c2, isOn);
                    ++c2;
                }
            }
        } else {
            this.data = data;
        }
    }

    private int readBits(int lenToRead) {
        int retVal = 0;
        if (this.hasSmallBits) {
            BitSet smallSet = this.bitset.get(this.p, this.p + lenToRead);
            for (int i2 = 0; i2 < lenToRead; ++i2) {
                if (smallSet.get(i2)) {
                    retVal = retVal << 1 | 1;
                    continue;
                }
                retVal <<= 1;
            }
            this.p += lenToRead;
        } else {
            int len = lenToRead / 8;
            for (int i3 = 0; i3 < len; ++i3) {
                retVal <<= 8;
                retVal |= this.data[this.p / 8] & 0xFF;
                this.p += 8;
            }
        }
        return retVal;
    }

    public int getPositive(int bitLen) {
        return this.readBits(bitLen);
    }
}

