/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png.data;

public final class D4 {
    private final int a;
    private final int r;
    private final int g;
    private final int b;
    private final int argb;

    private D4(int a10, int r2, int g2, int b2) {
        this.a = a10;
        this.r = r2;
        this.g = g2;
        this.b = b2;
        this.argb = a10 << 24 | r2 << 16 | g2 << 8 | b2;
    }

    private static int diff(int a10, int r2, int g2, int b2, D4 pal) {
        int Adiff = a10 - pal.a;
        int Rdiff = r2 - pal.r;
        int Gdiff = g2 - pal.g;
        int Bdiff = b2 - pal.b;
        return Adiff * Adiff + Rdiff * Rdiff + Gdiff * Gdiff + Bdiff * Bdiff;
    }

    private static void findClosest(int argb, D4[] palette, int[] obj) {
        D4 closest = palette[0];
        int a10 = argb >> 24 & 0xFF;
        int r2 = argb >> 16 & 0xFF;
        int g2 = argb >> 8 & 0xFF;
        int b2 = argb & 0xFF;
        int cDiff = D4.diff(a10, r2, g2, b2, closest);
        int found = 0;
        for (int i2 = 1; i2 < 256; ++i2) {
            D4 n2 = palette[i2];
            int nDiff = D4.diff(a10, r2, g2, b2, n2);
            if (nDiff >= cDiff) continue;
            closest = n2;
            found = i2;
            cDiff = nDiff;
        }
        obj[0] = closest.argb;
        obj[1] = found;
    }

    public static byte[] process(byte[] colorPalette, byte[] trns, int[] image, int h2, int w2) {
        int p2 = 0;
        D4[] palette = new D4[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            int a10 = trns[i2] & 0xFF;
            int r2 = colorPalette[p2++] & 0xFF;
            int g2 = colorPalette[p2++] & 0xFF;
            int b2 = colorPalette[p2++] & 0xFF;
            palette[i2] = new D4(a10, r2, g2, b2);
        }
        byte[] indexedPixels = new byte[h2 * w2];
        p2 = 0;
        int[] obj = new int[2];
        D4.findClosest(-1, palette, obj);
        int lastArgb = obj[0];
        for (int y2 = 0; y2 < h2; ++y2) {
            for (int x2 = 0; x2 < w2; ++x2) {
                int argb = image[y2 * w2 + x2];
                if (lastArgb != argb) {
                    D4.findClosest(argb, palette, obj);
                    lastArgb = argb;
                }
                int nextArgb = obj[0];
                indexedPixels[p2++] = (byte)obj[1];
                int a11 = argb >> 24 & 0xFF;
                int r3 = argb >> 16 & 0xFF;
                int g3 = argb >> 8 & 0xFF;
                int b3 = argb & 0xFF;
                int na = nextArgb >> 24 & 0xFF;
                int nr = nextArgb >> 16 & 0xFF;
                int ng = nextArgb >> 8 & 0xFF;
                int nb = nextArgb & 0xFF;
                int errA = a11 - na;
                int errR = r3 - nr;
                int errG = g3 - ng;
                int errB = b3 - nb;
                if (x2 + 1 < w2) {
                    image[y2 * w2 + x2 + 1] = D4.applyFloyd(image[y2 * w2 + x2 + 1], errA, errR, errG, errB, 7);
                    if (y2 + 1 < h2) {
                        image[(y2 + 1) * w2 + x2 + 1] = D4.applyFloyd(image[(y2 + 1) * w2 + x2 + 1], errA, errR, errG, errB, 1);
                    }
                }
                if (y2 + 1 >= h2) continue;
                image[(y2 + 1) * w2 + x2] = D4.applyFloyd(image[(y2 + 1) * w2 + x2], errA, errR, errG, errB, 5);
                if (x2 - 1 < 0) continue;
                image[(y2 + 1) * w2 + x2 - 1] = D4.applyFloyd(image[(y2 + 1) * w2 + x2 - 1], errA, errR, errG, errB, 3);
            }
        }
        return indexedPixels;
    }

    private static int applyFloyd(int argb, int errA, int errR, int errG, int errB, int mul) {
        int a10 = argb >> 24 & 0xFF;
        int r2 = argb >> 16 & 0xFF;
        int g2 = argb >> 8 & 0xFF;
        int b2 = argb & 0xFF;
        r2 += errR * mul / 16;
        g2 += errG * mul / 16;
        b2 += errB * mul / 16;
        if ((a10 += errA * mul / 16) < 0) {
            a10 = 0;
        } else if (a10 > 255) {
            a10 = 255;
        }
        if (r2 < 0) {
            r2 = 0;
        } else if (r2 > 255) {
            r2 = 255;
        }
        if (g2 < 0) {
            g2 = 0;
        } else if (g2 > 255) {
            g2 = 255;
        }
        if (b2 < 0) {
            b2 = 0;
        } else if (b2 > 255) {
            b2 = 255;
        }
        return a10 << 24 | r2 << 16 | g2 << 8 | b2;
    }
}

