/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png.data;

public final class D3 {
    private final int r;
    private final int g;
    private final int b;
    private final int rgb;

    private D3(int r2, int g2, int b2) {
        this.r = r2;
        this.g = g2;
        this.b = b2;
        this.rgb = r2 << 16 | g2 << 8 | b2;
    }

    private static int diff(int r2, int g2, int b2, D3 pal) {
        int Rdiff = r2 - pal.r;
        int Gdiff = g2 - pal.g;
        int Bdiff = b2 - pal.b;
        return Rdiff * Rdiff + Gdiff * Gdiff + Bdiff * Bdiff;
    }

    private static void findClosest(int r2, int g2, int b2, D3[] palette, int[] obj) {
        D3 closest = palette[0];
        int cDiff = D3.diff(r2, g2, b2, closest);
        int found = 0;
        for (int i2 = 1; i2 < 256; ++i2) {
            D3 n2 = palette[i2];
            int nDiff = D3.diff(r2, g2, b2, n2);
            if (nDiff >= cDiff) continue;
            closest = n2;
            found = i2;
            cDiff = nDiff;
        }
        obj[0] = closest.rgb;
        obj[1] = found;
    }

    public static byte[] process(byte[] colorPalette, int[] image, int h2, int w2) {
        int b2;
        int g2;
        int r2;
        int p2 = 0;
        D3[] palette = new D3[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            r2 = colorPalette[p2++] & 0xFF;
            g2 = colorPalette[p2++] & 0xFF;
            b2 = colorPalette[p2++] & 0xFF;
            palette[i2] = new D3(r2, g2, b2);
        }
        byte[] indexedPixels = new byte[h2 * w2];
        p2 = 0;
        int[] obj = new int[2];
        D3.findClosest(255, 255, 255, palette, obj);
        int lastArgb = obj[0];
        for (int y2 = 0; y2 < h2; ++y2) {
            int y1w = (y2 + 1) * w2;
            for (int x2 = 0; x2 < w2; ++x2) {
                int argb = image[y2 * w2 + x2];
                r2 = argb >> 16 & 0xFF;
                g2 = argb >> 8 & 0xFF;
                b2 = argb & 0xFF;
                if (lastArgb != argb) {
                    D3.findClosest(r2, g2, b2, palette, obj);
                    lastArgb = argb;
                }
                int nextArgb = obj[0];
                indexedPixels[p2++] = (byte)obj[1];
                int errR = r2 - (nextArgb >> 16 & 0xFF);
                int errG = g2 - (nextArgb >> 8 & 0xFF);
                int errB = b2 - (nextArgb & 0xFF);
                if (x2 + 1 < w2) {
                    image[y2 * w2 + x2 + 1] = D3.applyFloyd(image[y2 * w2 + x2 + 1], errR, errG, errB, 7);
                    if (y2 + 1 < h2) {
                        image[y1w + x2 + 1] = D3.applyFloyd(image[y1w + x2 + 1], errR, errG, errB, 1);
                    }
                }
                if (y2 + 1 >= h2) continue;
                image[y1w + x2] = D3.applyFloyd(image[y1w + x2], errR, errG, errB, 5);
                if (x2 - 1 < 0) continue;
                image[y1w + x2 - 1] = D3.applyFloyd(image[y1w + x2 - 1], errR, errG, errB, 3);
            }
        }
        return indexedPixels;
    }

    private static int applyFloyd(int argb, int errR, int errG, int errB, int mul) {
        int r2 = argb >> 16 & 0xFF;
        int g2 = argb >> 8 & 0xFF;
        int b2 = argb & 0xFF;
        g2 += errG * mul / 16;
        b2 += errB * mul / 16;
        if ((r2 += errR * mul / 16) < 0) {
            r2 = 0;
        } else if (r2 > 255) {
            r2 = 255;
        }
        if (g2 < 0) {
            g2 = 0;
        } else if (g2 > 255) {
            g2 = 255;
        }
        if (b2 < 0) {
            b2 = 0;
        } else if (b2 > 255) {
            b2 = 255;
        }
        return r2 << 16 | g2 << 8 | b2;
    }
}

