/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png.data;

import java.io.IOException;
import java.io.OutputStream;
import org.jpedal.utils.LogWriter;

public class BitWriter {
    private int bitCount;
    private int pointer;
    private final OutputStream stream;

    public BitWriter(OutputStream stream) {
        this.stream = stream;
    }

    public void end() {
        while (this.bitCount > 0) {
            this.pointer <<= 1;
            ++this.bitCount;
            if (this.bitCount != 8) continue;
            try {
                this.stream.write(this.pointer);
            }
            catch (IOException e2) {
                LogWriter.writeLog(e2);
            }
            this.pointer = 0;
            this.bitCount = 0;
        }
    }

    public void writeBits(int bits, int num) {
        while (num > 0) {
            int cbit = Math.min(num, 8 - this.bitCount);
            this.pointer = this.pointer << cbit | bits >>> num - cbit & (1 << cbit) - 1;
            this.bitCount += cbit;
            num -= cbit;
            if (this.bitCount != 8) continue;
            try {
                this.stream.write(this.pointer);
            }
            catch (IOException e2) {
                LogWriter.writeLog(e2);
            }
            this.pointer = 0;
            this.bitCount = 0;
        }
    }

    public void writeByte() {
        if (this.bitCount == 0) {
            try {
                this.stream.write(0);
            }
            catch (IOException e2) {
                LogWriter.writeLog(e2);
            }
        } else {
            this.writeBits(0, 8);
        }
    }
}

