/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.png.data.BitWriter;
import com.idrsolutions.image.png.data.D3;
import com.idrsolutions.image.png.data.D4;
import com.idrsolutions.image.png.data.PngBitReader;
import com.idrsolutions.image.png.data.PngChunk;
import com.idrsolutions.image.png.data.Quant24;
import com.idrsolutions.image.png.data.Quant32;
import com.idrsolutions.image.png.options.PngCompressionFormat;
import com.idrsolutions.image.png.options.PngEncoderOptions;
import com.idrsolutions.image.util.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.zip.Deflater;

public class PngEncoder
extends JDeliImage
implements Encoder {
    private PngEncoderOptions pngEncoderOptions = new PngEncoderOptions();

    public PngEncoder(EncoderOptions format) {
        if (format != null) {
            this.pngEncoderOptions = (PngEncoderOptions)format;
        }
    }

    public PngEncoder() {
    }

    @Override
    public void write(BufferedImage image, OutputStream outputStream) throws IOException {
        PngEncoder.optimiseImage(image);
        BufferedImage img = ImageUtils.fixSubBufferedImage(image);
        if (this.pngEncoderOptions.isOptimizeBasedOnColors()) {
            img = PngEncoder.getColorCountIndexed(img);
        }
        if (this.pngEncoderOptions.getCompressionFormat() == PngCompressionFormat.QUANTISED8BIT) {
            this.compress8Bit(img, outputStream);
        } else {
            this.compressNormal(img, outputStream);
        }
    }

    public void write(BufferedImage image, File file) throws IOException {
        PngEncoder.optimiseImage(image);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        this.write(image, bos);
        bos.flush();
        bos.close();
    }

    private static BufferedImage getColorCountIndexed(BufferedImage image) {
        int zeroCount;
        int nColors;
        byte[] pixBytes = null;
        int[] pixInts = null;
        int iw = image.getWidth();
        int ih = image.getHeight();
        int count = 0;
        int dim = image.getWidth() * image.getHeight();
        int p2 = 0;
        int a10 = 0;
        int[] countMap = new int[255];
        boolean hasBlack = false;
        int nComp = image.getColorModel().getNumComponents();
        switch (image.getType()) {
            case 5: 
            case 6: 
            case 7: {
                int i2;
                pixBytes = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (i2 = 0; i2 < dim; ++i2) {
                    int g2;
                    int r2;
                    int v2;
                    if (nComp == 4) {
                        a10 = pixBytes[p2++] & 0xFF;
                    }
                    int b2 = pixBytes[p2++] & 0xFF;
                    if ((v2 = a10 << 24 | (r2 = pixBytes[p2++] & 0xFF) << 16 | (g2 = pixBytes[p2++] & 0xFF) << 8 | b2) == 0) {
                        hasBlack = true;
                        continue;
                    }
                    if (count < 255) {
                        if (PngEncoder.checkColorInArray(countMap, count + 1, v2)) continue;
                        countMap[count++] = v2;
                        continue;
                    }
                    return image;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                int i2;
                pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                for (i2 = 0; i2 < dim; ++i2) {
                    int v3 = pixInts[i2];
                    if (v3 == 0) {
                        hasBlack = true;
                        continue;
                    }
                    if (count < 255) {
                        if (PngEncoder.checkColorInArray(countMap, count + 1, v3)) continue;
                        countMap[count++] = v3;
                        continue;
                    }
                    return image;
                }
                break;
            }
            default: {
                return image;
            }
        }
        if ((nColors = count + (zeroCount = hasBlack ? 1 : 0)) <= 256) {
            return PngEncoder.getOptimizedImage(iw, ih, nColors, nComp, pixBytes, pixInts, countMap);
        }
        return image;
    }

    private static boolean checkColorInArray(int[] arr, int max, int color) {
        int temp = arr[0];
        for (int i2 = 0; i2 < max; ++i2) {
            if (arr[i2] != color) continue;
            arr[0] = arr[i2];
            arr[i2] = temp;
            return true;
        }
        return false;
    }

    private static BufferedImage getOptimizedImage(int iw, int ih, int nColors, int nComp, byte[] pixBytes, int[] pixInts, int[] countMap) {
        int v2;
        int a10 = 0;
        int[] palette = new int[nColors];
        System.arraycopy(countMap, 0, palette, 0, nColors);
        int p2 = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BitWriter bw = new BitWriter(bos);
        int bps = PngEncoder.getBps(nColors);
        int paletteLen = 1 << bps;
        int gap = 8 - iw * bps % 8;
        for (int y2 = 0; y2 < ih; ++y2) {
            for (int x2 = 0; x2 < iw; ++x2) {
                if (pixBytes != null) {
                    if (nComp == 4) {
                        a10 = pixBytes[p2++] & 0xFF;
                    }
                    int b2 = pixBytes[p2++] & 0xFF;
                    int g2 = pixBytes[p2++] & 0xFF;
                    int r2 = pixBytes[p2++] & 0xFF;
                    v2 = a10 << 24 | r2 << 16 | g2 << 8 | b2;
                } else {
                    v2 = pixInts[p2++];
                }
                int f2 = 0;
                for (int i2 = 0; i2 < nColors; ++i2) {
                    if (v2 != palette[i2]) continue;
                    f2 = i2;
                    break;
                }
                bw.writeBits(f2, bps);
            }
            if (gap == 8) continue;
            bw.writeBits(0, gap);
        }
        bw.end();
        byte[] aa2 = new byte[paletteLen];
        byte[] rr = new byte[paletteLen];
        byte[] gg = new byte[paletteLen];
        byte[] bb2 = new byte[paletteLen];
        for (int i3 = 0; i3 < nColors; ++i3) {
            v2 = palette[i3];
            aa2[i3] = (byte)(v2 >> 24 & 0xFF);
            rr[i3] = (byte)(v2 >> 16 & 0xFF);
            gg[i3] = (byte)(v2 >> 8 & 0xFF);
            bb2[i3] = (byte)(v2 & 0xFF);
        }
        IndexColorModel cm = nComp == 4 ? new IndexColorModel(bps, paletteLen, rr, gg, bb2, aa2) : new IndexColorModel(bps, paletteLen, rr, gg, bb2);
        BufferedImage img = bps <= 4 ? new BufferedImage(iw, ih, 12, cm) : new BufferedImage(iw, ih, 13, cm);
        byte[] dd = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        System.arraycopy(bos.toByteArray(), 0, dd, 0, dd.length);
        return img;
    }

    private static int getBps(int nColors) {
        int bps;
        switch (nColors) {
            case 1: 
            case 2: {
                bps = 1;
                break;
            }
            case 3: 
            case 4: {
                bps = 2;
                break;
            }
            default: {
                bps = 8;
            }
        }
        return bps;
    }

    @Deprecated
    public boolean isCompressed() {
        return this.pngEncoderOptions.getCompressionFormat() == PngCompressionFormat.QUANTISED8BIT;
    }

    public PngEncoderOptions getEncoderOptions() {
        return this.pngEncoderOptions;
    }

    public void setEncoderOptions(PngEncoderOptions pngEncoderOptions) {
        this.pngEncoderOptions = pngEncoderOptions;
    }

    @Deprecated
    public void setCompressed(boolean compress) {
        if (compress) {
            this.pngEncoderOptions.setCompressionFormat(PngCompressionFormat.QUANTISED8BIT);
        } else {
            this.pngEncoderOptions.setCompressionFormat(PngCompressionFormat.NONE);
        }
    }

    @Deprecated
    public boolean isOptimizeBasedOnColors() {
        return this.pngEncoderOptions.isOptimizeBasedOnColors();
    }

    @Deprecated
    public void setOptimizeBasedOnColors(boolean optimizeBasedOnColors) {
        this.pngEncoderOptions.setOptimizeBasedOnColors(optimizeBasedOnColors);
    }

    private static BufferedImage fixIndex567(BufferedImage image) {
        if (image.getType() == 13) {
            int pixLen = image.getColorModel().getPixelSize();
            switch (pixLen) {
                case 5: 
                case 6: 
                case 7: {
                    BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 13);
                    result.getGraphics().drawImage(image, 0, 0, null);
                    return result;
                }
            }
        }
        return image;
    }

    private void compressNormal(BufferedImage imageInput, OutputStream outputStream) throws IOException {
        int colType;
        BufferedImage image = PngEncoder.fixIndex567(imageInput);
        int bh2 = image.getHeight();
        int bw = image.getWidth();
        ColorModel colorModel = image.getColorModel();
        boolean hasAlpha = colorModel.hasAlpha();
        int pLen = colorModel.getPixelSize();
        int nComp = colorModel.getNumComponents();
        boolean isIndexed = colorModel instanceof IndexColorModel;
        int bitDepth = PngEncoder.calculateBitDepth(pLen, nComp);
        if (isIndexed) {
            colType = 3;
            nComp = 1;
        } else {
            colType = nComp < 3 ? (hasAlpha ? 4 : 0) : (bitDepth < 8 ? (hasAlpha ? 4 : 0) : (hasAlpha ? 6 : 2));
        }
        outputStream.write(PngChunk.SIGNATURE);
        PngChunk chunk = PngChunk.createHeaderChunk(bw, bh2, (byte)bitDepth, (byte)colType, (byte)0, (byte)0, (byte)0);
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
        byte[] pixels = isIndexed && bitDepth != 8 ? PngEncoder.getIndexedPaletteData(image) : PngEncoder.getPixelData(image, bitDepth, nComp, bw, bh2);
        if (pixels == null) {
            throw new IllegalArgumentException("Invalid bit depth");
        }
        if (isIndexed) {
            PngEncoder.handleindexed(outputStream, (IndexColorModel)colorModel, bitDepth, pixels);
        }
        if (this.pngEncoderOptions.getCompressionFormat() == PngCompressionFormat.ZLIB_BETTER_COMPRESSION && bitDepth == 8 && !isIndexed) {
            PngEncoder.adjustFilters(pixels, bw, bh2, nComp);
        }
        pixels = this.getDeflatedData(pixels);
        chunk = PngChunk.createDataChunk(pixels);
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
        chunk = PngChunk.createEndChunk();
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
    }

    private static void adjustFilters(byte[] pixels, int iw, int ih, int nComp) {
        int stripLen = iw * nComp;
        int stripFiltLen = stripLen + 1;
        int matchLoc = 1;
        for (int y2 = 1; y2 < ih; ++y2) {
            int dataLoc = y2 * stripFiltLen + 1;
            boolean same = true;
            for (int x2 = 0; x2 < stripLen; ++x2) {
                if (pixels[dataLoc + x2] == pixels[matchLoc + x2]) continue;
                same = false;
                break;
            }
            if (same) {
                pixels[dataLoc - 1] = 2;
                Arrays.fill(pixels, dataLoc, dataLoc + stripLen, (byte)0);
                continue;
            }
            matchLoc = dataLoc;
        }
    }

    private static void handleindexed(OutputStream outputStream, IndexColorModel colorModel, int bitDepth, byte[] pixels) throws IOException {
        int indexModelMapSize = colorModel.getMapSize();
        int[] rgbs = new int[indexModelMapSize];
        colorModel.getRGBs(rgbs);
        if (bitDepth == 8) {
            indexModelMapSize = PngEncoder.reduceIndexMap(indexModelMapSize, rgbs, pixels);
        }
        ByteBuffer bb2 = ByteBuffer.allocate(indexModelMapSize * 3);
        for (int i2 = 0; i2 < indexModelMapSize; ++i2) {
            int color = rgbs[i2];
            bb2.put(new byte[]{(byte)(color >> 16), (byte)(color >> 8), (byte)color});
        }
        PngChunk chunk = PngChunk.createPaleteChunk(bb2.array());
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
        if (colorModel.getNumComponents() == 4) {
            byte[] trnsBytes = new byte[indexModelMapSize];
            for (int i3 = 0; i3 < indexModelMapSize; ++i3) {
                trnsBytes[i3] = (byte)(rgbs[i3] >> 24);
            }
            chunk = PngChunk.createTrnsChunk(trnsBytes);
            outputStream.write(chunk.getLength());
            outputStream.write(chunk.getName());
            outputStream.write(chunk.getData());
            outputStream.write(chunk.getCRCValue());
        }
    }

    private static int reduceIndexMap(int indexModelMapSize, int[] rgbs, byte[] pixels) {
        int i2;
        int numColors = 0;
        byte[] indexMap = new byte[indexModelMapSize];
        LinkedHashMap<Integer, Integer> colors = new LinkedHashMap<Integer, Integer>();
        for (i2 = 0; i2 < indexModelMapSize; ++i2) {
            int color = rgbs[i2];
            if (!colors.containsKey(color)) {
                indexMap[i2] = (byte)numColors;
                colors.put(color, numColors);
                ++numColors;
                continue;
            }
            indexMap[i2] = (byte)((Integer)colors.get(color)).intValue();
        }
        if (numColors < indexModelMapSize) {
            for (i2 = 0; i2 < pixels.length; ++i2) {
                pixels[i2] = indexMap[pixels[i2] & 0xFF];
            }
            Set colorSet = colors.keySet();
            int temp = 0;
            Iterator iterator = colorSet.iterator();
            while (iterator.hasNext()) {
                int c2 = (Integer)iterator.next();
                rgbs[temp++] = c2;
            }
        }
        return numColors;
    }

    private static boolean isAlphaUsed(byte[] trnsBytes) {
        for (byte trn : trnsBytes) {
            if (trn == -1) continue;
            return true;
        }
        return false;
    }

    private void compress8Bit(BufferedImage image, OutputStream outputStream) throws IOException {
        int type = image.getType();
        int bh2 = image.getHeight();
        int bw = image.getWidth();
        int dim = bh2 * bw;
        int[] argb = null;
        int[] rgb = null;
        switch (type) {
            case 5: {
                rgb = PngEncoder.handleType3ByteBGR(image);
                break;
            }
            case 6: 
            case 7: {
                argb = PngEncoder.handleType4ByteABGR(image);
                break;
            }
            case 4: {
                rgb = PngEncoder.handleTypeIntBGR(image);
                break;
            }
            case 2: 
            case 3: {
                argb = PngEncoder.handleTypeIntRGBorARGB(image);
                break;
            }
            case 1: {
                rgb = PngEncoder.handleTypeIntRGBorARGB(image);
                break;
            }
            default: {
                this.compressNormal(image, outputStream);
                return;
            }
        }
        if (argb != null) {
            this.compressARGB(outputStream, bh2, bw, dim, argb);
        } else {
            this.compressRGB(outputStream, bh2, bw, dim, rgb);
        }
    }

    private void compressRGB(OutputStream outputStream, int bh2, int bw, int dim, int[] rgb) throws IOException {
        byte[] colorPalette;
        byte[] qBytes;
        byte[] indexedPixels = new byte[dim + bh2];
        Object[] objs = PngEncoder.getIndexedMap(rgb, bw, bh2);
        if (objs != null) {
            qBytes = (byte[])objs[0];
            colorPalette = (byte[])objs[1];
        } else {
            Quant24 wu = new Quant24();
            colorPalette = wu.getPalette(rgb, bw, bh2);
            qBytes = D3.process(colorPalette, rgb, bh2, bw);
        }
        int k2 = 0;
        int z2 = 0;
        for (int i2 = 0; i2 < bh2; ++i2) {
            indexedPixels[z2++] = 0;
            for (int j2 = 0; j2 < bw; ++j2) {
                indexedPixels[z2++] = qBytes[k2++];
            }
        }
        this.writePNGToStream(outputStream, null, colorPalette, indexedPixels, bw, bh2);
    }

    private void compressARGB(OutputStream outputStream, int bh2, int bw, int dim, int[] argb) throws IOException {
        byte[] trnsBytes;
        byte[] colorPalette;
        byte[] qBytes;
        byte[] indexedPixels = new byte[dim + bh2];
        Object[] objs = PngEncoder.getIndexedMap(argb, bw, bh2);
        if (objs != null) {
            qBytes = (byte[])objs[0];
            colorPalette = (byte[])objs[1];
            trnsBytes = (byte[])objs[2];
        } else {
            Quant32 wu = new Quant32();
            Object[] obj = wu.getPalette(argb, bw, bh2);
            colorPalette = (byte[])obj[0];
            trnsBytes = (byte[])obj[1];
            qBytes = D4.process(colorPalette, trnsBytes, argb, bh2, bw);
        }
        if (!PngEncoder.isAlphaUsed(trnsBytes)) {
            trnsBytes = null;
        }
        int k2 = 0;
        int z2 = 0;
        for (int i2 = 0; i2 < bh2; ++i2) {
            indexedPixels[z2++] = 0;
            for (int j2 = 0; j2 < bw; ++j2) {
                indexedPixels[z2++] = qBytes[k2++];
            }
        }
        this.writePNGToStream(outputStream, trnsBytes, colorPalette, indexedPixels, bw, bh2);
    }

    private static int[] handleTypeIntRGBorARGB(BufferedImage image) {
        return ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
    }

    private static int[] handleTypeIntBGR(BufferedImage image) {
        int bh2 = image.getHeight();
        int bw = image.getWidth();
        int p2 = 0;
        int pp = 0;
        int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] rgb = new int[bh2 * bw];
        for (int y2 = 0; y2 < bh2; ++y2) {
            for (int x2 = 0; x2 < bw; ++x2) {
                int val = intPixels[p2++];
                int b2 = val >> 16 & 0xFF;
                int g2 = val >> 8 & 0xFF;
                int r2 = val & 0xFF;
                rgb[pp++] = r2 << 16 | g2 << 8 | b2;
            }
        }
        return rgb;
    }

    private static int[] handleType4ByteABGR(BufferedImage image) {
        int bh2 = image.getHeight();
        int bw = image.getWidth();
        int p2 = 0;
        int pp = 0;
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int[] argb = new int[bh2 * bw];
        for (int y2 = 0; y2 < bh2; ++y2) {
            for (int x2 = 0; x2 < bw; ++x2) {
                int a10 = pixels[p2++] & 0xFF;
                int b2 = pixels[p2++] & 0xFF;
                int g2 = pixels[p2++] & 0xFF;
                int r2 = pixels[p2++] & 0xFF;
                argb[pp++] = a10 << 24 | r2 << 16 | g2 << 8 | b2;
            }
        }
        return argb;
    }

    private static int[] handleType3ByteBGR(BufferedImage image) {
        int bh2 = image.getHeight();
        int bw = image.getWidth();
        int p2 = 0;
        int pp = 0;
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int[] rgb = new int[bh2 * bw];
        for (int y2 = 0; y2 < bh2; ++y2) {
            for (int x2 = 0; x2 < bw; ++x2) {
                int b2 = pixels[p2++] & 0xFF;
                int g2 = pixels[p2++] & 0xFF;
                int r2 = pixels[p2++] & 0xFF;
                rgb[pp++] = r2 << 16 | g2 << 8 | b2;
            }
        }
        return rgb;
    }

    private void writePNGToStream(OutputStream outputStream, byte[] trnsBytes, byte[] colorPalette, byte[] indexedPixels, int bw, int bh2) throws IOException {
        outputStream.write(PngChunk.SIGNATURE);
        PngChunk chunk = PngChunk.createHeaderChunk(bw, bh2, (byte)8, (byte)3, (byte)0, (byte)0, (byte)0);
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
        byte[] pixels = this.getDeflatedData(indexedPixels);
        chunk = PngChunk.createPaleteChunk(colorPalette);
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
        if (trnsBytes != null) {
            chunk = PngChunk.createTrnsChunk(trnsBytes);
            outputStream.write(chunk.getLength());
            outputStream.write(chunk.getName());
            outputStream.write(chunk.getData());
            outputStream.write(chunk.getCRCValue());
        }
        chunk = PngChunk.createDataChunk(pixels);
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
        chunk = PngChunk.createEndChunk();
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
    }

    private static Object[] getIndexedMap(int[] pixel, int bw, int bh2) {
        int[] colors = new int[256];
        int c2 = 0;
        int p2 = 0;
        int t2 = 0;
        byte[] indexedBytes = new byte[bh2 * bw];
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int pp = 0;
        for (int y2 = 0; y2 < bh2; ++y2) {
            for (int x2 = 0; x2 < bw; ++x2) {
                int key;
                Integer val;
                if ((val = (Integer)map.get(key = pixel[pp++])) == null) {
                    if (c2 > 255) {
                        return null;
                    }
                    map.put(key, c2);
                    colors[c2] = key;
                    indexedBytes[p2++] = (byte)c2;
                    ++c2;
                    continue;
                }
                indexedBytes[p2++] = (byte)val.intValue();
            }
        }
        byte[] palette = new byte[c2 * 3];
        byte[] trns = new byte[c2];
        p2 = 0;
        for (int i2 = 0; i2 < c2; ++i2) {
            int val = colors[i2];
            trns[t2++] = (byte)(val >> 24 & 0xFF);
            palette[p2++] = (byte)(val >> 16 & 0xFF);
            palette[p2++] = (byte)(val >> 8 & 0xFF);
            palette[p2++] = (byte)(val & 0xFF);
        }
        return new Object[]{indexedBytes, palette, trns};
    }

    private static byte[] getIndexedPaletteData(BufferedImage buff) throws IOException {
        byte[] pixels = ((DataBufferByte)buff.getRaster().getDataBuffer()).getData();
        int ih = buff.getHeight();
        int len = pixels.length / ih;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int k2 = 0;
            for (int i2 = 0; i2 < ih; ++i2) {
                bos.write(0);
                byte[] temp = new byte[len];
                System.arraycopy(pixels, k2, temp, 0, len);
                bos.write(temp);
                k2 += len;
            }
            bos.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    private static byte[] getBIPixelData(BufferedImage buff, int bitDepth, int bw) throws IOException {
        byte[] pixels = ((DataBufferByte)buff.getRaster().getDataBuffer()).getData();
        int multi = bitDepth == 1 ? 8 : (bitDepth == 2 ? 4 : 2);
        PngBitReader reader = new PngBitReader(pixels, true);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BitWriter writer = new BitWriter(bos);
        int cc2 = 0;
        int iter = pixels.length * multi;
        for (int i2 = 0; i2 < iter; ++i2) {
            if (cc2 == 0) {
                writer.writeByte();
            }
            writer.writeBits(reader.getPositive(bitDepth), bitDepth);
            if (++cc2 != bw) continue;
            cc2 = 0;
        }
        writer.end();
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    private static byte[] getUnknowPixelData(BufferedImage buff, int bw, int bh2, int nComp) {
        ByteBuffer out = ByteBuffer.allocate(bw * bh2 * nComp + bh2);
        int[] pixInt = ((DataBufferInt)buff.getRaster().getDataBuffer()).getData();
        int clm = 0;
        for (int i2 : pixInt) {
            if (clm == 0) {
                out.put((byte)0);
            }
            byte[] t2 = PngChunk.intToBytes(i2);
            switch (nComp) {
                case 4: {
                    out.put(new byte[]{t2[1], t2[2], t2[3], t2[0]});
                    break;
                }
                case 3: {
                    out.put(new byte[]{t2[1], t2[2], t2[3]});
                    break;
                }
                case 2: {
                    out.put(new byte[]{t2[2], t2[3]});
                    break;
                }
                case 1: {
                    out.put(t2[3]);
                }
            }
            if (++clm != bw) continue;
            clm = 0;
        }
        return out.array();
    }

    private static byte[] getShortPixelData(BufferedImage buff, int bw, int bh2, int nComp) {
        short[] shortPixels = ((DataBufferUShort)buff.getRaster().getDataBuffer()).getData();
        ByteBuffer bos16 = ByteBuffer.allocate(shortPixels.length * 2 + bh2);
        int scol = 0;
        for (int p2 = 0; p2 < shortPixels.length; p2 += nComp) {
            if (scol == 0) {
                bos16.put((byte)0);
            }
            for (int i2 = 0; i2 < nComp; ++i2) {
                bos16.putShort(shortPixels[p2 + i2]);
            }
            if (++scol != bw) continue;
            scol = 0;
        }
        return bos16.array();
    }

    private static byte[] getPixelData(BufferedImage buff, int bitDepth, int nComp, int bw, int bh2) throws IOException {
        ColorModel model = buff.getColorModel();
        switch (bitDepth) {
            case 1: 
            case 2: 
            case 4: {
                return PngEncoder.getBIPixelData(buff, bitDepth, bw);
            }
            case 8: {
                return PngEncoder.get8BitData(buff, nComp, bw, bh2, model);
            }
            case 16: {
                return PngEncoder.getShortPixelData(buff, bw, bh2, nComp);
            }
        }
        return null;
    }

    private static byte[] get8BitData(BufferedImage buff, int nComp, int bw, int bh2, ColorModel model) {
        DataBuffer dataBuff = buff.getRaster().getDataBuffer();
        switch (dataBuff.getDataType()) {
            case 0: {
                switch (buff.getType()) {
                    case 5: {
                        return PngEncoder.handleBGR(nComp, buff, bh2, bw);
                    }
                    case 6: 
                    case 7: {
                        return PngEncoder.handleABGR(nComp, buff, bh2, bw);
                    }
                }
                return PngEncoder.handleDefaultTypeByte(nComp, buff, bh2, bw);
            }
            case 3: {
                if (buff.getType() == 2 || buff.getType() == 3) {
                    return PngEncoder.handleTypeIntARGB(bw, bh2, buff);
                }
                if (buff.getType() == 1) {
                    return PngEncoder.handleTypeIntRGB(bw, bh2, buff);
                }
                if (buff.getType() == 4) {
                    return PngEncoder.handleTypeIntBGR(bw, bh2, buff);
                }
                if (model instanceof DirectColorModel) {
                    return PngEncoder.handleDirectColorModel(model, bw, bh2, buff);
                }
                return PngEncoder.getUnknowPixelData(buff, bw, bh2, nComp);
            }
        }
        return null;
    }

    private static byte[] handleDirectColorModel(ColorModel model, int bw, int bh2, BufferedImage buff) {
        int k2 = 0;
        int p2 = 0;
        int[] pixInt = ((DataBufferInt)buff.getRaster().getDataBuffer()).getData();
        DirectColorModel dm = (DirectColorModel)model;
        long rMask = PngEncoder.getMaskValue(dm.getRedMask());
        long gMask = PngEncoder.getMaskValue(dm.getGreenMask());
        long bMask = PngEncoder.getMaskValue(dm.getBlueMask());
        long aMask = PngEncoder.getMaskValue(dm.getAlphaMask());
        byte[] output = new byte[bw * bh2 * 4 + bh2];
        for (int i2 = 0; i2 < bh2; ++i2) {
            output[k2++] = 0;
            for (int j2 = 0; j2 < bw; ++j2) {
                int val = pixInt[p2++];
                output[k2++] = (byte)(val >> (int)rMask);
                output[k2++] = (byte)(val >> (int)gMask);
                output[k2++] = (byte)(val >> (int)bMask);
                output[k2++] = (byte)(val >> (int)aMask);
            }
        }
        return output;
    }

    private static byte[] handleTypeIntBGR(int bw, int bh2, BufferedImage buff) {
        int k2 = 0;
        int p2 = 0;
        byte[] output = new byte[bw * bh2 * 3 + bh2];
        int[] pixInt = ((DataBufferInt)buff.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < bh2; ++i2) {
            output[k2++] = 0;
            for (int j2 = 0; j2 < bw; ++j2) {
                int val = pixInt[p2++];
                output[k2++] = (byte)val;
                output[k2++] = (byte)(val >> 8);
                output[k2++] = (byte)(val >> 16);
            }
        }
        return output;
    }

    private static byte[] handleTypeIntRGB(int bw, int bh2, BufferedImage buff) {
        int p2 = 0;
        int k2 = 0;
        byte[] output = new byte[bw * bh2 * 3 + bh2];
        int[] pixInt = ((DataBufferInt)buff.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < bh2; ++i2) {
            output[k2++] = 0;
            for (int j2 = 0; j2 < bw; ++j2) {
                int val = pixInt[p2++];
                output[k2++] = (byte)(val >> 16);
                output[k2++] = (byte)(val >> 8);
                output[k2++] = (byte)val;
            }
        }
        return output;
    }

    private static byte[] handleTypeIntARGB(int bw, int bh2, BufferedImage buff) {
        int k2 = 0;
        int p2 = 0;
        byte[] output = new byte[bw * bh2 * 4 + bh2];
        int[] pixInt = ((DataBufferInt)buff.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < bh2; ++i2) {
            output[k2++] = 0;
            for (int j2 = 0; j2 < bw; ++j2) {
                int val = pixInt[p2++];
                output[k2++] = (byte)(val >> 16);
                output[k2++] = (byte)(val >> 8);
                output[k2++] = (byte)val;
                output[k2++] = (byte)(val >> 24);
            }
        }
        return output;
    }

    private static byte[] handleDefaultTypeByte(int nComp, BufferedImage buff, int bh2, int bw) {
        byte[] pixels8 = ((DataBufferByte)buff.getRaster().getDataBuffer()).getData();
        byte[] res = new byte[bw * bh2 * nComp + bh2];
        int pLen = pixels8.length;
        int col = 0;
        int bp2 = 0;
        for (int p2 = 0; p2 < pLen; p2 += nComp) {
            if (col == 0) {
                res[bp2++] = 0;
            }
            for (int i2 = 0; i2 < nComp; ++i2) {
                res[bp2++] = pixels8[p2 + i2];
            }
            if (++col != bw) continue;
            col = 0;
        }
        return res;
    }

    private static byte[] handleABGR(int nComp, BufferedImage buff, int bh2, int bw) {
        byte[] pixels8 = ((DataBufferByte)buff.getRaster().getDataBuffer()).getData();
        byte[] res = new byte[bw * bh2 * nComp + bh2];
        int pLen = pixels8.length;
        int bp2 = 0;
        int col = 0;
        for (int p2 = 0; p2 < pLen; p2 += nComp) {
            if (col == 0) {
                res[bp2++] = 0;
            }
            res[bp2++] = pixels8[p2 + 3];
            res[bp2++] = pixels8[p2 + 2];
            res[bp2++] = pixels8[p2 + 1];
            res[bp2++] = pixels8[p2];
            if (++col != bw) continue;
            col = 0;
        }
        return res;
    }

    private static byte[] handleBGR(int nComp, BufferedImage buff, int bh2, int bw) {
        byte[] pixels8 = ((DataBufferByte)buff.getRaster().getDataBuffer()).getData();
        int pLen = pixels8.length;
        int col = 0;
        byte[] res = new byte[bw * bh2 * nComp + bh2];
        int bp2 = 0;
        for (int p2 = 0; p2 < pLen; p2 += nComp) {
            if (col == 0) {
                res[bp2++] = 0;
            }
            res[bp2++] = pixels8[p2 + 2];
            res[bp2++] = pixels8[p2 + 1];
            res[bp2++] = pixels8[p2];
            if (++col != bw) continue;
            col = 0;
        }
        return res;
    }

    private static int getMaskValue(int mask) {
        switch (mask) {
            case 255: {
                return 0;
            }
            case 65280: {
                return 8;
            }
            case 0xFF0000: {
                return 16;
            }
        }
        return 24;
    }

    private static int calculateBitDepth(int pixelBits, int nComp) {
        if (pixelBits < 8) {
            return pixelBits;
        }
        int c2 = pixelBits / nComp;
        if (c2 == 8 || c2 == 16) {
            return c2;
        }
        return 8;
    }

    private byte[] getDeflatedData(byte[] pixels) throws IOException {
        Deflater deflater = this.pngEncoderOptions.getCompressionFormat() == PngCompressionFormat.QUANTISED8BIT || this.pngEncoderOptions.getCompressionFormat() == PngCompressionFormat.ZLIB_BETTER_COMPRESSION || this.pngEncoderOptions.isOptimizeBasedOnColors() ? new Deflater(9) : new Deflater(1);
        deflater.setInput(pixels);
        int min = Math.min(pixels.length / 2, 4096);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(min);){
            deflater.finish();
            byte[] buffer = new byte[min];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            deflater.end();
            outputStream.close();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

