/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.filter.FlateFilterOptions;
import com.idrsolutions.image.png.data.Info;
import com.idrsolutions.image.utility.BitReader;
import com.idrsolutions.image.utility.DataByteBig;
import com.idrsolutions.image.utility.DataFileBig;
import com.idrsolutions.image.utility.DataReader;
import java.awt.Rectangle;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jpedal.io.filter.Flate;
import org.jpedal.utils.LogWriter;

public class PngDecoder
extends JDeliImage
implements Decoder {
    private static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int IHDR = 1229472850;
    private static final int PLTE = 1347179589;
    private static final int IDAT = 1229209940;
    private static final int IEND = 1229278788;
    private static final int tRNS = 1951551059;
    private static final int cHRM = 1665684045;
    private static final int gAMA = 1732332865;
    private static final int iCCP = 1766015824;
    private static final int sBIT = 1933723988;
    private static final int sRGB = 1934772034;
    private static final int tEXt = 1950701684;
    private static final int iTXt = 1767135348;
    private static final int zTXt = 2052348020;
    private static final int bKGD = 1649100612;
    private static final int hIST = 1749635924;
    private static final int pHYs = 1883789683;
    private static final int sPLT = 1934642260;
    private static final int tIME = 1950960965;
    private static final int COLORTYPE_GRAY = 0;
    private static final int COLORTYPE_RGB = 2;
    private static final int COLORTYPE_PALETTE = 3;
    private static final int COLORTYPE_GRAYALPHA = 4;
    private static final int COLORTYPE_RGBALPHA = 6;
    private static final int[] LEFTVALUES = new int[]{1, 3, 7, 15, 31, 63, 127, 255};
    private static final boolean debug = false;

    @Override
    public BufferedImage read(byte[] pngRawData) throws Exception {
        Info info = new Info();
        DataByteBig reader = new DataByteBig(pngRawData);
        byte[] pngData = PngDecoder.getUncompressedPngData(info, reader);
        if (pngData.length == 0) {
            return new BufferedImage(info.width, info.height, 1);
        }
        if (info.interlace == 1 && info.bps == 8 && info.colorType == 2) {
            return PngDecoder.readInterlacedRGB(pngData, info);
        }
        List<byte[]> scanList = PngDecoder.getScanList(pngData, info);
        PngDecoder.filterScans(scanList, info);
        if (info.interlace == 1) {
            scanList = PngDecoder.fillInterlaced(scanList, info);
        }
        reader.close();
        return PngDecoder.optimiseImage(PngDecoder.getImageFromList(scanList, info));
    }

    @Override
    public BufferedImage read(File file) throws Exception {
        Info info = new Info();
        DataFileBig reader = new DataFileBig(file);
        byte[] pngData = PngDecoder.getUncompressedPngData(info, reader);
        if (pngData.length == 0) {
            return new BufferedImage(info.width, info.height, 1);
        }
        if (info.interlace == 1 && info.bps == 8 && info.colorType == 2) {
            return PngDecoder.readInterlacedRGB(pngData, info);
        }
        List<byte[]> scanList = PngDecoder.getScanList(pngData, info);
        PngDecoder.filterScans(scanList, info);
        if (info.interlace == 1) {
            scanList = PngDecoder.fillInterlaced(scanList, info);
        }
        reader.close();
        return PngDecoder.optimiseImage(PngDecoder.getImageFromList(scanList, info));
    }

    @Override
    public Rectangle readDimension(File file) throws Exception {
        Info info = new Info();
        DataFileBig reader = new DataFileBig(file);
        PngDecoder.getDimensionInfo(info, reader);
        return new Rectangle(info.width, info.height);
    }

    @Override
    public Rectangle readDimension(byte[] pngRawData) throws Exception {
        Info info = new Info();
        DataByteBig reader = new DataByteBig(pngRawData);
        PngDecoder.getDimensionInfo(info, reader);
        return new Rectangle(info.width, info.height);
    }

    private static void getDimensionInfo(Info info, DataReader reader) throws Exception {
        byte[] temp = new byte[8];
        reader.read(temp);
        for (int i2 = 0; i2 < 8; ++i2) {
            if (SIGNATURE[i2] == temp[i2]) continue;
            throw new IOException("Not a valid PNG File");
        }
        boolean isEnd = false;
        int len = reader.getLength();
        while (reader.getPosition() < len && !isEnd) {
            int chunkLen = reader.getU32();
            int chunkType = reader.getU32();
            temp = new byte[chunkLen];
            reader.read(temp);
            if (reader.getPosition() != len) {
                reader.getU32();
            }
            if (chunkType == 1229472850) {
                PngDecoder.handleIHDR(info, temp);
            }
            if (chunkType != 1229278788) continue;
            isEnd = true;
        }
    }

    private static byte[] getUncompressedPngData(Info info, DataReader reader) throws Exception {
        byte[] temp = new byte[8];
        reader.read(temp);
        for (int i2 = 0; i2 < 8; ++i2) {
            if (SIGNATURE[i2] == temp[i2]) continue;
            throw new IOException("Not a valid PNG File");
        }
        boolean isEnd = false;
        try (ByteArrayOutputStream iDataStream = new ByteArrayOutputStream();){
            int len = reader.getLength();
            block15: while (reader.getPosition() < len && !isEnd) {
                int chunkLen = reader.getU32();
                int chunkType = reader.getU32();
                temp = new byte[chunkLen];
                reader.read(temp);
                if (reader.getPosition() != len) {
                    reader.getU32();
                }
                switch (chunkType) {
                    case 1229472850: {
                        PngDecoder.handleIHDR(info, temp);
                        continue block15;
                    }
                    case 1347179589: {
                        PngDecoder.handlePLTE(info, temp);
                        continue block15;
                    }
                    case 1229209940: {
                        iDataStream.write(temp);
                        continue block15;
                    }
                    case 1229278788: {
                        isEnd = true;
                        continue block15;
                    }
                    case 1649100612: 
                    case 1665684045: 
                    case 1732332865: 
                    case 1749635924: 
                    case 1767135348: 
                    case 1883789683: 
                    case 1933723988: 
                    case 1934642260: 
                    case 1934772034: 
                    case 1950701684: 
                    case 1950960965: 
                    case 2052348020: {
                        continue block15;
                    }
                    case 1951551059: {
                        info.trnsData = (byte[])temp.clone();
                        continue block15;
                    }
                    case 1766015824: {
                        PngDecoder.handleiCCP(temp, info);
                        continue block15;
                    }
                }
            }
            iDataStream.close();
            byte[] pngData = iDataStream.toByteArray();
            Flate flate = new Flate(new FlateFilterOptions());
            byte[] byArray = flate.decode(pngData);
            return byArray;
        }
    }

    private static void handleiCCP(byte[] temp, Info info) throws Exception {
        int ni = PngDecoder.findNullIndex(temp);
        if (ni != -1) {
            info.compressionMethod = temp[ni + 1];
            if (info.compressionMethod == 0) {
                int csLen = temp.length - (ni + 2);
                byte[] cp = new byte[csLen];
                System.arraycopy(temp, ni + 2, cp, 0, csLen);
                Flate flate = new Flate(new FlateFilterOptions());
                cp = flate.decode(cp);
                try {
                    info.cs = new ICC_ColorSpace(ICC_Profile.getInstance(cp));
                }
                catch (Exception e2) {
                    LogWriter.writeLog("invalid icc profile");
                }
            }
        }
    }

    private static void handlePLTE(Info info, byte[] temp) {
        info.rr = new byte[temp.length / 3];
        info.gg = new byte[temp.length / 3];
        info.bb = new byte[temp.length / 3];
        int i2 = 0;
        for (int p2 = 0; p2 < info.rr.length; ++p2) {
            info.rr[p2] = temp[i2++];
            info.gg[p2] = temp[i2++];
            info.bb[p2] = temp[i2++];
        }
    }

    private static void handleIHDR(Info info, byte[] temp) {
        info.width = (temp[0] & 0xFF) << 24 | (temp[1] & 0xFF) << 16 | (temp[2] & 0xFF) << 8 | temp[3] & 0xFF;
        info.height = (temp[4] & 0xFF) << 24 | (temp[5] & 0xFF) << 16 | (temp[6] & 0xFF) << 8 | temp[7] & 0xFF;
        info.bps = temp[8] & 0xFF;
        info.colorType = temp[9] & 0xFF;
        info.compression = temp[10] & 0xFF;
        info.filter = temp[11] & 0xFF;
        info.interlace = temp[12] & 0xFF;
    }

    private static List<byte[]> getScanList(byte[] pngData, Info info) throws IOException {
        ArrayList<byte[]> scanList = new ArrayList<byte[]>();
        int scanFillLen = info.getScaneLineLength();
        if (info.interlace == 0) {
            info.filters = new byte[info.height];
            int p2 = 0;
            for (int i2 = 0; i2 < info.height; ++i2) {
                if (p2 + scanFillLen >= pngData.length) continue;
                byte[] b2 = new byte[scanFillLen];
                info.filters[i2] = pngData[p2++];
                System.arraycopy(pngData, p2, b2, 0, scanFillLen);
                p2 += scanFillLen;
                scanList.add(b2);
            }
        } else {
            int nComp = info.colorType == 3 ? 1 : info.getNComp();
            int[] startRow = new int[]{0, 0, 4, 0, 2, 0, 1};
            int[] startCol = new int[]{0, 4, 0, 2, 0, 1, 0};
            int[] rowInc = new int[]{8, 8, 8, 4, 4, 2, 2};
            int[] colInc = new int[]{8, 8, 4, 4, 2, 2, 1};
            int p3 = 0;
            try (ByteArrayOutputStream filterBos = new ByteArrayOutputStream();){
                for (int i3 = 0; i3 < 7; ++i3) {
                    for (int y2 = startRow[i3]; y2 < info.height; y2 += rowInc[i3]) {
                        int totalPixels = 0;
                        int x2 = startCol[i3];
                        if (x2 < info.width) {
                            while (x2 < info.width) {
                                x2 += colInc[i3];
                                ++totalPixels;
                            }
                        }
                        if (totalPixels <= 0) continue;
                        filterBos.write(pngData[p3++]);
                        int scanLen = totalPixels * info.bps * nComp + 7 >> 3;
                        byte[] temp = new byte[scanLen];
                        System.arraycopy(pngData, p3, temp, 0, scanLen);
                        p3 += scanLen;
                        scanList.add(temp);
                    }
                }
                info.filters = filterBos.toByteArray();
            }
        }
        return scanList;
    }

    private static void filterScans(List<byte[]> scanList, Info info) {
        int nComp;
        int n2 = nComp = info.colorType == 3 ? 1 : info.getNComp();
        if (info.bps == 16) {
            byte[] prevScan = null;
            int p2 = 0;
            for (byte[] scan : scanList) {
                byte filter = info.filters[p2++];
                byte[] curScan = new byte[scan.length >> 1];
                int k2 = 0;
                for (int i2 = 0; i2 < curScan.length; ++i2) {
                    curScan[i2] = scan[k2++];
                    ++k2;
                }
                if (filter != 0) {
                    PngDecoder.filterBytes(filter, curScan, prevScan, curScan.length / nComp, nComp);
                }
                k2 = 0;
                for (byte aCurScan : curScan) {
                    scan[k2++] = aCurScan;
                    ++k2;
                }
                prevScan = (byte[])curScan.clone();
            }
        } else {
            byte[] prevScan = new byte[nComp * info.width];
            int p3 = 0;
            for (byte[] scan : scanList) {
                byte filter;
                if ((filter = info.filters[p3++]) != 0) {
                    PngDecoder.filterBytes(filter, scan, prevScan, scan.length / nComp, nComp);
                }
                System.arraycopy(scan, 0, prevScan, 0, scan.length);
            }
        }
    }

    private static BufferedImage readInterlacedRGB(byte[] data, Info info) {
        int w2 = info.width;
        int h2 = info.height;
        int bpp = info.bps * info.getNComp();
        int cbpp = bpp >> 3;
        int bpl = w2 * bpp / 8;
        BufferedImage img = new BufferedImage(info.width, info.height, 5);
        byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        int[] starting_row = new int[]{0, 0, 4, 0, 2, 0, 1};
        int[] starting_col = new int[]{0, 4, 0, 2, 0, 1, 0};
        int[] row_increment = new int[]{8, 8, 8, 4, 4, 2, 2};
        int[] col_increment = new int[]{8, 8, 4, 4, 2, 2, 1};
        int di = 0;
        for (int pass = 0; pass < 7; ++pass) {
            int ri = row_increment[pass];
            int ci = col_increment[pass];
            int sw = 0;
            int sh = 0;
            int cr = starting_row[pass];
            while (cr < h2) {
                cr += ri;
                ++sh;
            }
            int cc = starting_col[pass];
            while (cc < w2) {
                cc += ci;
                ++sw;
            }
            int bpll = sw * bpp / 8;
            PngDecoder.filterZero(data, info, di, sw, sh);
            int y2 = 0;
            for (int row = starting_row[pass]; row < h2; row += ri) {
                int cdi = di + y2 * bpll << 3;
                for (int col = starting_col[pass]; col < w2; col += ci) {
                    int ii = row * bpl + col * cbpp;
                    if (cbpp >= 0) {
                        System.arraycopy(data, cdi >> 3, imgData, ii, cbpp);
                    }
                    cdi += bpp;
                }
                ++y2;
            }
            if (sw * sh == 0) continue;
            di += sh * (1 + bpll);
        }
        for (int p2 = 0; p2 < imgData.length; p2 += 3) {
            byte t0 = imgData[p2];
            imgData[p2] = imgData[p2 + 2];
            imgData[p2 + 2] = t0;
        }
        return img;
    }

    private static void filterZero(byte[] data, Info info, int off, int w2, int h2) {
        int x2;
        int bpp = info.bps * info.getNComp();
        int bpl = w2 * bpp / 8;
        bpp /= 8;
        byte type = data[off];
        if (type > 1) {
            byte[] temp = new byte[]{0, 0, 1};
            data[off] = temp[type - 2];
        }
        if (type == 3) {
            for (x2 = bpp; x2 < bpl; ++x2) {
                data[x2 + 1] = (byte)((data[x2 + 1] & 0xFF) + ((data[x2 + 1 - bpp] & 0xFF) >>> 1) & 0xFF);
            }
        }
        for (int y2 = 0; y2 < h2; ++y2) {
            int i2 = off + y2 * bpl;
            int di = i2 + y2 + 1;
            type = data[di - 1];
            if (type == 0) {
                for (x2 = 0; x2 < bpl; ++x2) {
                    data[i2 + x2] = data[di + x2];
                }
                continue;
            }
            if (type == 1) {
                while (x2 < bpp) {
                    data[i2 + x2] = data[di + x2];
                    ++x2;
                }
                while (x2 < bpl) {
                    data[i2 + x2] = (byte)((data[di + x2] & 0xFF) + (data[i2 + x2 - bpp] & 0xFF));
                    ++x2;
                }
                continue;
            }
            if (type == 2) {
                while (x2 < bpl) {
                    data[i2 + x2] = (byte)((data[di + x2] & 0xFF) + (data[i2 + x2 - bpl] & 0xFF));
                    ++x2;
                }
                continue;
            }
            if (type == 3) {
                while (x2 < bpp) {
                    data[i2 + x2] = (byte)((data[di + x2] & 0xFF) + ((data[i2 + x2 - bpl] & 0xFF) >>> 1));
                    ++x2;
                }
                while (x2 < bpl) {
                    data[i2 + x2] = (byte)((data[di + x2] & 0xFF) + ((data[i2 + x2 - bpl] & 0xFF) + (data[i2 + x2 - bpp] & 0xFF) >>> 1));
                    ++x2;
                }
                continue;
            }
            while (x2 < bpp) {
                data[i2 + x2] = (byte)((data[di + x2] & 0xFF) + PngDecoder.paeth(0, data[i2 + x2 - bpl] & 0xFF, 0));
                ++x2;
            }
            while (x2 < bpl) {
                data[i2 + x2] = (byte)((data[di + x2] & 0xFF) + PngDecoder.paeth(data[i2 + x2 - bpp] & 0xFF, data[i2 + x2 - bpl] & 0xFF, data[i2 + x2 - bpp - bpl] & 0xFF));
                ++x2;
            }
        }
    }

    private static int paeth(int a10, int b2, int c2) {
        int p2 = a10 + b2 - c2;
        int pa = p2 - a10;
        int pb = p2 - b2;
        int pc = p2 - c2;
        if (pa * pa <= pb * pb && pa * pa <= pc * pc) {
            return a10;
        }
        if (pb * pb <= pc * pc) {
            return b2;
        }
        return c2;
    }

    private static List<byte[]> fillInterlaced(List<byte[]> scanList, Info info) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int i2 = 0; i2 < info.height; ++i2) {
            byte[] temp = new byte[info.getScaneLineLength()];
            result.add(temp);
        }
        int nComp = info.colorType == 3 ? 1 : info.getNComp();
        int[] tempScans = new int[]{0, 0, 4, 0, 2, 0, 1};
        int[] startRow = new int[]{0, 0, 4, 0, 2, 0, 1};
        int[] startCol = new int[]{0, 4, 0, 2, 0, 1, 0};
        int[] rowInc = new int[]{8, 8, 8, 4, 4, 2, 2};
        int[] colInc = new int[]{8, 8, 4, 4, 2, 2, 1};
        int p2 = 0;
        for (int i3 = 0; i3 < 7; ++i3) {
            for (int y2 = startRow[i3]; y2 < info.height; y2 += rowInc[i3]) {
                int totalPixels = 0;
                int x2 = startCol[i3];
                if (x2 < info.width) {
                    while (x2 < info.width) {
                        x2 += colInc[i3];
                        ++totalPixels;
                    }
                }
                if (totalPixels <= 0) continue;
                byte[] interScan = scanList.get(p2++);
                byte[] imgScan = (byte[])result.get(tempScans[i3]);
                switch (i3) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        PngDecoder.handleCases0to5(i3, info, totalPixels, imgScan, interScan, nComp);
                        break;
                    }
                    case 6: {
                        System.arraycopy(interScan, 0, imgScan, 0, interScan.length);
                    }
                }
                int n2 = i3;
                tempScans[n2] = tempScans[n2] + rowInc[i3];
            }
        }
        return result;
    }

    private static void handleCases0to5(int i2, Info info, int totalPoints, byte[] imgScan, byte[] interScan, int nComp) {
        int[] starts = new int[]{0, 4, 0, 2, 0, 1, 0};
        int[] counts = new int[]{8, 8, 4, 4, 2, 2, 1};
        byte[] pixels = new byte[info.bps * nComp / 8];
        int pixLen = info.bps * nComp;
        int x2 = starts[i2];
        DataByteBig buffer = new DataByteBig(interScan);
        BitReader reader = new BitReader(interScan);
        if (info.bps < 8) {
            for (int z2 = 0; z2 < totalPoints; ++z2) {
                int pixel = reader.readBits(pixLen);
                PngDecoder.fillBits(imgScan, x2, pixel, pixLen);
                x2 += counts[i2];
            }
        } else {
            for (int z3 = 0; z3 < totalPoints; ++z3) {
                buffer.read(pixels);
                System.arraycopy(pixels, 0, imgScan, x2 * pixels.length, pixels.length);
                x2 += counts[i2];
            }
        }
    }

    private static void fillBits(byte[] imgScan, int x2, int pixel, int pixLen) {
        if (pixLen == 8) {
            imgScan[x2] = (byte)pixel;
            return;
        }
        int bp2 = x2 * pixLen >> 3;
        int vv = imgScan[bp2] & 0xFF;
        int l2 = x2 * pixLen % 8;
        int r2 = 8 - l2;
        int m2 = r2 - pixLen;
        imgScan[bp2] = (byte)(vv >> r2 << r2 | pixel << m2 | vv & LEFTVALUES[m2]);
    }

    private static BufferedImage getImageFromList(List<byte[]> scanList, Info info) {
        switch (info.colorType) {
            case 0: 
            case 4: {
                return PngDecoder.getGrayImage(scanList, info);
            }
            case 2: 
            case 6: {
                return PngDecoder.getRGBImage(scanList, info);
            }
            case 3: {
                return PngDecoder.getPaletteImage(scanList, info);
            }
        }
        return null;
    }

    private static BufferedImage getPaletteImage(List<byte[]> scanList, Info info) {
        IndexColorModel cm;
        int width = info.width;
        int height = info.height;
        int bps = info.bps;
        BufferedImage img = null;
        int p2 = 0;
        int scaneLine = (width * bps + 7) / 8;
        if (info.trnsData == null) {
            cm = new IndexColorModel(bps, info.rr.length, info.rr, info.gg, info.bb);
        } else {
            byte[] aa2 = new byte[info.rr.length];
            Arrays.fill(aa2, (byte)-1);
            System.arraycopy(info.trnsData, 0, aa2, 0, Math.min(info.rr.length, info.trnsData.length));
            cm = new IndexColorModel(bps, info.rr.length, info.rr, info.gg, info.bb, aa2);
        }
        switch (bps) {
            case 1: 
            case 2: 
            case 4: {
                img = new BufferedImage(width, height, 12, cm);
                break;
            }
            case 8: {
                img = new BufferedImage(width, height, 13, cm);
            }
        }
        if (img != null) {
            byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
            for (byte[] scan : scanList) {
                System.arraycopy(scan, 0, imgData, p2 * scaneLine, scaneLine);
                ++p2;
            }
        }
        return img;
    }

    private static BufferedImage getRGBImage(List<byte[]> scanList, Info info) {
        int width = info.width;
        int height = info.height;
        int bps = info.bps;
        int p2 = 0;
        int nComp = info.getNComp();
        int scanLen = width * nComp;
        BufferedImage img = info.colorType == 2 ? new BufferedImage(width, height, 5) : new BufferedImage(width, height, 6);
        byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        if (bps == 8) {
            for (byte[] scan : scanList) {
                System.arraycopy(scan, 0, imgData, p2 * scanLen, scanLen);
                ++p2;
            }
        } else {
            for (byte[] scan : scanList) {
                int k2 = 0;
                byte[] curScan = new byte[scanLen];
                for (int j2 = 0; j2 < scanLen; ++j2) {
                    curScan[j2] = scan[k2++];
                    ++k2;
                }
                System.arraycopy(curScan, 0, imgData, p2 * scanLen, scanLen);
                ++p2;
            }
        }
        if (info.colorType == 2) {
            PngDecoder.handleRGB(info, imgData);
        } else {
            PngDecoder.handleNonRGB(info, imgData);
        }
        return img;
    }

    private static void handleNonRGB(Info info, byte[] imgData) {
        int p2 = 0;
        int length = imgData.length;
        if (info.cs != null && info.cs.getNumComponents() == 3) {
            float[] rgb = new float[3];
            int lastKey = 0;
            byte byte_r = 0;
            byte byte_g = 0;
            byte byte_b = 0;
            for (int i2 = 0; i2 < length; i2 += 4) {
                int r2 = imgData[i2] & 0xFF;
                int g2 = imgData[i2 + 1] & 0xFF;
                int b2 = imgData[i2 + 2] & 0xFF;
                int key = (r2 << 16) + (g2 << 8) + b2;
                if (key != lastKey) {
                    lastKey = key;
                    rgb[0] = (float)r2 / 255.0f;
                    rgb[1] = (float)g2 / 255.0f;
                    rgb[2] = (float)b2 / 255.0f;
                    rgb = info.cs.toRGB(rgb);
                    byte_r = (byte)(rgb[0] * 255.0f);
                    byte_g = (byte)(rgb[1] * 255.0f);
                    byte_b = (byte)(rgb[2] * 255.0f);
                }
                imgData[i2] = byte_r;
                imgData[i2 + 1] = byte_g;
                imgData[i2 + 2] = byte_b;
            }
        }
        while (p2 < length) {
            byte t3;
            byte t0 = imgData[p2];
            byte t1 = imgData[p2 + 1];
            byte t2 = imgData[p2 + 2];
            imgData[p2] = t3 = imgData[p2 + 3];
            imgData[p2 + 1] = t2;
            imgData[p2 + 2] = t1;
            imgData[p2 + 3] = t0;
            p2 += 4;
        }
    }

    private static void handleRGB(Info info, byte[] imgData) {
        int p2 = 0;
        if (info.cs != null) {
            float[] rgb = new float[3];
            for (int i2 = 0; i2 < imgData.length; i2 += 3) {
                rgb[0] = (float)(imgData[i2] & 0xFF) / 255.0f;
                rgb[1] = (float)(imgData[i2 + 1] & 0xFF) / 255.0f;
                rgb[2] = (float)(imgData[i2 + 2] & 0xFF) / 255.0f;
                rgb = info.cs.toRGB(rgb);
                imgData[i2] = (byte)(rgb[0] * 255.0f);
                imgData[i2 + 1] = (byte)(rgb[1] * 255.0f);
                imgData[i2 + 2] = (byte)(rgb[2] * 255.0f);
            }
        }
        while (p2 < imgData.length) {
            byte t0 = imgData[p2];
            imgData[p2] = imgData[p2 + 2];
            imgData[p2 + 2] = t0;
            p2 += 3;
        }
    }

    private static BufferedImage getGrayImage(List<byte[]> scanList, Info info) {
        int bps = info.bps;
        BufferedImage img = null;
        switch (bps) {
            case 1: {
                img = PngDecoder.handleCase1(scanList, info, bps);
                break;
            }
            case 2: {
                img = PngDecoder.handleCase2(scanList, info, bps);
                break;
            }
            case 4: {
                img = PngDecoder.handleCase4(scanList, info, bps);
                break;
            }
            case 8: {
                img = PngDecoder.handleCase8(scanList, info, bps);
                break;
            }
            case 16: {
                img = PngDecoder.handleCase16(scanList, info);
            }
        }
        return img;
    }

    private static BufferedImage handleCase16(List<byte[]> scanList, Info info) {
        int width = info.width;
        int height = info.height;
        int p2 = 0;
        BufferedImage img = new BufferedImage(width, height, 11);
        short[] imgDataShort = ((DataBufferUShort)img.getRaster().getDataBuffer()).getData();
        for (byte[] scan : scanList) {
            int k2 = 0;
            for (int j2 = 0; j2 < width; ++j2) {
                imgDataShort[p2++] = (short)((scan[k2++] & 0xFF) << 8 | scan[k2++] & 0xFF);
            }
        }
        return img;
    }

    private static BufferedImage handleCase8(List<byte[]> scanList, Info info, int bps) {
        BufferedImage img;
        block5: {
            int p2;
            int scaneLine;
            int height;
            int width;
            block4: {
                width = info.width;
                height = info.height;
                int nComp = info.getNComp();
                scaneLine = (width * bps * nComp + 7) / 8;
                p2 = 0;
                if (info.getNComp() != 2) break block4;
                img = new BufferedImage(width, height, 6);
                byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
                for (byte[] scan : scanList) {
                    int k2 = 0;
                    for (int j2 = 0; j2 < width; ++j2) {
                        byte r2 = scan[k2++];
                        byte a10 = scan[k2++];
                        imgData[p2++] = a10;
                        imgData[p2++] = r2;
                        imgData[p2++] = r2;
                        imgData[p2++] = r2;
                    }
                }
                break block5;
            }
            img = new BufferedImage(width, height, 10);
            byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
            for (byte[] scan : scanList) {
                System.arraycopy(scan, 0, imgData, p2 * scaneLine, scaneLine);
                ++p2;
            }
            if (info.cs == null) break block5;
            float[] rgb = new float[1];
            for (int i2 = 0; i2 < imgData.length; ++i2) {
                rgb[0] = (float)(imgData[i2] & 0xFF) / 255.0f;
                rgb = info.cs.toRGB(rgb);
                imgData[i2] = (byte)(rgb[0] * 255.0f);
            }
        }
        return img;
    }

    private static BufferedImage handleCase4(List<byte[]> scanList, Info info, int bps) {
        byte[] bits4Pal = new byte[]{0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1};
        int width = info.width;
        int height = info.height;
        int nComp = info.getNComp();
        int scaneLine = (width * bps * nComp + 7) / 8;
        IndexColorModel cm = new IndexColorModel(4, 16, bits4Pal, bits4Pal, bits4Pal);
        BufferedImage img = new BufferedImage(width, height, 12, cm);
        byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        int p2 = 0;
        for (byte[] scan : scanList) {
            System.arraycopy(scan, 0, imgData, p2 * scaneLine, scaneLine);
            ++p2;
        }
        return img;
    }

    private static BufferedImage handleCase2(List<byte[]> scanList, Info info, int bps) {
        byte[] bits2Pal = new byte[]{0, 85, -86, -1};
        int width = info.width;
        int height = info.height;
        int nComp = info.getNComp();
        int scaneLine = (width * bps * nComp + 7) / 8;
        IndexColorModel cm = new IndexColorModel(2, 4, bits2Pal, bits2Pal, bits2Pal);
        BufferedImage img = new BufferedImage(width, height, 12, cm);
        byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        int p2 = 0;
        for (byte[] scan : scanList) {
            System.arraycopy(scan, 0, imgData, p2 * scaneLine, scaneLine);
            ++p2;
        }
        return img;
    }

    private static BufferedImage handleCase1(List<byte[]> scanList, Info info, int bps) {
        int width = info.width;
        int height = info.height;
        int nComp = info.getNComp();
        int scaneLine = (width * bps * nComp + 7) / 8;
        BufferedImage img = new BufferedImage(width, height, 12);
        byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        int p2 = 0;
        for (byte[] scan : scanList) {
            System.arraycopy(scan, 0, imgData, p2 * scaneLine, scaneLine);
            ++p2;
        }
        return img;
    }

    private static void filterBytes(int mode, byte[] curScan, byte[] prevScan, int width, int nComp) {
        switch (mode) {
            case 1: {
                PngDecoder.handleSub(width, nComp, curScan);
                break;
            }
            case 2: {
                PngDecoder.handleUp(width, nComp, curScan, prevScan);
                break;
            }
            case 3: {
                PngDecoder.handleAverage(width, nComp, curScan, prevScan);
                break;
            }
            case 4: {
                if (prevScan == null) {
                    PngDecoder.handleSub(width, nComp, curScan);
                    break;
                }
                PngDecoder.handleCase4(width, nComp, curScan, prevScan);
            }
        }
    }

    private static void handleCase4(int width, int nComp, byte[] curScan, byte[] prevScan) {
        for (int i2 = 0; i2 < width; ++i2) {
            for (int j2 = 0; j2 < nComp; ++j2) {
                int pc;
                int pb;
                int c2;
                int b2;
                int off = j2 + i2 * nComp;
                int x2 = curScan[off] & 0xFF;
                int prevOff = j2 + (i2 - 1) * nComp;
                int a10 = i2 == 0 ? 0 : curScan[prevOff] & 0xFF;
                int p2 = a10 + (b2 = prevScan[off] & 0xFF) - (c2 = i2 == 0 ? 0 : prevScan[prevOff] & 0xFF);
                int pa = p2 - a10;
                if (pa < 0) {
                    pa = -pa;
                }
                if ((pb = p2 - b2) < 0) {
                    pb = -pb;
                }
                if ((pc = p2 - c2) < 0) {
                    pc = -pc;
                }
                int pr = pa <= pb && pa <= pc ? a10 : (pb <= pc ? b2 : c2);
                curScan[off] = (byte)(x2 + pr & 0xFF);
            }
        }
    }

    private static void handleAverage(int width, int nComp, byte[] curScan, byte[] prevScan) {
        for (int i2 = 0; i2 < width; ++i2) {
            for (int j2 = 0; j2 < nComp; ++j2) {
                int off = j2 + i2 * nComp;
                int x2 = curScan[off] & 0xFF;
                int prevOff = j2 + (i2 - 1) * nComp;
                int a10 = i2 == 0 ? 0 : curScan[prevOff] & 0xFF;
                int b2 = prevScan != null ? prevScan[off] & 0xFF : 0;
                curScan[off] = (byte)(x2 + (a10 + b2 >> 1) & 0xFF);
            }
        }
    }

    private static void handleUp(int width, int nComp, byte[] curScan, byte[] prevScan) {
        for (int i2 = 0; i2 < width; ++i2) {
            for (int j2 = 0; j2 < nComp; ++j2) {
                int off = j2 + i2 * nComp;
                int x2 = curScan[off] & 0xFF;
                int b2 = prevScan != null ? prevScan[off] & 0xFF : 0;
                curScan[off] = (byte)(x2 + b2 & 0xFF);
            }
        }
    }

    private static void handleSub(int width, int nComp, byte[] curScan) {
        for (int i2 = 0; i2 < width; ++i2) {
            for (int j2 = 0; j2 < nComp; ++j2) {
                int off = j2 + i2 * nComp;
                int prevOff = j2 + (i2 - 1) * nComp;
                int a10 = i2 == 0 ? 0 : curScan[prevOff] & 0xFF;
                int x2 = curScan[off] & 0xFF;
                curScan[off] = (byte)(a10 + x2 & 0xFF);
            }
        }
    }

    private static int findNullIndex(byte[] temp) {
        for (int i2 = 0; i2 < temp.length; ++i2) {
            if (temp[i2] != 0) continue;
            return i2;
        }
        return -1;
    }
}

