/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.png.PngEncoder;
import com.idrsolutions.image.png.options.PngCompressionFormat;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.jpedal.utils.LogWriter;

public class PngCompressor
extends JDeliImage {
    private static final String FILENAME = "_compressed";
    private static boolean verbose;

    private static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        try (FileInputStream sourceStream = new FileInputStream(sourceFile);
             FileChannel source = sourceStream.getChannel();
             FileOutputStream destStream = new FileOutputStream(destFile);
             FileChannel destination = destStream.getChannel();){
            destination.transferFrom(source, 0L, source.size());
        }
    }

    private static byte[] getCompressedImageAsByteArray(BufferedImage image, int inputLen) throws IOException {
        ByteArrayOutputStream tempStream = new ByteArrayOutputStream(inputLen / 2);
        PngEncoder encoder = new PngEncoder();
        encoder.getEncoderOptions().setCompressionFormat(PngCompressionFormat.QUANTISED8BIT);
        encoder.write(image, tempStream);
        tempStream.flush();
        tempStream.close();
        return tempStream.toByteArray();
    }

    private static void writeSizeMessage(int originalSize, int compressedSize) {
        String diffMessage;
        if (originalSize == compressedSize) {
            diffMessage = " (same size)";
        } else {
            float diff = 1.0f - (float)compressedSize / (float)originalSize;
            diff *= 100.0f;
            if (originalSize > compressedSize) {
                diffMessage = " (" + String.format("%.02f", Float.valueOf(diff)) + "% smaller)";
            } else {
                diff = -diff;
                diffMessage = " (" + String.format("%.02f", Float.valueOf(diff)) + "% larger)";
            }
        }
        LogWriter.writeLog("Original size: " + originalSize);
        LogWriter.writeLog("Compressed size: " + compressedSize + diffMessage);
    }

    private static void compress(File input, File output) throws IOException {
        BufferedImage image;
        try {
            image = JDeli.read(input);
        }
        catch (Exception e2) {
            LogWriter.writeLog("error: Failed to read image " + input.getAbsolutePath());
            throw new IOException(e2);
        }
        if (image == null) {
            throw new IOException("error: Failed to read image " + input.getAbsolutePath());
        }
        int inputLen = (int)input.length();
        byte[] compressedImage = PngCompressor.getCompressedImageAsByteArray(image, inputLen);
        if (verbose) {
            LogWriter.writeLog("Input: " + input.getAbsolutePath());
            LogWriter.writeLog("Output: " + output.getAbsolutePath());
            PngCompressor.writeSizeMessage(inputLen, compressedImage.length);
        }
        if (compressedImage.length < inputLen) {
            if (verbose) {
                LogWriter.writeLog("Writing compressed image");
            }
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(output));){
                outputStream.write(compressedImage);
                outputStream.flush();
            }
        } else if (!input.equals(output)) {
            if (verbose) {
                LogWriter.writeLog("Writing original image (compressed image is not smaller)");
            }
            PngCompressor.copyFile(input, output);
        } else if (verbose) {
            LogWriter.writeLog("Compressed image is not smaller, not overwriting");
        }
        if (verbose) {
            LogWriter.writeLog("");
        }
    }

    public static void compress(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedImage image;
        byte[] originalImage = PngCompressor.getByteArrayFromInputStream(inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(originalImage);
        try {
            image = JDeli.read(byteArrayInputStream);
        }
        catch (Exception e2) {
            LogWriter.writeLog("error: Failed to read image");
            throw new IOException(e2);
        }
        PngCompressor.optimiseImage(image);
        if (image == null) {
            throw new IOException("error: Failed to read image");
        }
        byte[] compressedImage = PngCompressor.getCompressedImageAsByteArray(image, originalImage.length);
        if (verbose) {
            PngCompressor.writeSizeMessage(originalImage.length, compressedImage.length);
        }
        if (compressedImage.length < originalImage.length) {
            if (verbose) {
                LogWriter.writeLog("Returning compressed image");
            }
            outputStream.write(compressedImage);
        } else {
            if (verbose) {
                LogWriter.writeLog("Returning original image (compressed image is not smaller)");
            }
            outputStream.write(originalImage);
        }
        if (verbose) {
            LogWriter.writeLog("");
        }
    }

    private static byte[] getByteArrayFromInputStream(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int nRead;
            byte[] data = new byte[16384];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    private static boolean processFile(File inputFile, boolean overwrite) {
        String fileLocation = inputFile.getAbsolutePath();
        if (inputFile.exists()) {
            if (fileLocation.toLowerCase().endsWith(".png")) {
                File outputFile;
                if (overwrite) {
                    outputFile = inputFile;
                } else {
                    int extIndex = fileLocation.length() - 4;
                    outputFile = new File(fileLocation.substring(0, extIndex) + FILENAME + fileLocation.substring(extIndex));
                }
                try {
                    PngCompressor.compress(inputFile, outputFile);
                    return true;
                }
                catch (IOException e2) {
                    LogWriter.writeLog(e2);
                    return false;
                }
            }
            LogWriter.writeLog("error: " + fileLocation + " is not a png file.");
            return false;
        }
        LogWriter.writeLog("error: " + fileLocation + " does not exist.");
        return false;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            PngCompressor.showCommandLineHelp();
        } else {
            boolean failed = false;
            verbose = "true".equalsIgnoreCase(System.getProperty("org.jpedal.verbose"));
            boolean overwrite = "true".equalsIgnoreCase(System.getProperty("org.jpedal.overwrite"));
            for (String arg : args) {
                boolean success = PngCompressor.processFile(new File(arg), overwrite);
                if (success) continue;
                failed = true;
            }
            if (failed) {
                System.exit(1);
            }
        }
    }

    private static void showCommandLineHelp() {
        LogWriter.writeLog("How to run PngCompressor:\n\n    java [options] -jar jdeli.jar compresspng [pngfile [pngfile ...]]\n\n        options:\n            1. -Dorg.jpedal.overwrite=true       overwrite input files (default: \"false\")\n            2. -Dorg.jpedal.verbose=true         print status messages (default: \"false\")\n\n    Examples:\n        java -jar jdeli.jar compresspng file.png\n\n        java -Dorg.jpedal.overwrite=true -jar jdeli.jar compresspng /directory/*.png\n\n        java -Dorg.jpedal.verbose=true -jar jdeli.jar compresspng /directory/*.png\n\n    The output filename is the same as the input name except that _compressed\n    will be appended to the name. E.g. file.png will become file_compressed.png\n    This can be changed to overwrite the existing file by setting the overwrite\n    setting to true.");
    }
}

