/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.metadata;

import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.metadata.ifd.IFDData;
import com.idrsolutions.image.tiff.TiffDecoder;
import com.idrsolutions.image.utility.DataByteBig;
import com.idrsolutions.image.utility.DataByteLittle;
import com.idrsolutions.image.utility.DataByteReader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jpedal.utils.LogWriter;

public final class Exif {
    private final List<IFDData> ifdDataList = new ArrayList<IFDData>();
    private final List<BufferedImage> ifdImages = new ArrayList<BufferedImage>();

    public List<IFDData> getIfdDataList() {
        return this.ifdDataList;
    }

    public List<BufferedImage> getIfdImages() {
        return this.ifdImages;
    }

    private Exif() {
    }

    public static Exif readExif(byte[] data) throws IOException {
        Exif exif = new Exif();
        if (data == null || data.length < 4) {
            return exif;
        }
        DataByteReader reader = new DataByteBig(data);
        int first2 = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        int offset = 0;
        int exifLen = 4;
        if (first2 == 19789 || first2 == 18761) {
            exifLen = 0;
        } else {
            offset = reader.getU32();
            if (offset == 0 && data[4] == 69 && data[5] == 120 && data[6] == 105 && data[7] == 102) {
                offset = 6;
            }
            reader.skip(offset);
        }
        int dataStart = offset + exifLen;
        byte[] rawTiffData = new byte[data.length - dataStart];
        System.arraycopy(data, dataStart, rawTiffData, 0, rawTiffData.length);
        int a10 = rawTiffData[0] & 0xFF;
        int b2 = rawTiffData[1] & 0xFF;
        reader = a10 == 77 && b2 == 77 ? new DataByteBig(rawTiffData) : new DataByteLittle(rawTiffData);
        reader.skip(2);
        reader.getU16();
        int ifdOffset = reader.getU32();
        int lastIfd = -1;
        while (ifdOffset != 0 && ifdOffset < reader.getLength()) {
            IFDData ifd = TiffDecoder.getIFD(reader, ifdOffset);
            ifd.isLittle = a10 == 73;
            exif.ifdDataList.add(ifd);
            ifdOffset = ifd.nextIFD;
            if (ifdOffset == lastIfd) break;
            lastIfd = ifdOffset;
            try {
                if (ifd.compressionType != 6 || ifd.jpegIFLength <= 0) continue;
                byte[] jpegRaw = new byte[ifd.jpegIFLength];
                int oldPos = reader.getPosition();
                reader.moveTo(ifd.jpegIFOffset);
                reader.read(jpegRaw);
                BufferedImage ifdImage = Exif.handleJpegTechNote(ifd, jpegRaw);
                if (ifdImage != null) {
                    exif.ifdImages.add(ifdImage);
                }
                reader.moveTo(oldPos);
            }
            catch (Exception ex) {
                LogWriter.writeLog("Error reading IFD data " + ex);
            }
        }
        reader.close();
        return exif;
    }

    private static BufferedImage handleJpegTechNote(IFDData ifd, byte[] tileData) throws Exception {
        if (ifd.jpegTables != null) {
            int ifdLen = ifd.jpegTables.length;
            byte[] temp = new byte[ifdLen + tileData.length - 2];
            System.arraycopy(ifd.jpegTables, 0, temp, 0, ifdLen);
            System.arraycopy(tileData, 2, temp, ifdLen, tileData.length - 2);
            tileData = temp;
        }
        JpegDecoder decoder = new JpegDecoder();
        return decoder.read(tileData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IFDData ifdData : this.ifdDataList) {
            sb.append(ifdData);
        }
        return sb.toString();
    }
}

