/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeglossless.data;

import com.idrsolutions.image.jpeg.data.Component;
import com.idrsolutions.image.utility.DataReader;
import java.io.IOException;

public class ScanInfo {
    public int nComp;
    public int spectralStart;
    public Component[] components;

    public void read(DataReader data) throws IOException {
        int count = 2;
        int length = data.getU16();
        this.nComp = data.getU8();
        ++count;
        this.components = new Component[this.nComp];
        for (int i2 = 0; i2 < this.nComp; ++i2) {
            this.components[i2] = new Component();
            if (count > length) {
                throw new IOException("Scan Info Error");
            }
            this.components[i2].lsComp = data.getU8();
            ++count;
            int temp = data.getU8();
            ++count;
            this.components[i2].lsDC = temp >> 4;
            this.components[i2].lsAC = temp & 0xF;
        }
        this.spectralStart = data.getU8();
        ++count;
        data.skip(2);
        if ((count += 2) != length) {
            throw new IOException("Scan Info Error");
        }
    }
}

