/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeglossless.data;

import com.idrsolutions.image.utility.DataReader;
import java.io.IOException;

public class QTable {
    private final int[] precision = new int[4];
    public final int[][] qTables = new int[4][64];

    public void read(DataReader data, int[] table) throws IOException {
        int cc = 2;
        int len = data.getU16();
        while (cc < len) {
            int i2;
            int temp = data.getU8();
            ++cc;
            int t2 = temp & 0xF;
            if (t2 > 3) {
                throw new IOException("Quantization table error");
            }
            this.precision[t2] = temp >> 4;
            switch (this.precision[t2]) {
                case 0: {
                    this.precision[t2] = 8;
                    break;
                }
                case 1: {
                    this.precision[t2] = 16;
                    break;
                }
                default: {
                    throw new IOException("Quantization table error");
                }
            }
            if (this.precision[t2] == 8) {
                for (i2 = 0; i2 < 64; ++i2) {
                    if (cc > len) {
                        throw new IOException("Quantization table error");
                    }
                    this.qTables[t2][i2] = data.getU8();
                    ++cc;
                }
            } else {
                for (i2 = 0; i2 < 64; ++i2) {
                    if (cc > len) {
                        throw new IOException("Quantization table error");
                    }
                    this.qTables[t2][i2] = data.getU16();
                    cc += 2;
                }
            }
            QTable.expand(this.qTables[t2], table);
        }
        if (cc != len) {
            throw new IOException("Quantization table error");
        }
    }

    private static void expand(int[] qt, int[] tbl) {
        int i2;
        for (i2 = 0; i2 < 8; ++i2) {
            int n2 = tbl[i2];
            qt[n2] = qt[n2] * 90;
            int n3 = tbl[32 + i2];
            qt[n3] = qt[n3] * 90;
            int n4 = tbl[16 + i2];
            qt[n4] = qt[n4] * 118;
            int n5 = tbl[48 + i2];
            qt[n5] = qt[n5] * 49;
            int n6 = tbl[40 + i2];
            qt[n6] = qt[n6] * 71;
            int n7 = tbl[8 + i2];
            qt[n7] = qt[n7] * 126;
            int n8 = tbl[56 + i2];
            qt[n8] = qt[n8] * 25;
            int n9 = tbl[24 + i2];
            qt[n9] = qt[n9] * 106;
        }
        for (i2 = 0; i2 < 8; ++i2) {
            int n10 = tbl[i2 << 3];
            qt[n10] = qt[n10] * 90;
            int n11 = tbl[4 + (i2 << 3)];
            qt[n11] = qt[n11] * 90;
            int n12 = tbl[2 + (i2 << 3)];
            qt[n12] = qt[n12] * 118;
            int n13 = tbl[6 + (i2 << 3)];
            qt[n13] = qt[n13] * 49;
            int n14 = tbl[5 + (i2 << 3)];
            qt[n14] = qt[n14] * 71;
            int n15 = tbl[1 + (i2 << 3)];
            qt[n15] = qt[n15] * 126;
            int n16 = tbl[7 + (i2 << 3)];
            qt[n16] = qt[n16] * 25;
            int n17 = tbl[3 + (i2 << 3)];
            qt[n17] = qt[n17] * 106;
        }
        i2 = 0;
        while (i2 < 64) {
            int n18 = i2++;
            qt[n18] = qt[n18] >> 6;
        }
    }
}

