/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeglossless.data;

import com.idrsolutions.image.utility.DataReader;
import java.io.IOException;

public class HTable {
    private final int[][][] l = new int[4][2][16];
    private final int[][][][] v = new int[4][2][16][200];
    private final int[][] tc = new int[4][2];
    private static final int MSB = Integer.MIN_VALUE;

    public void read(DataReader data, int[][][] HuffTab) throws IOException {
        int count = 2;
        int length = data.getU16();
        while (count < length) {
            int i2;
            int temp = data.getU8();
            ++count;
            int t2 = temp & 0xF;
            if (t2 > 3) {
                throw new IOException("Huffman Data Error");
            }
            int c2 = temp >> 4;
            if (c2 > 2) {
                throw new IOException("Huffman Data Error");
            }
            this.tc[t2][c2] = 1;
            for (i2 = 0; i2 < 16; ++i2) {
                this.l[t2][c2][i2] = data.getU8();
                ++count;
            }
            for (i2 = 0; i2 < 16; ++i2) {
                for (int j2 = 0; j2 < this.l[t2][c2][i2]; ++j2) {
                    if (count > length) {
                        throw new IOException("Huffman Data Error");
                    }
                    this.v[t2][c2][i2][j2] = data.getU8();
                    ++count;
                }
            }
        }
        if (count != length) {
            throw new IOException("Huffman Data Error");
        }
        for (int i3 = 0; i3 < 4; ++i3) {
            for (int j3 = 0; j3 < 2; ++j3) {
                if (this.tc[i3][j3] == 0) continue;
                HTable.build(HuffTab[i3][j3], this.l[i3][j3], this.v[i3][j3]);
            }
        }
    }

    private static void build(int[] tab, int[] L2, int[][] V2) throws IOException {
        int n2;
        int j2;
        int i2;
        int temp = 256;
        int k2 = 0;
        for (i2 = 0; i2 < 8; ++i2) {
            for (j2 = 0; j2 < L2[i2]; ++j2) {
                for (n2 = 0; n2 < 256 >> i2 + 1; ++n2) {
                    tab[k2] = V2[i2][j2] | i2 + 1 << 8;
                    ++k2;
                }
            }
        }
        i2 = 1;
        while (k2 < 256) {
            tab[k2] = i2 | Integer.MIN_VALUE;
            ++i2;
            ++k2;
        }
        int tp = 1;
        k2 = 0;
        for (i2 = 8; i2 < 16; ++i2) {
            for (j2 = 0; j2 < L2[i2]; ++j2) {
                for (n2 = 0; n2 < 256 >> i2 - 7; ++n2) {
                    tab[tp * 256 + k2] = V2[i2][j2] | i2 + 1 << 8;
                    ++k2;
                }
                if (k2 < 256) continue;
                if (k2 > 256) {
                    throw new IOException("Huffman Data Error");
                }
                k2 = 0;
                ++tp;
            }
        }
    }
}

