/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeglossless.data;

import com.idrsolutions.image.jpeglossless.data.Sampler;
import com.idrsolutions.image.utility.DataReader;
import java.io.IOException;

public class Frame {
    private Sampler[] samples;
    public int width;
    public int height;
    public int precision;

    public Sampler[] getSamples() {
        return (Sampler[])this.samples.clone();
    }

    public void read(DataReader data) throws IOException {
        int cc = 8;
        int len = data.getU16();
        this.precision = data.getU8();
        this.height = data.getU16();
        this.width = data.getU16();
        int nComp = data.getU8();
        this.samples = new Sampler[256];
        for (int i2 = 1; i2 <= nComp; ++i2) {
            if (cc > len) {
                throw new IOException("corrupted Jpeg Frame Data");
            }
            int c2 = data.getU8();
            if (++cc >= len) {
                throw new IOException("corrupted Jpeg Frame Data");
            }
            int temp = data.getU8();
            ++cc;
            if (this.samples[c2] == null) {
                this.samples[c2] = new Sampler();
            }
            this.samples[c2].h = temp >> 4;
            this.samples[c2].v = temp & 0xF;
            this.samples[c2].qt = data.getU8();
            ++cc;
        }
        if (cc != len) {
            throw new IOException("corrupted Jpeg Frame Data");
        }
    }
}

