/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeglossless;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.jpeg.data.Component;
import com.idrsolutions.image.jpeglossless.data.Frame;
import com.idrsolutions.image.jpeglossless.data.HTable;
import com.idrsolutions.image.jpeglossless.data.QTable;
import com.idrsolutions.image.jpeglossless.data.Sampler;
import com.idrsolutions.image.jpeglossless.data.ScanInfo;
import com.idrsolutions.image.utility.DataByteBig;
import com.idrsolutions.image.utility.DataFileBig;
import com.idrsolutions.image.utility.DataReader;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class JpegLosslessDecoder
extends JDeliImage
implements Decoder {
    private static final int MAX_HTREE = 50;
    private static final int MSB = Integer.MIN_VALUE;
    private DataReader reader;
    private Frame frame;
    private HTable hTable;
    private QTable qTable;
    private ScanInfo scan;
    private final int[][][] HuffTab = new int[4][2][12800];
    private final int[] sIDCT = new int[64];
    private final int[] nBlock = new int[10];
    private final int[][] acTab = new int[10][];
    private final int[][] dcTab = new int[10][];
    private final int[][] qTab = new int[10][];
    private boolean isRestart;
    private int marker;
    private int mIndex;
    private int nComp;
    private int interRestart;
    private int selection;
    private int iw;
    private int ih;
    private int mask;
    private int xLoc;
    private int yLoc;
    private int[] sample1;
    private int[] sample2;
    private int[] sample3;
    private static final int[] POINTERS = new int[]{0, 5, 40, 16, 45, 2, 7, 42, 21, 56, 8, 61, 18, 47, 1, 4, 41, 23, 58, 13, 32, 24, 37, 10, 63, 17, 44, 3, 6, 43, 20, 57, 15, 34, 29, 48, 53, 26, 39, 9, 60, 19, 46, 22, 59, 12, 33, 31, 50, 55, 25, 36, 11, 62, 14, 35, 28, 49, 52, 27, 38, 30, 51, 54};
    private static final int[] FIXED = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};

    @Override
    public BufferedImage read(byte[] data) throws IOException {
        this.reader = new DataByteBig(data);
        return JpegLosslessDecoder.optimiseImage(this.readImage());
    }

    @Override
    public BufferedImage read(File file) throws IOException {
        this.reader = new DataFileBig(file);
        BufferedImage img = this.readImage();
        this.reader.close();
        return JpegLosslessDecoder.optimiseImage(img);
    }

    private BufferedImage readImage() throws IOException {
        this.frame = new Frame();
        this.scan = new ScanInfo();
        this.qTable = new QTable();
        this.hTable = new HTable();
        int[][] decoded = this.getRawPixelArray();
        int width = this.frame.width;
        int height = this.frame.height;
        if (this.nComp == 1) {
            switch (this.frame.precision) {
                case 8: {
                    return JpegLosslessDecoder.toGray8(decoded, width, height);
                }
                case 12: {
                    return JpegLosslessDecoder.toGray12(decoded, width, height);
                }
                case 16: {
                    return JpegLosslessDecoder.toGray16(decoded, width, height);
                }
            }
        }
        if (this.nComp == 3) {
            return JpegLosslessDecoder.toRGB8(decoded, width, height);
        }
        return null;
    }

    private static BufferedImage toGray16(int[][] decoded, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 11);
        short[] imageBuffer = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < imageBuffer.length; ++i2) {
            imageBuffer[i2] = (short)decoded[0][i2];
        }
        return image;
    }

    private static BufferedImage toGray12(int[][] decoded, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 11);
        short[] imageBuffer = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < imageBuffer.length; ++i2) {
            imageBuffer[i2] = (short)(decoded[0][i2] << 4);
        }
        return image;
    }

    private static BufferedImage toGray8(int[][] decoded, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 10);
        byte[] imageBuffer = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < imageBuffer.length; ++i2) {
            imageBuffer[i2] = (byte)decoded[0][i2];
        }
        return image;
    }

    private static BufferedImage toRGB8(int[][] decoded, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        int[] imageBuffer = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < imageBuffer.length; ++i2) {
            imageBuffer[i2] = decoded[0][i2] << 16 | decoded[1][i2] << 8 | decoded[2][i2];
        }
        return image;
    }

    private int[][] getRawPixelArray() throws IOException {
        int[][] outputRef;
        int scanNum = 0;
        int[] pred = new int[10];
        this.xLoc = 0;
        this.yLoc = 0;
        if (this.reader.getU16() != 65496) {
            throw new IOException("Not a JPEG file");
        }
        int current = this.reader.getU16();
        while (current >> 4 != 4092 || current == 65476) {
            this.readMarker(current);
            current = this.reader.getU16();
        }
        if (current < 65472 || current > 65479) {
            throw new IOException("Arithmetic Decoding is not supported yet");
        }
        this.frame.read(this.reader);
        current = this.reader.getU16();
        while (true) {
            if (current != 65498) {
                this.readMarker(current);
                current = this.reader.getU16();
                continue;
            }
            int precision = this.frame.precision;
            this.mask = precision == 8 ? 255 : 65535;
            this.scan.read(this.reader);
            this.updateReadInfo();
            this.updateQTables();
            outputRef = new int[this.nComp][];
            this.sample1 = new int[this.iw * this.ih];
            outputRef[0] = this.sample1;
            if (this.nComp != 1) {
                this.sample2 = new int[this.iw * this.ih];
                outputRef[1] = this.sample2;
                this.sample3 = new int[this.iw * this.ih];
                outputRef[2] = this.sample3;
            }
            ++scanNum;
            do {
                int[] temp = new int[]{0};
                int[] index = new int[]{0};
                Arrays.fill(pred, 1 << precision - 1);
                if (this.interRestart == 0) {
                    current = this.decodeNComp(pred, temp, index);
                    while (current == 0 && this.xLoc < this.iw && this.yLoc < this.ih) {
                        this.output(pred);
                        current = this.decodeNComp(pred, temp, index);
                    }
                    break;
                }
                for (int mcuNum = 0; mcuNum < this.interRestart; ++mcuNum) {
                    this.isRestart = mcuNum == 0;
                    current = this.decodeNComp(pred, temp, index);
                    this.output(pred);
                    if (current != 0) break;
                }
                if (current != 0) continue;
                current = this.mIndex != 0 ? 0xFF00 | this.marker : this.reader.getU16();
                this.mIndex = 0;
            } while (current >= 65488 && current <= 65495);
            if (current == 65500 && scanNum == 1) {
                this.readNumber();
                current = this.reader.getU16();
            }
            if (current == 65497 || this.xLoc >= this.iw || this.yLoc >= this.ih || scanNum != 0) break;
        }
        return outputRef;
    }

    private void updateReadInfo() {
        this.nComp = this.scan.nComp;
        this.selection = this.scan.spectralStart;
        this.iw = this.frame.width;
        this.ih = this.frame.height;
    }

    private void updateQTables() {
        Sampler[] components = this.frame.getSamples();
        Component[] scanComps = this.scan.components;
        int[][] quantTables = this.qTable.qTables;
        for (int i2 = 0; i2 < this.nComp; ++i2) {
            int compN = scanComps[i2].lsComp;
            this.qTab[i2] = quantTables[components[compN].qt];
            this.nBlock[i2] = components[compN].v * components[compN].h;
            this.dcTab[i2] = this.HuffTab[scanComps[i2].lsDC][0];
            this.acTab[i2] = this.HuffTab[scanComps[i2].lsAC][1];
        }
    }

    private void readMarker(int current) throws IOException {
        switch (current) {
            case 65476: {
                this.hTable.read(this.reader, this.HuffTab);
                break;
            }
            case 65484: {
                throw new IOException("Arithmetic Decoding is not supported yet");
            }
            case 65499: {
                this.qTable.read(this.reader, FIXED);
                break;
            }
            case 65501: {
                this.interRestart = this.readNumber();
                break;
            }
            case 65534: {
                this.skipComment();
                break;
            }
            default: {
                if (current >= 65504 && current <= 65519) {
                    this.readApp();
                    break;
                }
                if (current >> 8 == 255) break;
                throw new IOException("Invalid Marker Found");
            }
        }
    }

    private int decodeNComp(int[] prev, int[] temp, int[] index) throws IOException {
        switch (this.nComp) {
            case 1: {
                return this.decode1Comp(prev, temp, index);
            }
            case 3: {
                return this.decode3Comp(prev, temp, index);
            }
        }
        return -1;
    }

    private int decode1Comp(int[] prev, int[] temp, int[] index) throws IOException {
        if (this.isRestart) {
            this.isRestart = false;
            prev[0] = 1 << this.frame.precision - 1;
        } else {
            switch (this.selection) {
                case 2: {
                    prev[0] = this.getPrevY(this.sample1);
                    break;
                }
                case 3: {
                    prev[0] = this.getPrevXY(this.sample1);
                    break;
                }
                case 4: {
                    prev[0] = this.getPrevX(this.sample1) + this.getPrevY(this.sample1) - this.getPrevXY(this.sample1);
                    break;
                }
                case 5: {
                    prev[0] = this.getPrevX(this.sample1) + (this.getPrevY(this.sample1) - this.getPrevXY(this.sample1) >> 1);
                    break;
                }
                case 6: {
                    prev[0] = this.getPrevY(this.sample1) + (this.getPrevX(this.sample1) - this.getPrevXY(this.sample1) >> 1);
                    break;
                }
                case 7: {
                    prev[0] = (int)(((long)this.getPrevX(this.sample1) + (long)this.getPrevY(this.sample1)) / 2L);
                    break;
                }
                default: {
                    prev[0] = this.getPrevX(this.sample1);
                }
            }
        }
        for (int i2 = 0; i2 < this.nBlock[0]; ++i2) {
            int value = this.getHuffmanValue(this.dcTab[0], temp, index);
            if (value >= 65280) {
                return value;
            }
            int n2 = this.getN(prev, value, temp, index);
            int nrs = n2 >> 8;
            if (nrs >= 65488 && nrs <= 65495) {
                return nrs;
            }
            prev[0] = prev[0] + n2;
        }
        return 0;
    }

    private int decode3Comp(int[] prev, int[] temp, int[] index) throws IOException {
        this.setPrevValues(prev);
        for (int ctrC = 0; ctrC < this.nComp; ++ctrC) {
            int[] qtab = this.qTab[ctrC];
            int[] actab = this.acTab[ctrC];
            int[] dctab = this.dcTab[ctrC];
            block1: for (int i2 = 0; i2 < this.nBlock[ctrC]; ++i2) {
                for (int k2 = 0; k2 < this.sIDCT.length; ++k2) {
                    this.sIDCT[k2] = 0;
                }
                int value = this.getHuffmanValue(dctab, temp, index);
                if (value >= 65280) {
                    return value;
                }
                prev[ctrC] = this.sIDCT[0] = prev[ctrC] + this.getN(index, value, temp, index);
                this.sIDCT[0] = this.sIDCT[0] * qtab[0];
                for (int j2 = 1; j2 < 64; ++j2) {
                    value = this.getHuffmanValue(actab, temp, index);
                    if (value >= 65280) {
                        return value;
                    }
                    j2 += value >> 4;
                    if ((value & 0xF) == 0) {
                        if (value >> 4 != 0) continue;
                        continue block1;
                    }
                    this.sIDCT[JpegLosslessDecoder.POINTERS[j2]] = this.getN(index, value & 0xF, temp, index) * qtab[j2];
                }
            }
        }
        return 0;
    }

    private void setPrevValues(int[] prev) {
        switch (this.selection) {
            case 2: {
                prev[0] = this.getPrevY(this.sample1);
                prev[1] = this.getPrevY(this.sample2);
                prev[2] = this.getPrevY(this.sample3);
                break;
            }
            case 3: {
                prev[0] = this.getPrevXY(this.sample1);
                prev[1] = this.getPrevXY(this.sample2);
                prev[2] = this.getPrevXY(this.sample3);
                break;
            }
            case 4: {
                prev[0] = this.getPrevX(this.sample1) + this.getPrevY(this.sample1) - this.getPrevXY(this.sample1);
                prev[1] = this.getPrevX(this.sample2) + this.getPrevY(this.sample2) - this.getPrevXY(this.sample2);
                prev[2] = this.getPrevX(this.sample3) + this.getPrevY(this.sample3) - this.getPrevXY(this.sample3);
                break;
            }
            case 5: {
                prev[0] = this.getPrevX(this.sample1) + (this.getPrevY(this.sample1) - this.getPrevXY(this.sample1) >> 1);
                prev[1] = this.getPrevX(this.sample2) + (this.getPrevY(this.sample2) - this.getPrevXY(this.sample2) >> 1);
                prev[2] = this.getPrevX(this.sample3) + (this.getPrevY(this.sample3) - this.getPrevXY(this.sample3) >> 1);
                break;
            }
            case 6: {
                prev[0] = this.getPrevY(this.sample1) + (this.getPrevX(this.sample1) - this.getPrevXY(this.sample1) >> 1);
                prev[1] = this.getPrevY(this.sample2) + (this.getPrevX(this.sample2) - this.getPrevXY(this.sample2) >> 1);
                prev[2] = this.getPrevY(this.sample3) + (this.getPrevX(this.sample3) - this.getPrevXY(this.sample3) >> 1);
                break;
            }
            case 7: {
                prev[0] = (int)(((long)this.getPrevX(this.sample1) + (long)this.getPrevY(this.sample1)) / 2L);
                prev[1] = (int)(((long)this.getPrevX(this.sample2) + (long)this.getPrevY(this.sample2)) / 2L);
                prev[2] = (int)(((long)this.getPrevX(this.sample3) + (long)this.getPrevY(this.sample3)) / 2L);
                break;
            }
            default: {
                prev[0] = this.getPrevX(this.sample1);
                prev[1] = this.getPrevX(this.sample2);
                prev[2] = this.getPrevX(this.sample3);
            }
        }
    }

    private int getHuffmanValue(int[] table, int[] temp, int[] index) throws IOException {
        int input;
        int maski = 65535;
        if (index[0] < 8) {
            temp[0] = temp[0] << 8;
            input = this.reader.getU8();
            if (input == 255) {
                this.marker = this.reader.getU8();
                if (this.marker != 0) {
                    this.mIndex = 9;
                }
            }
            temp[0] = temp[0] | input;
        } else {
            index[0] = index[0] - 8;
        }
        int code = table[temp[0] >> index[0]];
        if ((code & Integer.MIN_VALUE) != 0) {
            if (this.mIndex != 0) {
                this.mIndex = 0;
                return 0xFF00 | this.marker;
            }
            temp[0] = temp[0] & 65535 >> 16 - index[0];
            temp[0] = temp[0] << 8;
            input = this.reader.getU8();
            if (input == 255) {
                this.marker = this.reader.getU8();
                if (this.marker != 0) {
                    this.mIndex = 9;
                }
            }
            temp[0] = temp[0] | input;
            code = table[(code & 0xFF) * 256 + (temp[0] >> index[0])];
            index[0] = index[0] + 8;
        }
        index[0] = index[0] + (8 - (code >> 8));
        if (index[0] < 0) {
            throw new IOException("Huffman decoding error");
        }
        if (index[0] < this.mIndex) {
            this.mIndex = 0;
            return 0xFF00 | this.marker;
        }
        temp[0] = temp[0] & 65535 >> 16 - index[0];
        return code & 0xFF;
    }

    private int getN(int[] PRED, int n2, int[] temp, int[] index) throws IOException {
        boolean one = true;
        int n_one = -1;
        int maski = 65535;
        if (n2 == 0) {
            return 0;
        }
        if (n2 == 16) {
            return PRED[0] >= 0 ? Short.MIN_VALUE : 32768;
        }
        index[0] = index[0] - n2;
        if (index[0] >= 0) {
            if (index[0] < this.mIndex && !this.isEndPix()) {
                this.mIndex = 0;
                return (0xFF00 | this.marker) << 8;
            }
        } else {
            temp[0] = temp[0] << 8;
            int input = this.reader.getU8();
            if (input == 255) {
                this.marker = this.reader.getU8();
                if (this.marker != 0) {
                    this.mIndex = 9;
                }
            }
            temp[0] = temp[0] | input;
            index[0] = index[0] + 8;
            if (index[0] < 0) {
                if (this.mIndex != 0) {
                    this.mIndex = 0;
                    return (0xFF00 | this.marker) << 8;
                }
                temp[0] = temp[0] << 8;
                input = this.reader.getU8();
                if (input == 255) {
                    this.marker = this.reader.getU8();
                    if (this.marker != 0) {
                        this.mIndex = 9;
                    }
                }
                temp[0] = temp[0] | input;
                index[0] = index[0] + 8;
            }
            if (index[0] < 0) {
                throw new IOException("Decoding jpeglossless stream error");
            }
            if (index[0] < this.mIndex) {
                this.mIndex = 0;
                return (0xFF00 | this.marker) << 8;
            }
        }
        int nn = temp[0] >> index[0];
        temp[0] = temp[0] & 65535 >> 16 - index[0];
        if (nn < 1 << n2 - 1) {
            nn += (-1 << n2) + 1;
        }
        return nn;
    }

    private int getPrevX(int[] data) {
        if (this.xLoc > 0) {
            return data[this.yLoc * this.iw + this.xLoc - 1];
        }
        if (this.yLoc > 0) {
            return this.getPrevY(data);
        }
        return 1 << this.frame.precision - 1;
    }

    private int getPrevXY(int[] data) {
        if (this.xLoc > 0 && this.yLoc > 0) {
            return data[(this.yLoc - 1) * this.iw + this.xLoc - 1];
        }
        return this.getPrevY(data);
    }

    private int getPrevY(int[] data) {
        if (this.yLoc > 0) {
            return data[(this.yLoc - 1) * this.iw + this.xLoc];
        }
        return this.getPrevX(data);
    }

    private boolean isEndPix() {
        return this.xLoc == this.iw - 1 && this.yLoc == this.ih - 1;
    }

    private void output(int[] PRED) {
        if (this.nComp == 1) {
            this.outputSingle(PRED);
        } else {
            this.outputRGB(PRED);
        }
    }

    private void outputSingle(int[] PRED) {
        if (this.xLoc < this.iw && this.yLoc < this.ih) {
            this.sample1[this.yLoc * this.iw + this.xLoc] = this.mask & PRED[0];
            ++this.xLoc;
            if (this.xLoc >= this.iw) {
                ++this.yLoc;
                this.xLoc = 0;
            }
        }
    }

    private void outputRGB(int[] PRED) {
        if (this.xLoc < this.iw && this.yLoc < this.ih) {
            this.sample1[this.yLoc * this.iw + this.xLoc] = PRED[0];
            this.sample2[this.yLoc * this.iw + this.xLoc] = PRED[1];
            this.sample3[this.yLoc * this.iw + this.xLoc] = PRED[2];
            ++this.xLoc;
            if (this.xLoc >= this.iw) {
                ++this.yLoc;
                this.xLoc = 0;
            }
        }
    }

    private void readApp() throws IOException {
        int count = 0;
        int length = this.reader.getU16();
        count += 2;
        while (count < length) {
            this.reader.getU8();
            ++count;
        }
    }

    private void skipComment() throws IOException {
        int count = 0;
        int length = this.reader.getU16();
        count += 2;
        while (count < length) {
            this.reader.getU8();
            ++count;
        }
    }

    private int readNumber() throws IOException {
        int Ld = this.reader.getU16();
        if (Ld != 4) {
            throw new IOException("Invalid number symbol found");
        }
        return this.reader.getU16();
    }

    @Override
    public Rectangle readDimension(byte[] data) throws Exception {
        this.reader = new DataByteBig(data);
        BufferedImage img = this.readImage();
        if (img != null) {
            return new Rectangle(img.getWidth(), img.getHeight());
        }
        return new Rectangle(0, 0);
    }

    @Override
    public Rectangle readDimension(File imageFile) throws Exception {
        this.reader = new DataFileBig(imageFile);
        BufferedImage img = this.readImage();
        if (img != null) {
            return new Rectangle(img.getWidth(), img.getHeight());
        }
        return new Rectangle(0, 0);
    }
}

