/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import java.io.IOException;

class VLC {
    private final int[][] table;
    private final int bits;

    VLC(int bits, int[][] table) {
        this.bits = bits;
        this.table = table;
    }

    VLC(int bits, int[] lengths, int[] symbols) {
        int i2;
        this.bits = bits;
        this.table = new int[1 << bits][2];
        int[] codes = new int[lengths.length];
        int[] nLengths = new int[lengths.length];
        int[] nSymbols = new int[lengths.length];
        int count = 0;
        long code = 0L;
        for (i2 = 0; i2 < lengths.length; ++i2) {
            int len = lengths[i2];
            if (len > 0) {
                nLengths[count] = len;
                nSymbols[count] = symbols != null ? symbols[i2] : i2;
                codes[count] = (int)code;
                ++count;
            } else {
                if (len >= 0) continue;
                len = -len;
            }
            code += 1L << 32 - len;
        }
        for (i2 = 0; i2 < count; ++i2) {
            if (nLengths[i2] > bits) continue;
            int index = Integer.reverse(codes[i2]);
            int number = 1 << bits - nLengths[i2];
            int offset = 1 << nLengths[i2];
            for (int j2 = 0; j2 < number; ++j2) {
                this.table[index][0] = nSymbols[i2];
                this.table[index][1] = nLengths[i2];
                index += offset;
            }
        }
        for (int[] table1 : this.table) {
            if (table1[1] != 0) continue;
            table1[0] = -1;
        }
    }

    int getVLC(BitXL reader) throws IOException {
        int index = reader.showBits(this.bits);
        int symbol = this.table[index][0];
        int length = this.table[index][1];
        reader.skipBits(length);
        return symbol;
    }
}

