/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.ITX;
import com.idrsolutions.image.jpegXL.data.IntXL;
import com.idrsolutions.image.jpegXL.data.LFGroup;

class VBlock {
    final IntXL blockPosInLFGroup;
    final IntXL groupPosInLFGroup;
    final IntXL blockPosInGroup;
    final IntXL pixelPosInGroup;
    final IntXL pixelPosInLFGroup;
    final int groupID;
    final LFGroup lfGroup;

    VBlock(LFGroup lfGroup, IntXL blockPosInLFGroup) {
        this.lfGroup = lfGroup;
        this.blockPosInLFGroup = blockPosInLFGroup;
        this.pixelPosInLFGroup = new IntXL(blockPosInLFGroup.x << 3, blockPosInLFGroup.y << 3);
        this.groupPosInLFGroup = blockPosInLFGroup.toRight(5);
        int x2 = blockPosInLFGroup.x - (this.groupPosInLFGroup.x << 5);
        int y2 = blockPosInLFGroup.y - (this.groupPosInLFGroup.y << 5);
        this.blockPosInGroup = new IntXL(x2, y2);
        this.pixelPosInGroup = new IntXL(x2 << 3, y2 << 3);
        IntXL lfgXY = lfGroup.frame.getLFGroupXY(lfGroup.lfGroupID);
        x2 = (lfgXY.x << 3) + this.groupPosInLFGroup.x;
        y2 = (lfgXY.y << 3) + this.groupPosInLFGroup.y;
        this.groupID = y2 * lfGroup.frame.getGroupRowStride() + x2;
    }

    ITX transformType() {
        return this.lfGroup.hfMetadata.dctSelect[this.blockPosInLFGroup.y][this.blockPosInLFGroup.x];
    }

    int hfMult() {
        return this.lfGroup.hfMetadata.hfMultiplier[this.blockPosInLFGroup.y][this.blockPosInLFGroup.x];
    }

    IntXL sizeInBlocks() {
        ITX tt = this.transformType();
        return new IntXL(tt.dctW, tt.dctH);
    }

    IntXL sizeInPixels() {
        return this.transformType().getPixelSize();
    }

    boolean isCorner(IntXL shift) {
        int x2 = this.blockPosInLFGroup.x >> shift.x;
        int y2 = this.blockPosInLFGroup.y >> shift.y;
        return x2 << shift.x == this.blockPosInLFGroup.x && y2 << shift.y == this.blockPosInLFGroup.y;
    }
}

