/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.ExFunction;
import com.idrsolutions.image.jpegXL.data.FunctionalHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

class TaskList<T> {
    private final List<CompletableFuture<? extends T>>[] tasks;
    private final ExecutorService threadPool;

    TaskList(ExecutorService threadPool, int bins) {
        this.threadPool = threadPool;
        List[] tasks = new List[bins];
        this.tasks = tasks;
        for (int i2 = 0; i2 < bins; ++i2) {
            tasks[i2] = new ArrayList();
        }
    }

    <U> void submit(int bin, CompletableFuture<? extends U> supplier, ExFunction<? super U, ? extends T> f2) {
        this.tasks[bin].add((CompletableFuture<T>)supplier.thenApplyAsync(f2, (Executor)this.threadPool));
    }

    List<T> collect(int bin) {
        ArrayList<T> results = new ArrayList<T>();
        for (CompletableFuture<? extends T> completableFuture : this.tasks[bin]) {
            results.add(FunctionalHelper.join(completableFuture));
        }
        this.tasks[bin].clear();
        return results;
    }
}

