/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.BlendInfo;
import com.idrsolutions.image.jpegXL.data.ColorXL;
import com.idrsolutions.image.jpegXL.data.Configure;
import com.idrsolutions.image.jpegXL.data.FifoStream;
import com.idrsolutions.image.jpegXL.data.Frame;
import com.idrsolutions.image.jpegXL.data.HeaderFrame;
import com.idrsolutions.image.jpegXL.data.HeaderImage;
import com.idrsolutions.image.jpegXL.data.HelperXL;
import com.idrsolutions.image.jpegXL.data.ImageXL;
import com.idrsolutions.image.jpegXL.data.IntXL;
import com.idrsolutions.image.jpegXL.data.Inverse;
import com.idrsolutions.image.jpegXL.data.JXLSupplier;
import com.idrsolutions.image.jpegXL.data.MathXL;
import com.idrsolutions.image.jpegXL.data.Patch;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.ForkJoinPool;

public class StreamXL {
    private final BitXL bitreader;
    private final FifoStream in;
    private HeaderImage imageHeader;
    private final Configure options;
    private final JXLSupplier demuxer;
    private final HelperXL flowHelper;

    public StreamXL(InputStream ins) {
        this.demuxer = new JXLSupplier(ins);
        this.in = new FifoStream(this.demuxer);
        ForkJoinPool threadPool = ForkJoinPool.commonPool();
        this.flowHelper = new HelperXL(threadPool);
        this.bitreader = new BitXL(this.in);
        this.options = new Configure();
    }

    private static float[][] transposeBuffer(float[][] src, int orientation) {
        IntXL size = IntXL.sizeOf(src);
        if (orientation == 1) {
            return src;
        }
        float[][] dest = orientation > 4 ? new float[size.x][size.y] : new float[size.y][size.x];
        switch (orientation) {
            case 2: {
                for (IntXL p2 : HelperXL.range2D(size)) {
                    dest[p2.y][size.x - 1 - p2.x] = src[p2.y][p2.x];
                }
            }
            case 3: {
                for (IntXL p2 : HelperXL.range2D(size)) {
                    dest[size.y - 1 - p2.y][size.x - 1 - p2.x] = src[p2.y][p2.x];
                }
            }
            case 4: {
                for (IntXL p2 : HelperXL.range2D(size)) {
                    dest[size.y - 1 - p2.y][p2.x] = src[p2.y][p2.x];
                }
            }
            case 5: {
                for (IntXL p2 : HelperXL.range2D(size)) {
                    dest[p2.x][p2.y] = src[p2.y][p2.x];
                }
            }
            case 6: {
                for (IntXL p2 : HelperXL.range2D(size)) {
                    dest[p2.x][size.y - 1 - p2.y] = src[p2.y][p2.x];
                }
            }
            case 7: {
                for (IntXL p2 : HelperXL.range2D(size)) {
                    dest[size.x - 1 - p2.x][size.y - 1 - p2.y] = src[p2.y][p2.x];
                }
            }
            case 8: {
                for (IntXL p2 : HelperXL.range2D(size)) {
                    dest[size.x - 1 - p2.x][p2.y] = src[p2.y][p2.x];
                }
                break;
            }
        }
        return dest;
    }

    private void computePatches(float[][][][] references, Frame frame) {
        Patch[] patches;
        float[][][] frameBuffer = frame.getBuffer();
        int colorChannels = this.imageHeader.getColorChannelCount();
        int extraChannels = this.imageHeader.getExtraChannelCount();
        for (Patch patch : patches = frame.getLFGlobal().patches) {
            float[][][] refBuffer = references[patch.ref];
            if (refBuffer == null) continue;
            for (int j2 = 0; j2 < patch.positions.length; ++j2) {
                int x0 = patch.positions[j2].x;
                int y0 = patch.positions[j2].y;
                for (int d2 = 0; d2 < colorChannels + extraChannels; ++d2) {
                    int c2 = d2 < colorChannels ? 0 : d2 - colorChannels + 1;
                    BlendInfo info = patch.blendingInfos[j2][c2];
                    if (info.mode == 0) continue;
                    boolean premult = !this.imageHeader.hasAlpha() || this.imageHeader.getExtraChannel((int)info.alphaChannel).alphaAssociated;
                    boolean isAlpha = c2 > 0 && this.imageHeader.getExtraChannel((int)(c2 - 1)).type == 0;
                    for (int y2 = 0; y2 < patch.height; ++y2) {
                        for (int x2 = 0; x2 < patch.width; ++x2) {
                            float sample;
                            int oldX = x2 + x0;
                            int oldY = y2 + y0;
                            int newX = x2 + patch.origin.x;
                            int newY = y2 + patch.origin.y;
                            float oldSample = frameBuffer[d2][oldY][oldX];
                            float newSample = refBuffer[d2][newY][newX];
                            float alpha = 0.0f;
                            float newAlpha = 0.0f;
                            float oldAlpha = 0.0f;
                            if (info.mode > 3) {
                                oldAlpha = this.imageHeader.hasAlpha() ? frameBuffer[colorChannels + info.alphaChannel][oldY][oldX] : 1.0f;
                                float f2 = newAlpha = this.imageHeader.hasAlpha() ? refBuffer[colorChannels + info.alphaChannel][newY][newX] : 1.0f;
                                if (info.clamp) {
                                    newAlpha = MathXL.clamp(newAlpha, 0.0f, 1.0f);
                                }
                                if (info.mode < 6 || !isAlpha || !premult) {
                                    alpha = oldAlpha + newAlpha * (1.0f - oldAlpha);
                                }
                            }
                            switch (info.mode) {
                                case 1: {
                                    sample = newSample;
                                    break;
                                }
                                case 2: {
                                    sample = oldSample + newSample;
                                    break;
                                }
                                case 3: {
                                    sample = oldSample * newSample;
                                    break;
                                }
                                case 4: {
                                    sample = isAlpha ? alpha : (premult ? newSample + oldSample * (1.0f - newAlpha) : (newSample * newAlpha + oldSample * oldAlpha * (1.0f - newAlpha)) / alpha);
                                    break;
                                }
                                case 5: {
                                    sample = isAlpha ? alpha : (premult ? oldSample + newSample * (1.0f - newAlpha) : (oldSample * newAlpha + newSample * oldAlpha * (1.0f - newAlpha)) / alpha);
                                    break;
                                }
                                case 6: {
                                    sample = isAlpha ? newAlpha : oldSample + alpha * newSample;
                                    break;
                                }
                                case 7: {
                                    sample = isAlpha ? oldAlpha : newSample + alpha * oldSample;
                                    break;
                                }
                                default: {
                                    sample = 0.0f;
                                }
                            }
                            frameBuffer[d2][oldY][oldX] = sample;
                        }
                    }
                }
            }
        }
    }

    private void doColorTransforms(Inverse inv, Frame frame) {
        float[][][] frameBuffer = frame.getBuffer();
        if (inv != null) {
            inv.invertXYB(frameBuffer, this.imageHeader.getToneMapping().intensityTarget);
        }
        if (frame.getFrameHeader().doYCbCr) {
            IntXL size = frame.getPaddedFrameSize();
            int sy = size.y;
            int sx = size.x;
            for (int y2 = 0; y2 < sy; ++y2) {
                float[] f1 = frameBuffer[0][y2];
                float[] f2 = frameBuffer[1][y2];
                float[] f3 = frameBuffer[2][y2];
                for (int x2 = 0; x2 < sx; ++x2) {
                    float cb = f1[x2];
                    float yh = f2[x2] + 0.50196f;
                    float cr = f3[x2];
                    f1[x2] = yh + 1.402f * cr;
                    f2[x2] = yh - 0.34414f * cb - 0.71414f * cr;
                    f3[x2] = yh + 1.772f * cb;
                }
            }
        }
    }

    private static void copyToCanvas(float[][] canvas, IntXL start, IntXL off, IntXL size, float[][] frameBuffer) {
        for (int y2 = 0; y2 < size.y; ++y2) {
            System.arraycopy(frameBuffer[y2 + off.y], off.x, canvas[y2 + start.y], start.x, size.x);
        }
    }

    void blendFrame(float[][][] canvas, float[][][][] reference, Frame frame) {
        int width = this.imageHeader.getSize().width;
        int height = this.imageHeader.getSize().height;
        HeaderFrame header = frame.getFrameHeader();
        IntXL frameStart = header.origin.max(IntXL.ZERO);
        IntXL frameSize = new IntXL(width, height).min(header.origin.plus(new IntXL(header.width, header.height))).minus(frameStart);
        int frameColors = frame.getColorChannelCount();
        int imageColors = this.imageHeader.getColorChannelCount();
        block6: for (int c2 = 0; c2 < canvas.length; ++c2) {
            int frameC = frameColors != imageColors ? (c2 == 0 ? 1 : c2 + 2) : c2;
            float[][] frameBuffer = frame.getBuffer()[frameC];
            BlendInfo info = frameC < frameColors ? frame.getFrameHeader().blendInfo : frame.getFrameHeader().ecBlendInfo[frameC - frameColors];
            boolean isAlpha = c2 >= imageColors && this.imageHeader.getExtraChannel((int)(c2 - imageColors)).type == 0;
            boolean premult = !this.imageHeader.hasAlpha() || this.imageHeader.getExtraChannel((int)info.alphaChannel).alphaAssociated;
            float[][][] refBuffer = reference[info.source];
            if (info.mode == 0 || refBuffer == null && info.mode == 1) {
                StreamXL.copyToCanvas(canvas[c2], frameStart, frameStart.minus(header.origin), frameSize, frameBuffer);
                continue;
            }
            float[][] ref = refBuffer != null ? refBuffer[c2] : null;
            switch (info.mode) {
                case 1: {
                    int cx;
                    int x2;
                    int cy;
                    int y2;
                    for (y2 = 0; y2 < frameSize.y; ++y2) {
                        cy = y2 + frameStart.y;
                        for (x2 = 0; x2 < frameSize.x; ++x2) {
                            cx = x2 + frameStart.x;
                            if (ref == null) continue;
                            canvas[c2][cy][cx] = ref[cy][cx] + frameBuffer[y2][x2];
                        }
                    }
                    continue block6;
                }
                case 4: {
                    int cx;
                    int x2;
                    int cy;
                    int y2;
                    for (y2 = 0; y2 < frameSize.y; ++y2) {
                        cy = y2 + frameStart.y;
                        if (ref != null) {
                            for (x2 = 0; x2 < frameSize.x; ++x2) {
                                cx = x2 + frameStart.x;
                                float newSample = frameBuffer[y2][x2];
                                if (info.clamp) {
                                    newSample = MathXL.clamp(newSample, 0.0f, 1.0f);
                                }
                                canvas[c2][cy][cx] = newSample * ref[cy][cx];
                            }
                            continue;
                        }
                        Arrays.fill(canvas[c2][cy], frameStart.x, frameSize.x, 0.0f);
                    }
                    continue block6;
                }
                case 2: {
                    int cx;
                    int cy;
                    for (cy = frameStart.y; cy < frameSize.y + frameStart.y; ++cy) {
                        for (cx = frameStart.x; cx < frameSize.x + frameStart.x; ++cx) {
                            float newAlpha;
                            float oldAlpha = !this.imageHeader.hasAlpha() ? 1.0f : (ref != null ? refBuffer[imageColors + info.alphaChannel][cy][cx] : 0.0f);
                            float f2 = newAlpha = !this.imageHeader.hasAlpha() ? 1.0f : frame.getSample(frameColors + info.alphaChannel, cx, cy);
                            if (info.clamp) {
                                newAlpha = MathXL.clamp(newAlpha, 0.0f, 1.0f);
                            }
                            float alpha = 1.0f;
                            float oldSample = ref != null ? ref[cy][cx] : 0.0f;
                            float newSample = frame.getSample(frameC, cx, cy);
                            if (isAlpha || !premult) {
                                alpha = oldAlpha + newAlpha * (1.0f - oldAlpha);
                            }
                            canvas[c2][cy][cx] = isAlpha ? alpha : (premult ? newSample + oldSample * (1.0f - newAlpha) : (newSample * newAlpha + oldSample * oldAlpha * (1.0f - newAlpha)) / alpha);
                        }
                    }
                    continue block6;
                }
                case 3: {
                    int cx;
                    int cy;
                    for (cy = frameStart.y; cy < frameSize.y + frameStart.y; ++cy) {
                        for (cx = frameStart.x; cx < frameSize.x + frameStart.x; ++cx) {
                            float newAlpha;
                            float oldAlpha = !this.imageHeader.hasAlpha() ? 1.0f : (ref != null ? refBuffer[imageColors + info.alphaChannel][cy][cx] : 0.0f);
                            float f3 = newAlpha = !this.imageHeader.hasAlpha() ? 1.0f : frame.getSample(frameColors + info.alphaChannel, cx, cy);
                            if (info.clamp) {
                                newAlpha = MathXL.clamp(newAlpha, 0.0f, 1.0f);
                            }
                            float oldSample = ref != null ? ref[cy][cx] : 0.0f;
                            float newSample = frame.getSample(frameC, cx, cy);
                            canvas[c2][cy][cx] = isAlpha ? oldAlpha : oldSample + newAlpha * newSample;
                        }
                    }
                    continue block6;
                }
            }
        }
    }

    public boolean atEnd() throws IOException {
        return this.bitreader != null && this.bitreader.atEnd();
    }

    public ImageXL decode() throws IOException {
        int i2;
        HeaderFrame header;
        if (this.atEnd()) {
            return null;
        }
        this.bitreader.showBits(16);
        int level = this.demuxer.getLevel();
        this.imageHeader = HeaderImage.parse(this.bitreader, level);
        if (this.imageHeader.getPreviewHeader()) {
            Configure previewOptions = new Configure(this.options);
            previewOptions.parseOnly = true;
            Frame frame = new Frame(this.bitreader, this.imageHeader, this.flowHelper, previewOptions);
            frame.readFrameHeader();
            frame.skipFrameData();
        }
        float[][][][] reference = new float[4][][][];
        float[][][][] lfBuffer = new float[5][][][];
        Inverse matrix = null;
        if (this.imageHeader.isXYBEncoded()) {
            ColorXL bundle = this.imageHeader.getColorEncoding();
            matrix = this.imageHeader.getOpsinInverseMatrix().getMatrix(bundle.prim, bundle.white);
        }
        float[][][] canvas = null;
        if (!this.options.parseOnly) {
            canvas = new float[this.imageHeader.getColorChannelCount() + this.imageHeader.getExtraChannelCount()][this.imageHeader.getSize().height][this.imageHeader.getSize().width];
        }
        long invisibleFrames = 0L;
        long visibleFrames = 0L;
        do {
            boolean save;
            Frame frame = new Frame(this.bitreader, this.imageHeader, this.flowHelper, this.options);
            header = frame.readFrameHeader();
            if (this.options.parseOnly) {
                frame.skipFrameData();
                continue;
            }
            frame.decodeFrame(lfBuffer[header.lfLevel]);
            if (header.lfLevel > 0) {
                lfBuffer[header.lfLevel - 1] = frame.getBuffer();
            }
            boolean bl2 = save = (header.saveAsReference != 0 || header.duration == 0) && !header.isLast && header.type != 1;
            if (frame.isVisible()) {
                ++visibleFrames;
                invisibleFrames = 0L;
            } else {
                ++invisibleFrames;
            }
            frame.initializeNoise(visibleFrames << 32 | invisibleFrames);
            frame.upsample();
            if (save && header.saveBeforeCT) {
                reference[header.saveAsReference] = frame.getBuffer();
            }
            this.computePatches(reference, frame);
            frame.renderSplines();
            frame.synthesizeNoise();
            this.doColorTransforms(matrix, frame);
            if (header.encoding == 0 && this.options.renderVarblocks) {
                frame.drawVarblocks();
            }
            if (header.type == 0 || header.type == 3) {
                boolean found = false;
                for (i2 = 0; i2 < 4; ++i2) {
                    if (!Arrays.deepEquals((Object[])reference[i2], (Object[])canvas) || i2 == header.saveAsReference) continue;
                    found = true;
                    break;
                }
                if (found) {
                    canvas = MathXL.mmCopy(canvas);
                }
                this.blendFrame(canvas, reference, frame);
            }
            if (!save || header.saveBeforeCT) continue;
            reference[header.saveAsReference] = canvas;
        } while (!header.isLast);
        this.bitreader.zeroPadToByte();
        byte[] drain = this.bitreader.drainCache();
        if (drain != null) {
            this.demuxer.pushBack(drain);
        }
        while ((drain = this.in.getBalance()) != null) {
            this.demuxer.pushBack(drain);
        }
        if (this.options.parseOnly) {
            return null;
        }
        int orientation = this.imageHeader.getOrientation();
        float[][][] orientedCanvas = new float[canvas.length][][];
        for (i2 = 0; i2 < orientedCanvas.length; ++i2) {
            orientedCanvas[i2] = StreamXL.transposeBuffer(canvas[i2], orientation);
        }
        return new ImageXL(orientedCanvas, this.imageHeader);
    }
}

