/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.Entropy;
import com.idrsolutions.image.jpegXL.data.IntXL;
import com.idrsolutions.image.jpegXL.data.MathXL;
import java.io.IOException;

class SplinesGroup {
    final int numSplines;
    final int quantAdjust;
    final IntXL[] splinePos;
    final int[] controlCount;
    final IntXL[][] points;
    final int[][] coeffX;
    final int[][] coeffY;
    final int[][] coeffB;
    final int[][] coeffSigma;

    SplinesGroup(BitXL reader) throws IOException {
        int i2;
        Entropy entropy = new Entropy(reader, 6);
        this.numSplines = 1 + entropy.readSymbol(reader, 2);
        this.splinePos = new IntXL[this.numSplines];
        for (i2 = 0; i2 < this.numSplines; ++i2) {
            int x2 = entropy.readSymbol(reader, 1);
            int y2 = entropy.readSymbol(reader, 1);
            if (i2 != 0) {
                x2 = MathXL.unpackSigned(x2) + this.splinePos[i2 - 1].x;
                y2 = MathXL.unpackSigned(y2) + this.splinePos[i2 - 1].y;
            }
            this.splinePos[i2] = new IntXL(x2, y2);
        }
        this.quantAdjust = MathXL.unpackSigned(entropy.readSymbol(reader, 0));
        this.controlCount = new int[this.numSplines];
        this.points = new IntXL[this.numSplines][];
        this.coeffX = new int[this.numSplines][32];
        this.coeffY = new int[this.numSplines][32];
        this.coeffB = new int[this.numSplines][32];
        this.coeffSigma = new int[this.numSplines][32];
        for (i2 = 0; i2 < this.numSplines; ++i2) {
            int j2;
            this.controlCount[i2] = 1 + entropy.readSymbol(reader, 3);
            this.points[i2] = new IntXL[this.controlCount[i2]];
            this.points[i2][0] = new IntXL(this.splinePos[i2]);
            IntXL[] delta = new IntXL[this.controlCount[i2] - 1];
            for (int j3 = 0; j3 < delta.length; ++j3) {
                int x3 = MathXL.unpackSigned(entropy.readSymbol(reader, 4));
                int y3 = MathXL.unpackSigned(entropy.readSymbol(reader, 4));
                delta[j3] = new IntXL(x3, y3);
            }
            IntXL current = new IntXL(this.points[i2][0]);
            IntXL deltaPoint = new IntXL();
            for (j2 = 1; j2 < this.controlCount[i2]; ++j2) {
                deltaPoint = deltaPoint.plus(delta[j2 - 1]);
                current = current.plus(deltaPoint);
                this.points[i2][j2] = new IntXL(current);
            }
            for (j2 = 0; j2 < 32; ++j2) {
                this.coeffX[i2][j2] = MathXL.unpackSigned(entropy.readSymbol(reader, 5));
            }
            for (j2 = 0; j2 < 32; ++j2) {
                this.coeffY[i2][j2] = MathXL.unpackSigned(entropy.readSymbol(reader, 5));
            }
            for (j2 = 0; j2 < 32; ++j2) {
                this.coeffB[i2][j2] = MathXL.unpackSigned(entropy.readSymbol(reader, 5));
            }
            for (j2 = 0; j2 < 32; ++j2) {
                this.coeffSigma[i2][j2] = MathXL.unpackSigned(entropy.readSymbol(reader, 5));
            }
        }
    }
}

