/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.FloatXL;
import com.idrsolutions.image.jpegXL.data.Frame;
import com.idrsolutions.image.jpegXL.data.IntXL;
import com.idrsolutions.image.jpegXL.data.LFGlobal;
import com.idrsolutions.image.jpegXL.data.MathXL;
import java.util.ArrayList;

class Spline {
    final IntXL[] controlPoints;
    private FloatXL[] upsampled;
    private float[] coeffX;
    private float[] coeffY;
    private float[] coeffB;
    private float[] coeffSigma;
    private int splineID;

    Spline(IntXL[] controlPoints) {
        this.controlPoints = controlPoints;
    }

    private FloatXL[] upsampleControlPoints() {
        if (this.controlPoints.length == 1) {
            return new FloatXL[]{new FloatXL(this.controlPoints[0])};
        }
        IntXL[] extended = new IntXL[this.controlPoints.length + 2];
        extended[0] = this.controlPoints[0].plus(this.controlPoints[0]).minus(this.controlPoints[1]);
        System.arraycopy(this.controlPoints, 0, extended, 1, this.controlPoints.length);
        extended[extended.length - 1] = this.controlPoints[this.controlPoints.length - 1].plus(this.controlPoints[this.controlPoints.length - 1]).minus(this.controlPoints[this.controlPoints.length - 2]);
        FloatXL[] upsampled = new FloatXL[16 * (extended.length - 3) + 1];
        for (int i2 = 0; i2 < extended.length - 3; ++i2) {
            int k2;
            float[] t2 = new float[4];
            FloatXL[] p2 = new FloatXL[4];
            FloatXL[] a10 = new FloatXL[3];
            FloatXL[] b2 = new FloatXL[3];
            for (k2 = 0; k2 < 4; ++k2) {
                p2[k2] = new FloatXL(extended[i2 + k2]);
            }
            upsampled[i2 * 16] = p2[1];
            t2[0] = 0.0f;
            for (k2 = 1; k2 < 4; ++k2) {
                t2[k2] = t2[k2 - 1] + (float)Math.pow(p2[k2].minus(p2[k2 - 1]).squared(), 0.25);
            }
            for (int step = 1; step < 16; ++step) {
                float f2;
                int k3;
                float knot = t2[1] + 0.0625f * (float)step * (t2[2] - t2[1]);
                for (k3 = 0; k3 < 3; ++k3) {
                    f2 = (knot - t2[k3]) / (t2[k3 + 1] - t2[k3]);
                    a10[k3] = p2[k3 + 1].minus(p2[k3]).multiply(f2).plus(p2[k3]);
                }
                for (k3 = 0; k3 < 2; ++k3) {
                    f2 = (knot - t2[k3]) / (t2[k3 + 2] - t2[k3]);
                    b2[k3] = a10[k3 + 1].minus(a10[k3]).multiply(f2).plus(a10[k3]);
                }
                float f3 = (knot - t2[1]) / (t2[2] - t2[1]);
                upsampled[i2 * 16 + step] = b2[1].minus(b2[0]).multiply(f3).plus(b2[0]);
            }
        }
        upsampled[upsampled.length - 1] = new FloatXL(this.controlPoints[this.controlPoints.length - 1]);
        return upsampled;
    }

    private Arc[] computeIntermediarySamples() {
        FloatXL current = this.upsampled[0];
        int nextID = 0;
        ArrayList<Arc> allSamples = new ArrayList<Arc>();
        allSamples.add(new Arc(current, 1.0f));
        block0: while (nextID < this.upsampled.length) {
            FloatXL prev = new FloatXL(current);
            float arcLengthFromPrevious = 0.0f;
            while (true) {
                if (nextID >= this.upsampled.length) {
                    allSamples.add(new Arc(prev, arcLengthFromPrevious));
                    continue block0;
                }
                FloatXL next = this.upsampled[nextID];
                float arcLengthToNext = next.minus(prev).norm();
                if (arcLengthFromPrevious + arcLengthToNext >= 1.0f) {
                    float f2 = (1.0f - arcLengthFromPrevious) / arcLengthToNext;
                    current = next.minus(prev).multiply(f2).plus(prev);
                    allSamples.add(new Arc(current, 1.0f));
                    continue block0;
                }
                arcLengthFromPrevious += arcLengthToNext;
                prev = next;
                ++nextID;
            }
        }
        return allSamples.toArray(new Arc[0]);
    }

    private static float doFICT(float[] coeffs, float t2) {
        float total = MathXL.SQRT_H * coeffs[0];
        for (int i2 = 1; i2 < 32; ++i2) {
            total = (float)((double)total + (double)coeffs[i2] * Math.cos((double)i2 * 0.09817477042468103 * ((double)t2 + 0.5)));
        }
        return total;
    }

    private void computeCoeffs(int splineID, LFGlobal lfGlobal) {
        this.coeffX = new float[32];
        this.coeffY = new float[32];
        this.coeffB = new float[32];
        this.coeffSigma = new float[32];
        float quantAdjust = (float)lfGlobal.splines.quantAdjust / 8.0f;
        float invQa = quantAdjust >= 0.0f ? 1.0f / (1.0f + quantAdjust) : 1.0f - quantAdjust;
        float yAdjust = 0.10606602f * invQa;
        float xAdjust = 0.005939697f * invQa;
        float bAdjust = 0.09899495f * invQa;
        float sigmaAdjust = 0.47135738f * invQa;
        for (int i2 = 0; i2 < 32; ++i2) {
            this.coeffY[i2] = (float)lfGlobal.splines.coeffY[splineID][i2] * yAdjust;
            this.coeffX[i2] = (float)lfGlobal.splines.coeffX[splineID][i2] * xAdjust + lfGlobal.lfChanCorr.baseX * this.coeffY[i2];
            this.coeffB[i2] = (float)lfGlobal.splines.coeffB[splineID][i2] * bAdjust + lfGlobal.lfChanCorr.baseB * this.coeffY[i2];
            this.coeffSigma[i2] = (float)lfGlobal.splines.coeffSigma[splineID][i2] * sigmaAdjust;
        }
    }

    void renderSpline(Frame frame) {
        this.computeCoeffs(this.splineID, frame.getLFGlobal());
        this.upsampled = this.upsampleControlPoints();
        float renderDistance = 1.0f;
        Arc[] arcs = this.computeIntermediarySamples();
        float arcLength = ((float)arcs.length - 2.0f) * 1.0f + arcs[arcs.length - 1].len;
        if ((double)arcLength <= 0.0) {
            return;
        }
        for (int i2 = 0; i2 < arcs.length; ++i2) {
            Arc arc = arcs[i2];
            float progressAlongArc = Math.min(1.0f, (float)i2 * 1.0f / arcLength);
            float t2 = 31.0f * progressAlongArc;
            float[] values = new float[]{Spline.doFICT(this.coeffX, t2) * arc.len, Spline.doFICT(this.coeffY, t2) * arc.len, Spline.doFICT(this.coeffB, t2) * arc.len};
            float sigma = Spline.doFICT(this.coeffSigma, t2);
            float inverseSigma = 1.0f / sigma;
            float maxColor = MathXL.max(0.01f, values[0], values[1], values[2]);
            float maxDist = (float)Math.sqrt(-2.0f * sigma * sigma * ((float)Math.log(0.1) * 3.0f - maxColor));
            int xBegin = Math.max(0, MathXL.round(arc.pos.x - maxDist));
            int xEnd = Math.min(frame.getFrameHeader().width - 1, MathXL.round(arc.pos.x + maxDist));
            int yBegin = Math.max(0, MathXL.round(arc.pos.y - maxDist));
            int yEnd = Math.min(frame.getFrameHeader().height - 1, MathXL.round(arc.pos.y + maxDist));
            for (int c2 = 0; c2 < 3; ++c2) {
                for (int y2 = yBegin; y2 <= yEnd; ++y2) {
                    float[] buffer = frame.buffer[c2][y2];
                    int x2 = xBegin;
                    while (x2 <= xEnd) {
                        float diffX = (float)x2 - arc.pos.x;
                        float diffY = (float)y2 - arc.pos.y;
                        float distance = (float)Math.sqrt(diffX * diffX + diffY * diffY);
                        float factor = MathXL.erf((0.5f * distance + MathXL.SQRT_F) * inverseSigma);
                        float extra = 0.25f * values[c2] * sigma * (factor -= MathXL.erf((0.5f * distance - MathXL.SQRT_F) * inverseSigma)) * factor;
                        int n2 = x2++;
                        buffer[n2] = buffer[n2] + extra;
                    }
                }
            }
        }
    }

    static class Arc {
        final FloatXL pos;
        final float len;

        Arc(FloatXL pos, float len) {
            this.pos = pos;
            this.len = len;
        }
    }
}

