/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.ANS;
import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.MathXL;
import com.idrsolutions.image.jpegXL.data.Symbols;
import com.idrsolutions.image.jpegXL.data.VLC;
import java.io.IOException;
import java.util.Arrays;

class PrefixSymbols
extends Symbols {
    private static final VLC level0Table = new VLC(4, new int[][]{{0, 2}, {4, 2}, {3, 2}, {2, 3}, {0, 2}, {4, 2}, {3, 2}, {1, 4}, {0, 2}, {4, 2}, {3, 2}, {2, 3}, {0, 2}, {4, 2}, {3, 2}, {5, 4}});
    private static final int[] codelenMap = new int[]{1, 2, 3, 4, 0, 5, 17, 6, 16, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private VLC table;
    private int defaultSymbol;

    PrefixSymbols(BitXL reader, int alphabetSize) throws IOException {
        this.alphabetSize = alphabetSize;
        this.logAlphabetSize = MathXL.ceilLog1p(alphabetSize - 1);
        if (alphabetSize == 1) {
            this.table = null;
            this.defaultSymbol = 0;
            return;
        }
        int hskip = reader.u(2);
        if (hskip == 1) {
            this.createSimple(reader);
        } else {
            this.createComplex(reader, hskip);
        }
    }

    private void createSimple(BitXL reader) throws IOException {
        int[] symbols = new int[4];
        int[] lens = null;
        int nsym = 1 + reader.u(2);
        boolean treeSelect = false;
        int bits = 0;
        for (int i2 = 0; i2 < nsym; ++i2) {
            symbols[i2] = reader.u(this.logAlphabetSize);
        }
        if (nsym == 4) {
            treeSelect = reader.bool();
        }
        switch (nsym) {
            case 1: {
                this.table = null;
                this.defaultSymbol = symbols[0];
                return;
            }
            case 2: {
                bits = 1;
                lens = new int[]{1, 1, 0, 0};
                if (symbols[0] <= symbols[1]) break;
                int temp = symbols[1];
                symbols[1] = symbols[0];
                symbols[0] = temp;
                break;
            }
            case 3: {
                bits = 2;
                lens = new int[]{1, 2, 2, 0};
                if (symbols[1] <= symbols[2]) break;
                int temp = symbols[2];
                symbols[2] = symbols[1];
                symbols[1] = temp;
                break;
            }
            case 4: {
                int temp;
                if (treeSelect) {
                    bits = 3;
                    lens = new int[]{1, 2, 3, 3};
                    if (symbols[2] <= symbols[3]) break;
                    temp = symbols[3];
                    symbols[3] = symbols[2];
                    symbols[2] = temp;
                    break;
                }
                bits = 2;
                lens = new int[]{2, 2, 2, 2};
                Arrays.sort(symbols);
            }
        }
        this.table = new VLC(bits, lens, symbols);
    }

    private void createComplex(BitXL reader, int hskip) throws IOException {
        int i2;
        int i3;
        int[] level1Lengths = new int[18];
        int[] level1Codecounts = new int[19];
        level1Codecounts[0] = hskip;
        int totalCode = 0;
        int numCodes = 0;
        for (i3 = hskip; i3 < 18; ++i3) {
            int code;
            int n2 = level0Table.getVLC(reader);
            level1Lengths[PrefixSymbols.codelenMap[i3]] = n2;
            int n3 = code = n2;
            level1Codecounts[n3] = level1Codecounts[n3] + 1;
            if (code != 0) {
                totalCode += 32 >>> code;
                ++numCodes;
            }
            if (totalCode < 32) continue;
            level1Codecounts[0] = level1Codecounts[0] + (17 - i3);
            break;
        }
        for (i3 = 1; i3 < 19; ++i3) {
            int n4 = i3;
            level1Codecounts[n4] = level1Codecounts[n4] + level1Codecounts[i3 - 1];
        }
        int[] level1LengthsScrambled = new int[18];
        int[] level1Symbols = new int[18];
        int i4 = 17;
        while (i4 >= 0) {
            int n5 = level1Lengths[i4];
            int n6 = level1Codecounts[n5] - 1;
            level1Codecounts[n5] = n6;
            int index = n6;
            level1LengthsScrambled[index] = level1Lengths[i4];
            level1Symbols[index] = i4--;
        }
        VLC leve11Table = numCodes == 1 ? new VLC(0, new int[][]{{level1Symbols[17], 0}}) : new VLC(5, level1LengthsScrambled, level1Symbols);
        totalCode = 0;
        int prevRepeatCount = 0;
        int prevZeroCount = 0;
        int[] level2Lengths = new int[this.alphabetSize];
        int[] level2Symbols = new int[this.alphabetSize];
        int[] level2Counts = new int[this.alphabetSize + 1];
        int prev = 8;
        for (i2 = 0; i2 < this.alphabetSize; ++i2) {
            int code = leve11Table.getVLC(reader);
            switch (code) {
                case 16: {
                    int extra = 3 + reader.u(2);
                    if (prevRepeatCount > 0) {
                        extra = 4 * (prevRepeatCount - 2) - prevRepeatCount + extra;
                    }
                    for (int j2 = 0; j2 < extra; ++j2) {
                        level2Lengths[i2 + j2] = prev;
                    }
                    totalCode += (32768 >>> prev) * extra;
                    i2 += extra - 1;
                    prevRepeatCount += extra;
                    prevZeroCount = 0;
                    int n7 = prev;
                    level2Counts[n7] = level2Counts[n7] + extra;
                    break;
                }
                case 17: {
                    int extra = 3 + reader.u(3);
                    if (prevZeroCount > 0) {
                        extra = 8 * (prevZeroCount - 2) - prevZeroCount + extra;
                    }
                    i2 += extra - 1;
                    prevRepeatCount = 0;
                    prevZeroCount += extra;
                    level2Counts[0] = level2Counts[0] + extra;
                    break;
                }
                default: {
                    level2Lengths[i2] = code;
                    prevRepeatCount = 0;
                    prevZeroCount = 0;
                    if (code != 0) {
                        totalCode += 32768 >>> code;
                        prev = code;
                    }
                    int n8 = code;
                    level2Counts[n8] = level2Counts[n8] + 1;
                }
            }
            if (totalCode < 32768) continue;
            level2Counts[0] = level2Counts[0] + (this.alphabetSize - i2 - 1);
            break;
        }
        for (i2 = 1; i2 <= this.alphabetSize; ++i2) {
            int n9 = i2;
            level2Counts[n9] = level2Counts[n9] + level2Counts[i2 - 1];
        }
        int[] level2LengthsScrambled = new int[this.alphabetSize];
        int i5 = this.alphabetSize - 1;
        while (i5 >= 0) {
            int n10 = level2Lengths[i5];
            int n11 = level2Counts[n10] - 1;
            level2Counts[n10] = n11;
            int index = n11;
            level2LengthsScrambled[index] = level2Lengths[i5];
            level2Symbols[index] = i5--;
        }
        this.table = new VLC(15, level2LengthsScrambled, level2Symbols);
    }

    @Override
    public int readSymbol(BitXL reader, ANS state) throws IOException {
        if (this.table == null) {
            return this.defaultSymbol;
        }
        return this.table.getVLC(reader);
    }
}

