/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.BlendInfo;
import com.idrsolutions.image.jpegXL.data.Entropy;
import com.idrsolutions.image.jpegXL.data.IntXL;
import com.idrsolutions.image.jpegXL.data.MathXL;
import java.io.IOException;

class Patch {
    final int width;
    final int height;
    final int ref;
    final IntXL origin;
    final IntXL[] positions;
    final BlendInfo[][] blendingInfos;

    Patch(Entropy entropy, BitXL reader, int extraChannelCount, int alphaChannelCount) throws IOException {
        this.ref = entropy.readSymbol(reader, 1);
        int x0 = entropy.readSymbol(reader, 3);
        int y0 = entropy.readSymbol(reader, 3);
        this.origin = new IntXL(x0, y0);
        this.width = 1 + entropy.readSymbol(reader, 2);
        this.height = 1 + entropy.readSymbol(reader, 2);
        int count = 1 + entropy.readSymbol(reader, 7);
        this.positions = new IntXL[count];
        this.blendingInfos = new BlendInfo[count][];
        for (int j2 = 0; j2 < count; ++j2) {
            IntXL xy;
            int y2;
            int x2;
            if (j2 == 0) {
                x2 = entropy.readSymbol(reader, 4);
                y2 = entropy.readSymbol(reader, 4);
                xy = new IntXL(x2, y2);
            } else {
                x2 = entropy.readSymbol(reader, 6);
                y2 = entropy.readSymbol(reader, 6);
                x2 = MathXL.unpackSigned(x2) + this.positions[j2 - 1].x;
                y2 = MathXL.unpackSigned(y2) + this.positions[j2 - 1].y;
                xy = new IntXL(x2, y2);
            }
            this.positions[j2] = xy;
            this.blendingInfos[j2] = new BlendInfo[extraChannelCount + 1];
            for (int k2 = 0; k2 < extraChannelCount + 1; ++k2) {
                int mode = entropy.readSymbol(reader, 5);
                int alpha = 0;
                boolean clamp = false;
                if (mode > 3 && alphaChannelCount > 1) {
                    alpha = entropy.readSymbol(reader, 8);
                }
                if (mode > 2) {
                    clamp = entropy.readSymbol(reader, 9) != 0;
                }
                this.blendingInfos[j2][k2] = new BlendInfo(mode, alpha, clamp, 0);
            }
        }
    }
}

