/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.Frame;
import com.idrsolutions.image.jpegXL.data.GlobalModular;
import com.idrsolutions.image.jpegXL.data.HFPass;
import com.idrsolutions.image.jpegXL.data.MathXL;
import com.idrsolutions.image.jpegXL.data.ModularChannel;
import com.idrsolutions.image.jpegXL.data.ModularInfo;
import com.idrsolutions.image.jpegXL.data.PassInfo;
import java.io.IOException;

class Pass {
    final int minShift;
    final int maxShift;
    final ModularInfo[] replacedChannels;
    final HFPass hfPass;

    Pass(BitXL reader, Frame frame, int passIndex, int prevMinshift) throws IOException {
        this.maxShift = passIndex > 0 ? prevMinshift : 3;
        int n2 = -1;
        PassInfo passes = frame.getFrameHeader().passes;
        for (int i2 = 0; i2 < passes.lastPass.length; ++i2) {
            if (passes.lastPass[i2] != passIndex) continue;
            n2 = i2;
            break;
        }
        this.minShift = n2 >= 0 ? MathXL.ceilLog1p(passes.downSample[n2] - 1) : this.maxShift;
        GlobalModular globalModular = frame.getLFGlobal().gModular;
        this.replacedChannels = new ModularInfo[globalModular.stream.getEncodedChannelCount()];
        for (int i3 = 0; i3 < globalModular.stream.getEncodedChannelCount(); ++i3) {
            int m2;
            ModularChannel chan = globalModular.stream.getChannel(i3);
            if (chan.isDecoded() || this.minShift > (m2 = Math.min(chan.hshift, chan.vshift)) || m2 >= this.maxShift) continue;
            this.replacedChannels[i3] = new ModularInfo(chan);
        }
        this.hfPass = frame.getFrameHeader().encoding == 0 ? new HFPass(reader, frame) : null;
    }
}

