/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.Entropy;
import com.idrsolutions.image.jpegXL.data.Frame;
import com.idrsolutions.image.jpegXL.data.ITXInfo;
import com.idrsolutions.image.jpegXL.data.MTree;
import com.idrsolutions.image.jpegXL.data.ModularChannel;
import com.idrsolutions.image.jpegXL.data.ModularInfo;
import com.idrsolutions.image.jpegXL.data.SqueezeInfo;
import com.idrsolutions.image.jpegXL.data.WPInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ModularStream {
    private static final int[][] DELTAS = new int[][]{{0, 0, 0}, {4, 4, 4}, {11, 0, 0}, {0, 0, -13}, {0, -12, 0}, {-10, -10, -10}, {-18, -18, -18}, {-27, -27, -27}, {-18, -18, 0}, {0, 0, -32}, {-32, 0, 0}, {-37, -37, -37}, {0, -32, -32}, {24, 24, 45}, {50, 50, 50}, {-45, -24, -24}, {-24, -45, -45}, {0, -24, -24}, {-34, -34, 0}, {-24, 0, -24}, {-45, -45, -24}, {64, 64, 64}, {-32, 0, -32}, {0, -32, 0}, {-32, 0, 32}, {-24, -45, -24}, {45, 24, 45}, {24, -24, -45}, {-45, -24, 24}, {80, 80, 80}, {64, 0, 0}, {0, 0, -64}, {0, -64, -64}, {-24, -24, 45}, {96, 96, 96}, {64, 64, 0}, {45, -24, -24}, {34, -34, 0}, {112, 112, 112}, {24, -45, -45}, {45, 45, -24}, {0, -32, 32}, {24, -24, 45}, {0, 96, 96}, {45, -24, 24}, {24, -45, -24}, {-24, -45, 24}, {0, -64, 0}, {96, 0, 0}, {128, 128, 128}, {64, 0, 64}, {144, 144, 144}, {96, 96, 0}, {-36, -36, 36}, {45, -24, -45}, {45, -45, -24}, {0, 0, -96}, {0, 128, 128}, {0, 96, 0}, {45, 24, -45}, {-128, 0, 0}, {24, -45, 24}, {-45, 24, -45}, {64, 0, -64}, {64, -64, -64}, {96, 0, 96}, {45, -45, 24}, {24, 45, -45}, {64, 64, -64}, {128, 128, 0}, {0, 0, -128}, {-24, 45, -45}};
    private static final int[][] permutationLut = new int[][]{{0, 1, 2}, {1, 2, 0}, {2, 0, 1}, {0, 2, 1}, {1, 0, 2}, {2, 1, 0}};
    private int nbMetaChannels;
    private final int streamIndex;
    private final int distMultiplier;
    private final MTree tree;
    private final WPInfo wpParams;
    private final ITXInfo[] transforms;
    private final Frame frame;
    private Entropy stream;
    private boolean transformed;
    private final List<ModularInfo> channels = new ArrayList<ModularInfo>();
    private final Map<Integer, SqueezeInfo[]> squeezeMap = new HashMap<Integer, SqueezeInfo[]>();

    ModularStream(BitXL reader, Frame frame, int streamIndex, int channelCount, int ecStart) throws IOException {
        this(reader, frame, streamIndex, channelCount, ecStart, null);
    }

    ModularStream(BitXL reader, Frame frame, int streamIndex, ModularInfo[] channelArray) throws IOException {
        this(reader, frame, streamIndex, channelArray.length, 0, channelArray);
    }

    private ModularStream(BitXL reader, Frame frame, int streamIndex, int channelCount, int ecStart, ModularInfo[] channelArray) throws IOException {
        int i2;
        this.frame = frame;
        this.streamIndex = streamIndex;
        if (channelCount == 0) {
            this.tree = null;
            this.wpParams = null;
            this.transforms = new ITXInfo[0];
            this.distMultiplier = 1;
            return;
        }
        boolean useGlobalTree = reader.bool();
        this.wpParams = new WPInfo(reader);
        int nbTransforms = reader.u32(0, 0, 1, 0, 2, 4, 18, 8);
        this.transforms = new ITXInfo[nbTransforms];
        for (int i3 = 0; i3 < nbTransforms; ++i3) {
            this.transforms[i3] = new ITXInfo(reader);
        }
        int w2 = frame.getModularFrameSize().x;
        int h2 = frame.getModularFrameSize().y;
        if (channelArray == null) {
            for (i2 = 0; i2 < channelCount; ++i2) {
                int dimShift = i2 < ecStart ? 0 : frame.globalMetadata.getExtraChannel((int)(i2 - ecStart)).dimShift;
                this.channels.add(new ModularInfo(w2, h2, dimShift, dimShift));
            }
        } else {
            this.channels.addAll(Arrays.asList(channelArray));
        }
        block6: for (i2 = 0; i2 < nbTransforms; ++i2) {
            switch (this.transforms[i2].tr) {
                case 1: {
                    this.nbMetaChannels = this.transforms[i2].beginC < this.nbMetaChannels ? (this.nbMetaChannels += 2 - this.transforms[i2].numC) : ++this.nbMetaChannels;
                    int start = this.transforms[i2].beginC + 1;
                    if (this.transforms[i2].beginC + this.transforms[i2].numC > start) {
                        this.channels.subList(start, this.transforms[i2].beginC + this.transforms[i2].numC).clear();
                    }
                    if (this.transforms[i2].nbDeltas > 0 && this.transforms[i2].dPred == 6) {
                        this.channels.get((int)this.transforms[i2].beginC).forceWP = true;
                    }
                    this.channels.add(0, new ModularInfo(this.transforms[i2].nbColors, this.transforms[i2].numC, -1, -1));
                    continue block6;
                }
                case 2: {
                    ArrayList<SqueezeInfo> squeezeList = new ArrayList<SqueezeInfo>();
                    if (this.transforms[i2].sp.length == 0) {
                        int first = this.nbMetaChannels;
                        int count = this.channels.size() - first;
                        w2 = this.channels.get((int)first).width;
                        h2 = this.channels.get((int)first).height;
                        if (count > 2 && this.channels.get((int)(first + 1)).width == w2 && this.channels.get((int)(first + 1)).height == h2) {
                            squeezeList.add(new SqueezeInfo(true, false, first + 1, 2));
                            squeezeList.add(new SqueezeInfo(false, false, first + 1, 2));
                        }
                        if (h2 >= w2 && h2 > 8) {
                            squeezeList.add(new SqueezeInfo(false, true, first, count));
                            h2 = (h2 + 1) / 2;
                        }
                        while (w2 > 8 || h2 > 8) {
                            if (w2 > 8) {
                                squeezeList.add(new SqueezeInfo(true, true, first, count));
                                w2 = (w2 + 1) / 2;
                            }
                            if (h2 <= 8) continue;
                            squeezeList.add(new SqueezeInfo(false, true, first, count));
                            h2 = (h2 + 1) / 2;
                        }
                    } else {
                        squeezeList.addAll(Arrays.asList(this.transforms[i2].sp));
                    }
                    SqueezeInfo[] sqi = squeezeList.toArray(new SqueezeInfo[0]);
                    this.squeezeMap.put(i2, sqi);
                    for (SqueezeInfo sqa1 : sqi) {
                        int offset;
                        int begin = sqa1.beginC;
                        int end = begin + sqa1.numC - 1;
                        int n2 = offset = sqa1.inPlace ? end + 1 : this.channels.size();
                        if (begin < this.nbMetaChannels) {
                            this.nbMetaChannels += sqa1.numC;
                        }
                        for (int k2 = begin; k2 <= end; ++k2) {
                            ModularInfo residual;
                            ModularInfo chan = this.channels.get(k2);
                            int r2 = offset + k2 - begin;
                            if (sqa1.horizontal) {
                                w2 = chan.width;
                                chan.width = (w2 + 1) / 2;
                                ++chan.hshift;
                                residual = new ModularInfo(chan);
                                residual.width = w2 / 2;
                            } else {
                                h2 = chan.height;
                                chan.height = (h2 + 1) / 2;
                                ++chan.vshift;
                                residual = new ModularInfo(chan);
                                residual.height = h2 / 2;
                            }
                            this.channels.add(r2, residual);
                        }
                    }
                    continue block6;
                }
            }
        }
        this.tree = !useGlobalTree ? new MTree(reader) : frame.getGlobalTree();
        this.stream = new Entropy(this.tree.entropy);
        this.distMultiplier = this.channels.stream().mapToInt(c2 -> c2.width).reduce(0, Math::max);
    }

    void decodeChannels(BitXL reader) throws IOException {
        this.decodeChannels(reader, false);
    }

    void decodeChannels(BitXL reader, boolean partial) throws IOException {
        this.channels.replaceAll(ModularChannel::new);
        int groupDim = this.frame.getFrameHeader().groupDim;
        for (int i2 = 0; i2 < this.channels.size(); ++i2) {
            ModularChannel channel = this.getChannel(i2);
            if (partial && i2 >= this.nbMetaChannels && (channel.width > groupDim || channel.height > groupDim)) break;
            channel.decode(reader, this.stream, this.wpParams, this.tree, this, i2, this.streamIndex, this.distMultiplier);
        }
        if (!partial) {
            this.applyTransforms();
        }
    }

    int getEncodedChannelCount() {
        return this.channels.size();
    }

    ModularChannel getChannel(int index) {
        ModularInfo channel = this.channels.get(index);
        return (ModularChannel)channel;
    }

    ModularInfo getChannelInfo(int index) {
        return this.channels.get(index);
    }

    void applyTransforms() {
        if (this.transformed) {
            return;
        }
        this.transformed = true;
        block14: for (int i2 = this.transforms.length - 1; i2 >= 0; --i2) {
            switch (this.transforms[i2].tr) {
                case 2: {
                    SqueezeInfo[] sqa = this.squeezeMap.get(i2);
                    for (int j2 = sqa.length - 1; j2 >= 0; --j2) {
                        int c2;
                        SqueezeInfo sq = sqa[j2];
                        int begin = sq.beginC;
                        int end = begin + sq.numC - 1;
                        int offset = sq.inPlace ? end + 1 : this.channels.size() + begin - end - 1;
                        for (c2 = begin; c2 <= end; ++c2) {
                            ModularChannel output;
                            ModularInfo outputInfo;
                            int r2 = offset + c2 - begin;
                            ModularChannel chan = this.getChannel(c2);
                            ModularChannel residual = this.getChannel(r2);
                            if (sq.horizontal) {
                                outputInfo = new ModularInfo(chan.width + residual.width, chan.height, chan.hshift - 1, chan.vshift);
                                output = ModularChannel.inverseHorizontalSqueeze(outputInfo, chan, residual);
                            } else {
                                outputInfo = new ModularInfo(chan.width, chan.height + residual.height, chan.hshift, chan.vshift - 1);
                                output = ModularChannel.inverseVerticalSqueeze(outputInfo, chan, residual);
                            }
                            this.channels.set(c2, output);
                        }
                        for (c2 = 0; c2 < end - begin + 1; ++c2) {
                            this.channels.remove(offset);
                        }
                    }
                    continue block14;
                }
                case 0: {
                    int j3;
                    int permutation = this.transforms[i2].rctType / 7;
                    int type = this.transforms[i2].rctType % 7;
                    ModularChannel[] v2 = new ModularChannel[3];
                    int start = this.transforms[i2].beginC;
                    for (j3 = 0; j3 < 3; ++j3) {
                        v2[j3] = this.getChannel(start + j3);
                    }
                    for (int y2 = 0; y2 < v2[0].height; ++y2) {
                        block20: for (int x2 = 0; x2 < v2[0].width; ++x2) {
                            switch (type) {
                                case 0: {
                                    continue block20;
                                }
                                case 1: {
                                    v2[2].buffer[y2][x2] = v2[0].buffer[y2][x2] + v2[2].buffer[y2][x2];
                                    continue block20;
                                }
                                case 2: {
                                    v2[1].buffer[y2][x2] = v2[0].buffer[y2][x2] + v2[1].buffer[y2][x2];
                                    continue block20;
                                }
                                case 3: {
                                    int a10 = v2[0].buffer[y2][x2];
                                    v2[2].buffer[y2][x2] = a10 + v2[2].buffer[y2][x2];
                                    v2[1].buffer[y2][x2] = a10 + v2[1].buffer[y2][x2];
                                    continue block20;
                                }
                                case 4: {
                                    v2[1].buffer[y2][x2] = v2[1].buffer[y2][x2] + (v2[0].buffer[y2][x2] + v2[2].buffer[y2][x2]) >> 1;
                                    continue block20;
                                }
                                case 5: {
                                    int aa2 = v2[0].buffer[y2][x2];
                                    int cc = v2[2].buffer[y2][x2];
                                    int[] nArray = v2[1].buffer[y2];
                                    int n2 = x2;
                                    nArray[n2] = nArray[n2] + (aa2 + (cc >> 1));
                                    v2[2].buffer[y2][x2] = aa2 + cc;
                                    continue block20;
                                }
                                case 6: {
                                    int b2 = v2[1].buffer[y2][x2];
                                    int c3 = v2[2].buffer[y2][x2];
                                    int tmp = v2[0].buffer[y2][x2] - (c3 >> 1);
                                    int f2 = tmp - (b2 >> 1);
                                    v2[0].buffer[y2][x2] = f2 + b2;
                                    v2[1].buffer[y2][x2] = c3 + tmp;
                                    v2[2].buffer[y2][x2] = f2;
                                }
                            }
                        }
                    }
                    for (j3 = 0; j3 < 3; ++j3) {
                        this.channels.set(start + permutationLut[permutation][j3], v2[j3]);
                    }
                    continue block14;
                }
                case 1: {
                    int first = this.transforms[i2].beginC + 1;
                    int endC = this.transforms[i2].beginC + this.transforms[i2].numC - 1;
                    int last = endC + 1;
                    int bitDepth = this.frame.globalMetadata.getBitDepthHeader().bitsPerSample;
                    ModularChannel firstChannel = this.getChannel(first);
                    ModularChannel c0 = this.getChannel(0);
                    for (int j4 = first + 1; j4 <= last; ++j4) {
                        this.channels.add(j4, new ModularChannel(firstChannel));
                    }
                    for (int c4 = 0; c4 < this.transforms[i2].numC; ++c4) {
                        ModularChannel chan = this.getChannel(first + c4);
                        for (int y3 = 0; y3 < firstChannel.height; ++y3) {
                            for (int x3 = 0; x3 < firstChannel.width; ++x3) {
                                int value;
                                boolean isDelta;
                                int index = chan.buffer[y3][x3];
                                boolean bl2 = isDelta = index < this.transforms[i2].nbDeltas;
                                if (index >= 0 && index < this.transforms[i2].nbColors) {
                                    value = c0.buffer[c4][index];
                                } else if (index >= this.transforms[i2].nbColors) {
                                    if ((index -= this.transforms[i2].nbColors) < 64) {
                                        value = (index >> 2 * c4) % 4 * ((1 << bitDepth) - 1) / 4 + (1 << Math.max(0, bitDepth - 3));
                                    } else {
                                        index -= 64;
                                        for (int k2 = 0; k2 < c4; ++k2) {
                                            index /= 5;
                                        }
                                        value = index % 5 * ((1 << bitDepth) - 1) / 4;
                                    }
                                } else if (c4 < 3) {
                                    index = (-index - 1) % 143;
                                    value = DELTAS[index + 1 >> 1][c4];
                                    if ((index & 1) == 0) {
                                        value = -value;
                                    }
                                    if (bitDepth > 8) {
                                        value <<= Math.min(bitDepth, 24) - 8;
                                    }
                                } else {
                                    value = 0;
                                }
                                chan.buffer[y3][x3] = value;
                                if (!isDelta) continue;
                                int[] nArray = chan.buffer[y3];
                                int n3 = x3;
                                nArray[n3] = nArray[n3] + chan.predict(x3, y3, this.transforms[i2].dPred);
                            }
                        }
                    }
                    this.channels.remove(0);
                    --this.nbMetaChannels;
                    continue block14;
                }
            }
        }
    }

    int[][][] getDecodedBuffer() {
        int[][][] bands = new int[this.channels.size()][][];
        for (int i2 = 0; i2 < bands.length; ++i2) {
            bands[i2] = this.getChannel((int)i2).buffer;
        }
        return bands;
    }
}

