/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.Entropy;
import com.idrsolutions.image.jpegXL.data.HelperXL;
import com.idrsolutions.image.jpegXL.data.MTree;
import com.idrsolutions.image.jpegXL.data.MathXL;
import com.idrsolutions.image.jpegXL.data.ModularInfo;
import com.idrsolutions.image.jpegXL.data.ModularStream;
import com.idrsolutions.image.jpegXL.data.WPInfo;
import java.io.IOException;
import java.util.Arrays;

class ModularChannel
extends ModularInfo {
    private static final int[] oneL24OverKP1 = new int[64];
    int[][] buffer;
    protected int[][][] error;
    protected int[][] pred;
    private int[] subpred;
    private int[] weight;
    private boolean decoded;

    private static int tendency(int a10, int b2, int c2) {
        if (a10 >= b2 && b2 >= c2) {
            int x2 = (4 * a10 - 3 * c2 - b2 + 6) / 12;
            int d2 = 2 * (a10 - b2);
            int e2 = 2 * (b2 - c2);
            if (x2 - (x2 & 1) > d2) {
                x2 = d2 + 1;
            }
            if (x2 + (x2 & 1) > e2) {
                x2 = e2;
            }
            return x2;
        }
        if (a10 <= b2 && b2 <= c2) {
            int x3 = (4 * a10 - 3 * c2 - b2 - 6) / 12;
            int d3 = 2 * (a10 - b2);
            int e3 = 2 * (b2 - c2);
            if (x3 + (x3 & 1) < d3) {
                x3 = d3 - 1;
            }
            if (x3 - (x3 & 1) < e3) {
                x3 = e3;
            }
            return x3;
        }
        return 0;
    }

    ModularChannel(ModularInfo info) {
        super(info);
        this.buffer = this.width == 0 || this.height == 0 ? (Object)new int[0][] : new int[this.height][this.width];
        this.decoded = false;
    }

    ModularChannel(int width, int height, int hshift, int vshift) {
        super(width, height, hshift, vshift);
    }

    ModularChannel(ModularChannel copy) {
        this((ModularInfo)copy);
        if (copy.buffer != null) {
            this.buffer = new int[this.height][];
            for (int y2 = 0; y2 < this.height; ++y2) {
                this.buffer[y2] = Arrays.copyOf(copy.buffer[y2], copy.buffer[y2].length);
            }
        }
        this.decoded = copy.decoded;
    }

    private int west(int x2, int y2) {
        return x2 > 0 ? this.buffer[y2][x2 - 1] : (y2 > 0 ? this.buffer[y2 - 1][x2] : 0);
    }

    private int north(int x2, int y2) {
        return y2 > 0 ? this.buffer[y2 - 1][x2] : (x2 > 0 ? this.buffer[y2][x2 - 1] : 0);
    }

    private int northWest(int x2, int y2) {
        return x2 > 0 && y2 > 0 ? this.buffer[y2 - 1][x2 - 1] : this.west(x2, y2);
    }

    private int northEast(int x2, int y2) {
        return x2 + 1 < this.width && y2 > 0 ? this.buffer[y2 - 1][x2 + 1] : this.north(x2, y2);
    }

    private int northNorth(int x2, int y2) {
        return y2 > 1 ? this.buffer[y2 - 2][x2] : this.north(x2, y2);
    }

    private int northEastEast(int x2, int y2) {
        return x2 + 2 < this.width && y2 > 0 ? this.buffer[y2 - 1][x2 + 2] : this.northEast(x2, y2);
    }

    private int westWest(int x2, int y2) {
        return x2 > 1 ? this.buffer[y2][x2 - 2] : this.west(x2, y2);
    }

    private int errorWest(int x2, int y2, int e2) {
        return x2 > 0 ? this.error[e2][y2][x2 - 1] : 0;
    }

    private int errorNorth(int x2, int y2, int e2) {
        return y2 > 0 ? this.error[e2][y2 - 1][x2] : 0;
    }

    private int errorWestWest(int x2, int y2, int e2) {
        return x2 > 1 ? this.error[e2][y2][x2 - 2] : 0;
    }

    private int errorNorthWest(int x2, int y2, int e2) {
        return x2 > 0 && y2 > 0 ? this.error[e2][y2 - 1][x2 - 1] : this.errorNorth(x2, y2, e2);
    }

    private int errorNorthEast(int x2, int y2, int e2) {
        return x2 + 1 < this.width && y2 > 0 ? this.error[e2][y2 - 1][x2 + 1] : this.errorNorth(x2, y2, e2);
    }

    int predict(int x2, int y2, int k2) {
        switch (k2) {
            case 1: {
                return this.west(x2, y2);
            }
            case 2: {
                return this.north(x2, y2);
            }
            case 3: {
                return (this.west(x2, y2) + this.north(x2, y2)) / 2;
            }
            case 4: {
                int w2 = this.west(x2, y2);
                int n2 = this.north(x2, y2);
                int nw = this.northWest(x2, y2);
                return Math.abs(n2 - nw) < Math.abs(w2 - nw) ? w2 : n2;
            }
            case 5: {
                int w3 = this.west(x2, y2);
                int n3 = this.north(x2, y2);
                int v2 = w3 + n3 - this.northWest(x2, y2);
                return MathXL.clamp(v2, n3, w3);
            }
            case 6: {
                return this.pred[y2][x2] + 3 >> 3;
            }
            case 7: {
                return this.northEast(x2, y2);
            }
            case 8: {
                return this.northWest(x2, y2);
            }
            case 9: {
                return this.westWest(x2, y2);
            }
            case 10: {
                return (this.west(x2, y2) + this.northWest(x2, y2)) / 2;
            }
            case 11: {
                return (this.north(x2, y2) + this.northWest(x2, y2)) / 2;
            }
            case 12: {
                return (this.north(x2, y2) + this.northEast(x2, y2)) / 2;
            }
            case 13: {
                return (6 * this.north(x2, y2) - 2 * this.northNorth(x2, y2) + 7 * this.west(x2, y2) + this.westWest(x2, y2) + this.northEastEast(x2, y2) + 3 * this.northEast(x2, y2) + 8) / 16;
            }
        }
        return 0;
    }

    private int prePredictWP(WPInfo wpParams, int x2, int y2) {
        int n3 = this.north(x2, y2) << 3;
        int nw3 = this.northWest(x2, y2) << 3;
        int ne3 = this.northEast(x2, y2) << 3;
        int w3 = this.west(x2, y2) << 3;
        int nn3 = this.northNorth(x2, y2) << 3;
        int tN = this.errorNorth(x2, y2, 4);
        int tW = this.errorWest(x2, y2, 4);
        int tNE = this.errorNorthEast(x2, y2, 4);
        int tNW = this.errorNorthWest(x2, y2, 4);
        this.subpred[0] = w3 + ne3 - n3;
        this.subpred[1] = n3 - ((tW + tN + tNE) * wpParams.param1 >> 5);
        this.subpred[2] = w3 - ((tW + tN + tNW) * wpParams.param2 >> 5);
        this.subpred[3] = n3 - (tNW * wpParams.param3a + tN * wpParams.param3b + tNE * wpParams.param3c + (nn3 - n3) * wpParams.param3d + (nw3 - w3) * wpParams.param3e >> 5);
        int wSum = 0;
        for (int e2 = 0; e2 < 4; ++e2) {
            int shift;
            int eSum = this.errorNorth(x2, y2, e2) + this.errorWest(x2, y2, e2) + this.errorNorthWest(x2, y2, e2) + this.errorWestWest(x2, y2, e2) + this.errorNorthEast(x2, y2, e2);
            if (x2 + 1 == this.width) {
                eSum += this.errorWest(x2, y2, e2);
            }
            if ((shift = MathXL.floorLog1p(eSum) - 5) < 0) {
                shift = 0;
            }
            this.weight[e2] = 4 + (wpParams.weight[e2] * oneL24OverKP1[eSum >> shift] >> shift);
            wSum += this.weight[e2];
        }
        int logWeight = MathXL.floorLog1p(wSum - 1) - 4;
        wSum = 0;
        for (int e3 = 0; e3 < 4; ++e3) {
            int n2 = e3;
            this.weight[n2] = this.weight[n2] >> logWeight;
            wSum += this.weight[e3];
        }
        long s2 = (long)(wSum >> 1) - 1L;
        for (int e4 = 0; e4 < 4; ++e4) {
            s2 += (long)this.subpred[e4] * (long)this.weight[e4];
        }
        this.pred[y2][x2] = (int)(s2 * (long)oneL24OverKP1[wSum - 1] >> 24);
        if ((tN ^ tW | tN ^ tNW) <= 0) {
            this.pred[y2][x2] = MathXL.clamp(this.pred[y2][x2], w3, n3, ne3);
        }
        int maxError = tW;
        if (Math.abs(tN) > Math.abs(maxError)) {
            maxError = tN;
        }
        if (Math.abs(tNW) > Math.abs(maxError)) {
            maxError = tNW;
        }
        if (Math.abs(tNE) > Math.abs(maxError)) {
            maxError = tNE;
        }
        return maxError;
    }

    void decode(BitXL reader, Entropy stream, WPInfo wpParams, MTree tree, ModularStream parent, int channelIndex, int streamIndex, int distMultiplier) throws IOException {
        boolean useWP;
        if (this.decoded) {
            return;
        }
        this.decoded = true;
        tree = tree.compact(channelIndex, streamIndex);
        boolean bl2 = useWP = this.forceWP || tree.usesWeightedPredictor();
        if (useWP) {
            this.error = new int[5][this.height][this.width];
            this.pred = new int[this.height][this.width];
            this.subpred = new int[4];
            this.weight = new int[4];
        }
        for (int y2 : HelperXL.range(this.height)) {
            MTree refinedTree = tree.compact(channelIndex, streamIndex, y2);
            for (int x2 : HelperXL.range(this.width)) {
                int trueValue;
                int maxError = useWP ? this.prePredictWP(wpParams, x2, y2) : 0;
                MTree leafNode = refinedTree.walk(k2 -> {
                    switch (k2) {
                        case 0: {
                            return channelIndex;
                        }
                        case 1: {
                            return streamIndex;
                        }
                        case 2: {
                            return y2;
                        }
                        case 3: {
                            return x2;
                        }
                        case 4: {
                            return Math.abs(this.north(x2, y2));
                        }
                        case 5: {
                            return Math.abs(this.west(x2, y2));
                        }
                        case 6: {
                            return this.north(x2, y2);
                        }
                        case 7: {
                            return this.west(x2, y2);
                        }
                        case 8: {
                            return x2 > 0 ? this.west(x2, y2) - (this.west(x2 - 1, y2) + this.north(x2 - 1, y2) - this.northWest(x2 - 1, y2)) : this.west(x2, y2);
                        }
                        case 9: {
                            return this.west(x2, y2) + this.north(x2, y2) - this.northWest(x2, y2);
                        }
                        case 10: {
                            return this.west(x2, y2) - this.northWest(x2, y2);
                        }
                        case 11: {
                            return this.northWest(x2, y2) - this.north(x2, y2);
                        }
                        case 12: {
                            return this.north(x2, y2) - this.northEast(x2, y2);
                        }
                        case 13: {
                            return this.north(x2, y2) - this.northNorth(x2, y2);
                        }
                        case 14: {
                            return this.west(x2, y2) - this.westWest(x2, y2);
                        }
                        case 15: {
                            return maxError;
                        }
                    }
                    if (k2 - 16 >= 4 * channelIndex) {
                        return 0;
                    }
                    int k22 = 16;
                    for (int j2 = channelIndex - 1; j2 >= 0; --j2) {
                        ModularChannel channel = parent.getChannel(j2);
                        if (channel.width != this.width || channel.height != this.height || channel.hshift != this.hshift || channel.vshift != this.vshift) continue;
                        if (k22 + 4 <= k2) {
                            k22 += 4;
                            continue;
                        }
                        int rC = channel.buffer[y2][x2];
                        if (k22++ == k2) {
                            return Math.abs(rC);
                        }
                        if (k22++ == k2) {
                            return rC;
                        }
                        int rW = x2 > 0 ? channel.buffer[y2][x2 - 1] : 0;
                        int rN = y2 > 0 ? channel.buffer[y2 - 1][x2] : rW;
                        int rNW = x2 > 0 && y2 > 0 ? channel.buffer[y2 - 1][x2 - 1] : rW;
                        int rG = rC - MathXL.clamp(rW + rN - rNW, rN, rW);
                        if (k22++ == k2) {
                            return Math.abs(rG);
                        }
                        if (k22++ != k2) continue;
                        return rG;
                    }
                    return 0;
                });
                int diff = stream.readSymbol(reader, leafNode.context, distMultiplier);
                diff = MathXL.unpackSigned(diff) * leafNode.multiplier + leafNode.offset;
                this.buffer[y2][x2] = trueValue = diff + this.predict(x2, y2, leafNode.predictor);
                if (!useWP) continue;
                for (int e2 = 0; e2 < 4; ++e2) {
                    this.error[e2][y2][x2] = Math.abs(this.subpred[e2] - (trueValue << 3)) + 3 >> 3;
                }
                this.error[4][y2][x2] = this.pred[y2][x2] - (trueValue << 3);
            }
        }
    }

    boolean isDecoded() {
        return this.decoded;
    }

    static ModularChannel inverseHorizontalSqueeze(ModularInfo info, ModularChannel orig, ModularChannel res) {
        int y2;
        ModularChannel channel = new ModularChannel(info);
        for (y2 = 0; y2 < res.height; ++y2) {
            for (int x2 = 0; x2 < res.width; ++x2) {
                int first;
                int avg = orig.buffer[y2][x2];
                int residu = res.buffer[y2][x2];
                int nextAvg = x2 + 1 < orig.width ? orig.buffer[y2][x2 + 1] : avg;
                int left = x2 > 0 ? channel.buffer[y2][2 * x2 - 1] : avg;
                int diff = residu + ModularChannel.tendency(left, avg, nextAvg);
                channel.buffer[y2][2 * x2] = first = avg + diff / 2;
                channel.buffer[y2][2 * x2 + 1] = first - diff;
            }
        }
        if (orig.width > res.width) {
            for (y2 = 0; y2 < channel.height; ++y2) {
                channel.buffer[y2][2 * res.width] = orig.buffer[y2][res.width];
            }
        }
        return channel;
    }

    static ModularChannel inverseVerticalSqueeze(ModularInfo info, ModularChannel orig, ModularChannel res) {
        ModularChannel channel = new ModularChannel(info);
        for (int y2 = 0; y2 < res.height; ++y2) {
            for (int x2 = 0; x2 < channel.width; ++x2) {
                int first;
                int avg = orig.buffer[y2][x2];
                int residu = res.buffer[y2][x2];
                int nextAvg = y2 + 1 < orig.height ? orig.buffer[y2 + 1][x2] : avg;
                int top = y2 > 0 ? channel.buffer[2 * y2 - 1][x2] : avg;
                int diff = residu + ModularChannel.tendency(top, avg, nextAvg);
                channel.buffer[2 * y2][x2] = first = avg + diff / 2;
                channel.buffer[2 * y2 + 1][x2] = first - diff;
            }
        }
        if (orig.height > res.height) {
            System.arraycopy(orig.buffer[res.height], 0, channel.buffer[2 * res.height], 0, channel.width);
        }
        return channel;
    }

    static {
        for (int i2 = 0; i2 < oneL24OverKP1.length; ++i2) {
            ModularChannel.oneL24OverKP1[i2] = 0x1000000 / (i2 + 1);
        }
    }
}

