/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.IntXL;
import java.io.IOException;
import java.util.Arrays;

final class MathXL {
    static final float SQRT_2 = (float)StrictMath.sqrt(2.0);
    static final float SQRT_H = (float)StrictMath.sqrt(0.5);
    static final float SQRT_F = (float)StrictMath.sqrt(0.125);
    static final float PHI_BAR = (float)(StrictMath.sqrt(5.0) * 0.5 - 0.5);
    private static final float[][][] COSINES = new float[9][][];

    private MathXL() {
    }

    static int mirror(int coord, int size) {
        if (coord < 0) {
            return MathXL.mirror(~coord, size);
        }
        if (coord < size) {
            return coord;
        }
        return MathXL.mirror((size << 1) + ~coord, size);
    }

    static int ceilLog1p(long x2) {
        return 64 - Long.numberOfLeadingZeros(x2);
    }

    static int ceilLog2(long x2) {
        return MathXL.ceilLog1p(x2 - 1L);
    }

    static int ceilDiv(int n2, int d2) {
        return (n2 - 1) / d2 + 1;
    }

    static int floorLog1p(long x2) {
        int c2 = MathXL.ceilLog1p(x2);
        if ((x2 + 1L & x2) != 0L) {
            return c2 - 1;
        }
        return c2;
    }

    static float max(float ... a10) {
        float result = a10[0];
        for (int i2 = 1; i2 < a10.length; ++i2) {
            result = Math.min(a10[i2], result);
        }
        return result;
    }

    static float signedPow(float base) {
        return (float)(base < 0.0f ? -Math.pow(-base, 0.3333333432674408) : Math.pow(base, 0.3333333432674408));
    }

    static int clamp(int v2, int a10, int b2, int c2) {
        int lower = Math.min(a10, b2);
        int upper = lower ^ a10 ^ b2;
        lower = Math.min(lower, c2);
        upper = Math.max(upper, c2);
        return v2 < lower ? lower : Math.min(v2, upper);
    }

    static int clamp(int v2, int a10, int b2) {
        int lower = Math.min(a10, b2);
        int upper = lower ^ a10 ^ b2;
        return v2 < lower ? lower : Math.min(v2, upper);
    }

    static float clamp(float v2, float a10, float b2) {
        float lower = Math.min(a10, b2);
        float upper = Math.max(a10, b2);
        return v2 < lower ? lower : Math.min(v2, upper);
    }

    static int unpackSigned(int value) {
        return (value & 1) == 0 ? value >>> 1 : ~value >>> 1 | Integer.MIN_VALUE;
    }

    static int round(float d2) {
        return (int)(d2 + 0.5f);
    }

    static float erf(float z2) {
        float absErf;
        float az2 = Math.abs(z2);
        if (az2 > 1.0E-4f) {
            float t2 = 1.0f / (az2 * 0.5f + 1.0f);
            float u2 = t2 * (t2 * (t2 * (t2 * (t2 * (t2 * (t2 * (t2 * (t2 * 0.17087276f - 0.82215226f) + 1.4885159f) - 1.135204f) + 0.27886808f) - 0.18628806f) + 0.09678418f) + 0.37409195f) + 1.0000237f) - 1.2655122f;
            absErf = 1.0f - t2 * (float)Math.exp(-z2 * z2 + u2);
        } else {
            float t3 = 1.0f / (az2 * 0.47047f + 1.0f);
            float u3 = t3 * (t3 * (t3 * 0.7478556f - 0.0958798f) + 0.3480242f);
            absErf = 1.0f - u3 * (float)Math.exp(-z2 * z2);
        }
        if (z2 < 0.0f) {
            return -absErf;
        }
        return absErf;
    }

    static void inverseDCTHorizontal(float[][] src, int yIn, int xStartIn, float[][] dest, int yOut, int xStartOut, int xLogLength, int xLength) {
        float[] d2 = dest[yOut];
        float[] s2 = src[yIn];
        Arrays.fill(d2, xStartOut, xStartOut + xLength, s2[xStartIn]);
        for (int n2 = 1; n2 < xLength; ++n2) {
            float[] lut = COSINES[xLogLength][n2 - 1];
            float s22 = s2[xStartIn + n2];
            for (int k2 = 0; k2 < xLength; ++k2) {
                int n3 = xStartOut + k2;
                d2[n3] = d2[n3] + s22 * lut[k2];
            }
        }
    }

    static void forwardDCTHorizontal(float[][] src, int yIn, int xStartIn, float[][] dest, int yOut, int xStartOut, int xLogLength, int xLength) {
        float invLength = 1.0f / (float)xLength;
        float[] d2 = dest[yOut];
        float[] s2 = src[yIn];
        float d22 = 0.0f;
        for (int x2 = 0; x2 < xLength; ++x2) {
            d22 += s2[xStartIn + x2];
        }
        d2[xStartOut] = d22 * invLength;
        for (int k2 = 1; k2 < xLength; ++k2) {
            d22 = 0.0f;
            float[] lut = COSINES[xLogLength][k2 - 1];
            for (int n2 = 0; n2 < xLength; ++n2) {
                d22 += s2[xStartIn + n2] * lut[n2];
            }
            d2[xStartOut + k2] = d22 * invLength;
        }
    }

    static void inverseDCT2D(float[][] src, float[][] dest, IntXL startIn, IntXL startOut, IntXL length, float[][] scratchSpace1, float[][] scratchSpace2, boolean transposed) {
        int y2;
        int xLogLength = MathXL.ceilLog2(length.x);
        int yLogLength = MathXL.ceilLog2(length.y);
        for (y2 = 0; y2 < length.y; ++y2) {
            MathXL.inverseDCTHorizontal(src, y2 + startIn.y, startIn.x, scratchSpace1, y2, 0, xLogLength, length.x);
        }
        MathXL.mmTransposeTo(scratchSpace1, scratchSpace2, IntXL.ZERO, IntXL.ZERO, length);
        if (transposed) {
            for (y2 = 0; y2 < length.x; ++y2) {
                MathXL.inverseDCTHorizontal(scratchSpace2, y2, 0, dest, startOut.y + y2, startOut.x, yLogLength, length.y);
            }
        } else {
            for (int x2 = 0; x2 < length.x; ++x2) {
                MathXL.inverseDCTHorizontal(scratchSpace2, x2, 0, scratchSpace1, x2, 0, yLogLength, length.y);
            }
            MathXL.mmTransposeTo(scratchSpace1, dest, IntXL.ZERO, startOut, length.transpose());
        }
    }

    static void forwardDCT2D(float[][] src, float[][] dest, IntXL startIn, IntXL startOut, IntXL length, float[][] scratchSpace1, float[][] scratchSpace2) {
        int xLogLength = MathXL.ceilLog2(length.x);
        int yLogLength = MathXL.ceilLog2(length.y);
        for (int y2 = 0; y2 < length.y; ++y2) {
            MathXL.forwardDCTHorizontal(src, y2 + startIn.y, startIn.x, scratchSpace1, y2, 0, xLogLength, length.x);
        }
        MathXL.mmTransposeTo(scratchSpace1, scratchSpace2, IntXL.ZERO, IntXL.ZERO, length);
        for (int x2 = 0; x2 < length.x; ++x2) {
            MathXL.forwardDCTHorizontal(scratchSpace2, x2, 0, scratchSpace1, x2, 0, yLogLength, length.y);
        }
        MathXL.mmTransposeTo(scratchSpace1, dest, IntXL.ZERO, startOut, length.transpose());
    }

    static void mmTransposeTo(float[][] src, float[][] dest, IntXL srcStart, IntXL destStart, IntXL srcSize) {
        for (int y2 = 0; y2 < srcSize.y; ++y2) {
            float[] srcy = src[srcStart.y + y2];
            for (int x2 = 0; x2 < srcSize.x; ++x2) {
                dest[destStart.y + x2][destStart.x + y2] = srcy[srcStart.x + x2];
            }
        }
    }

    static float[][] mmTranspose(float[][] matrix, IntXL inSize) {
        float[][] dest = new float[inSize.x][inSize.y];
        MathXL.mmTransposeTo(matrix, dest, IntXL.ZERO, IntXL.ZERO, inSize);
        return dest;
    }

    static float[] mmMutliply(float[][] mm, float[] vector) {
        if (mm == null) {
            return vector;
        }
        int extra = vector.length - mm[0].length;
        float[] total = new float[mm.length + extra];
        for (int y2 = 0; y2 < mm.length; ++y2) {
            float[] row = mm[y2];
            for (int x2 = 0; x2 < row.length; ++x2) {
                int n2 = y2;
                total[n2] = total[n2] + row[x2] * vector[x2];
            }
        }
        if (extra != 0) {
            System.arraycopy(vector, vector.length - extra, total, total.length - extra, extra);
        }
        return total;
    }

    static float[] mmMutliply(float[] vector, float[][] mm) {
        if (mm == null) {
            return vector;
        }
        float[] total = new float[mm[0].length];
        for (int y2 = 0; y2 < vector.length; ++y2) {
            float[] row = mm[y2];
            for (int x2 = 0; x2 < total.length; ++x2) {
                int n2 = x2;
                total[n2] = total[n2] + vector[y2] * row[x2];
            }
        }
        return total;
    }

    static float[][] mmMutliply(float[][] left, float[][] right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        float[][] result = new float[left.length][right[0].length];
        for (int y2 = 0; y2 < right.length; ++y2) {
            result[y2] = MathXL.mmMutliply(left[y2], right);
        }
        return result;
    }

    static float[][] mmIdentity(int n2) {
        float[][] identity = new float[n2][n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            identity[i2][i2] = 1.0f;
        }
        return identity;
    }

    static float[][] mmMutliply(float[][] a10, float[][] b2, float[][] c2) {
        return MathXL.mmMutliply(MathXL.mmMutliply(a10, b2), c2);
    }

    static float[][] mmInverse3x3(float[][] mm) {
        if (mm == null) {
            return null;
        }
        float det = 0.0f;
        for (int c2 = 0; c2 < 3; ++c2) {
            int c1 = (c2 + 1) % 3;
            int c22 = (c2 + 2) % 3;
            det += mm[c2][0] * mm[c1][1] * mm[c22][2] - mm[c2][0] * mm[c1][2] * mm[c22][1];
        }
        if (det == 0.0f) {
            return null;
        }
        float invDet = 1.0f / det;
        float[][] result = new float[3][3];
        for (int x2 = 0; x2 < 3; ++x2) {
            for (int y2 = 0; y2 < 3; ++y2) {
                int x1 = (x2 + 1) % 3;
                int x22 = (x2 + 2) % 3;
                int y1 = (y2 + 1) % 3;
                int y22 = (y2 + 2) % 3;
                result[y2][x2] = (mm[x1][y1] * mm[x22][y22] - mm[x22][y1] * mm[x1][y22]) * invDet;
            }
        }
        return result;
    }

    static float float16To32(int bits16) {
        int mantissa = bits16 & 0x3FF;
        int exp = bits16 >>> 10 & 0x1F;
        int sign = bits16 >>> 15 & 1;
        if (exp == 31) {
            return Float.NaN;
        }
        if (exp == 0) {
            return (float)((1 - 2 * sign) * mantissa) / 1.6777216E7f;
        }
        int total = (sign <<= 31) | (exp += 112) << 23 | (mantissa <<= 13);
        return Float.intBitsToFloat(total);
    }

    static float[][][] mmCopy(float[][][] array) {
        if (array == null) {
            return null;
        }
        float[][][] copy = new float[array.length][][];
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] == null) continue;
            copy[i2] = new float[array[i2].length][];
            for (int j2 = 0; j2 < array[i2].length; ++j2) {
                if (array[i2][j2] == null) continue;
                copy[i2][j2] = Arrays.copyOf(array[i2][j2], array[i2][j2].length);
            }
        }
        return copy;
    }

    static void skipExtensions(BitXL reader) throws IOException {
        int i2;
        long extensionsKey = reader.u64();
        int[] payLen = new int[64];
        for (i2 = 0; i2 < 64; ++i2) {
            if ((1L << i2 & extensionsKey) == 0L) continue;
            long length = reader.u64();
            payLen[i2] = (int)length;
        }
        for (i2 = 0; i2 < 64; ++i2) {
            if (payLen[i2] == 0) continue;
            for (int j2 = 0; j2 < payLen[i2]; ++j2) {
                reader.u(8);
            }
        }
    }

    static {
        double root2 = StrictMath.sqrt(2.0);
        for (int l2 = 0; l2 < COSINES.length; ++l2) {
            int s2 = 1 << l2;
            MathXL.COSINES[l2] = new float[s2 - 1][s2];
            for (int n2 = 0; n2 < COSINES[l2].length; ++n2) {
                for (int k2 = 0; k2 < COSINES[l2][n2].length; ++k2) {
                    MathXL.COSINES[l2][n2][k2] = (float)(root2 * StrictMath.cos(Math.PI * (double)(n2 + 1) * ((double)k2 + 0.5) / (double)s2));
                }
            }
        }
    }
}

