/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.Frame;
import com.idrsolutions.image.jpegXL.data.HFBlock;
import com.idrsolutions.image.jpegXL.data.HeaderFrame;
import com.idrsolutions.image.jpegXL.data.IntXL;
import com.idrsolutions.image.jpegXL.data.LFChannel;
import com.idrsolutions.image.jpegXL.data.LFGroup;
import com.idrsolutions.image.jpegXL.data.ModularInfo;
import com.idrsolutions.image.jpegXL.data.ModularStream;
import java.io.IOException;
import java.util.Arrays;

class LFCoeff {
    final float[][][] dequantLFCoeff;
    final int[][] lfIndex;
    final Frame frame;

    LFCoeff(BitXL reader, LFGroup parent, Frame frame, float[][][] lfBuffer) throws IOException {
        this.frame = frame;
        this.lfIndex = new int[parent.size.y][parent.size.x];
        IntXL sizeInPixels = frame.getLFGroupSize(parent.lfGroupID);
        IntXL pixelPos = frame.getLFGroupXY(parent.lfGroupID).toLeft(11);
        IntXL blockPos = pixelPos.toRight(3);
        IntXL sizeInBlocks = sizeInPixels.toRight(3);
        HeaderFrame header = frame.getFrameHeader();
        boolean adaptiveSmoothing = (header.flags & 0xA0L) == 0L;
        IntXL[] shift = header.jpegUpsampling;
        ModularInfo[] info = new ModularInfo[3];
        float[][][] dequantLFCoeff = new float[3][][];
        for (int i2 = 0; i2 < 3; ++i2) {
            IntXL channelSize = sizeInBlocks.toRight(shift[i2]);
            info[Frame.cMap[i2]] = new ModularInfo(channelSize.x, channelSize.y, shift[i2].x, shift[i2].y);
            dequantLFCoeff[i2] = new float[channelSize.y][channelSize.x];
        }
        if ((frame.getFrameHeader().flags & 0x20L) != 0L) {
            this.dequantLFCoeff = dequantLFCoeff;
            for (int c2 = 0; c2 < 3; ++c2) {
                for (int y2 = 0; y2 < sizeInBlocks.y; ++y2) {
                    System.arraycopy(lfBuffer[c2][y2 + blockPos.y], blockPos.x, dequantLFCoeff[c2][y2], 0, sizeInBlocks.x);
                }
            }
            this.populateLFIndex(parent, null);
            return;
        }
        int extraPrecision = reader.u(2);
        ModularStream lfQuantStream = new ModularStream(reader, frame, 1 + parent.lfGroupID, info);
        lfQuantStream.decodeChannels(reader);
        int[][][] lfQuant = lfQuantStream.getDecodedBuffer();
        float[] scaledDequant = frame.getLFGlobal().quantizer.scaledDequant;
        for (int i3 = 0; i3 < 3; ++i3) {
            int c3 = Frame.cMap[i3];
            float sd = scaledDequant[i3] / (float)(1 << extraPrecision);
            for (int y3 = 0; y3 < lfQuant[c3].length; ++y3) {
                float[] dq = dequantLFCoeff[i3][y3];
                int[] q2 = lfQuant[c3][y3];
                for (int x2 = 0; x2 < lfQuant[c3][y3].length; ++x2) {
                    dq[x2] = (float)q2[x2] * sd;
                }
            }
        }
        if (shift[0].x + shift[1].x + shift[2].x + shift[0].y + shift[1].y + shift[2].y == 0) {
            LFChannel lfc = frame.getLFGlobal().lfChanCorr;
            float kX = lfc.baseX + ((float)lfc.x - 128.0f) / (float)lfc.factor;
            float kB = lfc.baseB + ((float)lfc.b - 128.0f) / (float)lfc.factor;
            float[][] dqLFY = dequantLFCoeff[1];
            float[][] dqLFX = dequantLFCoeff[0];
            float[][] dqLFB = dequantLFCoeff[2];
            for (int y4 = 0; y4 < dqLFY.length; ++y4) {
                float[] dqLFYy = dqLFY[y4];
                float[] dqLFXy = dqLFX[y4];
                float[] dqLFBy = dqLFB[y4];
                for (int x3 = 0; x3 < dqLFYy.length; ++x3) {
                    int n2 = x3;
                    dqLFXy[n2] = dqLFXy[n2] + kX * dqLFYy[x3];
                    int n3 = x3;
                    dqLFBy[n3] = dqLFBy[n3] + kB * dqLFYy[x3];
                }
            }
        }
        this.dequantLFCoeff = adaptiveSmoothing ? LFCoeff.adaptiveSmooth(dequantLFCoeff, scaledDequant) : (float[][][])dequantLFCoeff;
        this.populateLFIndex(parent, lfQuant);
    }

    private void populateLFIndex(LFGroup parent, int[][][] lfQuant) {
        HFBlock hfctx = this.frame.getLFGlobal().hfBlockCtx;
        for (int y2 = 0; y2 < parent.size.y; ++y2) {
            int[] lfi = this.lfIndex[y2];
            for (int x2 = 0; x2 < parent.size.x; ++x2) {
                lfi[x2] = LFCoeff.getLFIndex(lfQuant, hfctx, new IntXL(x2, y2), this.frame.getFrameHeader().jpegUpsampling);
            }
        }
    }

    private static float[][][] adaptiveSmooth(float[][][] coeff, float[] scaledDequant) {
        int x2;
        float[] gy;
        float[][][] weighted = new float[3][][];
        float[][] gap = new float[coeff[0].length][];
        float[][][] dequantLFCoeff = new float[3][][];
        for (int i2 = 0; i2 < 3; ++i2) {
            float[][] co = coeff[i2];
            weighted[i2] = new float[co.length][];
            float sd = scaledDequant[i2];
            for (int y2 = 1; y2 < co.length - 1; ++y2) {
                float[] coy = co[y2];
                float[] coym = co[y2 - 1];
                float[] coyp = co[y2 + 1];
                if (gap[y2] == null) {
                    gap[y2] = new float[coy.length];
                    Arrays.fill(gap[y2], 0.5f);
                }
                gy = gap[y2];
                weighted[i2][y2] = new float[coy.length];
                float[] wy = weighted[i2][y2];
                for (x2 = 1; x2 < coy.length - 1; ++x2) {
                    float sample = coy[x2];
                    float adjacent = coy[x2 - 1] + coy[x2 + 1] + coym[x2] + coyp[x2];
                    float diag = coym[x2 - 1] + coym[x2 + 1] + coyp[x2 - 1] + coyp[x2 + 1];
                    wy[x2] = 0.052262735f * sample + 0.2034514f * adjacent + 0.03348292f * diag;
                    float g2 = Math.abs(sample - wy[x2]) * sd;
                    if (!(g2 > gy[x2])) continue;
                    gy[x2] = g2;
                }
            }
        }
        for (float[] gap1 : gap) {
            if (gap1 == null) continue;
            float[] gy2 = gap1;
            for (int x3 = 0; x3 < gy2.length; ++x3) {
                gy2[x3] = Math.max(0.0f, 3.0f - 4.0f * gy2[x3]);
            }
        }
        for (int i3 = 0; i3 < 3; ++i3) {
            float[][] co = coeff[i3];
            dequantLFCoeff[i3] = new float[co.length][];
            float[][] dqi = dequantLFCoeff[i3];
            float[][] wi = weighted[i3];
            for (int y3 = 0; y3 < co.length; ++y3) {
                float[] coy = co[y3];
                dqi[y3] = new float[coy.length];
                float[] dqy = dqi[y3];
                gy = gap[y3];
                float[] wiy = wi[y3];
                if (y3 == 0 || y3 + 1 == co.length) {
                    System.arraycopy(coy, 0, dqy, 0, coy.length);
                    continue;
                }
                for (x2 = 0; x2 < coy.length; ++x2) {
                    dqy[x2] = x2 == 0 || x2 + 1 == coy.length ? coy[x2] : (coy[x2] - wiy[x2]) * gy[x2] + wiy[x2];
                }
            }
        }
        return dequantLFCoeff;
    }

    private static int getLFIndex(int[][][] lfQuant, HFBlock hfctx, IntXL blockPos, IntXL[] upsampling) {
        int[] index = new int[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            int[] hft;
            IntXL shifted = blockPos.toRight(upsampling[i2]);
            for (int k2 : hft = hfctx.lfThresholds[i2]) {
                if (lfQuant[Frame.cMap[i2]][shifted.y][shifted.x] <= k2) continue;
                int n2 = i2;
                index[n2] = index[n2] + 1;
            }
        }
        int idx = index[0];
        idx *= hfctx.lfThresholds[2].length + 1;
        idx += index[2];
        idx *= hfctx.lfThresholds[1].length + 1;
        return idx += index[1];
    }
}

