/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

class JXLXor {
    private final long[] state0 = new long[8];
    private final long[] state1 = new long[8];
    private final long[] batch = new long[8];
    private int batchPos;

    private static long splitMix64(long z2) {
        z2 = (z2 ^ z2 >>> 30) * -4658895280553007687L;
        z2 = (z2 ^ z2 >>> 27) * -7723592293110705685L;
        return z2 ^ z2 >>> 31;
    }

    JXLXor(long s0, long s1) {
        this.state0[0] = JXLXor.splitMix64(s0 + -7046029254386353131L);
        this.state1[0] = JXLXor.splitMix64(s1 + -7046029254386353131L);
        for (int i2 = 1; i2 < 8; ++i2) {
            this.state0[i2] = JXLXor.splitMix64(this.state0[i2 - 1]);
            this.state1[i2] = JXLXor.splitMix64(this.state1[i2 - 1]);
        }
    }

    long nextLong() {
        this.fillBatch();
        return this.batch[this.batchPos++];
    }

    void fill(int[] bits) {
        for (int i2 = 0; i2 < bits.length; i2 += 2) {
            long l2 = this.nextLong();
            bits[i2] = (int)(l2 & 0xFFFFFFFFL);
            bits[i2 + 1] = (int)(l2 >>> 32 & 0xFFFFFFFFL);
        }
    }

    private void fillBatch() {
        if (this.batchPos < this.batch.length) {
            return;
        }
        for (int i2 = 0; i2 < this.batch.length; ++i2) {
            long a10 = this.state1[i2];
            long b2 = this.state0[i2];
            this.batch[i2] = a10 + b2;
            this.state0[i2] = a10;
            b2 ^= b2 << 23;
            this.state1[i2] = b2 ^ a10 ^ b2 >>> 18 ^ a10 >>> 5;
        }
        this.batchPos = 0;
    }
}

