/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.CIERGB;
import com.idrsolutions.image.jpegXL.data.CIEXY;
import com.idrsolutions.image.jpegXL.data.ColorUtil;
import com.idrsolutions.image.jpegXL.data.MathXL;
import java.io.IOException;

class Inverse {
    private static final float[][] DEFAULT_MATRIX = new float[][]{{11.031567f, -9.866944f, -0.16462299f}, {-3.2541473f, 4.4187703f, -0.16462299f}, {-3.6588514f, 2.712923f, 1.9459282f}};
    private static final float[] DEFAULT_OPSIN_BIAS = new float[]{-0.0037930734f, -0.0037930734f, -0.0037930734f};
    private static final float[] DEFAULT_QUANT_BIAS = new float[]{0.94534993f, 0.92994547f, 0.9500649f};
    private static final float DEFAULT_QBIAS_NUMERATOR = 0.145f;
    private final float[][] matrix;
    private final float[] opsinBias;
    private float[] cbrtOpsinBias;
    final float[] quantBias;
    final float quantBiasNumerator;
    final CIERGB primaries;
    final CIEXY whitePoint;

    Inverse() {
        this(ColorUtil.PRI_SRGB, ColorUtil.WP_D65, DEFAULT_MATRIX, DEFAULT_OPSIN_BIAS, DEFAULT_QUANT_BIAS, 0.145f);
    }

    private Inverse(CIERGB primaries, CIEXY whitePoint, float[][] matrix, float[] opsinBias, float[] quantBias, float quantBiasNumerator) {
        this.matrix = matrix;
        this.opsinBias = opsinBias;
        this.quantBias = quantBias;
        this.quantBiasNumerator = quantBiasNumerator;
        this.primaries = primaries;
        this.whitePoint = whitePoint;
        this.bakeCbrtBias();
    }

    Inverse(BitXL reader) throws IOException {
        if (reader.bool()) {
            this.matrix = DEFAULT_MATRIX;
            this.opsinBias = DEFAULT_OPSIN_BIAS;
            this.quantBias = DEFAULT_QUANT_BIAS;
            this.quantBiasNumerator = 0.145f;
        } else {
            int i2;
            this.matrix = new float[3][3];
            for (i2 = 0; i2 < 3; ++i2) {
                for (int j2 = 0; j2 < 3; ++j2) {
                    this.matrix[i2][j2] = reader.f16();
                }
            }
            this.opsinBias = new float[3];
            for (i2 = 0; i2 < 3; ++i2) {
                this.opsinBias[i2] = reader.f16();
            }
            this.quantBias = new float[3];
            for (i2 = 0; i2 < 3; ++i2) {
                this.quantBias[i2] = reader.f16();
            }
            this.quantBiasNumerator = reader.f16();
        }
        this.primaries = ColorUtil.PRI_SRGB;
        this.whitePoint = ColorUtil.WP_D65;
        this.bakeCbrtBias();
    }

    private void bakeCbrtBias() {
        this.cbrtOpsinBias = new float[3];
        for (int c2 = 0; c2 < 3; ++c2) {
            this.cbrtOpsinBias[c2] = MathXL.signedPow(this.opsinBias[c2]);
        }
    }

    Inverse getMatrix(CIERGB primaries, CIEXY whitePoint) {
        float[][] conversion = ColorUtil.getConversionMatrix(primaries, whitePoint, this.primaries, this.whitePoint);
        float[][] mm = MathXL.mmMutliply(conversion, this.matrix);
        return new Inverse(primaries, whitePoint, mm, this.opsinBias, this.quantBias, this.quantBiasNumerator);
    }

    void invertXYB(float[][][] buffer, float intensity) {
        float itScale = 255.0f / intensity;
        for (int y2 = 0; y2 < buffer[0].length; ++y2) {
            float[] b0 = buffer[0][y2];
            float[] b1 = buffer[1][y2];
            float[] b2 = buffer[2][y2];
            for (int x2 = 0; x2 < b0.length; ++x2) {
                float gL = b1[x2] + b0[x2] - this.cbrtOpsinBias[0];
                float gM = b1[x2] - b0[x2] - this.cbrtOpsinBias[1];
                float gS = b2[x2] - this.cbrtOpsinBias[2];
                float mixL = gL * gL * gL + this.opsinBias[0];
                float mixM = gM * gM * gM + this.opsinBias[1];
                float mixS = gS * gS * gS + this.opsinBias[2];
                b0[x2] = (this.matrix[0][0] * mixL + this.matrix[0][1] * mixM + this.matrix[0][2] * mixS) * itScale;
                b1[x2] = (this.matrix[1][0] * mixL + this.matrix[1][1] * mixM + this.matrix[1][2] * mixS) * itScale;
                b2[x2] = (this.matrix[2][0] * mixL + this.matrix[2][1] * mixM + this.matrix[2][2] * mixS) * itScale;
            }
        }
    }
}

