/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.MathXL;

class IntXL {
    final int x;
    final int y;
    static final IntXL ZERO = new IntXL();

    static IntXL coordinates(int index, int rowStride) {
        return new IntXL(index % rowStride, index / rowStride);
    }

    static IntXL sizeOf(float[][] array) {
        return array.length == 0 ? new IntXL() : new IntXL(array[0].length, array.length);
    }

    IntXL(int x2, int y2) {
        this.x = x2;
        this.y = y2;
    }

    IntXL(int dim) {
        this(dim, dim);
    }

    IntXL(IntXL p2) {
        this(p2.x, p2.y);
    }

    IntXL() {
        this(0, 0);
    }

    IntXL plus(IntXL p2) {
        return new IntXL(this.x + p2.x, this.y + p2.y);
    }

    IntXL minus(IntXL p2) {
        return new IntXL(this.x - p2.x, this.y - p2.y);
    }

    IntXL times(IntXL p2) {
        return new IntXL(this.x * p2.x, this.y * p2.y);
    }

    IntXL times(int factor) {
        return new IntXL(this.x * factor, this.y * factor);
    }

    IntXL ceilDiv(int factor) {
        return new IntXL(MathXL.ceilDiv(this.x, factor), MathXL.ceilDiv(this.y, factor));
    }

    IntXL transpose() {
        return new IntXL(this.y, this.x);
    }

    IntXL toLeft(int hshift, int vshift) {
        int x2 = this.x << hshift;
        int y2 = this.y << vshift;
        return new IntXL(x2, y2);
    }

    IntXL toLeft(int shift) {
        return this.toLeft(shift, shift);
    }

    IntXL toRight(int hshift, int vshift) {
        int x2 = this.x >> hshift;
        int y2 = this.y >> vshift;
        return new IntXL(x2, y2);
    }

    IntXL toRight(int shift) {
        return this.toRight(shift, shift);
    }

    IntXL toRight(IntXL shift) {
        return this.toRight(shift.x, shift.y);
    }

    int unwrapCoord(int rowStride) {
        return this.y * rowStride + this.x;
    }

    IntXL min(IntXL p2) {
        return new IntXL(Math.min(this.x, p2.x), Math.min(this.y, p2.y));
    }

    IntXL max(IntXL p2) {
        return new IntXL(Math.max(this.x, p2.x), Math.max(this.y, p2.y));
    }
}

