/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.CIERGB;
import com.idrsolutions.image.jpegXL.data.CIEXY;
import com.idrsolutions.image.jpegXL.data.ColorSpaceXL;
import com.idrsolutions.image.jpegXL.data.ColorUtil;
import com.idrsolutions.image.jpegXL.data.ColorXL;
import com.idrsolutions.image.jpegXL.data.HeaderImage;
import com.idrsolutions.image.jpegXL.data.MathXL;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.function.DoubleUnaryOperator;

public class ImageXL {
    private DataBufferFloat buffer;
    private WritableRaster raster;
    private SampleModel sampleModel;
    private final HeaderImage imageHeader;
    private int colorEncoding;
    private final int alphaIndex;
    int primaries;
    int whitePoint;
    int transfer;
    int taggedTransfer;
    private CIEXY white1931;
    private CIERGB primaries1931;
    private final byte[] iccProfile;
    int width;
    int height;
    private final boolean alphaIsPremultiplied;

    ImageXL(float[][][] buffer, HeaderImage header) throws IOException {
        this.width = buffer[0][0].length;
        this.height = buffer[0].length;
        int channels = header.getColorChannelCount() + (header.hasAlpha() ? 1 : 0);
        float[][] dataArray = new float[channels][this.width * this.height];
        for (int c2 = 0; c2 < channels; ++c2) {
            for (int y2 = 0; y2 < this.height; ++y2) {
                System.arraycopy(buffer[c2][y2], 0, dataArray[c2], y2 * this.width, this.width);
            }
        }
        this.buffer = new DataBufferFloat(dataArray, this.width * this.height);
        this.sampleModel = new BandedSampleModel(4, this.width, this.height, dataArray.length);
        this.raster = Raster.createWritableRaster(this.sampleModel, this.buffer, new Point());
        ColorXL bundle = header.getColorEncoding();
        this.colorEncoding = bundle.colorEncoding;
        this.alphaIndex = header.hasAlpha() ? header.getAlphaIndex(0) : -1;
        this.imageHeader = header;
        this.primaries = bundle.primaries;
        this.whitePoint = bundle.whitePoint;
        this.primaries1931 = bundle.prim;
        this.white1931 = bundle.white;
        if (this.imageHeader.isXYBEncoded()) {
            this.transfer = 0x1000008;
            this.iccProfile = null;
        } else {
            this.transfer = bundle.tf;
            this.iccProfile = header.getDecodedICC();
        }
        this.taggedTransfer = bundle.tf;
        this.alphaIsPremultiplied = this.hasAlpha() && this.imageHeader.getExtraChannel((int)this.alphaIndex).alphaAssociated;
    }

    private ImageXL(ImageXL image, boolean copyBuffer) {
        this.sampleModel = image.sampleModel;
        this.imageHeader = image.imageHeader;
        this.colorEncoding = image.colorEncoding;
        this.alphaIndex = image.alphaIndex;
        this.primaries = image.primaries;
        this.whitePoint = image.whitePoint;
        this.transfer = image.transfer;
        this.taggedTransfer = image.taggedTransfer;
        this.white1931 = image.white1931;
        this.primaries1931 = image.primaries1931;
        this.iccProfile = image.iccProfile;
        this.width = image.width;
        this.height = image.height;
        this.alphaIsPremultiplied = image.alphaIsPremultiplied;
        if (copyBuffer) {
            float[][] dataBuffer = image.buffer.getBankData();
            float[][] buf = new float[dataBuffer.length][this.width * this.height];
            for (int c2 = 0; c2 < buf.length; ++c2) {
                System.arraycopy(dataBuffer[c2], 0, buf[c2], 0, dataBuffer[c2].length);
            }
            this.buffer = new DataBufferFloat(buf, buf[0].length);
            this.raster = Raster.createWritableRaster(this.sampleModel, this.buffer, new Point());
        }
    }

    ImageXL(ImageXL image) {
        this(image, true);
    }

    private ColorSpace getColorSpace() {
        ColorSpace cs = this.hasICCProfile() ? new ICC_ColorSpace(ICC_Profile.getInstance(this.iccProfile)) : new ColorSpaceXL(this.primaries1931, this.white1931, this.transfer, this.imageHeader.getColorChannelCount());
        return cs;
    }

    public BufferedImage asBufferedImage() {
        BufferedImage image;
        ColorSpace cs = this.getColorSpace();
        if (cs.getNumComponents() == 1) {
            image = new BufferedImage(this.width, this.height, 10);
            byte[] pixelsByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            float[] frgb = new float[]{};
            int p2 = 0;
            float[][] dataBuffer = this.buffer.getBankData();
            for (int y2 = 0; y2 < this.height; ++y2) {
                int yw = y2 * this.width;
                for (int x2 = 0; x2 < this.width; ++x2) {
                    frgb[0] = dataBuffer[0][yw + x2];
                    float[] srgb = cs.toRGB(frgb);
                    pixelsByte[p2++] = (byte)(srgb[0] * 255.0f);
                }
            }
        } else {
            image = new BufferedImage(this.width, this.height, 5);
            byte[] pixelsByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            float[] fRGB = new float[3];
            int p3 = 0;
            float[][] dataBuffer = this.buffer.getBankData();
            for (int y3 = 0; y3 < this.height; ++y3) {
                int yw = y3 * this.width;
                for (int x3 = 0; x3 < this.width; ++x3) {
                    fRGB[0] = dataBuffer[0][yw + x3];
                    fRGB[1] = dataBuffer[1][yw + x3];
                    fRGB[2] = dataBuffer[2][yw + x3];
                    float[] srgb = cs.toRGB(fRGB);
                    pixelsByte[p3++] = (byte)(srgb[2] * 255.0f);
                    pixelsByte[p3++] = (byte)(srgb[1] * 255.0f);
                    pixelsByte[p3++] = (byte)(srgb[0] * 255.0f);
                }
            }
        }
        return image;
    }

    private ImageXL toneMapLinear() {
        if (CIERGB.matches(this.primaries1931, null) && CIEXY.matches(this.white1931, null)) {
            return this;
        }
        float[][] conversionMatrix = ColorUtil.getConversionMatrix(null, null, this.primaries1931, this.white1931);
        ImageXL image = new ImageXL(this, false);
        image.buffer = new DataBufferFloat(this.buffer.getSize(), this.buffer.getNumBanks());
        image.raster = Raster.createWritableRaster(image.sampleModel, image.buffer, new Point());
        float[] rgb = this.raster.getPixel(0, 0, (float[])null);
        for (int py = 0; py < this.height; ++py) {
            for (int px = 0; px < this.width; ++px) {
                this.raster.getPixel(px, py, rgb);
                image.raster.setPixel(px, py, MathXL.mmMutliply(conversionMatrix, rgb));
            }
        }
        image.primaries1931 = null;
        image.white1931 = null;
        image.primaries = ColorUtil.getCIERGBType(null);
        image.whitePoint = ColorUtil.getWhitePoint(null);
        return image;
    }

    ImageXL fillColor() {
        if (this.colorEncoding != 1) {
            return this;
        }
        float[][] dataArray = new float[this.buffer.getNumBanks() + 2][this.buffer.getSize()];
        float[][] src = this.buffer.getBankData();
        for (int c2 = 0; c2 < dataArray.length; ++c2) {
            int cIn = c2 > 2 ? c2 - 2 : 0;
            System.arraycopy(src[cIn], 0, dataArray[c2], 0, this.buffer.getSize());
        }
        ImageXL image = new ImageXL(this, false);
        image.buffer = new DataBufferFloat(dataArray, this.buffer.getSize());
        image.sampleModel = new BandedSampleModel(4, image.width, image.height, dataArray.length);
        image.raster = Raster.createWritableRaster(image.sampleModel, image.buffer, new Point());
        image.colorEncoding = 0;
        return image;
    }

    ImageXL transform() {
        ImageXL image = this;
        if (CIERGB.matches(null, this.primaries1931) && CIEXY.matches(null, this.white1931)) {
            return image.transfer();
        }
        return image.linearize().fillColor().toneMapLinear().transfer();
    }

    private float determinePeak() {
        return MathXL.max(this.transform().buffer.getData(1));
    }

    private ImageXL transfer(DoubleUnaryOperator op) {
        ImageXL image = new ImageXL(this);
        for (int c2 = 0; c2 < this.imageHeader.getColorChannelCount(); ++c2) {
            for (int y2 = 0; y2 < this.height; ++y2) {
                for (int x2 = 0; x2 < this.width; ++x2) {
                    image.raster.setSample(x2, y2, c2, op.applyAsDouble(this.raster.getSampleFloat(x2, y2, c2)));
                }
            }
        }
        return image;
    }

    private ImageXL linearize() {
        if (this.transfer == 0x1000008) {
            return this;
        }
        DoubleUnaryOperator inverse = ColorUtil.getInverseTransfer(this.transfer);
        ImageXL image = this.transfer(inverse);
        image.transfer = 0x1000008;
        return image;
    }

    ImageXL transfer() {
        if (0x1000008 == this.transfer) {
            return this;
        }
        ImageXL image = this.linearize();
        if (this.taggedTransfer == 0x1000010) {
            // empty if block
        }
        DoubleUnaryOperator forward = ColorUtil.getTransferFunction(0x1000008);
        image = image.transfer(forward);
        image.transfer = 0x1000008;
        return image;
    }

    final boolean hasAlpha() {
        return this.alphaIndex >= 0;
    }

    boolean hasICCProfile() {
        return this.iccProfile != null;
    }

    private static /* synthetic */ double lambda$transfer$0(float scale, double f2) {
        return f2 * (double)scale;
    }
}

