/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.SqueezeInfo;
import java.io.IOException;

class ITXInfo {
    final int tr;
    final int beginC;
    final int rctType;
    final int numC;
    final int nbColors;
    final int nbDeltas;
    final int dPred;
    final SqueezeInfo[] sp;

    ITXInfo(BitXL reader) throws IOException {
        this.tr = reader.u(2);
        this.beginC = this.tr != 2 ? reader.u32(0, 3, 8, 6, 72, 10, 1096, 13) : 0;
        this.rctType = this.tr == 0 ? reader.u32(6, 0, 0, 2, 2, 4, 10, 6) : 0;
        if (this.tr == 1) {
            this.numC = reader.u32(1, 0, 3, 0, 4, 0, 1, 13);
            this.nbColors = reader.u32(0, 8, 256, 10, 1280, 12, 5376, 16);
            this.nbDeltas = reader.u32(0, 0, 1, 8, 257, 10, 1281, 16);
            this.dPred = reader.u(4);
        } else {
            this.dPred = 0;
            this.nbDeltas = 0;
            this.nbColors = 0;
            this.numC = 0;
        }
        if (this.tr == 2) {
            int numSq = reader.u32(0, 0, 1, 4, 9, 6, 41, 8);
            this.sp = new SqueezeInfo[numSq];
            for (int i2 = 0; i2 < numSq; ++i2) {
                this.sp[i2] = new SqueezeInfo(reader);
            }
        } else {
            this.sp = null;
        }
    }
}

