/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.IntXL;

enum ITX {
    DCT8(0, 0, 1, 1, 8, 8, 8, 8, 0, 0),
    HORNUSS(1, 1, 1, 1, 8, 8, 8, 8, 1, 3),
    DCT2(2, 2, 1, 1, 8, 8, 8, 8, 1, 1),
    DCT4(3, 3, 1, 1, 8, 8, 8, 8, 1, 2),
    DCT16(4, 4, 2, 2, 16, 16, 16, 16, 2, 0),
    DCT32(5, 5, 4, 4, 32, 32, 32, 32, 3, 0),
    DCT16_8(6, 6, 2, 1, 16, 8, 8, 16, 4, 0),
    DCT8_16(7, 6, 1, 2, 8, 16, 8, 16, 4, 0),
    DCT32_8(8, 7, 4, 1, 32, 8, 8, 32, 5, 0),
    DCT8_32(9, 7, 1, 4, 8, 32, 8, 32, 5, 0),
    DCT32_16(10, 8, 4, 2, 32, 16, 16, 32, 6, 0),
    DCT16_32(11, 8, 2, 4, 16, 32, 16, 32, 6, 0),
    DCT4_8(12, 9, 1, 1, 8, 8, 8, 8, 1, 5),
    DCT8_4(13, 9, 1, 1, 8, 8, 8, 8, 1, 4),
    AFV0(14, 10, 1, 1, 8, 8, 8, 8, 1, 6),
    AFV1(15, 10, 1, 1, 8, 8, 8, 8, 1, 6),
    AFV2(16, 10, 1, 1, 8, 8, 8, 8, 1, 6),
    AFV3(17, 10, 1, 1, 8, 8, 8, 8, 1, 6),
    DCT64(18, 11, 8, 8, 64, 64, 64, 64, 7, 0),
    DCT64_32(19, 12, 8, 4, 64, 32, 32, 64, 8, 0),
    DCT32_64(20, 12, 4, 8, 32, 64, 32, 64, 8, 0),
    DCT128(21, 13, 16, 16, 128, 128, 128, 128, 9, 0),
    DCT128_64(22, 14, 16, 8, 128, 64, 64, 128, 10, 0),
    DCT64_128(23, 14, 8, 16, 64, 128, 64, 128, 10, 0),
    DCT256(24, 15, 32, 32, 256, 256, 256, 256, 11, 0),
    DCT256_128(25, 16, 32, 16, 256, 128, 128, 256, 12, 0),
    DCT128_256(26, 16, 16, 32, 128, 256, 128, 256, 12, 0);

    static final int MODE_LIBRARY = 0;
    static final int MODE_HORNUSS = 1;
    static final int MODE_DCT2 = 2;
    static final int MODE_DCT4 = 3;
    static final int MODE_DCT4_8 = 4;
    static final int MODE_AFV = 5;
    static final int MODE_DCT = 6;
    static final int MODE_RAW = 7;
    static final int METHOD_DCT = 0;
    static final int METHOD_DCT2 = 1;
    static final int METHOD_DCT4 = 2;
    static final int METHOD_HORNUSS = 3;
    static final int METHOD_DCT8_4 = 4;
    static final int METHOD_DCT4_8 = 5;
    static final int METHOD_AFV = 6;
    final int type;
    final int idx;
    final int dctW;
    final int dctH;
    final int blockW;
    final int blockH;
    final int mmW;
    final int mmH;
    final int orderID;
    final int method;
    final float[][] llfScale;

    private ITX(int type, int idx, int dctH, int dctW, int blockH, int blockW, int mmH, int mmW, int orderID, int method) {
        this.type = type;
        this.idx = idx;
        this.dctW = dctW;
        this.dctH = dctH;
        this.blockW = blockW;
        this.blockH = blockH;
        this.mmW = mmW;
        this.mmH = mmH;
        this.orderID = orderID;
        this.method = method;
        this.llfScale = new float[dctH][dctW];
        for (int y2 = 0; y2 < dctH; ++y2) {
            for (int x2 = 0; x2 < dctW; ++x2) {
                this.llfScale[y2][x2] = ITX.scaleF(y2, blockH) * ITX.scaleF(x2, blockW);
            }
        }
    }

    boolean isVertical() {
        return this.blockH > this.blockW;
    }

    boolean flip() {
        return this.blockH > this.blockW || this.method == 0 && this.blockH == this.blockW;
    }

    private static float scaleF(int c2, int b2) {
        double piSize = Math.PI * (double)c2;
        return (float)(1.0 / (Math.cos(piSize / (double)(2 * b2)) * Math.cos(piSize / (double)b2) * Math.cos(2.0 * piSize / (double)b2)));
    }

    IntXL getPixelSize() {
        return new IntXL(this.blockW, this.blockH);
    }
}

