/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.BlendInfo;
import com.idrsolutions.image.jpegXL.data.HeaderImage;
import com.idrsolutions.image.jpegXL.data.IntXL;
import com.idrsolutions.image.jpegXL.data.LoopFilter;
import com.idrsolutions.image.jpegXL.data.MathXL;
import com.idrsolutions.image.jpegXL.data.PassInfo;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Stream;

class HeaderFrame {
    final int type;
    final int encoding;
    final long flags;
    final boolean doYCbCr;
    final IntXL[] jpegUpsampling;
    final int upsampling;
    final int[] ecUpsampling;
    final int groupSizeShift;
    final int groupDim;
    final int lfGroupDim;
    final int logGroupDim;
    final int logLFGroupDim;
    final int xqmScale;
    final int bqmScale;
    final PassInfo passes;
    final int lfLevel;
    final boolean haveCrop;
    IntXL origin;
    int width;
    int height;
    final BlendInfo blendInfo;
    final BlendInfo[] ecBlendInfo;
    final int duration;
    final int timecode;
    final boolean isLast;
    final int saveAsReference;
    final boolean saveBeforeCT;
    final String name;
    final LoopFilter restorationFilter;

    HeaderFrame(BitXL reader, HeaderImage parent) throws IOException {
        int i2;
        int i3;
        boolean allDefault = reader.bool();
        this.type = allDefault ? 0 : reader.u(2);
        this.encoding = allDefault ? 0 : reader.u(1);
        this.flags = allDefault ? 0L : reader.u64();
        this.doYCbCr = !allDefault && !parent.isXYBEncoded() && reader.bool();
        this.jpegUpsampling = new IntXL[3];
        if (this.doYCbCr && (this.flags & 0x20L) == 0L) {
            for (i3 = 0; i3 < 3; ++i3) {
                int y2 = reader.u(1);
                int x2 = reader.u(1);
                this.jpegUpsampling[i3] = new IntXL(x2 ^ y2, y2);
            }
        } else {
            Arrays.fill(this.jpegUpsampling, new IntXL());
        }
        this.ecUpsampling = new int[parent.getExtraChannelCount()];
        if (!allDefault && (this.flags & 0x20L) == 0L) {
            this.upsampling = 1 << reader.u(2);
            for (i3 = 0; i3 < this.ecUpsampling.length; ++i3) {
                this.ecUpsampling[i3] = 1 << reader.u(2);
            }
        } else {
            this.upsampling = 1;
            Arrays.fill(this.ecUpsampling, 1);
        }
        this.groupSizeShift = this.encoding == 1 ? reader.u(2) : 1;
        this.groupDim = 128 << this.groupSizeShift;
        this.lfGroupDim = this.groupDim << 3;
        this.logGroupDim = MathXL.ceilLog2(this.groupDim);
        this.logLFGroupDim = MathXL.ceilLog2(this.lfGroupDim);
        if (parent.isXYBEncoded() && this.encoding == 0) {
            if (!allDefault) {
                this.xqmScale = reader.u(3);
                this.bqmScale = reader.u(3);
            } else {
                this.xqmScale = 3;
                this.bqmScale = 2;
            }
        } else {
            this.xqmScale = 2;
            this.bqmScale = 2;
        }
        this.passes = !allDefault && this.type != 2 ? new PassInfo(reader) : new PassInfo();
        this.lfLevel = this.type == 1 ? 1 + reader.u(2) : 0;
        boolean bl2 = this.haveCrop = !allDefault && this.type != 1 && reader.bool();
        if (this.haveCrop && this.type != 2) {
            int x0 = reader.u32(0, 8, 256, 11, 2304, 14, 18688, 30);
            int y0 = reader.u32(0, 8, 256, 11, 2304, 14, 18688, 30);
            x0 = MathXL.unpackSigned(x0);
            y0 = MathXL.unpackSigned(y0);
            this.origin = new IntXL(x0, y0);
        } else {
            this.origin = new IntXL();
        }
        if (this.haveCrop) {
            this.width = reader.u32(0, 8, 256, 11, 2304, 14, 18688, 30);
            this.height = reader.u32(0, 8, 256, 11, 2304, 14, 18688, 30);
        } else {
            this.width = parent.getSize().width;
            this.height = parent.getSize().height;
        }
        boolean normalFrame = !allDefault && (this.type == 0 || this.type == 3);
        boolean fullFrame = this.origin.x <= 0 && this.origin.y <= 0 && this.width + this.origin.x >= parent.getSize().width && this.height + this.origin.y >= parent.getSize().height;
        this.ecBlendInfo = new BlendInfo[parent.getExtraChannelCount()];
        if (normalFrame) {
            this.blendInfo = new BlendInfo(reader, this.ecBlendInfo.length > 0, fullFrame);
            for (int i4 = 0; i4 < this.ecBlendInfo.length; ++i4) {
                this.ecBlendInfo[i4] = new BlendInfo(reader, true, fullFrame);
            }
        } else {
            this.blendInfo = new BlendInfo();
            Arrays.fill(this.ecBlendInfo, this.blendInfo);
        }
        this.duration = normalFrame && parent.hasAnimation ? reader.u32(0, 0, 1, 0, 0, 8, 0, 32) : 0;
        int n2 = this.timecode = normalFrame && parent.hasAnimation ? reader.u(32) : 0;
        this.isLast = normalFrame ? reader.bool() : this.type == 0;
        this.saveAsReference = !allDefault && this.type != 1 && !this.isLast ? reader.u(2) : 0;
        boolean bl3 = this.saveBeforeCT = !(allDefault || this.type != 2 && (!fullFrame || this.type != 0 && this.type != 3 || this.duration != 0 && this.saveAsReference == 0 || this.isLast || this.blendInfo.mode != 0) || !reader.bool());
        if (allDefault) {
            this.name = "";
        } else {
            int nameLen = reader.u32(0, 0, 0, 4, 16, 5, 48, 10);
            byte[] buffer = new byte[nameLen];
            for (i2 = 0; i2 < nameLen; ++i2) {
                buffer[i2] = (byte)reader.u(8);
            }
            this.name = new String(buffer, StandardCharsets.UTF_8);
        }
        LoopFilter loopFilter = this.restorationFilter = allDefault ? new LoopFilter() : new LoopFilter(reader, this.encoding);
        if (!allDefault) {
            MathXL.skipExtensions(reader);
        }
        int maxJPX = Stream.of(this.jpegUpsampling).mapToInt(p2 -> p2.x).reduce(Math::max).getAsInt();
        int maxJPY = Stream.of(this.jpegUpsampling).mapToInt(p2 -> p2.y).reduce(Math::max).getAsInt();
        this.width = MathXL.ceilDiv(this.width, 1 << maxJPX) << maxJPX;
        this.height = MathXL.ceilDiv(this.height, 1 << maxJPY) << maxJPY;
        for (i2 = 0; i2 < 3; ++i2) {
            this.jpegUpsampling[i2] = new IntXL(maxJPX, maxJPY).minus(this.jpegUpsampling[i2]);
        }
    }
}

