/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.Entropy;
import com.idrsolutions.image.jpegXL.data.Frame;
import com.idrsolutions.image.jpegXL.data.ITX;
import com.idrsolutions.image.jpegXL.data.IntXL;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.stream.Stream;
import org.jpedal.utils.LogWriter;

class HFPass {
    private static final int[][] naturalOrderX = new int[13][];
    private static final int[][] naturalOrderY = new int[13][];
    final int usedOrders;
    final IntXL[][][] order = new IntXL[13][3][];
    final Entropy contextStream;

    HFPass(BitXL reader, Frame frame) throws IOException {
        this.usedOrders = reader.u32(95, 0, 19, 0, 0, 0, 0, 13);
        Entropy stream = this.usedOrders != 0 ? new Entropy(reader, 8) : null;
        for (int b2 = 0; b2 < 13; ++b2) {
            for (int c2 = 0; c2 < 3; ++c2) {
                this.order[b2][c2] = new IntXL[naturalOrderX[b2].length];
                if ((this.usedOrders & 1 << b2) != 0) {
                    int[] perm = Frame.readPermutation(reader, stream, this.order[b2][c2].length, this.order[b2][c2].length / 64);
                    for (int i2 = 0; i2 < this.order[b2][c2].length; ++i2) {
                        int x2 = naturalOrderX[b2][perm[i2]];
                        int y2 = naturalOrderY[b2][perm[i2]];
                        this.order[b2][c2][i2] = new IntXL(x2, y2);
                    }
                    continue;
                }
                for (int i3 = 0; i3 < this.order[b2][c2].length; ++i3) {
                    int x3 = naturalOrderX[b2][i3];
                    int y3 = naturalOrderY[b2][i3];
                    this.order[b2][c2][i3] = new IntXL(x3, y3);
                }
            }
        }
        int numContexts = 495 * frame.getHFGlobal().numHfPresets * frame.getLFGlobal().hfBlockCtx.numClusters;
        this.contextStream = new Entropy(reader, numContexts);
    }

    static {
        try (InputStream fis = HFPass.class.getResourceAsStream("/com/idrsolutions/image/res/XLN.B64");){
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            while ((nRead = fis.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            data = buffer.toByteArray();
            data = Base64.getDecoder().decode(data);
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            for (int i2 = 0; i2 < 13; ++i2) {
                int j2;
                int index = i2;
                ITX tt = Stream.of(ITX.values()).filter(t2 -> t2.orderID == index && !t2.isVertical()).findAny().get();
                int len = tt.blockH * tt.blockW;
                HFPass.naturalOrderX[index] = new int[len];
                HFPass.naturalOrderY[index] = new int[len];
                HFPass.naturalOrderX[index][0] = bis.read();
                for (j2 = 1; j2 < len; ++j2) {
                    HFPass.naturalOrderX[index][j2] = bis.read() + naturalOrderX[index][j2 - 1] & 0xFF;
                }
                HFPass.naturalOrderY[index][0] = bis.read();
                for (j2 = 1; j2 < len; ++j2) {
                    HFPass.naturalOrderY[index][j2] = bis.read() + naturalOrderY[index][j2 - 1] & 0xFF;
                }
            }
        }
        catch (Exception ioe) {
            LogWriter.writeLog("Jpeg xl error reading passes");
        }
    }
}

