/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.Frame;
import com.idrsolutions.image.jpegXL.data.ITX;
import com.idrsolutions.image.jpegXL.data.IntXL;
import com.idrsolutions.image.jpegXL.data.LFGroup;
import com.idrsolutions.image.jpegXL.data.MathXL;
import com.idrsolutions.image.jpegXL.data.ModularInfo;
import com.idrsolutions.image.jpegXL.data.ModularStream;
import com.idrsolutions.image.jpegXL.data.VBlock;
import java.io.IOException;
import java.util.Arrays;

class HFMetadata {
    final int nbBlocks;
    final ITX[][] dctSelect;
    final IntXL[] blockList;
    final VBlock[][] blockMap;
    final int[][] hfMultiplier;
    final int[][][] hfStreamBuffer;
    final LFGroup parent;

    HFMetadata(BitXL reader, LFGroup parent, Frame frame) throws IOException {
        this.parent = parent;
        IntXL size = frame.getLFGroupSize(parent.lfGroupID).toRight(3);
        int n2 = MathXL.ceilLog2((long)size.x * (long)size.y);
        this.nbBlocks = 1 + reader.u(n2);
        IntXL aFromYSize = size.ceilDiv(8);
        ModularInfo xFromY = new ModularInfo(aFromYSize.x, aFromYSize.y, 0, 0);
        ModularInfo bFromY = new ModularInfo(aFromYSize.x, aFromYSize.y, 0, 0);
        ModularInfo blockInfo = new ModularInfo(this.nbBlocks, 2, 0, 0);
        ModularInfo sharpness = new ModularInfo(size.x, size.y, 0, 0);
        ModularStream hfStream = new ModularStream(reader, frame, 1 + 2 * frame.getNumLFGroups() + parent.lfGroupID, new ModularInfo[]{xFromY, bFromY, blockInfo, sharpness});
        hfStream.decodeChannels(reader);
        this.hfStreamBuffer = hfStream.getDecodedBuffer();
        this.dctSelect = new ITX[size.y][size.x];
        this.hfMultiplier = new int[size.y][size.x];
        this.blockList = new IntXL[this.nbBlocks];
        this.blockMap = new VBlock[size.y][size.x];
        int[][] blockInfoBuffer = this.hfStreamBuffer[2];
        IntXL lastBlock = new IntXL();
        ITX[] tta = ITX.values();
        for (int i2 = 0; i2 < this.nbBlocks; ++i2) {
            int type = blockInfoBuffer[0][i2];
            ITX tt = tta[type];
            IntXL pos = this.placeBlock(lastBlock, tt, 1 + blockInfoBuffer[1][i2]);
            if (pos == null) continue;
            lastBlock = pos;
            this.blockList[i2] = pos;
            VBlock varblock = new VBlock(parent, pos);
            for (int y2 = 0; y2 < tt.dctH; ++y2) {
                Arrays.fill(this.blockMap[y2 + pos.y], pos.x, pos.x + tt.dctW, varblock);
            }
        }
    }

    private IntXL placeBlock(IntXL lastBlock, ITX block, int mul) {
        int x2 = lastBlock.x;
        for (int y2 = lastBlock.y; y2 < this.dctSelect.length; ++y2) {
            ITX[] dctY = this.dctSelect[y2];
            while (x2 < dctY.length && block.dctW + x2 <= dctY.length) {
                block4: {
                    for (int ix = 0; ix < block.dctW; ++ix) {
                        ITX tt = dctY[x2 + ix];
                        if (tt == null) continue;
                        x2 += tt.dctW - 1;
                        break block4;
                    }
                    IntXL pos = new IntXL(x2, y2);
                    this.hfMultiplier[y2][x2] = mul;
                    for (int iy = 0; iy < block.dctH; ++iy) {
                        Arrays.fill((Object[])this.dctSelect[y2 + iy], x2, x2 + block.dctW, (Object)block);
                    }
                    return pos;
                }
                ++x2;
            }
            x2 = 0;
        }
        return null;
    }

    VBlock getVBlock(int n2) {
        IntXL block = this.blockList[n2];
        return this.blockMap[block.y][block.x];
    }
}

