/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.DCTInfo;
import com.idrsolutions.image.jpegXL.data.Frame;
import com.idrsolutions.image.jpegXL.data.FunctionalHelper;
import com.idrsolutions.image.jpegXL.data.HelperXL;
import com.idrsolutions.image.jpegXL.data.ITX;
import com.idrsolutions.image.jpegXL.data.IntXL;
import com.idrsolutions.image.jpegXL.data.MathXL;
import com.idrsolutions.image.jpegXL.data.ModularChannel;
import com.idrsolutions.image.jpegXL.data.ModularInfo;
import com.idrsolutions.image.jpegXL.data.ModularStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.stream.Stream;

class HFGlobal {
    private static final DCTInfo[] defaultParams = new DCTInfo[17];
    private static final float[][][][] defaultWeights = new float[17][3][][];
    private static final float[] afvFreqs = new float[]{0.0f, 0.0f, 0.8517779f, 5.3777843f, 0.0f, 0.0f, 4.734748f, 5.4492455f, 1.659827f, 4.0f, 7.275749f, 10.423227f, 2.6629324f, 7.6306577f, 8.962389f, 12.971662f};
    final DCTInfo[] params;
    final float[][][][] weights;
    final int numHfPresets;

    private static float[] prepend(float a10, float ... values) {
        float[] arr = new float[values.length + 1];
        arr[0] = a10;
        System.arraycopy(values, 0, arr, 1, values.length);
        return arr;
    }

    private static float[][] readDCTParams(BitXL reader) throws IOException {
        int numParams = 1 + reader.u(4);
        float[][] vals = new float[3][numParams];
        for (int c2 = 0; c2 < 3; ++c2) {
            for (int i2 = 0; i2 < numParams; ++i2) {
                vals[c2][i2] = reader.f16();
            }
            float[] fArray = vals[c2];
            fArray[0] = (float)((double)fArray[0] * 64.0);
        }
        return vals;
    }

    private static float interpolate(float pos, float max, float[] bands) {
        if (bands.length == 1) {
            return bands[0];
        }
        float scaledPos = pos * (float)(bands.length - 1) / max;
        int scaledIndex = (int)scaledPos;
        float fracIndex = scaledPos - (float)scaledIndex;
        float a10 = bands[scaledIndex];
        float b2 = bands[scaledIndex + 1];
        return a10 * (float)Math.pow(b2 / a10, fracIndex);
    }

    private static float quantMult(float v2) {
        return v2 >= 0.0f ? 1.0f + v2 : 1.0f / (1.0f - v2);
    }

    private static float[][] getDCTQuantWeights(int width, int height, float[] params) {
        float[] bands = new float[params.length];
        bands[0] = params[0];
        for (int i2 = 1; i2 < bands.length; ++i2) {
            bands[i2] = bands[i2 - 1] * HFGlobal.quantMult(params[i2]);
        }
        float[][] weights = new float[height][width];
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                float dx = (float)x2 / (float)(width - 1);
                float dy = (float)y2 / (float)(height - 1);
                float dist = (float)Math.sqrt(dx * dx + dy * dy);
                weights[y2][x2] = HFGlobal.interpolate(dist, MathXL.SQRT_2 + 1.0E-6f, bands);
            }
        }
        return weights;
    }

    private static void setupDefaultParams() {
        HFGlobal.defaultParams[0] = new DCTInfo(new float[][]{{3150.0f, 0.0f, -0.4f, -0.4f, -0.4f, -2.0f}, {560.0f, 0.0f, -0.3f, -0.3f, -0.3f, -0.3f}, {512.0f, -2.0f, -1.0f, 0.0f, -1.0f, -2.0f}}, null, 6);
        HFGlobal.defaultParams[1] = new DCTInfo(null, new float[][]{{280.0f, 3160.0f, 3160.0f}, {60.0f, 864.0f, 864.0f}, {18.0f, 200.0f, 200.0f}}, 1);
        HFGlobal.defaultParams[2] = new DCTInfo(null, new float[][]{{3840.0f, 2560.0f, 1280.0f, 640.0f, 480.0f, 300.0f}, {960.0f, 640.0f, 320.0f, 180.0f, 140.0f, 120.0f}, {640.0f, 320.0f, 128.0f, 64.0f, 32.0f, 16.0f}}, 2);
        float[][] dct4x4params = new float[][]{{2200.0f, 0.0f, 0.0f, 0.0f}, {392.0f, 0.0f, 0.0f, 0.0f}, {112.0f, -0.25f, -0.25f, -0.5f}};
        HFGlobal.defaultParams[3] = new DCTInfo((float[][])dct4x4params, (float[][])new float[][]{{1.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 1.0f}}, dct4x4params, 3);
        HFGlobal.defaultParams[4] = new DCTInfo(new float[][]{{8996.873f, -1.3000778f, -0.4942453f, -0.43909377f, -0.6350102f, -0.9017726f, -1.6162099f}, {3191.4836f, -0.67424583f, -0.80745816f, -0.4492584f, -0.3586544f, -0.3132239f, -0.37615025f}, {1157.504f, -2.0531423f, -1.4f, -0.5068713f, -0.4270873f, -1.4856834f, -4.920914f}}, null, 6);
        HFGlobal.defaultParams[5] = new DCTInfo(new float[][]{{15718.408f, -1.025f, -0.98f, -0.9012f, -0.4f, -0.48819396f, -0.421064f, -0.27f}, {7305.7637f, -0.8041958f, -0.76330364f, -0.5566038f, -0.49785304f, -0.43699592f, -0.40180868f, -0.27321684f}, {3803.5317f, -3.0607336f, -2.041327f, -2.023565f, -0.54953897f, -0.4f, -0.4f, -0.3f}}, null, 6);
        HFGlobal.defaultParams[6] = new DCTInfo(new float[][]{{7240.7734f, -0.7f, -0.7f, -0.2f, -0.2f, -0.2f, -0.5f}, {1448.1547f, -0.5f, -0.5f, -0.5f, -0.2f, -0.2f, -0.2f}, {506.85413f, -1.4f, -0.2f, -0.5f, -0.5f, -1.5f, -3.6f}}, null, 6);
        HFGlobal.defaultParams[7] = new DCTInfo(new float[][]{{16283.249f, -1.7812846f, -1.6309059f, -1.0382179f, -0.85f, -0.7f, -0.9f, -1.2360638f}, {5089.1577f, -0.3200494f, -0.3536285f, -0.3034f, -0.61f, -0.5f, -0.5f, -0.6f}, {3397.7761f, -0.32132736f, -0.3450762f, -0.7034f, -0.9f, -1.0f, -1.0f, -1.1754606f}}, null, 6);
        HFGlobal.defaultParams[8] = new DCTInfo(new float[][]{{13844.971f, -0.971138f, -0.658f, -0.42026f, -0.22712f, -0.2206f, -0.226f, -0.6f}, {4798.964f, -0.6112531f, -0.8377079f, -0.7901486f, -0.26927274f, -0.38272768f, -0.22924222f, -0.20719099f}, {1807.2369f, -1.2f, -1.2f, -0.7f, -0.7f, -0.7f, -0.4f, -0.5f}}, null, 6);
        float[][] dct4x8Params = new float[][]{{2198.0505f, -0.96269625f, -0.7619425f, -0.65511405f}, {764.36554f, -0.926302f, -0.967523f, -0.2784529f}, {527.10754f, -1.4594386f, -1.4500821f, -1.5843723f}};
        HFGlobal.defaultParams[9] = new DCTInfo(dct4x8Params, new float[][]{{1.0f}, {1.0f}, {1.0f}}, 4);
        HFGlobal.defaultParams[10] = new DCTInfo((float[][])dct4x8Params, (float[][])new float[][]{{3072.0f, 3072.0f, 256.0f, 256.0f, 256.0f, 414.0f, 0.0f, 0.0f, 0.0f}, {1024.0f, 1024.0f, 50.0f, 50.0f, 50.0f, 58.0f, 0.0f, 0.0f, 0.0f}, {384.0f, 384.0f, 12.0f, 12.0f, 12.0f, 22.0f, -0.25f, -0.25f, -0.25f}}, dct4x4params, 5);
        float[] seqA = new float[]{-1.025f, -0.78f, -0.65012f, -0.19041574f, -0.20819396f, -0.421064f, -0.32733846f};
        float[] seqB = new float[]{-0.30419582f, -0.36330363f, -0.3566038f, -0.34430745f, -0.33699593f, -0.30180866f, -0.27321684f};
        float[] seqC = new float[]{-1.2f, -1.2f, -0.8f, -0.7f, -0.7f, -0.4f, -0.5f};
        HFGlobal.defaultParams[11] = new DCTInfo(new float[][]{HFGlobal.prepend(23966.166f, seqA), HFGlobal.prepend(8380.191f, seqB), HFGlobal.prepend(4493.024f, seqC)}, null, 6);
        HFGlobal.defaultParams[12] = new DCTInfo(new float[][]{HFGlobal.prepend(15358.898f, seqA), HFGlobal.prepend(5597.3604f, seqB), HFGlobal.prepend(2919.9617f, seqC)}, null, 6);
        HFGlobal.defaultParams[13] = new DCTInfo(new float[][]{HFGlobal.prepend(47932.332f, seqA), HFGlobal.prepend(16760.383f, seqB), HFGlobal.prepend(8986.048f, seqC)}, null, 6);
        HFGlobal.defaultParams[14] = new DCTInfo(new float[][]{HFGlobal.prepend(30717.797f, seqA), HFGlobal.prepend(11194.721f, seqB), HFGlobal.prepend(5839.9233f, seqC)}, null, 6);
        HFGlobal.defaultParams[15] = new DCTInfo(new float[][]{HFGlobal.prepend(95864.664f, seqA), HFGlobal.prepend(33520.766f, seqB), HFGlobal.prepend(17972.096f, seqC)}, null, 6);
        HFGlobal.defaultParams[16] = new DCTInfo(new float[][]{HFGlobal.prepend(61435.594f, seqA), HFGlobal.prepend(24209.441f, seqB), HFGlobal.prepend(12979.847f, seqC)}, null, 6);
    }

    private static void readDefaultWeights() throws IOException {
        int nRead;
        InputStream fis = HFGlobal.class.getResourceAsStream("/com/idrsolutions/image/res/XLW.B64");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((nRead = fis.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        data = buffer.toByteArray();
        data = Base64.getDecoder().decode(data);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        for (int i2 : HelperXL.range(17)) {
            ITX tt = Stream.of(ITX.values()).filter(t2 -> t2.idx == i2 && !t2.isVertical()).findFirst().get();
            for (int c2 = 0; c2 < 3; ++c2) {
                HFGlobal.defaultWeights[i2][c2] = new float[tt.mmH][tt.mmW];
                for (int y2 = 0; y2 < tt.mmH; ++y2) {
                    for (int x2 = 0; x2 < tt.mmW; ++x2) {
                        HFGlobal.defaultWeights[i2][c2][y2][x2] = in.readFloat();
                    }
                }
            }
        }
        in.close();
    }

    HFGlobal(BitXL reader, Frame frame) throws IOException {
        int i2;
        boolean quantAllDefault = reader.bool();
        if (quantAllDefault) {
            this.params = defaultParams;
        } else {
            this.params = new DCTInfo[17];
            for (i2 = 0; i2 < 17; ++i2) {
                this.setupDCTParam(reader, frame, i2);
            }
        }
        this.weights = new float[17][3][][];
        for (i2 = 0; i2 < 17; ++i2) {
            this.generateWeights(i2);
        }
        this.numHfPresets = 1 + reader.u(MathXL.ceilLog1p(frame.getNumGroups() - 1));
    }

    private void setupDCTParam(BitXL reader, Frame frame, int index) throws IOException {
        int encodingMode = reader.u(3);
        switch (encodingMode) {
            case 0: {
                this.params[index] = defaultParams[index];
                break;
            }
            case 1: {
                float[][] m2 = new float[3][3];
                for (int y2 = 0; y2 < 3; ++y2) {
                    for (int x2 = 0; x2 < 3; ++x2) {
                        m2[y2][x2] = 64.0f * reader.f16();
                    }
                }
                this.params[index] = new DCTInfo(null, m2, encodingMode);
                break;
            }
            case 2: {
                float[][] m3 = new float[3][6];
                for (int y3 = 0; y3 < 3; ++y3) {
                    for (int x3 = 0; x3 < 6; ++x3) {
                        m3[y3][x3] = 64.0f * reader.f16();
                    }
                }
                this.params[index] = new DCTInfo(null, m3, encodingMode);
                break;
            }
            case 3: {
                float[][] m4 = new float[3][2];
                for (int y4 = 0; y4 < 3; ++y4) {
                    for (int x4 = 0; x4 < 2; ++x4) {
                        m4[y4][x4] = 64.0f * reader.f16();
                    }
                }
                this.params[index] = new DCTInfo(HFGlobal.readDCTParams(reader), m4, encodingMode);
                break;
            }
            case 6: {
                this.params[index] = new DCTInfo(HFGlobal.readDCTParams(reader), null, encodingMode);
                break;
            }
            case 7: {
                float den = reader.f16();
                ITX tt = Stream.of(ITX.values()).filter(t2 -> t2.idx == index && !t2.isVertical()).findFirst().get();
                ModularInfo[] info = new ModularInfo[]{new ModularChannel(tt.mmW, tt.mmH, 0, 0), new ModularChannel(tt.mmW, tt.mmH, 0, 0), new ModularChannel(tt.mmW, tt.mmH, 0, 0)};
                ModularStream stream = new ModularStream(reader, frame, 1 + 3 * frame.getNumLFGroups() + index, info);
                stream.decodeChannels(reader);
                float[][] m5 = new float[3][tt.mmW * tt.mmH];
                int[][][] b2 = stream.getDecodedBuffer();
                for (int c2 = 0; c2 < 3; ++c2) {
                    for (int y5 = 0; y5 < b2[c2].length; ++y5) {
                        for (int x5 = 0; x5 < b2[c2][y5].length; ++x5) {
                            m5[c2][y5 * tt.mmW + x5] = b2[c2][y5][x5];
                        }
                    }
                }
                this.params[index] = new DCTInfo(null, m5, encodingMode, den);
                break;
            }
            case 5: {
                float[][] m6 = new float[3][9];
                for (int y6 = 0; y6 < 3; ++y6) {
                    for (int x6 = 0; x6 < 9; ++x6) {
                        m6[y6][x6] = reader.f16();
                        if (x6 >= 6) continue;
                        float[] fArray = m6[y6];
                        int n2 = x6;
                        fArray[n2] = fArray[n2] * 64.0f;
                    }
                }
                float[][] d2 = HFGlobal.readDCTParams(reader);
                float[][] f2 = HFGlobal.readDCTParams(reader);
                this.params[index] = new DCTInfo(d2, m6, f2, encodingMode);
            }
        }
    }

    private float[][] getAFVTransformWeights(int index, int c2) {
        int px;
        int py;
        float[][] weights4x8 = HFGlobal.getDCTQuantWeights(8, 4, this.params[index].dctParam[c2]);
        float[][] weights4x4 = HFGlobal.getDCTQuantWeights(4, 4, this.params[index].params4x4[c2]);
        float low = 0.8517779f;
        float high = 12.971662f;
        float[] bands = new float[4];
        bands[0] = this.params[index].param[c2][5];
        for (int i2 = 1; i2 < 4; ++i2) {
            bands[i2] = bands[i2 - 1] * HFGlobal.quantMult(this.params[index].param[c2][i2 + 5]);
        }
        float[][] weight = new float[8][8];
        weight[0][0] = 1.0f;
        weight[1][0] = this.params[index].param[c2][0];
        weight[0][1] = this.params[index].param[c2][1];
        weight[2][0] = this.params[index].param[c2][2];
        weight[0][2] = this.params[index].param[c2][3];
        weight[2][2] = this.params[index].param[c2][4];
        for (py = 0; py < 4; ++py) {
            for (px = 0; px < 4; ++px) {
                if (px < 2 && py < 2) continue;
                weight[2 * py][2 * px] = HFGlobal.interpolate(afvFreqs[py * 4 + px] - 0.8517779f, 12.1198845f, bands);
            }
        }
        for (py = 0; py < 4; ++py) {
            for (px = 0; px < 8; ++px) {
                if (px == 0 && py == 0) continue;
                weight[2 * py + 1][px] = weights4x8[py][px];
            }
        }
        for (py = 0; py < 4; ++py) {
            for (px = 0; px < 4; ++px) {
                if (px == 0 && py == 0) continue;
                weight[2 * py][2 * px + 1] = weights4x4[py][px];
            }
        }
        return weight;
    }

    private void generateWeights(int index) {
        int c2;
        ITX tt = Stream.of(ITX.values()).filter(t2 -> t2.idx == index && !t2.isVertical()).findFirst().get();
        if (this.params[index] == defaultParams[index]) {
            System.arraycopy(defaultWeights[index], 0, this.weights[index], 0, 3);
            return;
        }
        block9: for (c2 = 0; c2 < 3; ++c2) {
            switch (this.params[index].mode) {
                case 6: {
                    this.weights[index][c2] = HFGlobal.getDCTQuantWeights(tt.mmW, tt.mmH, this.params[index].dctParam[c2]);
                    continue block9;
                }
                case 3: {
                    int px;
                    int py;
                    this.weights[index][c2] = new float[8][8];
                    float[][] w2 = HFGlobal.getDCTQuantWeights(4, 4, this.params[index].dctParam[c2]);
                    for (py = 0; py < 8; ++py) {
                        for (px = 0; px < 8; ++px) {
                            this.weights[index][c2][py][px] = w2[py / 2][px / 2];
                        }
                    }
                    float[] fArray = this.weights[index][c2][1];
                    fArray[0] = fArray[0] / this.params[index].param[c2][0];
                    float[] fArray2 = this.weights[index][c2][0];
                    fArray2[1] = fArray2[1] / this.params[index].param[c2][0];
                    float[] fArray3 = this.weights[index][c2][1];
                    fArray3[1] = fArray3[1] / this.params[index].param[c2][1];
                    continue block9;
                }
                case 2: {
                    int px;
                    int py;
                    float[][] w2 = new float[8][8];
                    w2[0][0] = 1.0f;
                    float f2 = this.params[index].param[c2][0];
                    w2[1][0] = f2;
                    w2[0][1] = f2;
                    w2[1][1] = this.params[index].param[c2][1];
                    for (py = 0; py < 2; ++py) {
                        for (px = 0; px < 2; ++px) {
                            float f3 = this.params[index].param[c2][2];
                            w2[px + 2][py] = f3;
                            w2[py][px + 2] = f3;
                            w2[py + 2][px + 2] = this.params[index].param[c2][3];
                        }
                    }
                    for (py = 0; py < 4; ++py) {
                        for (px = 0; px < 4; ++px) {
                            float f4 = this.params[index].param[c2][4];
                            w2[px + 4][py] = f4;
                            w2[py][px + 4] = f4;
                            w2[py + 4][px + 4] = this.params[index].param[c2][5];
                        }
                    }
                    this.weights[index][c2] = w2;
                    continue block9;
                }
                case 1: {
                    int y2;
                    float[][] w2 = new float[8][8];
                    for (y2 = 0; y2 < 8; ++y2) {
                        Arrays.fill(w2[y2], this.params[index].param[c2][0]);
                    }
                    w2[1][1] = this.params[index].param[c2][2];
                    float f5 = this.params[index].param[c2][1];
                    w2[1][0] = f5;
                    w2[0][1] = f5;
                    w2[0][0] = 1.0f;
                    this.weights[index][c2] = w2;
                    continue block9;
                }
                case 4: {
                    int py;
                    this.weights[index][c2] = new float[8][8];
                    float[][] w2 = HFGlobal.getDCTQuantWeights(8, 4, this.params[index].dctParam[c2]);
                    for (py = 0; py < 8; ++py) {
                        System.arraycopy(w2[py / 2], 0, this.weights[index][c2][py], 0, 8);
                    }
                    float[] fArray = this.weights[index][c2][1];
                    fArray[0] = fArray[0] / this.params[index].param[c2][0];
                    continue block9;
                }
                case 5: {
                    this.weights[index][c2] = this.getAFVTransformWeights(index, c2);
                    continue block9;
                }
                case 7: {
                    int y2;
                    this.weights[index][c2] = new float[tt.mmH][tt.mmW];
                    for (y2 = 0; y2 < tt.mmH; ++y2) {
                        for (int x2 = 0; x2 < tt.mmW; ++x2) {
                            this.weights[index][c2][y2][x2] = this.params[index].param[c2][y2 * tt.mmW + x2] * this.params[index].denominator;
                        }
                    }
                    continue block9;
                }
            }
        }
        if (this.params[index].mode != 7) {
            for (c2 = 0; c2 < 3; ++c2) {
                for (IntXL p2 : HelperXL.range2D(IntXL.sizeOf(this.weights[index][c2]))) {
                    this.weights[index][c2][p2.y][p2.x] = 1.0f / this.weights[index][c2][p2.y][p2.x];
                }
            }
        }
    }

    static {
        HFGlobal.setupDefaultParams();
        try {
            HFGlobal.readDefaultWeights();
        }
        catch (Exception e2) {
            FunctionalHelper.sneakyThrow(e2);
        }
    }
}

