/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.Entropy;
import com.idrsolutions.image.jpegXL.data.Frame;
import com.idrsolutions.image.jpegXL.data.HFBlock;
import com.idrsolutions.image.jpegXL.data.HFPass;
import com.idrsolutions.image.jpegXL.data.ITX;
import com.idrsolutions.image.jpegXL.data.IntXL;
import com.idrsolutions.image.jpegXL.data.Inverse;
import com.idrsolutions.image.jpegXL.data.LFChannel;
import com.idrsolutions.image.jpegXL.data.LFGroup;
import com.idrsolutions.image.jpegXL.data.MathXL;
import com.idrsolutions.image.jpegXL.data.VBlock;
import java.io.IOException;
import java.util.Arrays;

class HFCoefficients {
    private static final int[] FREQUENCIES = new int[]{-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 23, 23, 24, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 27, 28, 28, 28, 28, 29, 29, 29, 29, 30, 30, 30, 30};
    private static final int[] NONZEROS = new int[]{-1, 0, 31, 62, 62, 93, 93, 93, 93, 123, 123, 123, 123, 152, 152, 152, 152, 152, 152, 152, 152, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206, 206};
    final int hfPreset;
    private final HFBlock hfctx;
    final LFGroup lfg;
    final int groupID;
    private final int[][][] nonZeroes;
    final float[][][] dequantHFCoeff;
    final int[][][] quantizedCoeffs;
    final Entropy entropy;
    final Frame frame;
    final VBlock[] varblocks;

    HFCoefficients(BitXL reader, Frame frame, int pass, int group) throws IOException {
        this.hfPreset = reader.u(MathXL.ceilLog1p(frame.getHFGlobal().numHfPresets - 1));
        this.groupID = group;
        this.frame = frame;
        this.hfctx = frame.getLFGlobal().hfBlockCtx;
        this.lfg = frame.getLFGroupForGroup(group);
        int offset = 495 * this.hfctx.numClusters * this.hfPreset;
        HFPass hfPass = frame.getHFPass(pass);
        IntXL groupSize = frame.groupSize(group);
        IntXL groupBlockSize = groupSize.toRight(3);
        this.nonZeroes = new int[3][groupBlockSize.y][groupBlockSize.x];
        IntXL[] shift = frame.getFrameHeader().jpegUpsampling;
        this.entropy = new Entropy(hfPass.contextStream);
        this.quantizedCoeffs = new int[3][][];
        this.dequantHFCoeff = new float[3][][];
        for (int c2 = 0; c2 < 3; ++c2) {
            IntXL s2 = groupSize.toRight(shift[c2]);
            this.quantizedCoeffs[c2] = new int[s2.y][s2.x];
            this.dequantHFCoeff[c2] = new float[s2.y][s2.x];
        }
        this.varblocks = new VBlock[this.lfg.hfMetadata.blockList.length];
        for (int i2 = 0; i2 < this.lfg.hfMetadata.blockList.length; ++i2) {
            VBlock varblock = this.lfg.hfMetadata.getVBlock(i2);
            if (varblock.groupID != this.groupID) continue;
            this.varblocks[i2] = varblock;
            ITX tt = varblock.transformType();
            boolean flip = tt.flip();
            int hfMult = varblock.hfMult();
            int lfIndex = this.lfg.lfCoeff.lfIndex[varblock.blockPosInLFGroup.y][varblock.blockPosInLFGroup.x];
            IntXL sizeInBlocks = varblock.sizeInBlocks();
            int numBlocks = sizeInBlocks.x * sizeInBlocks.y;
            block2: for (int c3 : Frame.cMap) {
                IntXL shiftC = shift[c3];
                if (!varblock.isCorner(shiftC)) continue;
                IntXL shiftedBlockPos = varblock.blockPosInGroup.toRight(shiftC);
                IntXL ppg = shiftedBlockPos.toLeft(3);
                int predicted = this.getPredictedNonZeroes(c3, shiftedBlockPos);
                int blockCtx = this.getBlockContext(c3, tt.orderID, hfMult, lfIndex);
                int nonZeroCtx = offset + this.getNonZeroContext(predicted, blockCtx);
                int nonZero = this.entropy.readSymbol(reader, nonZeroCtx);
                int[][] nz = this.nonZeroes[c3];
                for (int iy = 0; iy < sizeInBlocks.y; ++iy) {
                    for (int ix = 0; ix < sizeInBlocks.x; ++ix) {
                        nz[shiftedBlockPos.y + iy][shiftedBlockPos.x + ix] = (nonZero + numBlocks - 1) / numBlocks;
                    }
                }
                if (nonZero <= 0) continue;
                int size = hfPass.order[tt.orderID][c3].length;
                int[] ucoeff = new int[size - numBlocks];
                int histCtx = offset + 458 * blockCtx + 37 * this.hfctx.numClusters;
                for (int k2 = 0; k2 < ucoeff.length; ++k2) {
                    int prev = k2 == 0 ? (nonZero > size / 16 ? 0 : 1) : (ucoeff[k2 - 1] != 0 ? 1 : 0);
                    int ctx = histCtx + HFCoefficients.getCoeffContext(k2 + numBlocks, nonZero, numBlocks, prev);
                    ucoeff[k2] = this.entropy.readSymbol(reader, ctx);
                    IntXL pos = hfPass.order[tt.orderID][c3][k2 + numBlocks];
                    int posX = (flip ? pos.y : pos.x) + ppg.x;
                    int posY = (flip ? pos.x : pos.y) + ppg.y;
                    this.quantizedCoeffs[c3][posY][posX] = MathXL.unpackSigned(ucoeff[k2]);
                    if (ucoeff[k2] != 0 && --nonZero == 0) continue block2;
                }
            }
        }
    }

    void bakeDequantizedCoeffs() {
        this.dequantizeHFCoefficients();
        IntXL[] shift = this.frame.getFrameHeader().jpegUpsampling;
        if (!Arrays.stream(shift).allMatch(x2 -> IntXL.ZERO.equals(x2))) {
            return;
        }
        LFChannel lfc = this.frame.getLFGlobal().lfChanCorr;
        int[][] xFactorHF = this.lfg.hfMetadata.hfStreamBuffer[0];
        int[][] bFactorHF = this.lfg.hfMetadata.hfStreamBuffer[1];
        float[][] xFactors = new float[xFactorHF.length][xFactorHF[0].length];
        float[][] bFactors = new float[bFactorHF.length][bFactorHF[0].length];
        for (VBlock varblock : this.varblocks) {
            if (varblock == null) continue;
            IntXL sizeInPixels = varblock.sizeInPixels();
            for (int iy = 0; iy < sizeInPixels.y; ++iy) {
                int y2 = varblock.pixelPosInLFGroup.y + iy;
                int fy = y2 >> 6;
                boolean by = fy << 6 == y2;
                float[] xF = xFactors[fy];
                float[] bF = bFactors[fy];
                int[] hfX = xFactorHF[fy];
                int[] hfB = bFactorHF[fy];
                for (int ix = 0; ix < sizeInPixels.x; ++ix) {
                    float kB;
                    float kX;
                    int x3 = varblock.pixelPosInLFGroup.x + ix;
                    int fx = x3 >> 6;
                    if (by && fx << 6 == x3) {
                        kX = lfc.baseX + (float)hfX[fx] / (float)lfc.factor;
                        kB = lfc.baseB + (float)hfB[fx] / (float)lfc.factor;
                        xF[fx] = kX;
                        bF[fx] = kB;
                    } else {
                        kX = xF[fx];
                        kB = bF[fx];
                    }
                    float dequantY = this.dequantHFCoeff[1][varblock.pixelPosInGroup.y + iy][varblock.pixelPosInGroup.x + ix];
                    float[] fArray = this.dequantHFCoeff[0][varblock.pixelPosInGroup.y + iy];
                    int n2 = varblock.pixelPosInGroup.x + ix;
                    fArray[n2] = fArray[n2] + kX * dequantY;
                    float[] fArray2 = this.dequantHFCoeff[2][varblock.pixelPosInGroup.y + iy];
                    int n3 = varblock.pixelPosInGroup.x + ix;
                    fArray2[n3] = fArray2[n3] + kB * dequantY;
                }
            }
        }
    }

    void finalizeLLF() {
        float[][][] scratchBlock = new float[2][256][256];
        IntXL[] shift = this.frame.getFrameHeader().jpegUpsampling;
        for (VBlock varblock : this.varblocks) {
            if (varblock == null) continue;
            IntXL size = varblock.sizeInBlocks();
            ITX tt = varblock.transformType();
            for (int c2 = 0; c2 < 3; ++c2) {
                if (!varblock.isCorner(shift[c2])) continue;
                float[][] dqlf = this.lfg.lfCoeff.dequantLFCoeff[c2];
                float[][] dq = this.dequantHFCoeff[c2];
                IntXL ppg = varblock.pixelPosInGroup.toRight(shift[c2]);
                MathXL.forwardDCT2D(dqlf, dq, varblock.blockPosInLFGroup.toRight(shift[c2]), ppg, size, scratchBlock[0], scratchBlock[1]);
                for (int y2 = 0; y2 < size.y; ++y2) {
                    float[] dqy = dq[y2 + ppg.y];
                    float[] llfy = tt.llfScale[y2];
                    for (int x2 = 0; x2 < size.x; ++x2) {
                        int n2 = x2 + ppg.x;
                        dqy[n2] = dqy[n2] * llfy[x2];
                    }
                }
            }
        }
    }

    private int getBlockContext(int c2, int orderID, int hfMult, int lfIndex) {
        int idx = (c2 < 2 ? 1 - c2 : c2) * 13 + orderID;
        idx *= this.hfctx.qfThresholds.length + 1;
        for (int t2 : this.hfctx.qfThresholds) {
            if (hfMult <= t2) continue;
            ++idx;
        }
        return this.hfctx.clusterMap[(idx *= this.hfctx.numLFContexts) + lfIndex];
    }

    private int getNonZeroContext(int predicted, int ctx) {
        if (predicted > 64) {
            predicted = 64;
        }
        if (predicted < 8) {
            return ctx + this.hfctx.numClusters * predicted;
        }
        return ctx + this.hfctx.numClusters * (4 + predicted / 2);
    }

    private static int getCoeffContext(int k2, int nonZeroes, int numBlocks, int prev) {
        nonZeroes = (nonZeroes + numBlocks - 1) / numBlocks;
        return (NONZEROS[nonZeroes] + FREQUENCIES[k2 /= numBlocks]) * 2 + prev;
    }

    private int getPredictedNonZeroes(int c2, IntXL pos) {
        if (pos.x == 0 && pos.y == 0) {
            return 32;
        }
        if (pos.x == 0) {
            return this.nonZeroes[c2][pos.y - 1][0];
        }
        if (pos.y == 0) {
            return this.nonZeroes[c2][0][pos.x - 1];
        }
        return this.nonZeroes[c2][pos.y - 1][pos.x] + this.nonZeroes[c2][pos.y][pos.x - 1] + 1 >> 1;
    }

    private void dequantizeHFCoefficients() {
        Inverse matrix = this.frame.globalMetadata.getOpsinInverseMatrix();
        float globalScale = 65536.0f / (float)this.frame.getLFGlobal().quantizer.globalScale;
        float[] scaleFactor = new float[]{globalScale * (float)Math.pow(0.8, this.frame.getFrameHeader().xqmScale - 2), globalScale, globalScale * (float)Math.pow(0.8, this.frame.getFrameHeader().bqmScale - 2)};
        float[][][][] weights = this.frame.getHFGlobal().weights;
        IntXL[] shift = this.frame.getFrameHeader().jpegUpsampling;
        for (VBlock varblock : this.varblocks) {
            if (varblock == null) continue;
            ITX tt = varblock.transformType();
            boolean flip = tt.flip();
            float[][][] w2 = weights[tt.idx];
            for (int c2 = 0; c2 < 3; ++c2) {
                if (!varblock.isCorner(shift[c2])) continue;
                float[][] w3 = w2[c2];
                float qbc = matrix.quantBias[c2];
                float sfc = scaleFactor[c2] / (float)varblock.hfMult();
                IntXL ppg = varblock.pixelPosInGroup.toRight(shift[c2]);
                for (int y2 = 0; y2 < tt.blockH; ++y2) {
                    for (int x2 = 0; x2 < tt.blockW; ++x2) {
                        float quant;
                        int coeff = this.quantizedCoeffs[c2][ppg.y + y2][ppg.x + x2];
                        switch (coeff) {
                            case 0: {
                                quant = 0.0f;
                                break;
                            }
                            case 1: {
                                quant = qbc;
                                break;
                            }
                            case -1: {
                                quant = -qbc;
                                break;
                            }
                            default: {
                                quant = (float)coeff - matrix.quantBiasNumerator / (float)coeff;
                            }
                        }
                        int wx = flip ? y2 : x2;
                        int wy = y2 ^ x2 ^ wx;
                        this.dequantHFCoeff[c2][ppg.y + y2][ppg.x + x2] = quant * sfc * w3[wy][wx];
                    }
                }
            }
        }
    }
}

