/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.Configure;
import com.idrsolutions.image.jpegXL.data.Entropy;
import com.idrsolutions.image.jpegXL.data.ExFunction;
import com.idrsolutions.image.jpegXL.data.FunctionalHelper;
import com.idrsolutions.image.jpegXL.data.HFGlobal;
import com.idrsolutions.image.jpegXL.data.HFPass;
import com.idrsolutions.image.jpegXL.data.HeaderFrame;
import com.idrsolutions.image.jpegXL.data.HeaderImage;
import com.idrsolutions.image.jpegXL.data.HelperXL;
import com.idrsolutions.image.jpegXL.data.ITX;
import com.idrsolutions.image.jpegXL.data.IntXL;
import com.idrsolutions.image.jpegXL.data.JXLXor;
import com.idrsolutions.image.jpegXL.data.LFGlobal;
import com.idrsolutions.image.jpegXL.data.LFGroup;
import com.idrsolutions.image.jpegXL.data.MTree;
import com.idrsolutions.image.jpegXL.data.MathXL;
import com.idrsolutions.image.jpegXL.data.ModularChannel;
import com.idrsolutions.image.jpegXL.data.ModularInfo;
import com.idrsolutions.image.jpegXL.data.Pass;
import com.idrsolutions.image.jpegXL.data.PassGroup;
import com.idrsolutions.image.jpegXL.data.Spline;
import com.idrsolutions.image.jpegXL.data.TaskList;
import com.idrsolutions.image.jpegXL.data.VBlock;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntUnaryOperator;

class Frame {
    static final int[] cMap = new int[]{1, 0, 2};
    private static final IntXL[] epfCross = new IntXL[]{IntXL.ZERO, new IntXL(0, 1), new IntXL(1, 0), new IntXL(-1, 0), new IntXL(0, -1)};
    private static final IntXL[] epfDoubleCross = new IntXL[]{IntXL.ZERO, new IntXL(-1, 0), new IntXL(0, -1), new IntXL(1, 0), new IntXL(0, 1), new IntXL(1, -1), new IntXL(1, 1), new IntXL(-1, -1), new IntXL(-1, 1), new IntXL(2, 0), new IntXL(0, 2), new IntXL(-2, 0), new IntXL(-2, 2)};
    private static float[][] laplacian;
    private BitXL globalReader;
    private HeaderFrame header;
    private int numGroups;
    private int numLFGroups;
    private CompletableFuture<byte[]>[] buffers;
    private int[] tocPermuation;
    private int[] tocLengths;
    private LFGlobal lfGlobal;
    final HeaderImage globalMetadata;
    float[][][] buffer;
    float[][][] noiseBuffer;
    private Pass[] passes;
    private boolean decoded;
    private HFGlobal hfGlobal;
    private LFGroup[] lfGroups;
    private int groupRowStride;
    private int lfGroupRowStride;
    private MTree globalTree;
    private int width;
    private int height;
    private final HelperXL flowHelper;
    private final Configure options;

    Frame(BitXL reader, HeaderImage globalMetadata, HelperXL flowHelper, Configure options) {
        this.globalReader = reader;
        this.globalMetadata = globalMetadata;
        this.flowHelper = flowHelper;
        this.options = options;
    }

    private void readHeader() throws IOException {
        this.globalReader.zeroPadToByte();
        this.header = new HeaderFrame(this.globalReader, this.globalMetadata);
        this.width = this.header.width;
        this.height = this.header.height;
        this.width = MathXL.ceilDiv(this.width, this.header.upsampling);
        this.height = MathXL.ceilDiv(this.height, this.header.upsampling);
        this.width = MathXL.ceilDiv(this.width, 1 << 3 * this.header.lfLevel);
        this.height = MathXL.ceilDiv(this.height, 1 << 3 * this.header.lfLevel);
        this.groupRowStride = MathXL.ceilDiv(this.width, this.header.groupDim);
        this.lfGroupRowStride = MathXL.ceilDiv(this.width, this.header.groupDim << 3);
        this.numGroups = this.groupRowStride * MathXL.ceilDiv(this.height, this.header.groupDim);
        this.numLFGroups = this.lfGroupRowStride * MathXL.ceilDiv(this.height, this.header.groupDim << 3);
        this.readTOC();
    }

    HeaderFrame readFrameHeader() throws IOException {
        this.readHeader();
        return this.header;
    }

    HeaderFrame getFrameHeader() {
        return this.header;
    }

    void skipFrameData() throws IOException {
        for (int i2 = 0; i2 < this.tocLengths.length; ++i2) {
            this.globalReader.skipBits((long)this.tocLengths[i2] << 3);
        }
    }

    private void readTOC() throws IOException {
        int i2;
        int tocEntries = this.numGroups == 1 && this.header.passes.numPasses == 1 ? 1 : 1 + this.numLFGroups + 1 + this.numGroups * this.header.passes.numPasses;
        boolean permutedTOC = this.globalReader.bool();
        if (permutedTOC) {
            Entropy tocStream = new Entropy(this.globalReader, 8);
            this.tocPermuation = Frame.readPermutation(this.globalReader, tocStream, tocEntries, 0);
        } else {
            this.tocPermuation = new int[tocEntries];
            for (int i3 = 0; i3 < tocEntries; ++i3) {
                this.tocPermuation[i3] = i3;
            }
        }
        this.globalReader.zeroPadToByte();
        this.tocLengths = new int[tocEntries];
        this.buffers = new CompletableFuture[tocEntries];
        for (i2 = 0; i2 < tocEntries; ++i2) {
            this.buffers[i2] = new CompletableFuture();
        }
        for (i2 = 0; i2 < tocEntries; ++i2) {
            this.tocLengths[i2] = this.globalReader.u32(0, 10, 1024, 14, 17408, 22, 0x404400, 30);
        }
        this.globalReader.zeroPadToByte();
        if (tocEntries != 1 && !this.options.parseOnly) {
            new Thread(() -> {
                for (int i2 = 0; i2 < tocEntries; ++i2) {
                    try {
                        byte[] buffer = this.readBuffer(i2);
                        this.buffers[i2].complete(buffer);
                        continue;
                    }
                    catch (Throwable ex) {
                        this.buffers[i2].completeExceptionally(ex);
                    }
                }
            }).start();
        }
    }

    private byte[] readBuffer(int index) throws IOException {
        int length = this.tocLengths[index];
        byte[] buffer = new byte[length + 4];
        this.globalReader.read(buffer, 0, length);
        return buffer;
    }

    private CompletableFuture<BitXL> getBitreader(int index) {
        if (this.tocLengths.length == 1) {
            return CompletableFuture.completedFuture(this.globalReader);
        }
        int permutedIndex = this.tocPermuation[index];
        return this.buffers[permutedIndex].thenApply(buff -> new BitXL(new ByteArrayInputStream((byte[])buff)));
    }

    static int[] readPermutation(BitXL reader, Entropy stream, int size, int skip) throws IOException {
        IntUnaryOperator ctx = x2 -> Math.min(7, MathXL.ceilLog1p(x2));
        int end = stream.readSymbol(reader, ctx.applyAsInt(size));
        int[] lehmer = new int[size];
        for (int i2 = skip; i2 < end + skip; ++i2) {
            lehmer[i2] = stream.readSymbol(reader, ctx.applyAsInt(i2 > skip ? lehmer[i2 - 1] : 0));
        }
        LinkedList<Integer> temp = new LinkedList<Integer>();
        int[] permutation = new int[size];
        for (int i3 = 0; i3 < size; ++i3) {
            temp.add(i3);
        }
        for (int i4 = 0; i4 < size; ++i4) {
            int index = lehmer[i4];
            permutation[i4] = (Integer)temp.remove(index);
        }
        return permutation;
    }

    private float[][] doUpsampling(float[][] buffer, int c2) {
        int color = this.getColorChannelCount();
        int k2 = c2 < color ? this.header.upsampling : this.header.ecUpsampling[c2 - color];
        if (k2 == 1) {
            return buffer;
        }
        int l2 = MathXL.ceilLog1p(k2 - 1) - 1;
        float[][][][] upWeights = this.globalMetadata.getUpWeights()[l2];
        float[][] newBuffer = new float[buffer.length * k2][];
        for (int y2 = 0; y2 < buffer.length; ++y2) {
            for (int ky = 0; ky < k2; ++ky) {
                newBuffer[y2 * k2 + ky] = new float[buffer[y2].length * k2];
                for (int x2 = 0; x2 < buffer[y2].length; ++x2) {
                    for (int kx = 0; kx < k2; ++kx) {
                        float[][] weights = upWeights[ky][kx];
                        float total = 0.0f;
                        float min = Float.MAX_VALUE;
                        float max = Float.MIN_VALUE;
                        for (int iy = 0; iy < 5; ++iy) {
                            for (int ix = 0; ix < 5; ++ix) {
                                int newX;
                                int newY = MathXL.mirror(y2 + iy - 2, buffer.length);
                                float sample = buffer[newY][newX = MathXL.mirror(x2 + ix - 2, buffer[newY].length)];
                                if (sample < min) {
                                    min = sample;
                                }
                                if (sample > max) {
                                    max = sample;
                                }
                                total += weights[iy][ix] * sample;
                            }
                        }
                        newBuffer[y2 * k2 + ky][x2 * k2 + kx] = MathXL.clamp(total, min, max);
                    }
                }
            }
        }
        return newBuffer;
    }

    private void decodeLFGroups(float[][][] lfBuffer) throws IOException {
        int lfGroupID;
        ArrayList<ModularInfo> lfReplacementChannels = new ArrayList<ModularInfo>();
        ArrayList<Integer> lfReplacementChannelIndicies = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.lfGlobal.gModular.stream.getEncodedChannelCount(); ++i2) {
            ModularChannel chan = this.lfGlobal.gModular.stream.getChannel(i2);
            if (chan.isDecoded() || chan.hshift < 3 || chan.vshift < 3) continue;
            lfReplacementChannelIndicies.add(i2);
            IntXL size = new IntXL(this.header.lfGroupDim).toRight(chan.hshift, chan.vshift);
            lfReplacementChannels.add(new ModularInfo(size.x, size.y, chan.hshift, chan.vshift));
        }
        this.lfGroups = new LFGroup[this.numLFGroups];
        for (lfGroupID = 0; lfGroupID < this.numLFGroups; ++lfGroupID) {
            BitXL reader = FunctionalHelper.join(this.getBitreader(1 + lfGroupID));
            IntXL lfGroupPos = IntXL.coordinates(lfGroupID, this.lfGroupRowStride);
            ModularInfo[] replaced = (ModularInfo[])lfReplacementChannels.stream().map(ModularInfo::new).toArray(ModularInfo[]::new);
            IntXL frameSize = this.getPaddedFrameSize();
            for (ModularInfo info : replaced) {
                IntXL shift = new IntXL(info.hshift, info.vshift);
                IntXL lfSize = frameSize.toRight(shift);
                IntXL chanSize = new IntXL(info.width, info.height);
                IntXL pos = lfGroupPos.times(chanSize);
                IntXL size = chanSize.min(lfSize.minus(pos));
                info.width = size.x;
                info.height = size.y;
                info.origin = pos;
            }
            this.lfGroups[lfGroupID] = new LFGroup(reader, this, lfGroupID, replaced, lfBuffer);
        }
        for (lfGroupID = 0; lfGroupID < this.numLFGroups; ++lfGroupID) {
            for (int j2 = 0; j2 < lfReplacementChannelIndicies.size(); ++j2) {
                int index = (Integer)lfReplacementChannelIndicies.get(j2);
                ModularChannel channel = this.lfGlobal.gModular.stream.getChannel(index);
                int[][] newChannel = this.lfGroups[lfGroupID].modularLFGroupBuffer[j2];
                ModularInfo newChannelInfo = this.lfGroups[lfGroupID].modularLFGroupInfo[j2];
                for (int y2 = 0; y2 < newChannel.length; ++y2) {
                    System.arraycopy(newChannel[y2], 0, channel.buffer[y2 + newChannelInfo.origin.y], newChannelInfo.origin.x, newChannel[y2].length);
                }
            }
        }
    }

    private void decodePasses(BitXL reader) throws IOException {
        this.passes = new Pass[this.header.passes.numPasses];
        for (int pass = 0; pass < this.passes.length; ++pass) {
            this.passes[pass] = new Pass(reader, this, pass, pass > 0 ? this.passes[pass - 1].minShift : 0);
        }
    }

    private void decodePassGroups() {
        int numPasses = this.passes.length;
        PassGroup[][] passGroups = new PassGroup[numPasses][];
        TaskList<PassGroup> taskList = new TaskList<PassGroup>(this.flowHelper.getThreadPool(), numPasses);
        for (int pass : HelperXL.range(numPasses)) {
            for (int group : HelperXL.range(this.numGroups)) {
                taskList.submit(pass, this.getBitreader(2 + this.numLFGroups + pass * this.numGroups + group), reader -> {
                    ModularInfo[] replaced;
                    for (ModularInfo info : replaced = (ModularInfo[])Arrays.asList(this.passes[pass].replacedChannels).stream().filter(Objects::nonNull).map(ModularInfo::new).toArray(ModularInfo[]::new)) {
                        IntXL shift = new IntXL(info.hshift, info.vshift);
                        IntXL passGroupSize = new IntXL(this.header.groupDim).toRight(shift);
                        int rowStride = MathXL.ceilDiv(info.width, passGroupSize.x);
                        IntXL pos = IntXL.coordinates(group, rowStride).times(passGroupSize);
                        IntXL chanSize = new IntXL(info.width, info.height);
                        info.origin = pos;
                        IntXL size = passGroupSize.min(chanSize.minus(info.origin));
                        info.width = size.x;
                        info.height = size.y;
                    }
                    return new PassGroup((BitXL)reader, this, pass, group, replaced);
                });
            }
        }
        for (int pass = 0; pass < numPasses; ++pass) {
            passGroups[pass] = taskList.collect(pass).toArray(new PassGroup[0]);
            int j2 = 0;
            for (int i2 = 0; i2 < this.passes[pass].replacedChannels.length; ++i2) {
                if (this.passes[pass].replacedChannels[i2] == null) continue;
                ModularChannel channel = this.lfGlobal.gModular.stream.getChannel(i2);
                for (int group = 0; group < this.numGroups; ++group) {
                    ModularInfo newChannelInfo = passGroups[pass][group].modularPassGroupInfo[j2];
                    int[][] buff = passGroups[pass][group].modularPassGroupBuffer[j2];
                    for (int y2 = 0; y2 < newChannelInfo.height; ++y2) {
                        System.arraycopy(buff[y2], 0, channel.buffer[y2 + newChannelInfo.origin.y], newChannelInfo.origin.x, newChannelInfo.width);
                    }
                }
                ++j2;
            }
        }
        if (this.header.encoding == 0) {
            for (int pass : HelperXL.range(numPasses)) {
                for (int group : HelperXL.range(this.numGroups)) {
                    PassGroup passGroup = passGroups[pass][group];
                    PassGroup prev = pass > 0 ? passGroups[pass - 1][group] : null;
                    passGroup.invertVarDCT(this.buffer, prev);
                }
            }
        }
    }

    void decodeFrame(float[][][] lfBuffer) throws IOException {
        if (this.decoded) {
            return;
        }
        this.decoded = true;
        this.lfGlobal = (LFGlobal)FunctionalHelper.join(this.getBitreader(0).thenApplyAsync(ExFunction.of(reader -> new LFGlobal((BitXL)reader, this))));
        IntXL paddedSize = this.getPaddedFrameSize();
        this.buffer = new float[this.getColorChannelCount() + this.globalMetadata.getExtraChannelCount()][][];
        for (int c2 = 0; c2 < this.buffer.length; ++c2) {
            if (c2 < 3 && c2 < this.getColorChannelCount()) {
                IntXL shiftedSize = paddedSize.toRight(this.header.jpegUpsampling[c2]);
                this.buffer[c2] = new float[shiftedSize.y][shiftedSize.x];
                continue;
            }
            this.buffer[c2] = new float[paddedSize.y][paddedSize.x];
        }
        this.decodeLFGroups(lfBuffer);
        BitXL hfGlobalReader = FunctionalHelper.join(this.getBitreader(1 + this.numLFGroups));
        this.hfGlobal = this.header.encoding == 0 ? new HFGlobal(hfGlobalReader, this) : null;
        this.decodePasses(hfGlobalReader);
        this.decodePassGroups();
        this.lfGlobal.gModular.stream.applyTransforms();
        int[][][] modularBuffer = this.lfGlobal.gModular.stream.getDecodedBuffer();
        for (int c3 = 0; c3 < modularBuffer.length; ++c3) {
            int x2;
            int y2;
            boolean isModularColor = this.header.encoding == 1 && c3 < this.getColorChannelCount();
            boolean isModularXYB = this.globalMetadata.isXYBEncoded() && isModularColor;
            int cOut = (isModularXYB ? cMap[c3] : c3) + this.buffer.length - modularBuffer.length;
            int ecIndex = c3 - (this.header.encoding == 1 ? this.globalMetadata.getColorChannelCount() : 0);
            float scaleFactor = isModularXYB ? this.lfGlobal.lfDequant[cOut] : (isModularColor && this.globalMetadata.getBitDepthHeader().expBits != 0 ? 1.0f : (isModularColor ? 1.0f / (float)(-1L << this.globalMetadata.getBitDepthHeader().bitsPerSample ^ 0xFFFFFFFFFFFFFFFFL) : (this.globalMetadata.getExtraChannel((int)ecIndex).bitDepth.expBits != 0 ? 1.0f : 1.0f / (float)(-1L << this.globalMetadata.getExtraChannel((int)ecIndex).bitDepth.bitsPerSample ^ 0xFFFFFFFFFFFFFFFFL))));
            if (isModularXYB && c3 == 2) {
                for (y2 = 0; y2 < this.height; ++y2) {
                    for (x2 = 0; x2 < this.width; ++x2) {
                        this.buffer[cOut][y2][x2] = scaleFactor * (float)(modularBuffer[0][y2][x2] + modularBuffer[2][y2][x2]);
                    }
                }
                continue;
            }
            for (y2 = 0; y2 < this.height; ++y2) {
                for (x2 = 0; x2 < this.width; ++x2) {
                    this.buffer[cOut][y2][x2] = scaleFactor * (float)modularBuffer[c3][y2][x2];
                }
            }
        }
        this.invertSubsampling();
        if (this.header.restorationFilter.gab) {
            this.performGabConvolution();
        }
        if (this.header.restorationFilter.epfIterations > 0) {
            this.performEdgePreservingFilter();
        }
    }

    void drawVarblocks() {
        for (LFGroup lfg : this.lfGroups) {
            IntXL pixelPosInFrame = this.getLFGroupXY(lfg.lfGroupID).toLeft(11);
            for (int i2 = 0; i2 < lfg.hfMetadata.blockList.length; ++i2) {
                VBlock varblock = lfg.hfMetadata.getVBlock(i2);
                ITX tt = varblock.transformType();
                float hue = (float)tt.type * MathXL.PHI_BAR % 1.0f * 2.0f * (float)Math.PI;
                float rFactor = ((float)Math.cos(hue) + 0.5f) / 1.5f;
                float gFactor = ((float)Math.cos(hue - 2.0943952f) + 1.0f) / 2.0f;
                float bFactor = ((float)Math.cos(hue - 4.1887903f) + 1.0f) / 2.0f;
                IntXL corner = varblock.pixelPosInLFGroup.plus(pixelPosInFrame);
                IntXL size = varblock.sizeInPixels();
                for (int y2 = 0; y2 < size.y; ++y2) {
                    for (int x2 = 0; x2 < size.x; ++x2) {
                        float sampleR = this.buffer[0][y2 + corner.y][x2 + corner.x];
                        float sampleG = this.buffer[1][y2 + corner.y][x2 + corner.x];
                        float sampleB = this.buffer[2][y2 + corner.y][x2 + corner.x];
                        if (x2 == 0 || y2 == 0) {
                            this.buffer[1][y2 + corner.y][x2 + corner.x] = 0.0f;
                            this.buffer[0][y2 + corner.y][x2 + corner.x] = 0.0f;
                            this.buffer[2][y2 + corner.y][x2 + corner.x] = 0.0f;
                            continue;
                        }
                        float light = 0.25f * (sampleR + sampleB) + 0.5f * sampleG;
                        light = 0.5f * ((float)Math.cbrt(light) - 0.5f) + 0.5f;
                        this.buffer[0][y2 + corner.y][x2 + corner.x] = rFactor * 0.5f + 0.5f * sampleR / light;
                        this.buffer[1][y2 + corner.y][x2 + corner.x] = gFactor * 0.5f + 0.5f * sampleG / light;
                        this.buffer[2][y2 + corner.y][x2 + corner.x] = bFactor * 0.5f + 0.5f * sampleB / light;
                    }
                }
            }
        }
    }

    private void performGabConvolution() {
        float[][] normGabW = new float[3][this.getColorChannelCount()];
        for (int c2 = 0; c2 < this.getColorChannelCount(); ++c2) {
            float mult;
            float gabW1 = this.header.restorationFilter.gab1Weights[c2];
            float gabW2 = this.header.restorationFilter.gab2Weights[c2];
            normGabW[0][c2] = mult = 1.0f / (1.0f + 4.0f * (gabW1 + gabW2));
            normGabW[1][c2] = gabW1 * mult;
            normGabW[2][c2] = gabW2 * mult;
        }
        for (int c3 : HelperXL.range(this.getColorChannelCount())) {
            float[][] buffC = this.buffer[c3];
            int hh = buffC.length;
            int ww = buffC[0].length;
            float[][] newBuffer = new float[hh][ww];
            for (int y2 : HelperXL.range(hh)) {
                int north = MathXL.mirror(y2 - 1, hh);
                int south = MathXL.mirror(y2 + 1, hh);
                float[] buffR = buffC[y2];
                float[] buffN = buffC[north];
                float[] buffS = buffC[south];
                float[] newBuffR = newBuffer[y2];
                for (int x2 = 0; x2 < ww; ++x2) {
                    int west = MathXL.mirror(x2 - 1, ww);
                    int east = MathXL.mirror(x2 + 1, ww);
                    float adj = buffR[west] + buffR[east] + buffN[x2] + buffS[x2];
                    float diag = buffN[west] + buffN[east] + buffS[west] + buffS[east];
                    newBuffR[x2] = normGabW[0][c3] * buffR[x2] + normGabW[1][c3] * adj + normGabW[2][c3] * diag;
                }
            }
            this.buffer[c3] = newBuffer;
        }
    }

    private void performEdgePreservingFilter() {
        int y2;
        float stepMultiplier = (float)(6.6 * (1.0 - (double)MathXL.SQRT_H));
        IntXL size = this.getPaddedFrameSize();
        int blockW = MathXL.ceilDiv(size.x, 8);
        int blockH = MathXL.ceilDiv(size.y, 8);
        float[][] inverseSigma = new float[blockH][blockW];
        int dimS = this.header.logLFGroupDim - 3;
        CompletableFuture[] futures = new CompletableFuture[size.y];
        if (this.header.encoding == 1) {
            float inv = 1.0f / this.header.restorationFilter.epfSigmaForModular;
            for (y2 = 0; y2 < blockH; ++y2) {
                Arrays.fill(inverseSigma[y2], inv);
            }
        } else {
            int y0 = 0;
            while (y0 < blockH) {
                y2 = y0++;
                float[] invSY = inverseSigma[y2];
                int lfY = y2 >> dimS;
                int bY = y2 - (lfY << dimS);
                int lfR = lfY * this.lfGroupRowStride;
                futures[y2] = CompletableFuture.runAsync(() -> {
                    for (int x2 = 0; x2 < blockW; ++x2) {
                        int lfX = x2 >> dimS;
                        int bX = x2 - (lfX << dimS);
                        LFGroup lfg = this.lfGroups[lfR + lfX];
                        int hf = lfg.hfMetadata.blockMap[bY][bX].hfMult();
                        int sharpness = lfg.hfMetadata.hfStreamBuffer[3][bY][bX];
                        float sigma = (float)hf * this.header.restorationFilter.epfSharpLut[sharpness];
                        invSY[x2] = 1.0f / sigma;
                    }
                });
            }
            for (int y3 = 0; y3 < blockH; ++y3) {
                futures[y3].join();
            }
        }
        float[][][] outputBuffer = new float[this.getColorChannelCount()][size.y][size.x];
        for (int i2 : HelperXL.range(3)) {
            if (i2 == 0 && this.header.restorationFilter.epfIterations < 3) continue;
            if (i2 == 2 && this.header.restorationFilter.epfIterations < 2) break;
            float sigmaScale = stepMultiplier * (i2 == 0 ? this.header.restorationFilter.epfPass0SigmaScale : (i2 == 1 ? 1.0f : this.header.restorationFilter.epfPass2SigmaScale));
            IntXL[] pc = i2 == 0 ? epfDoubleCross : epfCross;
            for (int y4 : HelperXL.range(size.y)) {
                float[] invSY = inverseSigma[y4 >> 3];
                futures[y4] = CompletableFuture.runAsync(() -> {
                    for (int x2 = 0; x2 < size.x; ++x2) {
                        int c2;
                        float sumWeights = 0.0f;
                        float[] sumChannels = new float[outputBuffer.length];
                        float s2 = invSY[x2 >> 3];
                        if (s2 != s2 || s2 > 3.3333333f) {
                            for (c2 = 0; c2 < outputBuffer.length; ++c2) {
                                outputBuffer[c2][y2][x2] = this.buffer[c2][y4][x2];
                            }
                            continue;
                        }
                        for (IntXL ip : pc) {
                            int nX = x2 + ip.x;
                            int nY = y4 + ip.y;
                            int mX = MathXL.mirror(nX, size.x);
                            int mY = MathXL.mirror(nY, size.y);
                            float dist = i2 == 2 ? this.epfDistance2(this.buffer, outputBuffer.length, x2, y4, nX, nY, size) : this.epfDistance1(this.buffer, outputBuffer.length, x2, y4, nX, nY, size);
                            float weight = this.epfWeight(sigmaScale, dist, s2, x2, y4);
                            sumWeights += weight;
                            for (int c3 = 0; c3 < outputBuffer.length; ++c3) {
                                int n2 = c3;
                                sumChannels[n2] = sumChannels[n2] + this.buffer[c3][mY][mX] * weight;
                            }
                        }
                        for (c2 = 0; c2 < outputBuffer.length; ++c2) {
                            outputBuffer[c2][y2][x2] = sumChannels[c2] / sumWeights;
                        }
                    }
                });
            }
            for (int y5 = 0; y5 < size.y; ++y5) {
                futures[y5].join();
            }
            for (int c2 = 0; c2 < outputBuffer.length; ++c2) {
                float[][] tmp = this.buffer[c2];
                this.buffer[c2] = outputBuffer[c2];
                outputBuffer[c2] = tmp;
            }
        }
    }

    private float epfDistance1(float[][][] buffer, int colors, int basePosX, int basePosY, int distPosX, int distPosY, IntXL size) {
        float dist = 0.0f;
        for (int c2 = 0; c2 < colors; ++c2) {
            float[][] buffC = buffer[c2];
            float scale = this.header.restorationFilter.epfChannelScale[c2];
            for (IntXL p2 : epfCross) {
                int pX = MathXL.mirror(basePosX + p2.x, size.x);
                int pY = MathXL.mirror(basePosY + p2.y, size.y);
                int dX = MathXL.mirror(distPosX + p2.x, size.x);
                int dY = MathXL.mirror(distPosY + p2.y, size.y);
                dist += Math.abs(buffC[pY][pX] - buffC[dY][dX]) * scale;
            }
        }
        return dist;
    }

    private float epfDistance2(float[][][] buffer, int colors, int basePosX, int basePosY, int distPosX, int distPosY, IntXL size) {
        float dist = 0.0f;
        for (int c2 = 0; c2 < colors; ++c2) {
            float[][] buffC = buffer[c2];
            int dX = MathXL.mirror(distPosX, size.x);
            int dY = MathXL.mirror(distPosY, size.y);
            dist += Math.abs(buffC[basePosY][basePosX] - buffC[dY][dX]) * this.header.restorationFilter.epfChannelScale[c2];
        }
        return dist;
    }

    private float epfWeight(float stepMultiplier, float distance, float inverseSigma, int refX, int refY) {
        int modX = refX & 7;
        int modY = refY & 7;
        float dist = modX == 0 || modX == 7 || modY == 0 || modY == 7 ? distance * this.header.restorationFilter.epfBorderSadMul : distance;
        float v2 = 1.0f - dist * stepMultiplier * inverseSigma;
        if (v2 <= 0.0f) {
            return 0.0f;
        }
        return v2;
    }

    private void invertSubsampling() {
        for (int c2 = 0; c2 < 3; ++c2) {
            float[] oldRow;
            int y2;
            float[][] newChannel;
            float[][] oldChannel;
            int xShift = this.header.jpegUpsampling[c2].x;
            int yShift = this.header.jpegUpsampling[c2].y;
            while (xShift-- > 0) {
                oldChannel = this.buffer[c2];
                newChannel = new float[oldChannel.length][];
                for (y2 = 0; y2 < oldChannel.length; ++y2) {
                    oldRow = oldChannel[y2];
                    float[] newRow = new float[oldRow.length * 2];
                    for (int x2 = 0; x2 < oldRow.length; ++x2) {
                        float b75 = 0.75f * oldRow[x2];
                        newRow[2 * x2] = b75 + 0.25f * oldRow[x2 == 0 ? 0 : x2 - 1];
                        newRow[2 * x2 + 1] = b75 + 0.25f * oldRow[x2 + 1 == oldRow.length ? oldRow.length - 1 : x2 + 1];
                    }
                    newChannel[y2] = newRow;
                }
                this.buffer[c2] = newChannel;
            }
            while (yShift-- > 0) {
                oldChannel = this.buffer[c2];
                newChannel = new float[oldChannel.length * 2][];
                for (y2 = 0; y2 < oldChannel.length; ++y2) {
                    oldRow = oldChannel[y2];
                    float[] oldRowPrev = oldChannel[y2 == 0 ? 0 : y2 - 1];
                    float[] oldRowNext = oldChannel[y2 + 1 == oldChannel.length ? oldChannel.length - 1 : y2 + 1];
                    float[] firstNewRow = new float[oldRow.length];
                    float[] secondNewRow = new float[oldRow.length];
                    for (int x3 = 0; x3 < oldRow.length; ++x3) {
                        float b75 = 0.75f * oldRow[x3];
                        firstNewRow[x3] = b75 + 0.25f * oldRowPrev[x3];
                        secondNewRow[x3] = b75 + 0.25f * oldRowNext[x3];
                    }
                    newChannel[2 * y2] = firstNewRow;
                    newChannel[2 * y2 + 1] = secondNewRow;
                }
                this.buffer[c2] = newChannel;
            }
        }
    }

    void upsample() {
        for (int c2 = 0; c2 < this.buffer.length; ++c2) {
            this.buffer[c2] = this.doUpsampling(this.buffer[c2], c2);
        }
        this.width *= this.header.upsampling;
        this.height *= this.header.upsampling;
        this.header.origin = this.header.origin.times(this.header.upsampling);
    }

    void renderSplines() {
        if (this.lfGlobal.splines == null) {
            return;
        }
        for (int s2 = 0; s2 < this.lfGlobal.splines.numSplines; ++s2) {
            Spline spline = new Spline(this.lfGlobal.splines.points[s2]);
            spline.renderSpline(this);
        }
    }

    void initializeNoise(long s0) {
        if (this.lfGlobal.noiseInfo == null) {
            return;
        }
        int rowStride = MathXL.ceilDiv(this.header.width, this.header.groupDim);
        float[][][] localNoiseBuffer = new float[3][this.header.height][this.header.width];
        int numGroups = rowStride * MathXL.ceilDiv(this.header.height, this.header.groupDim);
        for (int group = 0; group < numGroups; ++group) {
            IntXL groupXYUp = IntXL.coordinates(group, rowStride).times(this.header.upsampling);
            for (int iy = 0; iy < this.header.upsampling; ++iy) {
                for (int ix = 0; ix < this.header.upsampling; ++ix) {
                    int x0 = (groupXYUp.x + ix) * this.header.groupDim;
                    int y0 = (groupXYUp.y + iy) * this.header.groupDim;
                    Frame.readNoiseGroup(this.header, s0, localNoiseBuffer, x0, y0);
                }
            }
        }
        if (laplacian == null) {
            laplacian = new float[5][5];
            for (int i2 = 0; i2 < 5; ++i2) {
                for (int j2 = 0; j2 < 5; ++j2) {
                    Frame.laplacian[i2][j2] = i2 == 2 && j2 == 2 ? -3.84f : 0.16f;
                }
            }
        }
        this.noiseBuffer = new float[3][this.header.height][this.header.width];
        for (int c2 = 0; c2 < 3; ++c2) {
            for (int y2 = 0; y2 < this.header.height; ++y2) {
                for (int x2 = 0; x2 < this.header.width; ++x2) {
                    for (int iy = 0; iy < 5; ++iy) {
                        for (int ix = 0; ix < 5; ++ix) {
                            int cy = MathXL.mirror(y2 + iy - 2, this.header.height);
                            int cx = MathXL.mirror(x2 + ix - 2, this.header.width);
                            float[] fArray = this.noiseBuffer[c2][y2];
                            int n2 = x2;
                            fArray[n2] = fArray[n2] + localNoiseBuffer[c2][cy][cx] * laplacian[iy][ix];
                        }
                    }
                }
            }
        }
    }

    void synthesizeNoise() {
        if (this.lfGlobal.noiseInfo == null) {
            return;
        }
        float[] lut = this.lfGlobal.noiseInfo.lut;
        for (int y2 = 0; y2 < this.header.height; ++y2) {
            int x2 = 0;
            while (x2 < this.header.width) {
                float fracInG;
                int intInG;
                float fracInR;
                float inScaledR = 3.0f * Math.max(0.0f, this.buffer[1][y2][x2] + this.buffer[0][y2][x2]);
                float inScaledG = 3.0f * Math.max(0.0f, this.buffer[1][y2][x2] - this.buffer[0][y2][x2]);
                int intInR = inScaledR >= 7.0f ? 6 : (int)inScaledR;
                float f2 = fracInR = inScaledR >= 7.0f ? 1.0f : inScaledR - (float)intInR;
                if (inScaledG >= 7.0f) {
                    intInG = 6;
                    fracInG = 1.0f;
                } else {
                    intInG = (int)inScaledG;
                    fracInG = inScaledG - (float)intInG;
                }
                float sr = (lut[intInR + 1] - lut[intInR]) * fracInR + lut[intInR];
                float sg = (lut[intInG + 1] - lut[intInG]) * fracInG + lut[intInG];
                float nr = 0.22f * sr * (0.0078125f * this.noiseBuffer[0][y2][x2] + 0.9921875f * this.noiseBuffer[2][y2][x2]);
                float ng = 0.22f * sg * (0.0078125f * this.noiseBuffer[1][y2][x2] + 0.9921875f * this.noiseBuffer[2][y2][x2]);
                float nrg = nr + ng;
                float[] fArray = this.buffer[0][y2];
                int n2 = x2;
                fArray[n2] = fArray[n2] + (this.lfGlobal.lfChanCorr.baseX * nrg + nr - ng);
                float[] fArray2 = this.buffer[1][y2];
                int n3 = x2;
                fArray2[n3] = fArray2[n3] + nrg;
                float[] fArray3 = this.buffer[2][y2];
                int n4 = x2++;
                fArray3[n4] = fArray3[n4] + this.lfGlobal.lfChanCorr.baseB * nrg;
            }
        }
    }

    LFGlobal getLFGlobal() {
        return this.lfGlobal;
    }

    HFGlobal getHFGlobal() {
        return this.hfGlobal;
    }

    HFPass getHFPass(int index) {
        return this.passes[index].hfPass;
    }

    LFGroup getLFGroupForGroup(int group) {
        return this.lfGroups[this.groupXY(group).toRight(3).unwrapCoord(this.lfGroupRowStride)];
    }

    int getNumLFGroups() {
        return this.numLFGroups;
    }

    int getNumGroups() {
        return this.numGroups;
    }

    int getGroupRowStride() {
        return this.groupRowStride;
    }

    float[][][] getBuffer() {
        return this.buffer;
    }

    int getColorChannelCount() {
        return this.globalMetadata.isXYBEncoded() || this.header.encoding == 0 ? 3 : this.globalMetadata.getColorChannelCount();
    }

    IntXL groupXY(int group) {
        return IntXL.coordinates(group, this.groupRowStride);
    }

    IntXL getLFGroupXY(int lfGroup) {
        return IntXL.coordinates(lfGroup, this.lfGroupRowStride);
    }

    IntXL groupSize(int group) {
        IntXL groupxy = this.groupXY(group);
        IntXL paddedSize = this.getPaddedFrameSize();
        return new IntXL(Math.min(this.header.groupDim, paddedSize.x - groupxy.x * this.header.groupDim), Math.min(this.header.groupDim, paddedSize.y - groupxy.y * this.header.groupDim));
    }

    IntXL getLFGroupSize(int lfGroup) {
        IntXL lfGroupXY = this.getLFGroupXY(lfGroup);
        IntXL paddedSize = this.getPaddedFrameSize();
        return new IntXL(Math.min(this.header.lfGroupDim, paddedSize.x - lfGroupXY.x * this.header.lfGroupDim), Math.min(this.header.lfGroupDim, paddedSize.y - lfGroupXY.y * this.header.lfGroupDim));
    }

    IntXL getPaddedFrameSize() {
        if (this.header.encoding == 0) {
            return new IntXL(this.width, this.height).ceilDiv(8).times(8);
        }
        return new IntXL(this.width, this.height);
    }

    IntXL getModularFrameSize() {
        return new IntXL(this.width, this.height);
    }

    MTree getGlobalTree() {
        return this.globalTree;
    }

    void setGlobalTree(MTree tree) {
        this.globalTree = tree;
    }

    boolean isVisible() {
        return !(this.header.type != 0 && this.header.type != 3 || this.header.duration == 0 && !this.header.isLast);
    }

    float getSample(int c2, int x2, int y2) {
        return x2 < this.header.origin.x || y2 < this.header.origin.y || x2 - this.header.origin.x >= this.width || y2 - this.header.origin.y >= this.height ? 0.0f : this.buffer[c2][y2 - this.header.origin.y][x2 - this.header.origin.x];
    }

    private static void readNoiseGroup(HeaderFrame header, long s0, float[][][] noise, int x0, int y0) {
        long s1 = (long)x0 << 32 | (long)y0;
        int xSize = Math.min(header.groupDim, header.width - x0);
        int ySize = Math.min(header.groupDim, header.height - y0);
        JXLXor rng = new JXLXor(s0, s1);
        int[] bits = new int[16];
        for (int c2 = 0; c2 < 3; ++c2) {
            for (int y2 = 0; y2 < ySize; ++y2) {
                for (int x2 = 0; x2 < xSize; x2 += 16) {
                    rng.fill(bits);
                    for (int i2 = 0; i2 < 16 && x2 + i2 < xSize; ++i2) {
                        int f2 = bits[i2] >>> 9 | 0x3F800000;
                        noise[c2][y0 + y2][x0 + x2 + i2] = Float.intBitsToFloat(f2);
                    }
                }
            }
        }
    }
}

