/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Supplier;

class FifoStream
extends InputStream {
    private byte[] buffer;
    private int bufferPos;
    private Supplier<byte[]> supplier;
    private final Queue<byte[]> fifo = new ArrayDeque<byte[]>();
    private InputStream in;

    public FifoStream(Supplier<byte[]> supplier) {
        this.supplier = supplier;
    }

    public FifoStream(InputStream in) {
        this.in = in;
    }

    public void push(byte[] array) {
        this.fifo.add(array);
    }

    private boolean refillBuffer() {
        if (this.buffer == null || this.bufferPos >= this.buffer.length) {
            this.bufferPos = 0;
            this.buffer = this.fifo.poll();
        }
        if (this.buffer == null && this.in == null) {
            this.buffer = this.supplier.get();
        }
        return this.buffer != null && this.buffer.length == 0;
    }

    @Override
    public int available() throws IOException {
        return this.buffer != null ? this.buffer.length - this.bufferPos : (this.in != null ? this.in.available() : 0);
    }

    public byte[] getBalance() {
        if (this.buffer == null || this.bufferPos >= this.buffer.length) {
            return null;
        }
        byte[] result = new byte[this.buffer.length - this.bufferPos];
        System.arraycopy(this.buffer, this.bufferPos, result, 0, result.length);
        this.buffer = this.fifo.poll();
        this.bufferPos = 0;
        return result;
    }

    @Override
    public int read() throws IOException {
        if (this.refillBuffer()) {
            return -1;
        }
        if (this.buffer == null) {
            return this.in.read();
        }
        return 0xFF & this.buffer[this.bufferPos++];
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int offset, int length) throws IOException {
        if (this.refillBuffer()) {
            return -1;
        }
        if (this.buffer == null) {
            return this.in.read(b2, offset, length);
        }
        int count = this.available();
        if (count > length) {
            count = length;
        }
        System.arraycopy(this.buffer, this.bufferPos, b2, offset, count);
        this.bufferPos += count;
        return count;
    }

    @Override
    public long skip(long n2) throws IOException {
        if (n2 <= 0L) {
            return 0L;
        }
        if (this.refillBuffer()) {
            return 0L;
        }
        if (this.buffer == null) {
            long count = Math.min(n2, (long)this.in.available());
            return this.in.skip(count);
        }
        int count = this.available();
        if ((long)count > n2) {
            count = (int)n2;
        }
        this.bufferPos += count;
        return count;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

