/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.ANS;
import com.idrsolutions.image.jpegXL.data.ANSSymbols;
import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.EML;
import com.idrsolutions.image.jpegXL.data.PrefixSymbols;
import com.idrsolutions.image.jpegXL.data.Symbols;
import java.io.IOException;

class Entropy {
    private static final int[][] FIXED_DISTANCES = new int[][]{{0, 1}, {1, 0}, {1, 1}, {-1, 1}, {0, 2}, {2, 0}, {1, 2}, {-1, 2}, {2, 1}, {-2, 1}, {2, 2}, {-2, 2}, {0, 3}, {3, 0}, {1, 3}, {-1, 3}, {3, 1}, {-3, 1}, {2, 3}, {-2, 3}, {3, 2}, {-3, 2}, {0, 4}, {4, 0}, {1, 4}, {-1, 4}, {4, 1}, {-4, 1}, {3, 3}, {-3, 3}, {2, 4}, {-2, 4}, {4, 2}, {-4, 2}, {0, 5}, {3, 4}, {-3, 4}, {4, 3}, {-4, 3}, {5, 0}, {1, 5}, {-1, 5}, {5, 1}, {-5, 1}, {2, 5}, {-2, 5}, {5, 2}, {-5, 2}, {4, 4}, {-4, 4}, {3, 5}, {-3, 5}, {5, 3}, {-5, 3}, {0, 6}, {6, 0}, {1, 6}, {-1, 6}, {6, 1}, {-6, 1}, {2, 6}, {-2, 6}, {6, 2}, {-6, 2}, {4, 5}, {-4, 5}, {5, 4}, {-5, 4}, {3, 6}, {-3, 6}, {6, 3}, {-6, 3}, {0, 7}, {7, 0}, {1, 7}, {-1, 7}, {5, 5}, {-5, 5}, {7, 1}, {-7, 1}, {4, 6}, {-4, 6}, {6, 4}, {-6, 4}, {2, 7}, {-2, 7}, {7, 2}, {-7, 2}, {3, 7}, {-3, 7}, {7, 3}, {-7, 3}, {5, 6}, {-5, 6}, {6, 5}, {-6, 5}, {8, 0}, {4, 7}, {-4, 7}, {7, 4}, {-7, 4}, {8, 1}, {8, 2}, {6, 6}, {-6, 6}, {8, 3}, {5, 7}, {-5, 7}, {7, 5}, {-7, 5}, {8, 4}, {6, 7}, {-6, 7}, {7, 6}, {-7, 6}, {8, 5}, {7, 7}, {-7, 7}, {8, 6}, {8, 7}};
    private final boolean usesLZ77;
    private int lz77MinSymbol;
    private int lz77MinLength;
    private EML lzLength;
    private final int[] clusterMap;
    private final Symbols[] dists;
    private final int logAlphabetSize;
    private int numToCopy77;
    private int copyPos77;
    private int numDecoded77;
    private int[] window;
    private final ANS state = new ANS();

    Entropy(Entropy entropy) {
        this.usesLZ77 = entropy.usesLZ77;
        this.lz77MinLength = entropy.lz77MinLength;
        this.lz77MinSymbol = entropy.lz77MinSymbol;
        this.lzLength = entropy.lzLength;
        this.clusterMap = entropy.clusterMap;
        this.logAlphabetSize = entropy.logAlphabetSize;
        this.dists = entropy.dists;
        if (this.usesLZ77) {
            this.window = new int[0x100000];
        }
    }

    Entropy(BitXL reader, int numDists) throws IOException {
        int i2;
        this.usesLZ77 = reader.bool();
        if (this.usesLZ77) {
            this.lz77MinSymbol = reader.u32(224, 0, 512, 0, 4096, 0, 8, 15);
            this.lz77MinLength = reader.u32(3, 0, 4, 0, 5, 2, 9, 8);
            ++numDists;
            this.lzLength = new EML(reader, 8);
            this.window = new int[0x100000];
        }
        this.clusterMap = new int[numDists];
        int numClusters = Entropy.readClusters(reader, this.clusterMap);
        this.dists = new Symbols[numClusters];
        boolean prefixCodes = reader.bool();
        this.logAlphabetSize = prefixCodes ? 15 : 5 + reader.u(2);
        EML[] configs = new EML[this.dists.length];
        for (i2 = 0; i2 < configs.length; ++i2) {
            configs[i2] = new EML(reader, this.logAlphabetSize);
        }
        if (prefixCodes) {
            int i3;
            int[] alphabetSizes = new int[this.dists.length];
            for (i3 = 0; i3 < this.dists.length; ++i3) {
                if (reader.bool()) {
                    int n2 = reader.u(4);
                    alphabetSizes[i3] = 1 + (1 << n2) + reader.u(n2);
                    continue;
                }
                alphabetSizes[i3] = 1;
            }
            for (i3 = 0; i3 < this.dists.length; ++i3) {
                this.dists[i3] = new PrefixSymbols(reader, alphabetSizes[i3]);
            }
        } else {
            for (i2 = 0; i2 < this.dists.length; ++i2) {
                this.dists[i2] = new ANSSymbols(reader, this.logAlphabetSize);
            }
        }
        for (int i4 = 0; i4 < this.dists.length; ++i4) {
            this.dists[i4].config = configs[i4];
        }
    }

    static int readClusters(BitXL reader, int[] clusters) throws IOException {
        int numDists = clusters.length;
        if (numDists == 1) {
            clusters[0] = 0;
        } else if (reader.bool()) {
            int nbits = reader.u(2);
            for (int i2 = 0; i2 < numDists; ++i2) {
                clusters[i2] = reader.u(nbits);
            }
        } else {
            boolean useMtf = reader.bool();
            Entropy nested = new Entropy(reader, 1);
            for (int i3 = 0; i3 < numDists; ++i3) {
                clusters[i3] = nested.readSymbol(reader, 0);
            }
            if (useMtf) {
                int i4;
                int[] temp = new int[256];
                for (i4 = 0; i4 < 256; ++i4) {
                    temp[i4] = i4;
                }
                for (i4 = 0; i4 < numDists; ++i4) {
                    int index = clusters[i4];
                    clusters[i4] = temp[index];
                    if (index == 0) continue;
                    int value = temp[index];
                    for (int j2 = index; j2 > 0; --j2) {
                        temp[j2] = temp[j2 - 1];
                    }
                    temp[0] = value;
                }
            }
        }
        int nClusters = 0;
        for (int cluster : clusters) {
            if (cluster < nClusters) continue;
            nClusters = cluster + 1;
        }
        return nClusters;
    }

    int readSymbol(BitXL reader, int context) throws IOException {
        return this.readSymbol(reader, context, 0);
    }

    int readSymbol(BitXL reader, int context, int dm) throws IOException {
        if (this.numToCopy77 > 0) {
            int hybridInt = this.window[this.copyPos77++ & 0xFFFFF];
            --this.numToCopy77;
            this.window[this.numDecoded77++ & 0xFFFFF] = hybridInt;
            return hybridInt;
        }
        Symbols dist = this.dists[this.clusterMap[context]];
        int token = dist.readSymbol(reader, this.state);
        if (this.usesLZ77 && token >= this.lz77MinSymbol) {
            Symbols lz77dist = this.dists[this.clusterMap[this.clusterMap.length - 1]];
            this.numToCopy77 = this.lz77MinLength + Entropy.getFromEML(reader, this.lzLength, token - this.lz77MinSymbol);
            token = lz77dist.readSymbol(reader, this.state);
            int distance = Entropy.getFromEML(reader, lz77dist.config, token);
            distance = dm == 0 ? ++distance : (distance < 120 ? FIXED_DISTANCES[distance][0] + dm * FIXED_DISTANCES[distance][1] : (distance -= 119));
            if (distance > 0x100000) {
                distance = 0x100000;
            }
            if (distance > this.numDecoded77) {
                distance = this.numDecoded77;
            }
            this.copyPos77 = this.numDecoded77 - distance;
            return this.readSymbol(reader, context);
        }
        int eml = Entropy.getFromEML(reader, dist.config, token);
        if (this.usesLZ77) {
            this.window[this.numDecoded77++ & 0xFFFFF] = eml;
        }
        return eml;
    }

    private static int getFromEML(BitXL reader, EML hyb, int token) throws IOException {
        int split = 1 << hyb.exp;
        if (token < split) {
            return token;
        }
        int n2 = hyb.exp - hyb.lsb - hyb.msb + (token - split >>> hyb.msb + hyb.lsb);
        int low = token & (1 << hyb.lsb) - 1;
        token >>>= hyb.lsb;
        token &= (1 << hyb.msb) - 1;
        return ((token |= 1 << hyb.msb) << n2 | reader.u(n2)) << hyb.lsb | low;
    }
}

