/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.CIERGB;
import com.idrsolutions.image.jpegXL.data.CIEXY;
import com.idrsolutions.image.jpegXL.data.ColorUtil;
import com.idrsolutions.image.jpegXL.data.MathXL;
import java.io.IOException;

class ColorXL {
    final boolean useIccProfile;
    final int colorEncoding;
    final int whitePoint;
    final CIEXY white;
    final int primaries;
    final CIERGB prim;
    final int tf;
    final int renderingIntent;

    ColorXL() {
        this.useIccProfile = false;
        this.colorEncoding = 0;
        this.whitePoint = 1;
        this.white = ColorUtil.getWhitePoint(this.whitePoint);
        this.primaries = 1;
        this.prim = ColorUtil.getCIERGB(this.primaries);
        this.tf = 0x100000D;
        this.renderingIntent = 1;
    }

    private static CIEXY readCustom(BitXL reader) throws IOException {
        int ux = reader.u32(0, 19, 524288, 19, 0x100000, 20, 0x200000, 21);
        int uy = reader.u32(0, 19, 524288, 19, 0x100000, 20, 0x200000, 21);
        float x2 = (float)MathXL.unpackSigned(ux) * 1.0E-6f;
        float y2 = (float)MathXL.unpackSigned(uy) * 1.0E-6f;
        return new CIEXY(x2, y2);
    }

    ColorXL(BitXL reader) throws IOException {
        boolean allDefault = reader.bool();
        this.useIccProfile = !allDefault && reader.bool();
        this.colorEncoding = !allDefault ? reader.readEnum() : 0;
        this.whitePoint = !allDefault && !this.useIccProfile && this.colorEncoding != 2 ? reader.readEnum() : 1;
        this.white = this.whitePoint == 2 ? ColorXL.readCustom(reader) : ColorUtil.getWhitePoint(this.whitePoint);
        this.primaries = !allDefault && !this.useIccProfile && this.colorEncoding != 2 && this.colorEncoding != 1 ? reader.readEnum() : 1;
        if (this.primaries == 2) {
            CIEXY pRed = ColorXL.readCustom(reader);
            CIEXY pGreen = ColorXL.readCustom(reader);
            CIEXY pBlue = ColorXL.readCustom(reader);
            this.prim = new CIERGB(pRed, pGreen, pBlue);
        } else {
            this.prim = ColorUtil.getCIERGB(this.primaries);
        }
        if (!allDefault && !this.useIccProfile) {
            boolean useGamma = reader.bool();
            this.tf = useGamma ? reader.u(24) : 0x1000000 + reader.readEnum();
            this.renderingIntent = reader.readEnum();
        } else {
            this.tf = 0x100000D;
            this.renderingIntent = 1;
        }
    }
}

