/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.CIERGB;
import com.idrsolutions.image.jpegXL.data.CIEXY;
import com.idrsolutions.image.jpegXL.data.IntXL;
import com.idrsolutions.image.jpegXL.data.MathXL;
import java.util.function.DoubleUnaryOperator;

final class ColorUtil {
    private static final float[][] BRADFORD = new float[][]{{0.8951f, 0.2664f, -0.1614f}, {-0.7502f, 1.7135f, 0.0367f}, {0.0389f, -0.0685f, 1.0296f}};
    private static final float[][] BRADFORD_INVERSE = MathXL.mmInverse3x3(BRADFORD);
    static final CIERGB PRI_SRGB = ColorUtil.getCIERGB(1);
    static final CIEXY WP_D65 = ColorUtil.getWhitePoint(1);
    static final CIEXY WP_D50 = ColorUtil.getWhitePoint(-1);

    private ColorUtil() {
    }

    static CIEXY getWhitePoint(int whitePoint) {
        switch (whitePoint) {
            case 1: {
                return new CIEXY(0.3127f, 0.329f);
            }
            case 10: {
                return new CIEXY(0.33333334f, 0.33333334f);
            }
            case 11: {
                return new CIEXY(0.314f, 0.351f);
            }
            case -1: {
                return new CIEXY(0.34567f, 0.34567f);
            }
        }
        return null;
    }

    static int getWhitePoint(CIEXY wp) {
        for (int white : new int[]{1, 10, 11, -1}) {
            if (!CIEXY.matches(wp, ColorUtil.getWhitePoint(white))) continue;
            return white;
        }
        return 2;
    }

    static CIERGB getCIERGB(int type) {
        switch (type) {
            case 1: {
                return new CIERGB(new CIEXY(0.6399987f, 0.33001015f), new CIEXY(0.3000038f, 0.60000336f), new CIEXY(0.15000205f, 0.059997205f));
            }
            case 9: {
                return new CIERGB(new CIEXY(0.708f, 0.292f), new CIEXY(0.17f, 0.797f), new CIEXY(0.131f, 0.046f));
            }
            case 11: {
                return new CIERGB(new CIEXY(0.68f, 0.32f), new CIEXY(0.265f, 0.69f), new CIEXY(0.15f, 0.06f));
            }
        }
        return null;
    }

    static int getCIERGBType(CIERGB primaries) {
        for (int prim : new int[]{1, 9, 11}) {
            if (!CIERGB.matches(primaries, ColorUtil.getCIERGB(prim))) continue;
            return prim;
        }
        return 2;
    }

    private static float[] getXYZ(CIEXY xy) {
        ColorUtil.validateXY(xy);
        float invY = 1.0f / xy.y;
        return new float[]{xy.x * invY, 1.0f, (1.0f - xy.x - xy.y) * invY};
    }

    private static void validateXY(CIEXY xy) {
        if (xy.x < 0.0f || xy.x > 1.0f || xy.y <= 0.0f || xy.y > 1.0f) {
            throw new IllegalArgumentException();
        }
    }

    private static void validateLMS(float[] lms) {
        for (float lm : lms) {
            if (!((double)Math.abs(lm) < 1.0E-8)) continue;
            throw new IllegalArgumentException();
        }
    }

    private static float[][] adaptWhitePoint(CIEXY targetWP, CIEXY currentWP) {
        if (targetWP == null) {
            targetWP = WP_D50;
        }
        if (currentWP == null) {
            currentWP = WP_D50;
        }
        float[] wCurrent = ColorUtil.getXYZ(currentWP);
        float[] lmsCurrent = MathXL.mmMutliply(BRADFORD, wCurrent);
        float[] wTarget = ColorUtil.getXYZ(targetWP);
        float[] lmsTarget = MathXL.mmMutliply(BRADFORD, wTarget);
        ColorUtil.validateLMS(lmsCurrent);
        float[][] a10 = new float[3][3];
        for (int i2 = 0; i2 < 3; ++i2) {
            a10[i2][i2] = lmsTarget[i2] / lmsCurrent[i2];
        }
        return MathXL.mmMutliply(BRADFORD_INVERSE, a10, BRADFORD);
    }

    private static float[][] fromCIERGBtoXYZ(CIERGB primaries, CIEXY wp) {
        if (primaries == null) {
            return null;
        }
        if (wp == null) {
            wp = WP_D50;
        }
        float[][] primariesTr = new float[][]{ColorUtil.getXYZ(primaries.red), ColorUtil.getXYZ(primaries.green), ColorUtil.getXYZ(primaries.blue)};
        float[][] primariesMatrix = MathXL.mmTranspose(primariesTr, new IntXL(3));
        float[][] inversePrimaries = MathXL.mmInverse3x3(primariesMatrix);
        float[] w2 = ColorUtil.getXYZ(wp);
        float[] xyz = MathXL.mmMutliply(inversePrimaries, w2);
        float[][] a10 = new float[][]{{xyz[0], 0.0f, 0.0f}, {0.0f, xyz[1], 0.0f}, {0.0f, 0.0f, xyz[2]}};
        return MathXL.mmMutliply(primariesMatrix, (float[][])a10);
    }

    static float[][] primariesToXYZD50(CIERGB primaries, CIEXY wp) {
        float[][] whitePointConv = ColorUtil.adaptWhitePoint(null, wp);
        return MathXL.mmMutliply(whitePointConv, ColorUtil.fromCIERGBtoXYZ(primaries, wp));
    }

    static float[][] getConversionMatrix(CIERGB dPrim, CIEXY dWP, CIERGB sPrim, CIEXY sWP) {
        if (CIERGB.matches(dPrim, sPrim) && CIEXY.matches(dWP, sWP)) {
            return MathXL.mmIdentity(3);
        }
        float[][] whitePointConv = null;
        if (!CIEXY.matches(dWP, sWP)) {
            whitePointConv = ColorUtil.adaptWhitePoint(dWP, sWP);
        }
        float[][] forward = ColorUtil.fromCIERGBtoXYZ(sPrim, sWP);
        float[][] reverse = MathXL.mmInverse3x3(ColorUtil.fromCIERGBtoXYZ(dPrim, dWP));
        return MathXL.mmMutliply(reverse, whitePointConv, forward);
    }

    static DoubleUnaryOperator getTransferFunction(int transfer) {
        switch (transfer) {
            case 0x1000008: {
                return DoubleUnaryOperator.identity();
            }
            case 0x100000D: {
                return f2 -> {
                    if (f2 <= 0.00313066844250063) {
                        return f2 * 12.92;
                    }
                    return 1.055 * Math.pow(f2, 0.4166666666666667) - 0.055;
                };
            }
            case 0x1000010: {
                return f2 -> {
                    double d2 = Math.pow(f2, 0.159423828125);
                    return Math.pow((0.8359375 + 18.8515625 * d2) / (1.0 + 18.6875 * d2), 78.84375);
                };
            }
            case 0x1000001: {
                return f2 -> {
                    if (f2 <= 0.018053968510807806) {
                        return 4.5 * f2;
                    }
                    return 1.099296826809443 * Math.pow(f2, 0.45) - 0.09929682680944293;
                };
            }
            case 0x1000011: {
                transfer = 3846154;
                break;
            }
        }
        if (transfer < 0x1000000) {
            double gamma = (double)transfer * 1.0E-7;
            return f2 -> Math.pow(f2, gamma);
        }
        return DoubleUnaryOperator.identity();
    }

    static DoubleUnaryOperator getInverseTransfer(int transfer) {
        switch (transfer) {
            case 0x1000008: {
                return DoubleUnaryOperator.identity();
            }
            case 0x100000D: {
                return f2 -> {
                    if (f2 <= 0.0404482362771082) {
                        return f2 * 0.07739938080495357;
                    }
                    return Math.pow((f2 + 0.055) * 0.9478672985781991, 2.4);
                };
            }
            case 0x1000001: {
                return f2 -> {
                    if (f2 <= 0.08124285829863513) {
                        return f2 * 0.2222222222222222;
                    }
                    return Math.pow((f2 + 0.09929682680944293) * 0.9096724156862726, 2.222222);
                };
            }
            case 0x1000010: {
                return f2 -> {
                    double d2 = Math.pow(f2, 0.012683313515655966);
                    return Math.pow((d2 - 0.8359375) / (18.8515625 + 18.6875 * d2), 6.272588055130169);
                };
            }
            case 0x1000011: {
                transfer = 3846154;
                break;
            }
        }
        if (transfer < 0x1000000) {
            double gamma = 1.0E7 / (double)transfer;
            return f2 -> Math.pow(f2, gamma);
        }
        return DoubleUnaryOperator.identity();
    }
}

